
;=================================
; Memory locations
; used as variables
;=================================

game_state      !byte 0
next_game_state	!byte 0 ; Set by IRQ when the counter hits the target
irq_counter     !byte 0,0
slow_counter 	!byte 0
irq_target		!byte 0
joystick		!byte 255
joystick_old	!byte 0
intro_top_count !byte 0
game_phase		!byte 0 ; In menu, in active game, etc.
level 			!byte 0
wave 			!byte 0 ; BCD level
score_delta		!byte 0
score 			!byte 0,0
highscore 		!byte 0,0
fail			!byte 0
infinite_lives 	!byte 0 ; For cheating

stage			!byte 0
stage_data 		!byte 0,0
stage_data_low 	!byte <inverted1,<inverted2,<inverted3,<inverted1
stage_data_high !byte >inverted1,>inverted2,>inverted3,>inverted1

curtain_sprite_x	!byte 16,64,88,112,160,184,232,0
curtain_sprite_y	!byte 250
curtain_sprite_look	!byte 0,0,1,1,0,0,1,0
curtain_pix 		!byte 0,0
curtain_bgcol 		!byte 0,0
curtain_fgcol 		!byte 0,0
curtain_delta 		!byte 64,1,40,0,40,0 ; Target curtain pix and color pointer position changes per row
curtain_row			!byte 0

; For cheating
cheat_counter 	!byte 0
collisions_on 	!byte 1

sound_effect	!byte 0,0,0
sound_counter	!byte 0,0,0
; Blank, Button press, Step, Shit caught, Shit dropped, Ding, Emptying bucket, Shit landed,
; Beep, Pew, Bullet hit, Fart, Gasp, Drown
snd_wave 		!byte 0,16,128,16,128,32,16,128, 32,128,32,128,128,16,128
snd_ad 			!byte 0,9,2,8,7,8,15,10, 15,8,8,136,124,13,0
snd_sr			!byte 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,57
snd_duration 	!byte 0,20,1,20,15,7,30,20, 15,10,10,20,40,40,16
voice_offsets	!byte 0,7,14
snd_jumptable_low 	!byte 0,<sound1,<sound2,<sound3,<sound4,<sound5,<sound6,<sound6
					!byte <sound7,<sound8,<sound9,<sound9,<sound7,<sound6,<sound10
snd_jumptable_high 	!byte 0,>sound1,>sound2,>sound3,>sound4,>sound5,>sound6,>sound6
					!byte >sound7,>sound8,>sound9,>sound9,>sound7,>sound6,>sound10
snd_effect_flag		!byte 0


board_text		!scr "  BECAUSE YOU "
				!scr "  DEMANDED IT "
				!scr "              "
				!scr "   STAGE 2:   "
				!scr "THE MOONA LISA"
				!scr "  IN THE LOO  "
				!scr "   STAGE 3:   "
				!scr " DONALD RUMP'S"
				!scr " OVAL ORIFICE "
				!scr "  WELL DONE!  "
				!scr " YOU KICK ALL "
				!scr " KINDS OF ASS!"

logoline1		!scr "KARL H/RNELL"
logoline2		!scr "SHAMEFULLY PRESENTS"
logoline3		!scr "- BEHIND ENEMA LINES -"

introline_low	!byte <introline1,0,<introline2,<introline3,<introline4,<introline5,<introline6
				!byte 0,<introline7,0,<introline8,0,0
introline_high	!byte >introline1,0,>introline2,>introline3,>introline4,>introline5,>introline6
				!byte 0,>introline7,0,>introline8,0,0

introline1		!scr "      WHAT IT'S ALL ABOUT       "

introline2		!scr "GIANT POSTERIORS HAVE INVADED   "
introline3		!scr "THE EARTH AND INTEND TO MAKE A  "
introline4		!scr "MESS IN ALL THE PLACES YOU HOLD "
introline5		!scr "DEAR. YOUR JOB IS TO STOP THEM  "
introline6		!scr "BY ANY MEANS NECESSARY.         "

introline7		!scr "        (*) EWEGUO 2018         "

introline8		!scr "   PRESS FIRE BUTTON TO START   "

instructions1	!scr "ATTACK WAVE 1:"
				!byte 13
				!scr "THE RIPE STOOL FOR THE JOB"
				!byte 13
				!scr " "
				!byte 13
				!scr "CATCH THE WASTE IN YOUR BUCKET."
				!byte 13
				!scr "MAKE SURE YOU EMPTY THE BUCKET"
				!byte 13
				!scr "IN THE TOILET BEFORE IT GETS"
				!byte 13
				!scr "TOO FULL."
				!byte 0

instructions2	!scr "ATTACK WAVE 4:"
				!byte 13
				!scr "A CHANGE OF FART"
				!byte 13
				!scr " "
				!byte 13
				!scr "TIME TO FIGHT BACK. NOW THE"
				!byte 13
				!scr "POSTERIOR IS RUNNING ON FUMES,"
				!byte 13
				!scr "BUT THAT DOESN'T MAKE IT ANY"
				!byte 13
				!scr "LESS DEADLY."
				!byte 0

instructions3 	!scr "ATTACK WAVE 7:"
				!byte 13
				!scr "STEREO ASS-STEREOID ASTEROIDS"
				!byte 13
				!scr " "
				!byte 13
				!scr "THE INVADERS ARE DOUBLING DOWN."
				!byte 13
				!scr "MAKE SURE THE YOU-KNOW-WHAT"
				!byte 13
				!scr "DOESN'T HIT THE FAN."
				!byte 0

instructions4 	!scr "ATTACK WAVE 10:"
				!byte 13
				!scr "NO LONGER UNSHARTED TERRITORY"
				!byte 13
				!scr " "
				!byte 13
				!scr "THIS WILL GET UGLY. RACK UP"
				!byte 13
				!scr "ENOUGH DAMAGE BEFORE YOU DROWN."
				!byte 13
				!scr "IT TAKES TWO HITS TO KILL THE"
				!byte 13
				!scr "CHEEKY BASTARDS."
				!byte 0



clear_text		!scr "WAVE CLEARED"
gameover_text	!scr "GAME OVER"

; For showing level-specific instructions
instructions_low	!byte 0,<instructions1,0,0,<instructions2,0,0,<instructions3,0,0
					!byte <instructions4, 0,0,0, 0,0,0, 0,0,0, 0, 0,0,0, 0,0,0, 0,0,0, 0,0
instructions_high	!byte 0,>instructions1,0,0,>instructions2,0,0,>instructions3,0,0
					!byte >instructions4, 0,0,0, 0,0,0, 0,0,0, 0, 0,0,0, 0,0,0, 0,0,0, 0,0
text_source			!byte 0,0
text_dest			!byte 0,0
line_dest			!byte 0,0

; Mid control panel segments
midpanel_low	!byte <ctrl_mid_bucket,<ctrl_mid_butthurt,<ctrl_mid_hit,<ctrl_mid_butthurt
				!byte <ctrl_mid_butthurt
midpanel_high	!byte >ctrl_mid_bucket,>ctrl_mid_butthurt,>ctrl_mid_hit,>ctrl_mid_butthurt
				!byte >ctrl_mid_butthurt

gameloop_low	!byte <loop_bucket_top,<loop_fart_top,<loop_fan_top,<loop_diarrhea_top
				!byte <loop_victory_top
gameloop_high	!byte >loop_bucket_top,>loop_fart_top,>loop_fan_top,>loop_diarrhea_top
				!byte >loop_victory_top

; Sprite management
butt_x	!byte 24
butt_y	!byte 50
butt_target	!byte 100

shit_x	!byte 0,0,0,0,0
shit_x_low !byte 0,0,0,0,0
shit_x_high !byte 0,0,0,0,0
shit_y	!byte 0,0,0,0,0
shit_mode	!byte 0,0,0,0,0
shit_look	!byte 0,0,0,0,0
shit_color	!byte 0,0,0,0,0
shit_speed 	!byte 2,2,2,2,2
shit_num	!byte 0
max_shit	!byte 2
shit_count	!byte 0
shit_caught !byte 0
shit_goal	!byte 5
shit_timer	!byte 0
shit_interval	!byte 100

; Fan level splat distribution
splat_x 	!byte 0,0,0,0,0,0,0,0
splat_y 	!byte 0,0,0,0,0,0,0,0

tush_look	!byte 101
tush_count	!byte 0
tush_timer	!byte 0
tush_mode	!byte 0,0,0,0,0,0,0
tush_color	!byte 0,0,0,0,0,0,0
tush_x		!byte 0,0,0,0,0,0,0
tush_y		!byte 0,0,0,0,0,0,0
tush_steps	!byte 0,0,0,0,0,0,0
tush_speed	!byte 0,0,0,0,0,0,0

tush_frames	!byte 101,102,101,103

; 0: bucket, 1: fart, 2: fan, 3: diarrhea, 4: completed
wave_types		!byte 0, 0,0,0, 1,1,1, 2,2,2, 3
				!byte 0,0,0, 1,1,1, 2,2,2, 3
				!byte 0,0,0, 1,1,1, 2,2,2, 3, 4
; 0: bucket, 1: gun
wave_tools 		!byte 0, 0,0,0, 1,1,1, 1,1,1, 1
				!byte 0,0,0, 1,1,1, 1,1,1, 1
				!byte 0,0,0, 1,1,1, 1,1,1, 1, 0
; Frames between releases or rising diarrhea surface
interval_table 	!byte 0, 100,130,50, 120,90,70, 100,80,60, 70
				!byte 90,80,70, 70,60,50, 60,50,40, 45
				!byte 30,25,20, 50,40,30, 40,40,30, 32, 0
; Maximum number on screen at the same time
max_table		!byte 0, 2,2,2, 2,2,2, 2,3,4, 0
				!byte 2,2,2, 2,2,2, 4,4,4, 0
				!byte 2,2,2, 3,3,3, 4,5,5, 0, 0
; Number to catch
goal_table		!byte 0, 5,7,10, 0,0,0, 0,0,0, 0
				!byte 12,13,15, 0,0,0, 0,0,0, 0
				!byte 15,17,20, 0,0,0, 0,0,0, 0, 0
; 0/3: livingroom, 1: museum, 2: White House
stage_table		!byte 0, 0,0,0, 0,0,0, 0,0,0, 0
				!byte 1,1,1, 1,1,1, 1,1,1, 1
				!byte 2,2,2, 2,2,2, 2,2,2, 2, 3
; Max speed
shit_speeds 	!byte 0, 2,2,2, 2,2,2, 4,4,5, 0
				!byte 2,2,2, 2,2,2, 6,6,7, 0
				!byte 2,2,2, 3,3,4, 7,7,8, 0


current_tool	!byte 0
last_tool		!byte 0


butthurt 		!byte 0
butthurt_adjust !byte 3,192,48,12

fan_x		!byte 128
fan_y		!byte 100
fan_look	!byte 6
fan_raw_x	!byte 128
fan_raw_y	!byte 128
fan_target_x	!byte 80
fan_target_y	!byte 140
fan_dx		!byte 0
fan_dy		!byte 0

; Diarrhea stream
diarrhea_pix 	!byte 0,0
diarrhea_col	!byte 0,0
diarrhea_length	!byte 0
diarrhea_y 		!byte 250
diarrhea_timer	!byte 0
diarrhea_delay 	!byte 100
diarrhea_look	!byte 98


; Bucket fill row positions
fill_pos_low !byte 23,22,21,20,19,18,17,16,215,214,213,212,211,210,209,208,151,150,149,148
fill_pos_high !byte 112,112,112,112,112,112,112,112,110,110,110,110,110,110,110,110,109,109,109,109
bucket_level !byte 0
bucket_drawn !byte 0

body_x	;!byte 15,17,19,23,25,27,29,31
		!byte 33,35,37,41,43,45,47,49
		!byte 51,53,55,59,61,63,65,67
		!byte 69,71,73,77,79,81,83,85
		!byte 87,89,91,95,97,99,101,103
		!byte 105,107,109,113,115,117,119,121
		!byte 123,125,127,131,133,135,137,139
		!byte 141,143,145,149,151,153,155,157
		!byte 159,161,163,167,169,171,173,175
		!byte 177,179,181,185,187,189,191,193
		!byte 195,197,199,203,205,207,209,211
		!byte 213,215,217,221,223,225,227,229
		!byte 231
leg1_dx	!byte 2,0,254,250,248,250,254,0
leg2_dx	!byte 24,26,24,30,28,26,24,26
cycle_y	!byte 191,191,192,193,194,193,192,191
man_pos	!byte 40
empty_topframes	!byte 0,48,48,48,50,50,50,52
empty_midframes	!byte 0,54,54,54,56,56,56,58
empty_bucketframes	!byte 0,11,11,11,12,12,12,13
empty_bucketx	!byte 0,1,1,1,5,5,5,15
empty_buckety	!byte 0,197,197,197,197,197,197,205
bucket_speed	!byte 0

bullet_x	!byte 0
bullet_y	!byte 0
bullet_look	!byte 0
bullet_mode	!byte 0


; For random number generation
random_pos	!byte 0
random_table
		!byte $a7,$95,$73,$b4,$dd,$78,$df,$63,$42,$bd,$ff,$56,$73,$56,$17,$4
		!byte $d4,$1e,$71,$a9,$9d,$9,$77,$23,$b0,$ed,$fd,$5e,$42,$8d,$33,$1f
		!byte $97,$65,$fc,$d9,$fb,$45,$7b,$ae,$ed,$b2,$9a,$b1,$2c,$53,$d1,$64
		!byte $14,$23,$61,$24,$9c,$6e,$8d,$3b,$b6,$5d,$1f,$d5,$da,$4e,$8d,$34
		!byte $41,$28,$53,$93,$c2,$fa,$66,$ad,$b7,$2a,$48,$af,$2d,$e9,$7d,$20
		!byte $92,$bd,$7a,$72,$10,$25,$6f,$33,$c1,$c,$ad,$7b,$52,$7a,$10,$b8
		!byte $b3,$69,$6d,$70,$47,$f6,$25,$dc,$ea,$d6,$36,$53,$e3,$d5,$bb,$1e
		!byte $db,$b7,$b4,$cc,$e3,$68,$85,$db,$bd,$92,$db,$5c,$7c,$42,$5a,$1f
		!byte $70,$df,$98,$e2,$9c,$a6,$35,$33,$dd,$ff,$6,$11,$84,$cf,$93,$c6
		!byte $f,$6d,$cd,$96,$2e,$8c,$3d,$fb,$bb,$83,$5e,$42,$15,$58,$af,$9c
		!byte $30,$4d,$4b,$6d,$ed,$de,$71,$86,$51,$f9,$cc,$c9,$3b,$da,$a4,$22
		!byte $f8,$e1,$d8,$5f,$12,$e2,$e0,$a,$f6,$3b,$fe,$5,$3,$d7,$5b,$26
		!byte $f5,$f1,$1b,$9c,$bb,$58,$f5,$ab,$c2,$4f,$ce,$99,$10,$e5,$5e,$f8
		!byte $c6,$ae,$3a,$e8,$3,$f5,$19,$ee,$15,$8e,$2c,$6,$9c,$b8,$73,$bb
		!byte $5,$12,$58,$35,$cc,$dc,$f4,$fe,$39,$2c,$93,$18,$2f,$30,$e2,$45
		!byte $e0,$4f,$81,$a6,$f9,$bb,$b8,$56,$2e,$0,$1b,$46,$76,$4b,$61,$49

; For computations
buffer 	!byte 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
		!byte 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
		!byte 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
		!byte 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
		!byte 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
		!byte 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
		!byte 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
		!byte 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
		!byte 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
		!byte 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
