/*
 * Decompiled with CFR 0.152.
 */
package sinclair.basic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZX81Translate {
    private static final String[] mTranslateTable = new String[]{" ", "{1}", "{2}", "{7}", "{4}", "{5}", "{T}", "{E}", "{A}", "{D}", "{S}", "\"", "\u00a3", "$", ":", "?", "(", ")", ">", "<", "=", "+", "-", "*", "/", ";", ",", ".", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "RND", "INKEY$", "PI", "<43>", "<44>", "<45>", "<46>", "<47>", "<48>", "<49>", "<4A>", "<4B>", "<4C>", "<4D>", "<4E>", "<4F>", "<50>", "<51>", "<52>", "<53>", "<54>", "<55>", "<56>", "<57>", "<58>", "<59>", "<5A>", "<5B>", "<5C>", "<5D>", "<5E>", "<5F>", "<60>", "<61>", "<62>", "<63>", "<64>", "<65>", "<66>", "<67>", "<68>", "<69>", "<6A>", "<6B>", "<6C>", "<6D>", "<6E>", "<6F>", "<70^>", "<71v>", "<72<>", "<73>>", "<74 GRAPHICS>", "<75 EDIT>", "<76 NEWLINE>", "<77 RUBOUT>", "<78 K/L>", "<79 FUNCTION>", "<7A>", "<7B>", "<7C>", "<7D>", "<7E number>", "<7F cursor>", "[ ]", "{Q}", "{W}", "{6}", "{R}", "{8}", "{Y}", "{E}", "{H}", "{G}", "{F}", "[\"]", "[\u00a3]", "[$]", "[:]", "[?]", "[(]", "[)]", "[>]", "[<]", "[=]", "[+]", "[-]", "[*]", "[/]", "[;]", "[,]", "[.]", "[0]", "[1]", "[2]", "[3]", "[4]", "[5]", "[6]", "[7]", "[8]", "[9]", "[A]", "[B]", "[C]", "[D]", "[E]", "[F]", "[G]", "[H]", "[I]", "[J]", "[K]", "[L]", "[M]", "[N]", "[O]", "[P]", "[Q]", "[R]", "[S]", "[T]", "[U]", "[V]", "[W]", "[X]", "[Y]", "[Z]", "\"\"", "AT ", "TAB ", "<C3>", "CODE ", "VAL ", "LEN ", "SIN ", "COS ", "TAN ", "ASN ", "ACS ", "ATN ", "LN ", "EXP ", "INT ", "SQR ", "SGN ", "ABS ", "PEEK ", "USR ", "STR$ ", "CHR$ ", "NOT ", "**", " OR ", " AND ", "<=", ">=", "<>", " THEN ", " TO ", " STEP ", "LPRINT ", "LLIST ", "STOP ", "SLOW ", "FAST ", "NEW ", "SCROLL ", "CONT ", "DIM ", "REM ", "FOR ", "GOTO ", "GOSUB ", "INPUT ", "LOAD ", "LIST ", "LET ", "PAUSE ", "NEXT ", "POKE ", "PRINT ", "PLOT ", "RUN ", "SAVE ", "RAND ", "IF ", "CLS ", "UNPLOT ", "CLEAR ", "RETURN ", "COPY "};
    private static final String[] mExpandTable;
    public static final int TOKEN_NUMBER = 126;
    public static final int TOKEN_NEWLINE = 118;
    public static final int TOKEN_REM = 234;

    static {
        String[] stringArray = new String[256];
        stringArray[64] = "RND";
        stringArray[65] = "INKEY$";
        stringArray[66] = "PI";
        stringArray[192] = "\"\"";
        stringArray[193] = "AT ";
        stringArray[194] = "TAB ";
        stringArray[195] = "";
        stringArray[196] = "CODE ";
        stringArray[197] = "VAL ";
        stringArray[198] = "LEN ";
        stringArray[199] = "SIN ";
        stringArray[200] = "COS ";
        stringArray[201] = "TAN ";
        stringArray[202] = "ASN ";
        stringArray[203] = "ACS ";
        stringArray[204] = "ATN ";
        stringArray[205] = "LN ";
        stringArray[206] = "EXP ";
        stringArray[207] = "INT ";
        stringArray[208] = "SQR ";
        stringArray[209] = "SGN ";
        stringArray[210] = "ABS ";
        stringArray[211] = "PEEK ";
        stringArray[212] = "USR ";
        stringArray[213] = "STR$ ";
        stringArray[214] = "CHR$ ";
        stringArray[215] = "NOT ";
        stringArray[216] = "**";
        stringArray[217] = " OR ";
        stringArray[218] = " AND ";
        stringArray[219] = "<=";
        stringArray[220] = ">=";
        stringArray[221] = "<>";
        stringArray[222] = " THEN ";
        stringArray[223] = " TO ";
        stringArray[224] = " STEP ";
        stringArray[225] = "LPRINT ";
        stringArray[226] = "LLIST ";
        stringArray[227] = "STOP ";
        stringArray[228] = "SLOW ";
        stringArray[229] = "FAST ";
        stringArray[230] = "NEW ";
        stringArray[231] = "SCROLL ";
        stringArray[232] = "CONT ";
        stringArray[233] = "DIM ";
        stringArray[234] = "REM ";
        stringArray[235] = "FOR ";
        stringArray[236] = "GOTO ";
        stringArray[237] = "GOSUB ";
        stringArray[238] = "INPUT ";
        stringArray[239] = "LOAD ";
        stringArray[240] = "LIST ";
        stringArray[241] = "LET ";
        stringArray[242] = "PAUSE ";
        stringArray[243] = "NEXT ";
        stringArray[244] = "POKE ";
        stringArray[245] = "PRINT ";
        stringArray[246] = "PLOT ";
        stringArray[247] = "RUN ";
        stringArray[248] = "SAVE ";
        stringArray[249] = "RAND ";
        stringArray[250] = "IF ";
        stringArray[251] = "CLS ";
        stringArray[252] = "UNPLOT ";
        stringArray[253] = "CLEAR ";
        stringArray[254] = "RETURN ";
        stringArray[255] = "COPY ";
        mExpandTable = stringArray;
    }

    public static void main(String[] args) {
        String pFileName = null;
        int aPos = 0;
        while (aPos < args.length) {
            if ((args[aPos].equals("-pFile") || args[aPos].equals("-p")) && aPos < args.length) {
                pFileName = args[++aPos];
            } else {
                ZX81Translate.usage();
            }
            ++aPos;
        }
        File pFile = new File(pFileName);
        if (!pFile.exists() || pFile.isDirectory()) {
            System.err.println("P file " + pFile + " does not exist or is a directory.");
            ZX81Translate.usage();
        }
        try {
            FileInputStream fis = new FileInputStream(pFile);
            String translated = ZX81Translate.translateZX81ToASCII(fis);
            System.out.println(translated);
        }
        catch (Exception exc) {
            System.err.println("Error loading " + pFile + " : " + exc.getMessage());
            ZX81Translate.usage();
        }
    }

    private static void usage() {
        System.out.println("Usage: ");
        System.out.println("java " + ZX81Translate.class.getName());
        System.out.println("   {-pFile|-p}  fileName    .P File name.");
        System.exit(-1);
    }

    public static String translateZX81ToASCII(int value) {
        return mTranslateTable[value];
    }

    public static int translateASCIIToZX81(char value) {
        int c = 0;
        while (c < mTranslateTable.length) {
            if (mTranslateTable[c].length() == 1 && mTranslateTable[c].charAt(0) == value) {
                return c;
            }
            ++c;
        }
        return -1;
    }

    public static void translateASCIIToZX81(String value, StringBuffer trans) {
        int i = 0;
        while (i < value.length()) {
            int translated = ZX81Translate.translateASCIIToZX81(value.charAt(i));
            if (translated != -1) {
                trans.append((char)translated);
            }
            ++i;
        }
    }

    public static String translateZX81ToASCII(InputStream is) throws IOException {
        StringBuffer buff = new StringBuffer();
        int b = is.read();
        while (b != -1) {
            buff.append(mTranslateTable[b]);
            if (b == 118) {
                buff.append('\n');
            }
            b = is.read();
        }
        return buff.toString();
    }

    public static String expandZX81(int c) {
        String s = mExpandTable[c];
        StringBuffer buff = new StringBuffer();
        if (s != null) {
            ZX81Translate.translateASCIIToZX81(s, buff);
        } else {
            buff.append((char)c);
        }
        return buff.toString();
    }

    public static boolean checkTranslatableToZX81(String str) {
        int i = 0;
        while (i < str.length()) {
            if (ZX81Translate.translateASCIIToZX81(str.charAt(i)) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

