/*
 * Decompiled with CFR 0.152.
 */
package tapeutils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import tapeutils.AnalysisEvent;
import tapeutils.AnalysisListener;
import tapeutils.Message;
import tapeutils.Sample;
import tapeutils.SampleAnalyzer;
import tapeutils.SampleAnalyzerFactory;
import tapeutils.zx81.TapeConverterParameters;

public class MultiSampleAnalyzer
implements SampleAnalyzer {
    private Sample mSample;
    private SampleAnalyzerFactory mFactory;
    private TapeConverterParameters mParameters;
    private int mNumAnalyzers = 0;
    private SampleAnalyzer[] mSampleAnalyzers = new SampleAnalyzer[200];
    private int[] mStarts = new int[200];
    private int mMinSecondsGap = 2;
    private int mExpectedAnalyzers = -1;
    private Set mListeners;

    public MultiSampleAnalyzer(Sample sample, SampleAnalyzerFactory factory, TapeConverterParameters parameters) {
        int expectedAnalyzers;
        this.mSample = sample;
        this.mFactory = factory;
        this.mParameters = parameters;
        int minSecondsGap = parameters.getMinSecondsGap();
        if (minSecondsGap != -1) {
            this.mMinSecondsGap = minSecondsGap;
        }
        this.mExpectedAnalyzers = (expectedAnalyzers = parameters.getNumExpectedFiles()) > -1 ? expectedAnalyzers : 200;
        this.mListeners = new HashSet();
    }

    private SampleAnalyzer getAnalyzer(int sampleIndex) {
        int num = this.getAnalyzerNumber(sampleIndex);
        if (num != -1) {
            return this.mSampleAnalyzers[num];
        }
        return null;
    }

    private int getAnalyzerNumber(int sampleIndex) {
        int i = 0;
        while (i < this.mNumAnalyzers) {
            if (sampleIndex > this.mStarts[i] && sampleIndex < this.mStarts[i + 1]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int analyze(int beginIndex, int maxErrors, int maxWarnings, boolean printMessages) {
        this.mNumAnalyzers = 0;
        return this.analyzeFrom(beginIndex, this.mSample.numSamples(), maxErrors, maxWarnings, printMessages);
    }

    private int analyzeFrom(int pos, int end, int maxErrors, int maxWarnings, boolean printMessages) {
        while (pos < end && pos != -1 && this.mNumAnalyzers < this.mExpectedAnalyzers) {
            SampleAnalyzer sa = this.mFactory.create(this.mNumAnalyzers);
            int start = pos;
            sa.debugMessage("SA " + this.mNumAnalyzers + " starting from " + start, false);
            pos = sa.analyze(pos, maxErrors, maxWarnings, false);
            sa.debugMessage("SA " + this.mNumAnalyzers + " returned " + pos + " num bytes: " + sa.getNumBytes(), false);
            if (sa.getNumBytes() <= 0) continue;
            if (printMessages) {
                sa.printMessages();
            }
            this.mSampleAnalyzers[this.mNumAnalyzers] = sa;
            this.mStarts[this.mNumAnalyzers++] = start;
            pos = (int)((double)pos + this.mSample.getSamplesPerSecond() * (double)this.mMinSecondsGap);
        }
        this.mStarts[this.mNumAnalyzers] = end;
        if (this.mNumAnalyzers != this.mExpectedAnalyzers) {
            this.mParameters.setNumFiles(this.mNumAnalyzers);
        }
        this.fireAnalysisComplete();
        return pos;
    }

    @Override
    public boolean isLoadComplete() {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public void loadCompleted() {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public void write(OutputStream output) throws IOException {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public int getWaveValue(int index) {
        SampleAnalyzer analyzer = this.getAnalyzer(index);
        if (analyzer != null) {
            return analyzer.getWaveValue(index);
        }
        return -1;
    }

    @Override
    public int getFitValue(int index) {
        SampleAnalyzer analyzer = this.getAnalyzer(index);
        if (analyzer != null) {
            return analyzer.getFitValue(index);
        }
        return -1;
    }

    @Override
    public int getBitValue(int index) {
        SampleAnalyzer analyzer = this.getAnalyzer(index);
        if (analyzer != null) {
            return analyzer.getBitValue(index);
        }
        return -1;
    }

    @Override
    public void getBitNumber(int index, int[] pos) {
        int numBits = 0;
        int i = 0;
        while (i < this.mNumAnalyzers) {
            if (index >= this.mSampleAnalyzers[i].getFirstBitStartIndex() && index <= this.mSampleAnalyzers[i].getLastBitEndIndex()) {
                this.mSampleAnalyzers[i].getBitNumber(index, pos);
                pos[0] = pos[0] + numBits;
                return;
            }
            numBits += this.mSampleAnalyzers[i].getNumBytes() * 8;
            ++i;
        }
    }

    @Override
    public int getBitStartIndex(int bitNumber) {
        int i = 0;
        while (i < this.mNumAnalyzers) {
            if (bitNumber < this.mSampleAnalyzers[i].getNumBytes() * 8) {
                return this.mSampleAnalyzers[i].getBitStartIndex(bitNumber);
            }
            bitNumber -= this.mSampleAnalyzers[i].getNumBytes() * 8;
            ++i;
        }
        return -1;
    }

    @Override
    public int getBitEndIndex(int bitNumber) {
        int i = 0;
        while (i < this.mNumAnalyzers) {
            if (bitNumber < this.mSampleAnalyzers[i].getNumBytes() * 8) {
                return this.mSampleAnalyzers[i].getBitEndIndex(bitNumber);
            }
            bitNumber -= this.mSampleAnalyzers[i].getNumBytes() * 8;
            ++i;
        }
        return -1;
    }

    @Override
    public int setBitValue(int index, int value, int maxErrors, int maxWarnings, boolean printMessages) {
        int analyzerNumber = this.getAnalyzerNumber(index);
        if (analyzerNumber != -1) {
            int pos = this.mSampleAnalyzers[analyzerNumber].setBitValue(index, value, maxErrors, maxWarnings, false);
            return this.reanalyze(analyzerNumber, pos, maxErrors, maxWarnings, printMessages);
        }
        return -1;
    }

    private void reanalyze(int index, int maxErrors, int maxWarnings, boolean printMessages) {
        if (index == -1) {
            return;
        }
        int number = this.getAnalyzerNumber(index);
        int start = this.mStarts[number];
        SampleAnalyzer analyzer = this.mSampleAnalyzers[number];
        int pos = analyzer.analyze(start, maxErrors, maxWarnings, printMessages);
        this.reanalyze(number, pos, maxErrors, maxWarnings, printMessages);
    }

    private int reanalyze(int number, int pos, int maxErrors, int maxWarnings, boolean printMessages) {
        if (pos != -1) {
            SampleAnalyzer sa = this.mSampleAnalyzers[number];
            if (printMessages) {
                sa.printMessages();
            }
            int j = number + 1;
            while (j < this.mNumAnalyzers) {
                this.mSampleAnalyzers[j].cleanUp();
                this.mSampleAnalyzers[j++] = null;
            }
            this.mNumAnalyzers = number + 1;
            pos = (int)((double)pos + this.mSample.getSamplesPerSecond() * (double)this.mMinSecondsGap);
            return this.analyzeFrom(pos, this.mSample.numSamples(), maxErrors, maxWarnings, printMessages);
        }
        return -1;
    }

    @Override
    public int undo(int maxErrors, int maxWarnings, boolean printMessages) {
        int index = this.mSample.undo();
        this.reanalyze(index, maxErrors, maxWarnings, printMessages);
        return index;
    }

    @Override
    public int redo(int maxErrors, int maxWarnings, boolean printMessages) {
        int index = this.mSample.redo();
        this.reanalyze(index, maxErrors, maxWarnings, printMessages);
        return index;
    }

    @Override
    public String getByteValue(int index) {
        SampleAnalyzer analyzer = this.getAnalyzer(index);
        if (analyzer != null) {
            return analyzer.getByteValue(index);
        }
        return null;
    }

    @Override
    public byte[] getBytes() {
        if (this.mNumAnalyzers == 1) {
            return this.mSampleAnalyzers[0].getBytes();
        }
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public int getByteNumber(int index) {
        SampleAnalyzer analyzer = this.getAnalyzer(index);
        if (analyzer != null) {
            return analyzer.getByteNumber(index);
        }
        return -1;
    }

    @Override
    public void getByteNumber(int index, int[] pos) {
        int numBytes = 0;
        int i = 0;
        while (i < this.mNumAnalyzers) {
            if (index >= this.mSampleAnalyzers[i].getFirstBitStartIndex() && index <= this.mSampleAnalyzers[i].getLastBitEndIndex()) {
                this.mSampleAnalyzers[i].getByteNumber(index, pos);
                pos[0] = pos[0] + numBytes;
                return;
            }
            numBytes += this.mSampleAnalyzers[i].getNumBytes();
            ++i;
        }
    }

    @Override
    public int getByte(int bytePosition) {
        int i = 0;
        while (i < this.mNumAnalyzers) {
            if (bytePosition < this.mSampleAnalyzers[i].getNumBytes()) {
                return this.mSampleAnalyzers[i].getByte(bytePosition);
            }
            bytePosition -= this.mSampleAnalyzers[i].getNumBytes();
            ++i;
        }
        return -1;
    }

    @Override
    public int getNumBytes() {
        int total = 0;
        int i = 0;
        while (i < this.mNumAnalyzers) {
            total += this.mSampleAnalyzers[i].getNumBytes();
            ++i;
        }
        return total;
    }

    @Override
    public int getByteStartIndex(int bytePosition) {
        int i = 0;
        while (i < this.mNumAnalyzers) {
            if (bytePosition < this.mSampleAnalyzers[i].getNumBytes()) {
                return this.mSampleAnalyzers[i].getByteStartIndex(bytePosition);
            }
            bytePosition -= this.mSampleAnalyzers[i].getNumBytes();
            ++i;
        }
        return -1;
    }

    @Override
    public int getNoiseThreshold(int index) {
        if (this.mNumAnalyzers > 0) {
            int aNum = Math.max(0, this.getAnalyzerNumber(index));
            return this.mSampleAnalyzers[aNum].getNoiseThreshold(Math.max(0, index - this.mStarts[aNum]));
        }
        return -1;
    }

    @Override
    public int getFirstBitStartIndex() {
        if (this.mNumAnalyzers > 0) {
            return this.mSampleAnalyzers[0].getFirstBitStartIndex();
        }
        return -1;
    }

    @Override
    public int getLastBitEndIndex() {
        if (this.mNumAnalyzers > 0) {
            return this.mSampleAnalyzers[this.mNumAnalyzers - 1].getLastBitEndIndex();
        }
        return -1;
    }

    @Override
    public void warning(int position, String message) {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public int numMessages() {
        return this.numWarnings() + this.numErrors();
    }

    @Override
    public int numWarnings() {
        int result = 0;
        int i = 0;
        while (i < this.mNumAnalyzers) {
            result += this.mSampleAnalyzers[i].numWarnings();
            ++i;
        }
        return result;
    }

    @Override
    public void error(int position, String message) {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public void clearMessages(int position) {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public int numErrors() {
        int result = 0;
        int i = 0;
        while (i < this.mNumAnalyzers) {
            result += this.mSampleAnalyzers[i].numErrors();
            ++i;
        }
        return result;
    }

    @Override
    public int getMessageIndex(int messageNumber) {
        int i = 0;
        while (i < this.mNumAnalyzers) {
            int msgs = this.mSampleAnalyzers[i].numMessages();
            if (messageNumber >= msgs) {
                messageNumber -= msgs;
            } else {
                return this.mSampleAnalyzers[i].getMessageIndex(messageNumber);
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isMessageError(int messageNumber) {
        int i = 0;
        while (i < this.mNumAnalyzers) {
            int msgs = this.mSampleAnalyzers[i].numMessages();
            if (messageNumber >= msgs) {
                messageNumber -= msgs;
            } else {
                return this.mSampleAnalyzers[i].isMessageError(messageNumber);
            }
            ++i;
        }
        return false;
    }

    @Override
    public void printMessages() {
        int i = 0;
        while (i < this.mNumAnalyzers) {
            this.mSampleAnalyzers[i].printMessages();
            ++i;
        }
    }

    @Override
    public Message[] getMessages() {
        int total = this.numErrors() + this.numWarnings();
        Message[] result = new Message[total];
        int i = 0;
        int pos = 0;
        while (i < this.mNumAnalyzers) {
            Message[] mess = this.mSampleAnalyzers[i].getMessages();
            if (mess.length > 0) {
                System.arraycopy(mess, 0, result, pos, mess.length);
                pos += mess.length;
            }
            ++i;
        }
        return result;
    }

    @Override
    public void cleanUp() {
        int i = 0;
        while (i < this.mNumAnalyzers) {
            this.mSampleAnalyzers[i].cleanUp();
            this.mSampleAnalyzers[i] = null;
            ++i;
        }
        this.mSampleAnalyzers = null;
    }

    @Override
    public void addAnalysisListener(AnalysisListener l) {
        this.mListeners.add(l);
    }

    private void fireAnalysisComplete() {
        for (AnalysisListener listener : this.mListeners) {
            listener.analysisComplete(new AnalysisEvent(this));
        }
    }

    public SampleAnalyzer getSampleAnalyzer(int analyzerNumber) {
        if (analyzerNumber < this.mNumAnalyzers) {
            return this.mSampleAnalyzers[analyzerNumber];
        }
        return null;
    }

    public int numAnalyzers() {
        return this.mNumAnalyzers;
    }

    @Override
    public void debugWaveMessage(int index, String message) {
        throw new IllegalArgumentException("Not implemented: debugWaveMessage");
    }

    @Override
    public void debugBitMessage(int index, String message) {
        throw new IllegalArgumentException("Not implemented: debugBitMessage");
    }

    @Override
    public void debugByteMessage(int index, String message) {
        throw new IllegalArgumentException("Not implemented: debugByteMessage");
    }

    @Override
    public void debugMessage(String message, boolean stack) {
        throw new IllegalArgumentException("Not implemented: debugMessage");
    }

    @Override
    public final boolean debuggingWave(int index) {
        return false;
    }

    @Override
    public final boolean debuggingBit(int index) {
        return false;
    }

    @Override
    public final boolean debuggingByte(int index) {
        return false;
    }
}

