/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tapeutils.Message;
import tapeutils.MultiSampleAnalyzer;
import tapeutils.SampleAnalyzer;
import tapeutils.gui.ConversionFrame;
import tapeutils.gui.MessageSelectionListener;
import tapeutils.impl.zx81.ZX81SampleAnalyzer;
import tapeutils.zx81.TapeConverter;

public class AnalysisResultsPanel
extends JPanel
implements ActionListener,
MessageSelectionListener,
ListSelectionListener {
    private JLabel mSampleLabel;
    private JList mMessageList;
    private JPanel mProgramListPanel;
    private JScrollPane mProgramListScrollPane;
    private Message[] mMessageLog;
    private TapeConverter mConverter;
    private int mSampleNumber;
    private int[] mMaxWidths;

    public AnalysisResultsPanel(TapeConverter converter, int sampleNumber) {
        this.setName("AnalysisResultsPanel");
        this.mConverter = converter;
        this.mConverter.addMessageSelectionListener(sampleNumber, this);
        ConversionFrame cf = this.mConverter.getConversionFrame();
        this.mSampleNumber = sampleNumber;
        this.setLayout(new BorderLayout(10, 10));
        JPanel panel1 = new JPanel();
        panel1.setBorder(BorderFactory.createTitledBorder("Sample " + (sampleNumber + 1) + " Properties"));
        this.add((Component)panel1, "North");
        this.mSampleLabel = cf.createLabel(this, "sample");
        panel1.add(this.mSampleLabel);
        this.mProgramListScrollPane = new JScrollPane();
        this.mProgramListScrollPane.setBorder(BorderFactory.createTitledBorder("ZX81 Programs Found"));
        cf.addToolTipText(this, this.mProgramListScrollPane, "programlist");
        this.add((Component)this.mProgramListScrollPane, "Center");
        this.mMessageList = new JList();
        this.mMessageList.setBackground(this.getBackground());
        this.mMessageList.setSelectionMode(0);
        this.mMessageList.setLayoutOrientation(0);
        this.mMessageList.setVisibleRowCount(8);
        this.mMessageList.addListSelectionListener(this);
        this.mMessageList.setModel(new DefaultListModel());
        this.mMessageList.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                if (this.isSelectedIndex(index0)) {
                    super.removeSelectionInterval(index0, index1);
                }
                super.setSelectionInterval(index0, index1);
            }
        });
        cf.addToolTipText(this, this.mSampleLabel, "messagelist");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(BorderFactory.createTitledBorder("Error/warning log"));
        scrollPane.getViewport().setView(this.mMessageList);
        this.add((Component)scrollPane, "South");
    }

    public void refresh() {
        this.mSampleLabel.setText("Audio format: " + this.mConverter.getSample(this.mSampleNumber).getAudioFormat());
        MultiSampleAnalyzer analyzer = (MultiSampleAnalyzer)this.mConverter.getSampleAnalyzer(this.mSampleNumber);
        if (analyzer == null) {
            return;
        }
        this.clearAnalysisResults();
        int num = analyzer.numAnalyzers();
        int i = 0;
        while (i < num) {
            this.addAnalysisResults(analyzer.getSampleAnalyzer(i), i);
            ++i;
        }
        this.addAnalysisResultsComplete();
        DefaultListModel<String> model = new DefaultListModel<String>();
        this.mMessageLog = analyzer.getMessages();
        if (this.mMessageLog.length > 0) {
            StringBuffer buffer = new StringBuffer();
            int i2 = 0;
            while (i2 < this.mMessageLog.length) {
                buffer.append(this.mMessageLog[i2].isError() ? "ERROR" : "Warning").append(" at ").append(this.mMessageLog[i2].getIndex()).append(" ").append(this.mMessageLog[i2].getText());
                model.addElement(buffer.toString());
                buffer.setLength(0);
                ++i2;
            }
        } else {
            model.addElement("--- No errors/warnings ---");
        }
        this.mMessageList.setModel(model);
        this.mMessageList.ensureIndexIsVisible(0);
    }

    private void clearAnalysisResults() {
        this.mProgramListPanel = new JPanel();
        this.mProgramListPanel.setLayout(new GridLayout(0, 1));
        JPanel rowPanel = new JPanel(new FlowLayout(0, 10, 0));
        this.mProgramListPanel.add(rowPanel);
        this.mMaxWidths = new int[6];
        this.addResultComponent(rowPanel, 0, new JLabel("Start Offset"));
        this.addResultComponent(rowPanel, 1, new JLabel("End Offset"));
        this.addResultComponent(rowPanel, 2, new JLabel("Program Name"));
        this.addResultComponent(rowPanel, 3, new JLabel("Bytes"));
        this.addResultComponent(rowPanel, 4, new JLabel(""));
        this.addResultComponent(rowPanel, 5, new JLabel(""));
    }

    private void addResultComponent(JComponent parent, int column, JComponent comp) {
        parent.add(comp);
        int width = (int)comp.getPreferredSize().getWidth();
        if (width > this.mMaxWidths[column]) {
            this.mMaxWidths[column] = width;
        }
    }

    private void addAnalysisResults(SampleAnalyzer analyzer, int index) {
        JPanel rowPanel = new JPanel(new FlowLayout(0, 10, 0));
        this.mProgramListPanel.add(rowPanel);
        int start = analyzer.getFirstBitStartIndex();
        this.addResultComponent(rowPanel, 0, new JLabel("" + start));
        int end = analyzer.getLastBitEndIndex();
        this.addResultComponent(rowPanel, 1, new JLabel("" + end));
        String programName = null;
        if (analyzer instanceof ZX81SampleAnalyzer) {
            programName = ((ZX81SampleAnalyzer)analyzer).getProgramName();
        }
        if (programName != null && programName.length() > 0) {
            this.addResultComponent(rowPanel, 2, new JLabel(programName));
        } else {
            this.addResultComponent(rowPanel, 2, new JLabel("<html><i>no program name</i></html>"));
        }
        int numBytes = analyzer.getNumBytes();
        this.addResultComponent(rowPanel, 3, new JLabel("" + numBytes));
        ConversionFrame cf = this.mConverter.getConversionFrame();
        JButton showButton = cf.createButton(this, "showposition", -1, true);
        showButton.setActionCommand("SP" + index);
        this.addResultComponent(rowPanel, 4, showButton);
        JButton listButton = cf.createButton(this, "listprogram", -1, true);
        listButton.setActionCommand("ZL" + index);
        this.addResultComponent(rowPanel, 5, listButton);
    }

    private void addAnalysisResultsComplete() {
        int i = 0;
        while (i < this.mProgramListPanel.getComponentCount()) {
            JPanel rowPanel = (JPanel)this.mProgramListPanel.getComponent(i);
            int j = 0;
            while (j < rowPanel.getComponentCount()) {
                JComponent comp = (JComponent)rowPanel.getComponent(j);
                Dimension d = comp.getPreferredSize();
                if (d.getWidth() < (double)this.mMaxWidths[j]) {
                    d.width = this.mMaxWidths[j];
                    comp.setPreferredSize(d);
                }
                ++j;
            }
            ++i;
        }
        this.mProgramListScrollPane.getViewport().setView(this.mProgramListPanel);
    }

    private void showPosition(int index) {
        MultiSampleAnalyzer msa = (MultiSampleAnalyzer)this.mConverter.getSampleAnalyzer(this.mSampleNumber);
        SampleAnalyzer sa = msa.getSampleAnalyzer(index);
        if (sa != null) {
            int startIndex = sa.getFirstBitStartIndex();
            this.mConverter.getConversionFrame().setStartIndex(this.mSampleNumber, startIndex);
        }
    }

    private void showListing(int index) {
        MultiSampleAnalyzer msa = (MultiSampleAnalyzer)this.mConverter.getSampleAnalyzer(this.mSampleNumber);
        SampleAnalyzer sa = msa.getSampleAnalyzer(index);
        if (sa != null) {
            this.mConverter.getConversionFrame().showListDialog(sa.getBytes());
        }
    }

    @Override
    public void messageSelected(int sampleNumber, int messageNumber) {
        this.mMessageList.removeListSelectionListener(this);
        this.mMessageList.setSelectedIndex(messageNumber);
        this.mMessageList.ensureIndexIsVisible(messageNumber);
        this.mMessageList.addListSelectionListener(this);
    }

    @Override
    public synchronized void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JButton) {
            String command = ((JButton)source).getActionCommand();
            if (command.startsWith("SP")) {
                this.showPosition(Integer.parseInt(command.substring(2)));
            } else if (command.startsWith("ZL")) {
                this.showListing(Integer.parseInt(command.substring(2)));
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        int i = evt.getFirstIndex();
        while (i <= evt.getLastIndex()) {
            if (this.mMessageList.isSelectedIndex(i)) {
                this.mConverter.fireMessageSelectionEvent(this.mSampleNumber, i);
                return;
            }
            ++i;
        }
    }
}

