/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.gui;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public abstract class BackgroundCanvas
extends Canvas {
    public static final int NONE = 0;
    public static final int SCALED = 1;
    public static final int TILED = 2;
    public static final int CENTRED = 3;
    public static final int TOPLEFT = 4;
    private Image mBackImage = null;
    private Image mCachedImage = null;
    private Image mDBImage = null;
    private Graphics mDBGraphics = null;
    private Dimension mDBSize = new Dimension(-1, -1);
    private Dimension mCachedSize = new Dimension(-1, -1);
    private boolean mDrawn = false;
    private int mBackMode = 1;
    private int mOldBackMode = 0;
    private boolean mDoubleBuffer = false;

    public BackgroundCanvas() {
        this.mBackMode = 1;
    }

    public BackgroundCanvas(int backMode) {
        this.mBackMode = backMode;
    }

    public abstract void drawBackground();

    public abstract void paintForeground(Graphics var1);

    @Override
    public void setBounds(int x, int y, int w, int h) {
        Dimension oldSize = this.getSize();
        super.setBounds(x, y, w, h);
        if (w != oldSize.width || h != oldSize.height) {
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (!this.mDrawn && this.mBackMode != 0) {
            if (this.mBackImage != null) {
                this.mBackImage.flush();
            }
            this.mBackImage = null;
            this.drawBackground();
            this.mDrawn = true;
            this.mCachedSize.width = -1;
            if (this.mBackImage == null) {
                this.disableBackground();
            }
        }
        Dimension size = this.getSize();
        Dimension minSize = this.getMinimumSize();
        if (minSize.width > size.width) {
            size.width = minSize.width;
        }
        if (minSize.height > size.height) {
            size.height = minSize.height;
        }
        if (this.mDoubleBuffer) {
            if (size.width > this.mDBSize.width || size.height > this.mDBSize.height) {
                if (this.mDBImage != null) {
                    this.mDBImage.flush();
                }
                this.mDBImage = this.createImage(size.width, size.height);
                this.mDBSize = size;
            }
            if (this.mDBGraphics != null) {
                this.mDBGraphics.dispose();
            }
            this.mDBGraphics = this.mDBImage.getGraphics();
            Rectangle clip = g.getClipBounds();
            if (clip != null) {
                this.mDBGraphics.setClip(clip.x, clip.y, clip.width, clip.height);
            }
        } else {
            this.mDBGraphics = g;
        }
        if (this.mBackMode == 2) {
            if (size.width > this.mCachedSize.width || size.height > this.mCachedSize.height) {
                if (this.mCachedImage != null) {
                    this.mCachedImage.flush();
                }
                this.mCachedImage = this.createImage(size.width + 50, size.height + 50);
                Graphics tiledGraphics = this.mCachedImage.getGraphics();
                int width = this.mBackImage.getWidth(null);
                int height = this.mBackImage.getHeight(null);
                int y = 0;
                while (y < size.height + 50) {
                    int x = 0;
                    while (x < size.width + 50) {
                        tiledGraphics.drawImage(this.mBackImage, x, y, null);
                        x += width;
                    }
                    y += height;
                }
                tiledGraphics.dispose();
                this.mCachedSize.width = size.width + 50;
                this.mCachedSize.height = size.height + 50;
            }
            this.mDBGraphics.drawImage(this.mCachedImage, 0, 0, null);
        } else if (this.mBackMode == 3) {
            int width = this.mBackImage.getWidth(null);
            int height = this.mBackImage.getHeight(null);
            this.mDBGraphics.setColor(this.getBackground());
            this.mDBGraphics.fillRect(0, 0, size.width, size.height);
            this.mDBGraphics.drawImage(this.mBackImage, (size.width - width) / 2, (size.height - height) / 2, null);
        } else if (this.mBackMode == 4) {
            this.mDBGraphics.setColor(this.getBackground());
            this.mDBGraphics.fillRect(0, 0, size.width, size.height);
            this.mDBGraphics.drawImage(this.mBackImage, 0, 0, null);
        } else if (this.mBackMode == 1) {
            if (!size.equals(this.mCachedSize)) {
                if (this.mCachedImage != null) {
                    this.mCachedImage.flush();
                }
                this.mCachedImage = this.mBackImage.getScaledInstance(size.width, size.height, 16);
                this.mCachedImage.flush();
                this.mCachedSize = size;
            }
            this.mDBGraphics.drawImage(this.mCachedImage, 0, 0, null);
        } else {
            this.mDBGraphics.setColor(this.getBackground());
            this.mDBGraphics.fillRect(0, 0, size.width, size.height);
        }
        this.paintForeground(this.mDBGraphics);
        if (this.mDoubleBuffer) {
            g.drawImage(this.mDBImage, 0, 0, null);
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public Graphics getBackgroundGraphics(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException();
        }
        this.mBackImage = this.createImage(width, height);
        if (this.mBackImage == null) {
            return null;
        }
        Graphics cachedGraphics = this.mBackImage.getGraphics();
        return cachedGraphics;
    }

    public int getBackgroundMode() {
        return this.mBackMode;
    }

    public void setBackgroundMode(int mode) {
        if (mode != this.mBackMode) {
            this.mCachedSize.width = -1;
        }
        this.mBackMode = mode;
    }

    public void invalidateBackground() {
        this.enableBackground();
        this.mDrawn = false;
        this.repaint();
    }

    public void disableBackground() {
        this.mOldBackMode = this.mBackMode;
        this.mBackMode = 0;
        this.repaint();
    }

    public void enableBackground() {
        if (this.mBackMode == 0) {
            this.mBackMode = this.mOldBackMode;
            this.repaint();
        }
    }

    protected void doubleBuffer(boolean buff) {
        if (buff != this.mDoubleBuffer) {
            this.mDoubleBuffer = buff;
            if (this.mDoubleBuffer) {
                this.mDBSize.width = -1;
                this.repaint();
            }
        }
    }

    public void repaintSync() {
        Graphics viewedGraphics = this.getGraphics();
        if (viewedGraphics != null) {
            this.paint(viewedGraphics);
            viewedGraphics.dispose();
        } else {
            this.repaint();
        }
    }
}

