/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import tapeutils.AnalysisEvent;
import tapeutils.AnalysisListener;
import tapeutils.gui.AnalysisResultsDialog;
import tapeutils.gui.AnalysisSettingsDialog;
import tapeutils.gui.DualSamplePanel;
import tapeutils.gui.HelpDialog;
import tapeutils.gui.ListDialog;
import tapeutils.gui.PreferencesDialog;
import tapeutils.zx81.PreferenceAccessor;
import tapeutils.zx81.TapeConverter;
import util.awt.MIEntry;

public class ConversionFrame
extends JFrame
implements ActionListener,
WindowListener,
ComponentListener,
AnalysisListener {
    private TapeConverter mConverter;
    private JFileChooser mFileDialog;
    private DualSamplePanel mDualSamplePanel;
    private AnalysisResultsDialog mAnalysisResultsDialog;
    private AnalysisSettingsDialog mAnalysisSettingsDialog;
    private PreferencesDialog mPreferencesDialog;
    private ListDialog mListDialog;
    private HelpDialog mHelpDialog;
    private PreferenceAccessor mPrefs;
    private Map mComponentText;
    private JMenuItem mOpen2MenuItem;
    private JMenuItem mSave1MenuItem;
    private JMenuItem mSave1AsMenuItem;
    private JMenuItem mSave2MenuItem;
    private JMenuItem mSave2AsMenuItem;
    private JMenuItem mClose2MenuItem;
    private JMenuItem mSavePMenuItem;
    private JMenuItem mSaveTZXMenuItem;
    private JMenuItem mPlay1MenuItem;
    private JMenuItem mPlay2MenuItem;
    private static final MIEntry[][] MI = new MIEntry[][]{{new MIEntry("File", "File", true, 70), new MIEntry("Open", "Open1", true, 79), new MIEntry("Save", "Save1", false, 83), new MIEntry("Save as", "Save1As", false), new MIEntry("Open second", "Open2", false), new MIEntry("Save second", "Save2", false), new MIEntry("Save second as", "Save2As", false), new MIEntry("Close second", "Close2", false), new MIEntry(), new MIEntry("Save as .P files", "SaveP", false, 83), new MIEntry("Save as .TZX file", "SaveTZX", false, 84), new MIEntry(), new MIEntry("Preferences", "Prefs", true, 80), new MIEntry(), new MIEntry("Quit", "Quit", true, 81)}, {new MIEntry("Analysis", "Analysis", true, 65), new MIEntry("Analysis Settings", "ASet", true, 83), new MIEntry("Analysis Results", "ARes", true, 82)}, {new MIEntry("Play", "Play", true, 80), new MIEntry("Play", "Play1", false, 80), new MIEntry("Play second", "Play2", false)}, {new MIEntry("Help", "Help", true, 72), new MIEntry("Help", "Help", true, 72), new MIEntry("About", "About", true, 65)}};
    public static final String FRAME_TITLE = "ZX81 Tape Converter";
    public static final String FRAME_ICON_FILE = "/images/TapeConverterFrameIcon.gif";
    public static final String ZX81_ROM_FILE = "/images/zx81.rom";
    public static final String DIALOG_RESULTS_TITLE = "Analysis Results";
    public static final String DIALOG_SETTINGS_TITLE = "Analysis Settings";
    public static final String DIALOG_PREFERENCES_TITLE = "Preferences";
    public static final String DIALOG_LISTING_TITLE = "Program Listing";
    public static final String DIALOG_HELP_TITLE = "Help";

    public ConversionFrame() {
        super(FRAME_TITLE);
        this.setName("ConversionFrame");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.addComponentListener(this);
        Image iconImage = new ImageIcon(this.getClass().getResource(FRAME_ICON_FILE)).getImage();
        this.setIconImage(iconImage);
        JMenuBar menuBar = new JMenuBar();
        MIEntry.constructMenus(MI, menuBar, (ActionListener)this);
        this.setJMenuBar(menuBar);
        this.mSave1MenuItem = (JMenuItem)menuBar.getMenu(0).getMenuComponent(1);
        this.mSave1AsMenuItem = (JMenuItem)menuBar.getMenu(0).getMenuComponent(2);
        this.mOpen2MenuItem = (JMenuItem)menuBar.getMenu(0).getMenuComponent(3);
        this.mSave2MenuItem = (JMenuItem)menuBar.getMenu(0).getMenuComponent(4);
        this.mSave2AsMenuItem = (JMenuItem)menuBar.getMenu(0).getMenuComponent(5);
        this.mClose2MenuItem = (JMenuItem)menuBar.getMenu(0).getMenuComponent(6);
        this.mSavePMenuItem = (JMenuItem)menuBar.getMenu(0).getMenuComponent(8);
        this.mSaveTZXMenuItem = (JMenuItem)menuBar.getMenu(0).getMenuComponent(9);
        this.mPlay1MenuItem = (JMenuItem)menuBar.getMenu(2).getMenuComponent(0);
        this.mPlay2MenuItem = (JMenuItem)menuBar.getMenu(2).getMenuComponent(1);
        this.mFileDialog = new JFileChooser();
        this.loadComponentText();
    }

    public void initialize(TapeConverter converter) {
        this.mConverter = converter;
        this.mPrefs = this.mConverter.getPreferences(this);
        this.mConverter.addAnalysisListener(0, this);
        this.mConverter.addAnalysisListener(1, this);
        this.mAnalysisResultsDialog = new AnalysisResultsDialog(converter);
        this.mAnalysisResultsDialog.addComponentListener(this);
        this.mAnalysisSettingsDialog = new AnalysisSettingsDialog(converter);
        this.mAnalysisSettingsDialog.addComponentListener(this);
        this.mPreferencesDialog = new PreferencesDialog(converter);
        this.mPreferencesDialog.addComponentListener(this);
        this.mListDialog = new ListDialog(converter);
        this.mListDialog.addComponentListener(this);
        this.mHelpDialog = new HelpDialog(converter);
        this.mHelpDialog.addComponentListener(this);
        this.mDualSamplePanel = new DualSamplePanel(converter);
        this.getContentPane().add(this.mDualSamplePanel);
        this.pack();
        this.locateWindow(this);
    }

    private void loadComponentText() {
        this.mComponentText = new Properties();
        try {
            InputStream is = this.getClass().getResourceAsStream("/help/componenttext.data");
            if (is == null) {
                throw new IOException("Failed to locate resource /help/componenttext.data");
            }
            ((Properties)this.mComponentText).load(is);
        }
        catch (IOException exc) {
            this.unexpectedError("Loading component text", exc);
        }
    }

    public void addToolTipText(Component parent, JComponent component, String componentName) {
        String parentName = parent.getName();
        String compName = String.valueOf(parentName) + "_" + componentName;
        String text = (String)this.mComponentText.get(String.valueOf(compName) + "_tip");
        if (text != null && text.length() > 0) {
            component.setToolTipText(text);
        }
    }

    public JButton createButton(Component parent, String componentName, int mnemonic, boolean parentIsActionListener) {
        String parentName = parent.getName();
        String compName = String.valueOf(parentName) + "_" + componentName;
        String buttonText = (String)this.mComponentText.get(compName);
        JButton result = new JButton(buttonText);
        result.setName(compName);
        String tipText = (String)this.mComponentText.get(String.valueOf(compName) + "_tip");
        if (tipText != null && tipText.length() > 0) {
            result.setToolTipText(tipText);
        }
        if (mnemonic != -1) {
            result.setMnemonic(mnemonic);
        }
        if (parentIsActionListener) {
            result.addActionListener((ActionListener)((Object)parent));
        }
        return result;
    }

    public JCheckBox createCheckBox(Component parent, String componentName) {
        String parentName = parent.getName();
        String compName = String.valueOf(parentName) + "_" + componentName;
        String checkBoxText = (String)this.mComponentText.get(compName);
        JCheckBox result = checkBoxText == null ? new JCheckBox() : new JCheckBox(checkBoxText);
        result.setName(compName);
        String tipText = (String)this.mComponentText.get(String.valueOf(compName) + "_tip");
        if (tipText != null && tipText.length() > 0) {
            result.setToolTipText(tipText);
        }
        return result;
    }

    public JTextField createTextField(Component parent, String componentName, int width) {
        String parentName = parent.getName();
        String compName = String.valueOf(parentName) + "_" + componentName;
        JTextField result = width == -1 ? new JTextField() : new JTextField(width);
        result.setName(compName);
        String tipText = (String)this.mComponentText.get(String.valueOf(compName) + "_tip");
        if (tipText != null && tipText.length() > 0) {
            result.setToolTipText(tipText);
        }
        return result;
    }

    public JLabel createLabel(Component parent, String componentName) {
        String parentName = parent.getName();
        String compName = String.valueOf(parentName) + "_" + componentName;
        String labelText = (String)this.mComponentText.get(compName);
        JLabel result = new JLabel(labelText);
        result.setName(compName);
        String tipText = (String)this.mComponentText.get(String.valueOf(compName) + "_tip");
        if (tipText != null && tipText.length() > 0) {
            result.setToolTipText(tipText);
        }
        return result;
    }

    public void locateWindow(Window window) {
        String savedLocation = this.mPrefs.get(String.valueOf(window.getName()) + ".Location", "");
        boolean positioned = false;
        if (savedLocation.length() > 0) {
            StringTokenizer tok = new StringTokenizer(savedLocation, ",");
            int x = Integer.parseInt(tok.nextToken());
            int y = Integer.parseInt(tok.nextToken());
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            if ((double)x < dim.getWidth() - 20.0 && (double)y < dim.getHeight() - 20.0) {
                window.setLocation(x, y);
                positioned = true;
            }
        }
        if (!positioned) {
            if (window != this) {
                Point location = this.getLocation();
                location.x += (this.getWidth() - window.getWidth()) / 2;
                location.y += (this.getHeight() - window.getHeight()) / 2;
                window.setLocation(location);
            } else {
                this.setLocationRelativeTo(null);
            }
        }
    }

    public void windowMoved(Window window) {
        Point location = window.getLocation();
        this.mPrefs.set(String.valueOf(window.getName()) + ".Location", String.valueOf(location.x) + "," + location.y);
    }

    @Override
    public void analysisComplete(AnalysisEvent event) {
        this.updateMenuItems();
        if (this.mPrefs.get("TapeConverter.autoShowResults", true)) {
            this.mAnalysisResultsDialog.setVisible(true);
        }
    }

    private void updateMenuItems() {
        this.mSave1MenuItem.setEnabled(this.mConverter.getSampleFile(0) != null);
        this.mSave1AsMenuItem.setEnabled(this.mConverter.getSampleFile(0) != null);
        this.mOpen2MenuItem.setEnabled(this.mConverter.getSampleFile(0) != null);
        this.mSave2MenuItem.setEnabled(this.mConverter.getSampleFile(1) != null);
        this.mSave2AsMenuItem.setEnabled(this.mConverter.getSampleFile(1) != null);
        this.mClose2MenuItem.setEnabled(this.mConverter.getSampleFile(1) != null);
        this.mSavePMenuItem.setEnabled(this.mConverter.getSampleFile(0) != null);
        this.mSaveTZXMenuItem.setEnabled(this.mConverter.getSampleFile(0) != null);
        this.mPlay1MenuItem.setEnabled(this.mConverter.getSampleFile(0) != null);
        this.mPlay2MenuItem.setEnabled(this.mConverter.getSampleFile(1) != null);
    }

    private void loadSample(int sampleNum) {
        int result;
        this.mFileDialog.setFileSelectionMode(0);
        this.mFileDialog.setDialogTitle("Load a Sample from a File");
        File sampleDirectory = this.mPrefs.get("TapeConverter.sampleDirectory", new File(""));
        if (sampleDirectory.exists()) {
            this.mFileDialog.setCurrentDirectory(sampleDirectory);
        }
        if ((result = this.mFileDialog.showOpenDialog(this)) == 0) {
            File f = this.mFileDialog.getSelectedFile();
            if (f.exists() && !f.isDirectory()) {
                File d = this.mFileDialog.getCurrentDirectory();
                if (!d.equals(sampleDirectory)) {
                    this.mPrefs.set("TapeConverter.sampleDirectory", d.getAbsolutePath());
                }
                try {
                    this.mConverter.loadSample(f, sampleNum);
                }
                catch (IOException exc) {
                    this.errorLoadingFile(f, exc);
                }
                catch (UnsupportedAudioFileException exc) {
                    this.errorLoadingFile(f, exc);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Selected file: " + f + " does not exist", "Unexpected error", 0);
            }
        }
    }

    public void errorLoadingFile(File f, Throwable exc) {
        this.unexpectedError("Loading file", exc);
        JOptionPane.showMessageDialog(this, "Error loading: " + f + "\nMessage: " + exc.toString(), "Error Loading File", 0);
    }

    public void errorSavingFile(File f, Throwable exc) {
        JOptionPane.showMessageDialog(this, "Error saving: " + f + "\nMessage: " + exc.toString(), "Error Saving File", 0);
    }

    public void saveSample(int sampleNum, boolean chooseFile) {
        File saveFile = null;
        if (chooseFile) {
            this.mFileDialog.setFileSelectionMode(0);
            this.mFileDialog.setDialogTitle("Save the Sample to a File");
            File sampleFile = this.mConverter.getSampleFile(sampleNum);
            File sampleDirectory = this.mPrefs.get("TapeConverter.sampleDirectory", new File(""));
            if (sampleFile != null) {
                this.mFileDialog.setSelectedFile(sampleFile.getAbsoluteFile());
            } else if (sampleDirectory.exists()) {
                this.mFileDialog.setCurrentDirectory(sampleDirectory);
            }
            int result = this.mFileDialog.showSaveDialog(this);
            if (result == 0) {
                File f = this.mFileDialog.getSelectedFile();
                if (!f.isDirectory()) {
                    if (this.mPrefs.get("TapeConverter.saveSampleAsZIP", false) && !f.getName().toLowerCase().endsWith(".zip")) {
                        f = new File(String.valueOf(f.getAbsolutePath()) + ".zip");
                    }
                    if (f.exists() && JOptionPane.showConfirmDialog(this, "OK to overwrite existing file: " + f + " ?") == 2) {
                        return;
                    }
                    File d = this.mFileDialog.getCurrentDirectory();
                    if (!d.equals(sampleDirectory)) {
                        this.mPrefs.set("TapeConverter.sampleDirectory", d.getAbsolutePath());
                    }
                    saveFile = f;
                } else {
                    JOptionPane.showMessageDialog(this, "Selected file: " + f + " is a directory", "Unexpected error", 0);
                }
            }
        } else {
            saveFile = this.mConverter.getSampleFile(sampleNum);
        }
        if (saveFile != null) {
            try {
                this.mConverter.saveSample(saveFile, sampleNum);
            }
            catch (IOException exc) {
                JOptionPane.showMessageDialog(this, "Error saving: " + saveFile + "\nMessage: " + exc.toString(), "Error Saving Sample File", 0);
            }
        }
        this.mAnalysisSettingsDialog.refreshParameters(sampleNum);
    }

    public void closeSample(int sampleNum) {
        this.mConverter.closeSample(sampleNum);
        this.updateMenuItems();
        this.mAnalysisResultsDialog.refresh(sampleNum);
        this.mAnalysisSettingsDialog.refresh();
        this.mDualSamplePanel.refresh();
    }

    private void playSample(int sampleNum) {
        try {
            int index = this.mDualSamplePanel.getIndex(sampleNum);
            this.mConverter.getSample(sampleNum).play(index, true);
            JOptionPane.showMessageDialog(this, "Playing sample... Hit OK to stop or when finished.", "Playing Sample", 1);
            this.mConverter.getSample(sampleNum).stopPlaying();
        }
        catch (LineUnavailableException exc) {
            JOptionPane.showMessageDialog(this, "Error playing sample: " + exc.toString(), "Error Playing Sample", 0);
        }
    }

    public void showListDialog(byte[] content) {
        this.mListDialog.setFileContent(content);
        this.mListDialog.setVisible(true);
    }

    private void quit() {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to quit?", "Confirm Quit", 0) == 0) {
            try {
                this.mPrefs.save(true);
            }
            catch (Throwable exc) {
                this.unexpectedError("Saving Preferences", exc);
            }
            System.exit(0);
        }
    }

    public void notImplemented(String function) {
        JOptionPane.showMessageDialog(this, "Function " + function, "Function not implemented", 0);
    }

    public void unexpectedError(String message) {
        JOptionPane.showMessageDialog(this, message, "Unexpected error", 0);
    }

    public void unexpectedError(String message, Throwable exc) {
        StringBuffer errorMessage = new StringBuffer();
        errorMessage.append(message).append('\n').append('\n');
        errorMessage.append(exc.toString()).append('\n');
        StackTraceElement[] e = exc.getStackTrace();
        int i = 0;
        while (i < e.length) {
            errorMessage.append(e[i].toString()).append('\n');
            ++i;
        }
        JOptionPane.showMessageDialog(this, errorMessage.toString(), "Unexpected error", 0);
    }

    private void savePFiles() {
        this.mFileDialog.setFileSelectionMode(1);
        this.mFileDialog.setDialogTitle("Save as .P Files - Select Directory");
        File pFileDirectory = this.mPrefs.get("TapeConverter.pFileDirectory", new File(""));
        if (pFileDirectory.exists()) {
            this.mFileDialog.setCurrentDirectory(pFileDirectory);
        }
        int result = this.mFileDialog.showSaveDialog(this);
        File d = null;
        while (d == null && result == 0) {
            d = this.mFileDialog.getSelectedFile();
            if (d.exists() && d.isDirectory()) continue;
            JOptionPane.showMessageDialog(this, "Please choose a directory in which the .P files will be saved", "Directory selection error", 0);
            d = null;
            result = this.mFileDialog.showSaveDialog(this);
        }
        if (result == 0) {
            if (!d.equals(pFileDirectory)) {
                this.mPrefs.set("TapeConverter.pFileDirectory", d.getAbsolutePath());
            }
            try {
                int files = this.mConverter.writePFiles(0, d);
                String message = files == 1 ? "Saved 1 .P file" : "Saved " + files + " .P files";
                JOptionPane.showMessageDialog(this, message, "Saved .P Files", 1);
            }
            catch (IOException exc) {
                this.errorSavingFile(d, exc);
            }
        }
    }

    private void saveTZXFile() {
        File f;
        int result;
        this.mFileDialog.setFileSelectionMode(0);
        this.mFileDialog.setDialogTitle("Save as a TZX File");
        File tzxFileDirectory = this.mPrefs.get("TapeConverter.tzxFileDirectory", new File(""));
        if (tzxFileDirectory.exists()) {
            this.mFileDialog.setCurrentDirectory(tzxFileDirectory);
        }
        if ((result = this.mFileDialog.showSaveDialog(this)) == 0 && !(f = this.mFileDialog.getSelectedFile()).isDirectory()) {
            if (!f.getParentFile().equals(tzxFileDirectory)) {
                this.mPrefs.set("TapeConverter.pFileDirectory", f.getParentFile().getAbsolutePath());
            }
            if (f.exists() && JOptionPane.showConfirmDialog(this, "OK to overwrite existing file: " + f + " ?") == 2) {
                return;
            }
            try {
                this.mConverter.writeTZXFile(0, f);
                JOptionPane.showMessageDialog(this, "Saved to " + f, "Saved .P Files", 1);
            }
            catch (IOException exc) {
                this.errorSavingFile(f, exc);
            }
        }
    }

    public void setStartIndex(int sampleNumber, int index) {
        this.mDualSamplePanel.setIndex(sampleNumber, Math.max(0, index - 40));
    }

    public void showHelp(String helpId) {
        this.mHelpDialog.showHelp(helpId);
        this.mHelpDialog.setVisible(true);
    }

    public void about() {
        JOptionPane.showMessageDialog(this, this.mComponentText.get("About_text"), "About ZX81 Tape Converter", 1, new ImageIcon(this.getIconImage()));
    }

    public void showHelp(Component component) {
        if (component instanceof JDialog) {
            this.mHelpDialog.showHelp("window_" + component.getName());
        } else {
            this.mHelpDialog.showHelp("comp_" + component.getName());
        }
        this.mHelpDialog.setVisible(true);
    }

    @Override
    public synchronized void actionPerformed(ActionEvent evt) {
        try {
            Object source = evt.getSource();
            if (source instanceof JMenuItem) {
                String command = ((JMenuItem)source).getActionCommand();
                if (command.equals("Open1")) {
                    this.loadSample(0);
                } else if (command.equals("Save1")) {
                    this.saveSample(0, false);
                } else if (command.equals("Save1As")) {
                    this.saveSample(0, true);
                } else if (command.equals("Open2")) {
                    this.loadSample(1);
                } else if (command.equals("Save2")) {
                    this.saveSample(1, false);
                } else if (command.equals("Save2As")) {
                    this.saveSample(1, true);
                } else if (command.equals("Close2")) {
                    this.closeSample(1);
                } else if (command.equals("ARes")) {
                    this.mAnalysisResultsDialog.setVisible(true);
                } else if (command.equals("ASet")) {
                    this.mAnalysisSettingsDialog.setVisible(true);
                } else if (command.equals("Quit")) {
                    this.quit();
                } else if (command.equals("SaveP")) {
                    this.savePFiles();
                } else if (command.equals("SaveTZX")) {
                    this.saveTZXFile();
                } else if (command.equals("Play1")) {
                    this.playSample(0);
                } else if (command.equals("Play2")) {
                    this.playSample(1);
                } else if (command.equals("Prefs")) {
                    this.mPreferencesDialog.setVisible(true);
                } else if (command.equals("About")) {
                    this.about();
                } else if (command.equals(DIALOG_HELP_TITLE)) {
                    this.mHelpDialog.setVisible(true);
                }
            }
        }
        catch (Throwable exc) {
            this.unexpectedError("Handling action", exc);
        }
    }

    @Override
    public synchronized void windowClosing(WindowEvent evt) {
        this.quit();
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    @Override
    public void windowClosed(WindowEvent evt) {
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }

    @Override
    public void componentMoved(ComponentEvent evt) {
        if (evt.getSource() instanceof Window) {
            this.windowMoved((Window)evt.getSource());
        }
    }

    @Override
    public void componentResized(ComponentEvent evt) {
    }

    @Override
    public void componentShown(ComponentEvent evt) {
    }

    @Override
    public void componentHidden(ComponentEvent evt) {
    }
}

