/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import tapeutils.gui.ConversionFrame;
import tapeutils.gui.ListCanvas;
import tapeutils.zx81.TapeConverter;

public class ListDialog
extends JDialog
implements ActionListener,
AdjustmentListener {
    private JButton mCloseButton;
    private JButton mHelpButton;
    private ListCanvas mListCanvas;
    private JScrollBar mScrollBar;
    private TapeConverter mConverter;
    private boolean mPositioned = false;

    public ListDialog(TapeConverter converter) {
        super(converter.getConversionFrame(), "Program Listing", false);
        this.setDefaultCloseOperation(1);
        this.setName("ListDialog");
        this.setResizable(false);
        this.mConverter = converter;
        ConversionFrame cf = this.mConverter.getConversionFrame();
        this.mListCanvas = new ListCanvas(this.getClass().getResourceAsStream("/images/zx81.rom"));
        this.getContentPane().add((Component)this.mListCanvas, "Center");
        this.mScrollBar = new JScrollBar(1);
        this.mScrollBar.addAdjustmentListener(this);
        this.getContentPane().add((Component)this.mScrollBar, "East");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.getContentPane().add((Component)buttonPanel, "South");
        this.mCloseButton = cf.createButton(this, "close", 67, true);
        buttonPanel.add(this.mCloseButton);
        this.mHelpButton = cf.createButton(this, "help", 72, true);
        buttonPanel.add(this.mHelpButton);
        this.pack();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && !this.mPositioned) {
            ConversionFrame frame = this.mConverter.getConversionFrame();
            frame.locateWindow(this);
            this.mPositioned = true;
        }
        super.setVisible(visible);
    }

    public void setFileContent(byte[] content) {
        this.mListCanvas.setFileContent(content);
        this.mScrollBar.setValue(0);
        this.mScrollBar.setMinimum(0);
        this.mScrollBar.setMaximum(this.mListCanvas.numLines());
        this.mScrollBar.setVisibleAmount(Math.min(this.mListCanvas.numLines(), 30));
        this.mScrollBar.setEnabled(this.mListCanvas.numLines() > 30);
        this.pack();
        this.repaint();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        this.mListCanvas.setLineNumber(evt.getValue());
    }

    @Override
    public synchronized void actionPerformed(ActionEvent evt) {
        try {
            Object source = evt.getSource();
            if (source instanceof JButton) {
                if (source == this.mCloseButton) {
                    this.setVisible(false);
                } else if (source == this.mHelpButton) {
                    this.mConverter.getConversionFrame().showHelp(this);
                }
            }
        }
        catch (Throwable exc) {
            this.mConverter.getConversionFrame().unexpectedError("Handling action", exc);
        }
    }
}

