/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import sinclair.basic.ZX81Translate;
import tapeutils.gui.ConversionFrame;
import tapeutils.zx81.PreferenceAccessor;
import tapeutils.zx81.PreferenceListener;
import tapeutils.zx81.TapeConverter;

public class PreferencesDialog
extends JDialog
implements ActionListener,
PreferenceListener {
    private JButton mOKButton;
    private JButton mApplyButton;
    private JButton mCancelButton;
    private JButton mHelpButton;
    private TapeConverter mConverter;
    private JComboBox mFrequencyBox;
    private JTextField mPFileNameField;
    private JCheckBox mSquareCheckBox;
    private JTextField mPDirectoryField;
    private JButton mPDirectoryBrowseButton;
    private JTextField mTZXDirectoryField;
    private JButton mTZXDirectoryBrowseButton;
    private JTextField mSampleDirectoryField;
    private JButton mSampleDirectoryBrowseButton;
    private JCheckBox mSaveSampleAsZipCheckBox;
    private JCheckBox mAutoShowResultsCheckBox;
    private JTextField mMaximumErrorsField;
    private JTextField mMaximumWarningsField;
    private JFileChooser mFileDialog;
    private boolean mPositioned = false;
    private PreferenceAccessor mPrefs;

    public PreferencesDialog(TapeConverter converter) {
        super(converter.getConversionFrame(), "Preferences", false);
        this.setDefaultCloseOperation(1);
        this.setName("PreferencesDialog");
        this.getContentPane().setLayout(new BorderLayout());
        this.mConverter = converter;
        ConversionFrame cf = this.mConverter.getConversionFrame();
        this.mPrefs = this.mConverter.getPreferences(this);
        this.mPrefs.addPreferenceListener(this);
        JPanel centrePanel = new JPanel();
        BoxLayout bl = new BoxLayout(centrePanel, 1);
        centrePanel.setLayout(bl);
        centrePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)centrePanel, "Center");
        JPanel sampleGenPanel = new JPanel(new GridLayout(0, 1));
        sampleGenPanel.setBorder(BorderFactory.createTitledBorder("Sample Generation"));
        cf.addToolTipText(this, sampleGenPanel, "samplegen");
        centrePanel.add(sampleGenPanel);
        JPanel panel = new JPanel(new FlowLayout(0));
        sampleGenPanel.add(panel);
        panel.add(cf.createLabel(this, "frequencylabel"));
        this.mFrequencyBox = new JComboBox<String>(new String[]{"22050hz", "44100hz"});
        panel.add(this.mFrequencyBox);
        cf.addToolTipText(this, this.mFrequencyBox, "frequency");
        panel = new JPanel(new FlowLayout(0));
        sampleGenPanel.add(panel);
        panel.add(cf.createLabel(this, "pfilenamelabel"));
        this.mPFileNameField = cf.createTextField(this, "pfilename", 20);
        panel.add(this.mPFileNameField);
        panel = new JPanel(new FlowLayout(0));
        sampleGenPanel.add(panel);
        this.mSquareCheckBox = cf.createCheckBox(this, "square");
        panel.add(this.mSquareCheckBox);
        JPanel directoriesPanel = new JPanel(new GridLayout(0, 1));
        directoriesPanel.setBorder(BorderFactory.createTitledBorder("Directories"));
        centrePanel.add(directoriesPanel);
        panel = new JPanel(new FlowLayout(0));
        directoriesPanel.add(panel);
        panel.add((Component)cf.createLabel(this, "pdirectorylabel"), "West");
        this.mPDirectoryField = cf.createTextField(this, "pdirectory", 30);
        panel.add((Component)this.mPDirectoryField, "Center");
        this.mPDirectoryBrowseButton = cf.createButton(this, "pdirectorybrowse", -1, true);
        panel.add((Component)this.mPDirectoryBrowseButton, "East");
        panel = new JPanel(new FlowLayout(0));
        directoriesPanel.add(panel);
        panel.add((Component)cf.createLabel(this, "tzxdirectorylabel"), "West");
        this.mTZXDirectoryField = cf.createTextField(this, "tzxdirectory", 30);
        panel.add((Component)this.mTZXDirectoryField, "Center");
        this.mTZXDirectoryBrowseButton = cf.createButton(this, "tzxdirectorybrowse", -1, true);
        panel.add((Component)this.mTZXDirectoryBrowseButton, "East");
        panel = new JPanel(new FlowLayout(0));
        directoriesPanel.add(panel);
        panel.add((Component)cf.createLabel(this, "sampledirectorylabel"), "West");
        this.mSampleDirectoryField = cf.createTextField(this, "sampledirectory", 30);
        panel.add((Component)this.mSampleDirectoryField, "Center");
        this.mSampleDirectoryBrowseButton = cf.createButton(this, "sampledirectorybrowse", -1, true);
        panel.add((Component)this.mSampleDirectoryBrowseButton, "East");
        this.mSaveSampleAsZipCheckBox = cf.createCheckBox(this, "saveaszip");
        directoriesPanel.add(this.mSaveSampleAsZipCheckBox);
        JPanel otherOptionsPanel = new JPanel(new GridLayout(0, 1));
        otherOptionsPanel.setBorder(BorderFactory.createTitledBorder("Other Options"));
        centrePanel.add(otherOptionsPanel);
        this.mAutoShowResultsCheckBox = cf.createCheckBox(this, "autoshowresults");
        otherOptionsPanel.add(this.mAutoShowResultsCheckBox);
        panel = new JPanel(new FlowLayout(0));
        otherOptionsPanel.add(panel);
        panel.add(cf.createLabel(this, "maximumerrorslabel"));
        this.mMaximumErrorsField = cf.createTextField(this, "maximumerrors", 10);
        panel.add(this.mMaximumErrorsField);
        panel = new JPanel(new FlowLayout(0));
        otherOptionsPanel.add(panel);
        panel.add(cf.createLabel(this, "maximumwarningslabel"));
        this.mMaximumWarningsField = cf.createTextField(this, "maximumwarnings", 10);
        panel.add(this.mMaximumWarningsField);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)buttonPanel, "South");
        this.mOKButton = cf.createButton(this, "ok", 79, true);
        buttonPanel.add(this.mOKButton);
        this.mApplyButton = cf.createButton(this, "apply", 65, true);
        buttonPanel.add(this.mApplyButton);
        this.mCancelButton = cf.createButton(this, "cancel", 67, true);
        buttonPanel.add(this.mCancelButton);
        this.mHelpButton = cf.createButton(this, "help", 72, true);
        buttonPanel.add(this.mHelpButton);
        this.mFileDialog = new JFileChooser();
        this.mFileDialog.setFileSelectionMode(1);
        this.mFileDialog.setApproveButtonText("Select Directory");
        this.refresh(null);
    }

    public void refresh(String key) {
        if (key == null || key.equals("TapeConverter.sampleRate")) {
            float sampleRate = this.mPrefs.get("TapeConverter.sampleRate", 22050.0f);
            if (sampleRate == 22050.0f) {
                this.mFrequencyBox.setSelectedIndex(0);
            } else {
                this.mFrequencyBox.setSelectedIndex(1);
            }
        }
        if (key == null || key.equals("TapeConverter.pProgramName")) {
            this.mPFileNameField.setText(this.mPrefs.get("TapeConverter.pProgramName", "P"));
        }
        if (key == null || key.equals("TapeConverter.squareWave")) {
            this.mSquareCheckBox.setSelected(this.mPrefs.get("TapeConverter.squareWave", false));
        }
        if (key == null || key.equals("TapeConverter.saveSampleAsZIP")) {
            this.mSaveSampleAsZipCheckBox.setSelected(this.mPrefs.get("TapeConverter.saveSampleAsZIP", false));
        }
        if (key == null || key.equals("TapeConverter.autoShowResults")) {
            this.mAutoShowResultsCheckBox.setSelected(this.mPrefs.get("TapeConverter.autoShowResults", true));
        }
        if (key == null || key.equals("TapeConverter.maximumErrors")) {
            this.mMaximumErrorsField.setText(this.mPrefs.get("TapeConverter.maximumErrors", "50"));
        }
        if (key == null || key.equals("TapeConverter.maximumWarnings")) {
            this.mMaximumWarningsField.setText(this.mPrefs.get("TapeConverter.maximumWarnings", "1000"));
        }
        this.initDirectoryFields(key, this.mPDirectoryField, "TapeConverter.pFileDirectory");
        this.initDirectoryFields(key, this.mTZXDirectoryField, "TapeConverter.tzxFileDirectory");
        this.initDirectoryFields(key, this.mSampleDirectoryField, "TapeConverter.sampleDirectory");
        this.pack();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && !this.mPositioned) {
            ConversionFrame frame = this.mConverter.getConversionFrame();
            frame.locateWindow(this);
            this.mPositioned = true;
        }
        super.setVisible(visible);
    }

    private void applyChanges(boolean stayVisible) {
        this.setVisible(stayVisible);
        String pName = this.mPFileNameField.getText();
        if (ZX81Translate.checkTranslatableToZX81(pName)) {
            this.mPrefs.set("TapeConverter.pProgramName", pName);
        } else {
            this.mPFileNameField.setText(this.mPrefs.get("TapeConverter.pProgramName", ""));
        }
        float rate = this.mFrequencyBox.getSelectedIndex() == 0 ? 22050.0f : 44100.0f;
        this.mPrefs.set("TapeConverter.sampleRate", rate);
        this.mPrefs.set("TapeConverter.squareWave", this.mSquareCheckBox.isSelected());
        this.mPrefs.set("TapeConverter.saveSampleAsZIP", this.mSaveSampleAsZipCheckBox.isSelected());
        this.mPrefs.set("TapeConverter.autoShowResults", this.mAutoShowResultsCheckBox.isSelected());
        this.mPrefs.set("TapeConverter.maximumErrors", Integer.parseInt(this.mMaximumErrorsField.getText()));
        this.mPrefs.set("TapeConverter.maximumWarnings", Integer.parseInt(this.mMaximumWarningsField.getText()));
        this.applyDirectoryChange(this.mPDirectoryField, "TapeConverter.pFileDirectory");
        this.applyDirectoryChange(this.mTZXDirectoryField, "TapeConverter.tzxFileDirectory");
        this.applyDirectoryChange(this.mSampleDirectoryField, "TapeConverter.sampleDirectory");
    }

    private void initDirectoryFields(String key, JTextField field, String directoryKey) {
        if (key == null || key.equals(directoryKey)) {
            field.setText(this.mPrefs.get(directoryKey, ""));
        }
    }

    private void applyDirectoryChange(JTextField field, String directoryKey) {
        String dir = field.getText();
        if (dir.length() == 0 || new File(dir).isDirectory()) {
            this.mPrefs.set(directoryKey, dir);
        } else {
            String previous = this.mPrefs.get(directoryKey, "");
            JOptionPane.showMessageDialog(this, "Selected directory: " + dir + " does not exist.\n" + "Resetting to previous value: " + previous, "Directory does not exist", 0);
            field.setText(previous);
        }
    }

    private void browseForDirectory(JTextField field, String title, String key) {
        File directory = new File(field.getText());
        if (directory.isDirectory()) {
            this.mFileDialog.setCurrentDirectory(directory);
        }
        this.mFileDialog.setDialogTitle(title);
        if (this.mFileDialog.showOpenDialog(this) == 0) {
            String path = this.mFileDialog.getSelectedFile().getAbsolutePath();
            field.setText(path);
            this.mPrefs.set(key, path);
        }
    }

    @Override
    public void preferenceUpdated(Object source, String key) {
        if (source == this) {
            return;
        }
        this.refresh(key);
    }

    @Override
    public synchronized void actionPerformed(ActionEvent evt) {
        try {
            Object source = evt.getSource();
            if (source instanceof JButton) {
                if (source == this.mCancelButton) {
                    this.refresh(null);
                    this.setVisible(false);
                } else if (source == this.mApplyButton) {
                    this.applyChanges(true);
                } else if (source == this.mOKButton) {
                    this.applyChanges(false);
                } else if (source == this.mHelpButton) {
                    this.mConverter.getConversionFrame().showHelp(this);
                } else if (source == this.mPDirectoryBrowseButton) {
                    this.browseForDirectory(this.mPDirectoryField, "Select Default .P File Directory", "TapeConverter.pFileDirectory");
                } else if (source == this.mTZXDirectoryBrowseButton) {
                    this.browseForDirectory(this.mTZXDirectoryField, "Select Default .TZX File Directory", "TapeConverter.tzxFileDirectory");
                } else if (source == this.mSampleDirectoryBrowseButton) {
                    this.browseForDirectory(this.mSampleDirectoryField, "Select Default Sample Directory", "TapeConverter.sampleDirectory");
                }
            }
        }
        catch (Throwable exc) {
            this.mConverter.getConversionFrame().unexpectedError("Handling action", exc);
        }
    }
}

