/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import tapeutils.gui.BackgroundCanvas;

public class ProgressBar
extends BackgroundCanvas {
    private int mMaxValue = 100;
    private int mCurrValue = 0;
    private Color mBarColour = null;
    private Canvas mBackCanvas = null;
    private String mText = null;
    private FontMetrics mMetrics = null;
    private boolean mPercentageText = false;
    private Dimension mPreferredSize = null;

    public ProgressBar() {
        super(2);
        this.doubleBuffer(true);
        this.mBarColour = Color.blue;
    }

    public ProgressBar(Color barColour) {
        super(2);
        this.doubleBuffer(true);
        this.mBarColour = barColour;
    }

    @Override
    public void drawBackground() {
        Graphics backGraphics = null;
        backGraphics = this.getBackgroundGraphics(100, 100);
        if (backGraphics == null) {
            return;
        }
        backGraphics.setColor(this.mBarColour);
        backGraphics.fillRect(0, 0, 100, 100);
        backGraphics.dispose();
    }

    @Override
    public void paintForeground(Graphics g) {
        g.setColor(this.getBackground());
        Dimension size = this.getSize();
        int barWidth = size.width * this.mCurrValue / this.mMaxValue;
        g.fillRect(barWidth, 0, size.width - barWidth, size.height);
        if (this.mText != null || this.mPercentageText) {
            String displayText = this.mPercentageText ? 100 * this.mCurrValue / this.mMaxValue + "%" : this.mText;
            this.mMetrics = g.getFontMetrics();
            int textHeight = this.mMetrics.getMaxAscent() - this.mMetrics.getMaxDescent();
            g.setColor(Color.black);
            g.drawString(displayText, 2, (size.height + textHeight) / 2);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mPreferredSize != null) {
            return this.mPreferredSize;
        }
        return this.getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public String getBarText() {
        return this.mText;
    }

    public void setBarText(String text) {
        this.mPercentageText = false;
        this.mText = text;
        this.repaint();
    }

    public boolean getPercentageText() {
        return this.mPercentageText;
    }

    public void setPercentageText(boolean perc) {
        this.mText = null;
        this.mPercentageText = perc;
        this.repaint();
    }

    public void setBarColour(Color barColour) {
        if (!barColour.equals(this.mBarColour)) {
            this.mBarColour = barColour;
            this.invalidateBackground();
        }
    }

    public Color getBarColour() {
        return this.mBarColour;
    }

    public void setCurrentValue(int curr) {
        if (curr != this.mCurrValue) {
            this.mCurrValue = curr;
            if (this.mCurrValue > this.mMaxValue) {
                this.mCurrValue = this.mMaxValue;
            }
            this.repaintSync();
        }
    }

    public int getCurrentValue() {
        return this.mCurrValue;
    }

    public void setMaximumValue(int max) {
        this.mMaxValue = max;
        if (this.mCurrValue > this.mMaxValue) {
            this.mCurrValue = this.mMaxValue;
        }
        this.repaint();
    }

    public int getMaximumValue() {
        return this.mMaxValue;
    }

    public void increaseValue(int inc) {
        this.mCurrValue += inc;
        if (this.mCurrValue > this.mMaxValue) {
            this.mCurrValue = this.mMaxValue;
        }
        this.repaint();
    }

    @Override
    public void setBackground(Color col) {
        super.setBackground(col);
        if (this.mBackCanvas != null) {
            this.mBackCanvas.setBackground(col);
        }
    }

    @Override
    public void setSize(int w, int h) {
        this.mPreferredSize = new Dimension(w, h);
        super.setSize(w, h);
    }
}

