/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.gui;

import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tapeutils.gui.ConversionFrame;
import tapeutils.zx81.TapeConverter;
import tapeutils.zx81.TapeConverterParameters;

public class SampleParametersPanel
extends JPanel {
    private TapeConverterParameters mParameters;
    private JTextField mBeginIndexField;
    private JCheckBox mInvertCheckBox;
    private JComboBox mChannelNumberBox;
    private JTextField mMinSecondsGapField;
    private JTextField mNumExpectedFilesField;

    public SampleParametersPanel(TapeConverter converter) {
        this.setName("SampleParametersPanel");
        this.setLayout(new GridLayout(0, 2));
        ConversionFrame cf = converter.getConversionFrame();
        this.add(cf.createLabel(this, "beginindexlabel"));
        this.mBeginIndexField = cf.createTextField(this, "beginindex", -1);
        this.add(this.mBeginIndexField);
        this.add(cf.createLabel(this, "numexpectedfileslabel"));
        this.mNumExpectedFilesField = cf.createTextField(this, "numexpectedfiles", -1);
        this.add(this.mNumExpectedFilesField);
        this.add(cf.createLabel(this, "minsecondsgaplabel"));
        this.mMinSecondsGapField = cf.createTextField(this, "minsecondsgap", -1);
        this.add(this.mMinSecondsGapField);
        this.add(cf.createLabel(this, "invertlabel"));
        this.mInvertCheckBox = cf.createCheckBox(this, "invert");
        this.add(this.mInvertCheckBox);
        this.add(cf.createLabel(this, "channelnumberlabel"));
        this.mChannelNumberBox = new JComboBox();
        this.add(this.mChannelNumberBox);
        cf.addToolTipText(this, this.mChannelNumberBox, "channelnumber");
    }

    public void initialize(TapeConverterParameters params) {
        this.mParameters = params;
        boolean[] isDefault = new boolean[1];
        this.mBeginIndexField.setText(this.getValueText(this.mParameters.getBeginIndex(isDefault), isDefault));
        this.mMinSecondsGapField.setText(this.getValueText(this.mParameters.getMinSecondsGap(isDefault), isDefault));
        this.mNumExpectedFilesField.setText(this.getValueText(this.mParameters.getNumExpectedFiles(isDefault), isDefault));
        this.mInvertCheckBox.setSelected(this.mParameters.getInvert());
        int channel = this.mParameters.getChannel(isDefault);
        int defaultChannel = isDefault[0] ? channel : 1 - channel;
        int maxChannels = 2;
        this.mChannelNumberBox.removeAllItems();
        int i = 0;
        while (i < maxChannels) {
            if (i == defaultChannel) {
                this.mChannelNumberBox.addItem("Default: channel " + i);
            } else {
                this.mChannelNumberBox.addItem("channel " + i);
            }
            ++i;
        }
        this.mChannelNumberBox.setSelectedIndex(channel);
        this.repaint();
    }

    private String getValueText(int value, boolean[] isDefault) {
        return String.valueOf(isDefault[0] ? "Default: " : "") + value;
    }

    private int getTextValue(String text) {
        if ((text = text.trim().toLowerCase()).length() == 0 || text.startsWith("def")) {
            return -1;
        }
        return Integer.parseInt(text);
    }

    public void apply(boolean[] updated) {
        updated[0] = updated[0] | this.mParameters.setInvert(this.mInvertCheckBox.isSelected());
        updated[0] = updated[0] | this.mParameters.setChannel(this.mChannelNumberBox.getSelectedIndex());
        updated[1] = updated[1] | updated[0];
        updated[1] = updated[1] | this.mParameters.setBeginIndex(this.getTextValue(this.mBeginIndexField.getText()));
        updated[1] = updated[1] | this.mParameters.setMinSecondsGap(this.getTextValue(this.mMinSecondsGapField.getText()));
        updated[1] = updated[1] | this.mParameters.setNumExpectedFiles(this.getTextValue(this.mNumExpectedFilesField.getText()));
    }
}

