/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.impl;

import tapeutils.Sample;
import tapeutils.SampleAnalyzer;
import tapeutils.WaveIdentifier;
import tapeutils.WaveProcessor;
import util.BlockSequence;

public class SineWaveIdentifier
implements WaveIdentifier {
    private Sample mSample;
    private SampleAnalyzer mSampleAnalyzer;
    private WaveProcessor mWaveProcessor;
    private BlockSequence mWaveData;
    private int mNoiseThreshold;
    private int mCurrentNoiseThreshold;
    private int mCrossThreshold = 4;
    private int mMinWaveLength = 6;
    private int mMaxWaveLength = 18;
    private int mActualMinWaveLength;
    private int mActualMaxWaveLength;
    private int mTotalWaveLength;
    private int mTotalWaves;
    private int mNormalWaveLength = 13;
    private int mNormalGap = 50;
    private int mLastNonOutside = -1;
    private static final int OUTSIDE = 0;
    private static final int UP_FIRST = 1;
    private static final int DOWN_FIRST = 2;
    private static final int DOWN_SECOND = 4;
    private int mWaveState;
    private int mWaveAmplitude;
    private int mWaveStart;
    private int mWaveEnd;
    private int mCrossoverStart;
    private int mCrossover2Start;
    private boolean mIgnoredBlip;
    private int mRestoreNoiseThreshold = -1;
    private int mRestoreNoiseIndex = -1;
    private static final int BLOCK_SIZE = 49152;

    public SineWaveIdentifier(Sample sample, SampleAnalyzer analyzer, int noiseThreshold, int maxWaveLength, WaveProcessor processor) {
        this.mSample = sample;
        this.mSampleAnalyzer = analyzer;
        this.mWaveProcessor = processor;
        double rateMult = this.mSample.getRateMultiplier();
        this.mMinWaveLength = (int)((double)this.mMinWaveLength * rateMult);
        this.mMaxWaveLength = (int)((double)maxWaveLength * rateMult);
        this.mCrossThreshold = (int)((double)this.mCrossThreshold * rateMult);
        this.mNormalGap = (int)((double)this.mNormalGap * rateMult);
        this.mNormalWaveLength = (int)((double)this.mNormalWaveLength * rateMult);
        int bytesPerSample = this.mSample.getBytesPerSample();
        this.mNoiseThreshold = noiseThreshold << (bytesPerSample - 1) * 8;
        this.mWaveData = new BlockSequence(49152);
    }

    @Override
    public void initialize() {
        this.mWaveData.initialize();
        this.mActualMinWaveLength = 999999;
        this.mActualMaxWaveLength = 0;
        this.mTotalWaveLength = 0;
        this.mTotalWaves = 0;
        this.mRestoreNoiseThreshold = -1;
        this.mRestoreNoiseIndex = -1;
        this.mWaveState = 0;
        this.mWaveAmplitude = 0;
        this.mWaveStart = -1;
        this.mWaveEnd = -1;
        this.mCrossoverStart = -1;
        this.mIgnoredBlip = false;
        this.mCurrentNoiseThreshold = this.mNoiseThreshold;
    }

    @Override
    public int identifyNextWave(int pos, int sampleValue) {
        boolean debugWave = this.mSampleAnalyzer.debuggingWave(pos);
        if (pos == this.mRestoreNoiseIndex) {
            this.mCurrentNoiseThreshold = this.mRestoreNoiseThreshold;
            this.mRestoreNoiseThreshold = -1;
        }
        switch (this.mWaveState) {
            case 0: {
                if (debugWave) {
                    this.mSampleAnalyzer.debugWaveMessage(pos, "OUTSIDE (" + sampleValue + "); Noise threshold = " + this.mCurrentNoiseThreshold);
                }
                if (sampleValue > this.mCurrentNoiseThreshold) {
                    this.mWaveStart = pos > 0 && this.mSample.getSampleValue(pos - 1) > 0 ? pos - 1 : pos;
                    this.mWaveAmplitude = sampleValue;
                    this.mWaveState = 1;
                } else if (-sampleValue > this.mCurrentNoiseThreshold) {
                    this.mWaveStart = pos > 0 && this.mSample.getSampleValue(pos - 1) < 0 ? pos - 1 : pos;
                    this.mWaveAmplitude = -sampleValue;
                    this.mWaveState = 2;
                } else if (this.mLastNonOutside != -1 && pos - this.mLastNonOutside > this.mNormalGap * 10) {
                    return this.mWaveProcessor.processWave(pos, pos, 0, 0, 0, pos);
                }
                this.mCrossoverStart = -1;
                this.mIgnoredBlip = false;
                break;
            }
            case 1: {
                int newPos;
                if (debugWave) {
                    this.mSampleAnalyzer.debugWaveMessage(pos, "UP_FIRST (" + sampleValue + ")");
                }
                if (sampleValue > this.mCurrentNoiseThreshold) {
                    if (this.mCrossoverStart != -1 && pos - this.mCrossoverStart > this.mCrossThreshold / 2) {
                        if (pos - this.mWaveStart > this.mMaxWaveLength / 2) {
                            this.mWaveStart = pos - this.mMaxWaveLength / 2;
                        }
                        this.mWaveEnd = pos;
                        newPos = this.setWave(pos);
                        if (newPos == pos) {
                            this.mIgnoredBlip = false;
                            this.mWaveStart = pos;
                            this.mWaveAmplitude = sampleValue;
                        } else {
                            pos = newPos;
                            this.mWaveState = 0;
                        }
                    }
                    if (sampleValue > this.mWaveAmplitude) {
                        this.mWaveAmplitude = sampleValue;
                    }
                    this.mCrossoverStart = -1;
                    break;
                }
                if (-sampleValue > this.mCurrentNoiseThreshold) {
                    if (pos - this.mWaveStart > this.mMaxWaveLength / 2) {
                        this.mWaveStart = pos - this.mMaxWaveLength / 2;
                    }
                    this.mWaveState = 4;
                    if (this.mCrossoverStart == -1) {
                        this.mCrossoverStart = pos;
                    }
                    this.mCrossover2Start = -1;
                    this.mIgnoredBlip = false;
                    if (-sampleValue <= this.mWaveAmplitude) break;
                    this.mWaveAmplitude = -sampleValue;
                    break;
                }
                if (this.mCrossoverStart == -1) {
                    this.mCrossoverStart = pos;
                    break;
                }
                if (pos - this.mCrossoverStart <= this.mCrossThreshold) break;
                if (debugWave) {
                    this.mSampleAnalyzer.debugWaveMessage(pos, "Crossover threshold exceeded; wave size = " + (pos - this.mWaveStart) + " half wave = " + this.mMaxWaveLength / 2 + " plus crossover=" + (pos - this.mCrossoverStart + this.mMaxWaveLength / 2));
                }
                if (pos - this.mWaveStart > pos - this.mCrossoverStart + this.mMaxWaveLength / 2) {
                    this.mWaveStart = this.mCrossoverStart - this.mMaxWaveLength / 2;
                }
                this.mWaveEnd = pos;
                pos = this.setWave(pos);
                this.mWaveState = 0;
                break;
            }
            case 2: {
                int newPos;
                if (debugWave) {
                    this.mSampleAnalyzer.debugWaveMessage(pos, "DOWN_FIRST (" + sampleValue + ") crossover=" + (this.mCrossoverStart == -1 ? -1 : pos - this.mCrossoverStart));
                }
                if (-sampleValue > this.mCurrentNoiseThreshold) {
                    if (-sampleValue > this.mWaveAmplitude) {
                        this.mWaveAmplitude = -sampleValue;
                    }
                    this.mCrossoverStart = -1;
                    break;
                }
                if (pos < this.mSample.numSamples() - 1 && pos - this.mWaveStart < this.mMaxWaveLength / 2 && this.mSample.getSampleValue(pos + 1) < 0 && !this.mIgnoredBlip) {
                    if (debugWave) {
                        this.mSampleAnalyzer.debugWaveMessage(pos, "    Ignoring blip.");
                    }
                    this.mIgnoredBlip = true;
                    break;
                }
                if (sampleValue > this.mCurrentNoiseThreshold) {
                    if (pos - this.mWaveStart < this.mMinWaveLength / 2) {
                        this.mWaveState = 1;
                        this.mWaveStart = pos;
                        this.mCrossoverStart = -1;
                        this.mWaveAmplitude = sampleValue;
                    } else {
                        if (pos - this.mWaveStart > this.mMaxWaveLength) {
                            this.mWaveStart = pos - this.mMaxWaveLength;
                        } else if (pos - this.mWaveStart >= this.mMinWaveLength / 2) {
                            this.mWaveStart = this.mWaveEnd < this.mWaveStart - this.mMaxWaveLength / 2 ? (pos - this.mWaveStart < this.mMaxWaveLength / 2 ? (this.mWaveStart -= this.mMaxWaveLength / 2) : pos - this.mMaxWaveLength) : (pos - this.mWaveEnd < this.mMaxWaveLength ? this.mWaveEnd : pos - this.mMaxWaveLength);
                        }
                        this.mWaveEnd = pos;
                        newPos = this.setWave(pos);
                        if (newPos == pos) {
                            this.mWaveStart = pos;
                            this.mWaveAmplitude = sampleValue;
                            this.mWaveState = 1;
                            this.mCrossoverStart = -1;
                        } else {
                            this.mWaveState = 0;
                            pos = newPos;
                        }
                    }
                    this.mIgnoredBlip = false;
                    break;
                }
                if (pos - this.mWaveStart > this.mMaxWaveLength) {
                    this.mWaveStart = pos - this.mMaxWaveLength;
                } else if (pos - this.mWaveStart >= this.mMinWaveLength / 2) {
                    this.mWaveStart = this.mWaveEnd < this.mWaveStart - this.mMaxWaveLength / 2 ? (pos - this.mWaveStart < this.mMaxWaveLength / 2 ? (this.mWaveStart -= this.mMaxWaveLength / 2) : pos - this.mMaxWaveLength) : (pos - this.mWaveEnd < this.mMaxWaveLength ? this.mWaveEnd : pos - this.mMaxWaveLength);
                }
                this.mWaveEnd = pos;
                pos = this.setWave(pos);
                this.mWaveState = 0;
                break;
            }
            case 4: {
                int newPos;
                if (debugWave) {
                    this.mSampleAnalyzer.debugWaveMessage(pos, "DOWN_SECOND (" + sampleValue + ")");
                }
                if (-sampleValue > this.mCurrentNoiseThreshold && pos - this.mCrossoverStart < this.mMaxWaveLength / 2) {
                    if (-sampleValue <= this.mWaveAmplitude) break;
                    this.mWaveAmplitude = -sampleValue;
                    break;
                }
                if (sampleValue > this.mCurrentNoiseThreshold) {
                    if (pos - this.mCrossoverStart < this.mMaxWaveLength / 2 && pos < this.mSample.numSamples() - 1 && this.mSample.getSampleValue(pos + 1) < 0 && !this.mIgnoredBlip) {
                        if (debugWave) {
                            this.mSampleAnalyzer.debugWaveMessage(pos, "    Ignoring blip.");
                        }
                        this.mIgnoredBlip = true;
                        break;
                    }
                    this.mWaveEnd = pos - this.mWaveStart > this.mMaxWaveLength ? this.mWaveStart + this.mMaxWaveLength : pos;
                    newPos = this.setWave(pos);
                    if (newPos == pos) {
                        this.mIgnoredBlip = false;
                        if (sampleValue > this.mCurrentNoiseThreshold) {
                            this.mWaveStart = pos;
                            this.mWaveAmplitude = sampleValue;
                            this.mWaveState = 1;
                            this.mCrossoverStart = -1;
                            break;
                        }
                        if (-sampleValue > this.mCurrentNoiseThreshold) {
                            this.mWaveStart = pos;
                            this.mWaveAmplitude = -sampleValue;
                            this.mWaveState = 2;
                            this.mCrossoverStart = -1;
                            break;
                        }
                        this.mWaveState = 0;
                        break;
                    }
                    pos = newPos;
                    this.mWaveState = 0;
                    break;
                }
                if (this.mCrossover2Start == -1) {
                    this.mCrossover2Start = pos;
                    break;
                }
                if (pos - this.mCrossover2Start <= this.mCrossThreshold / 2 && pos - this.mCrossoverStart < this.mMaxWaveLength / 2) break;
                this.mWaveEnd = pos - this.mWaveStart > this.mMaxWaveLength ? this.mWaveStart + this.mMaxWaveLength : pos;
                pos = this.setWave(pos);
                this.mWaveState = 0;
            }
        }
        return ++pos;
    }

    @Override
    public void completeProcessing() {
        int numSamples = this.mSample.numSamples();
        this.mWaveProcessor.processWave(numSamples * 2, numSamples * 2 + this.mMinWaveLength, 1, this.mMinWaveLength, this.mMaxWaveLength, numSamples - 1);
    }

    private int setWave(int currentPos) {
        int length;
        if (this.mWaveStart < 0) {
            this.mWaveStart = 0;
        }
        if ((length = this.mWaveEnd - this.mWaveStart) >= this.mMinWaveLength && length <= this.mMaxWaveLength) {
            if (this.mSampleAnalyzer.debuggingBit(currentPos)) {
                this.mSampleAnalyzer.debugBitMessage(currentPos, "Setting wave at " + this.mWaveStart + " length " + length + " amplitude " + this.mWaveAmplitude);
            }
            this.setWaveData(this.mWaveStart, this.mWaveEnd, this.mWaveAmplitude);
            currentPos = this.mWaveProcessor.processWave(this.mWaveStart, this.mWaveEnd, this.mWaveAmplitude, this.mMinWaveLength, this.mMaxWaveLength, currentPos);
            if (length < this.mActualMinWaveLength) {
                this.mActualMinWaveLength = length;
            }
            if (length > this.mActualMaxWaveLength) {
                this.mActualMaxWaveLength = length;
            }
            this.mTotalWaveLength += length;
            ++this.mTotalWaves;
        } else if (this.mSampleAnalyzer.debuggingBit(currentPos)) {
            this.mSampleAnalyzer.debugBitMessage(currentPos, "Ignoring wave length " + length + " as too big/small");
        }
        return currentPos;
    }

    private void setWaveData(int start, int end, int amp) {
        this.mWaveData.addBlock(start, end, amp);
    }

    @Override
    public boolean processingDropOut() {
        return this.mRestoreNoiseThreshold != -1 || this.mWaveStart <= this.mRestoreNoiseIndex;
    }

    @Override
    public void startProcessingDropOut(int restoreIndex) {
        this.mRestoreNoiseThreshold = this.mCurrentNoiseThreshold;
        this.mRestoreNoiseIndex = restoreIndex;
        this.mCurrentNoiseThreshold /= 2;
    }

    @Override
    public int getActualMinWaveLength() {
        return this.mActualMinWaveLength;
    }

    @Override
    public int getActualMaxWaveLength() {
        return this.mActualMaxWaveLength;
    }

    @Override
    public int getAverageWaveLength() {
        if (this.mTotalWaves == 0) {
            return -1;
        }
        return this.mTotalWaveLength / this.mTotalWaves;
    }

    @Override
    public int getNoiseThreshold() {
        return this.mNoiseThreshold;
    }

    @Override
    public int getWaveValue(int index) {
        return this.mWaveData.getValue(index);
    }

    @Override
    public int getFitValue(int index) {
        return 0;
    }

    @Override
    public void cleanUp() {
        this.mWaveData = null;
        this.mSample = null;
        this.mWaveProcessor = null;
    }
}

