/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.impl.zx81;

import sinclair.basic.ZX81Translate;
import tapeutils.impl.SimpleByteProcessor;
import tapeutils.impl.zx81.ZX81SampleAnalyzer;
import tapeutils.zx81.PFile;

public class ZX81BASICByteProcessor
extends SimpleByteProcessor {
    private int mProgramNameLength = -1;
    private PFile mPFile;
    private StringBuffer mProgramNameBuffer;
    private byte[] mProgramNameBytes;
    private int mProgramNameNumBytes;

    public ZX81BASICByteProcessor(ZX81SampleAnalyzer analyzer) {
        super(analyzer);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.mProgramNameLength = -1;
        this.mProgramNameBuffer = new StringBuffer();
        this.mProgramNameBytes = new byte[200];
        this.mProgramNameNumBytes = 0;
    }

    @Override
    public void processByte(int start, int end, int byteValue) {
        super.processByte(start, end, byteValue);
        if (this.mProgramNameLength == -1) {
            if (this.mProgramNameNumBytes == this.mProgramNameBytes.length) {
                this.mSampleAnalyzer.loadCompleted();
                return;
            }
            if (this.mSampleAnalyzer.debuggingByte(start)) {
                this.mSampleAnalyzer.debugByteMessage(start, "BYTE VALUE number " + this.mBytes.length() + " = " + Integer.toBinaryString(byteValue) + " translated " + ZX81Translate.translateZX81ToASCII(byteValue));
            }
            this.mProgramNameBuffer.append(ZX81Translate.translateZX81ToASCII(byteValue & 0x7F));
            this.mProgramNameBytes[this.mProgramNameNumBytes++] = (byte)byteValue;
            if ((byteValue & 0x80) != 0) {
                this.mProgramNameLength = this.mProgramNameNumBytes;
                ((ZX81SampleAnalyzer)this.mSampleAnalyzer).setProgramName(this.mProgramNameBuffer.toString());
                ((ZX81SampleAnalyzer)this.mSampleAnalyzer).setProgramNameBytes(this.mProgramNameBytes, this.mProgramNameNumBytes);
            }
        } else if (this.mBytes.length() == this.mProgramNameLength + 16509 - 16393) {
            this.mPFile = new PFile(this.getBytes(), this.mProgramNameBuffer.toString());
            this.mNumExpectedBytes = this.mProgramNameLength + this.mPFile.getTotalFileLength();
            if (this.mNumExpectedBytes - this.mProgramNameLength < 0) {
                this.mSampleAnalyzer.error(start, "Number of expected program bytes (" + (this.mNumExpectedBytes - this.mProgramNameLength) + ") < 0");
                this.mSampleAnalyzer.loadCompleted();
            }
        } else if (this.mPFile != null) {
            if (this.mSampleAnalyzer.debuggingByte(start)) {
                if (this.mBytes.length() == this.mProgramNameLength + this.mPFile.getProgramEndOffset()) {
                    this.mPFile = new PFile(this.getBytes(), this.mProgramNameBuffer.toString());
                    this.mSampleAnalyzer.debugByteMessage(start, this.mPFile.listProgram(false, false));
                } else if (this.mBytes.length() == this.mProgramNameLength + this.mPFile.getDisplayEndOffset()) {
                    this.mPFile = new PFile(this.getBytes(), this.mProgramNameBuffer.toString());
                    this.mSampleAnalyzer.debugByteMessage(start, this.mPFile.listDisplay(false));
                } else if (this.mBytes.length() == this.mProgramNameLength + this.mPFile.getTotalFileLength()) {
                    this.mPFile = new PFile(this.getBytes(), this.mProgramNameBuffer.toString());
                    this.mSampleAnalyzer.debugByteMessage(start, this.mPFile.listVariables(false));
                }
            }
            if (this.mBytes.length() == this.mProgramNameLength + this.mPFile.getTotalFileLength()) {
                this.mPFile = new PFile(this.getBytes(), this.mProgramNameBuffer.toString());
            }
        }
    }

    @Override
    public int undoLastByte() {
        if (this.mProgramNameLength == -1 || this.mBytes.length() <= this.mProgramNameLength) {
            --this.mProgramNameNumBytes;
            byte lastByte = this.mProgramNameBytes[this.mProgramNameNumBytes];
            String lastZX81Char = ZX81Translate.translateZX81ToASCII(lastByte & 0x7F);
            this.mProgramNameBuffer.setLength(this.mProgramNameBuffer.length() - lastZX81Char.length());
            this.mProgramNameLength = -1;
        }
        return super.undoLastByte();
    }

    @Override
    public byte[] getBytes() {
        if (this.mProgramNameLength == -1) {
            return super.getBytes();
        }
        byte[] result = new byte[this.mBytes.length() - this.mProgramNameLength];
        int i = 0;
        while (i < result.length) {
            result[i] = (byte)this.mBytes.getBlockValue(i + this.mProgramNameLength);
            ++i;
        }
        return result;
    }

    @Override
    public int numBytesProcessed() {
        if (this.mBytes.length() <= 116) {
            return 0;
        }
        return super.numBytesProcessed();
    }

    @Override
    public String checkConsistent() {
        if (this.mBytes.length() > 0 && (this.mBytes.getLastBlockValue() & 0xFF) != 128) {
            return "Possible loading error - last byte not 128 (" + (this.mBytes.getLastBlockValue() & 0xFF) + ")";
        }
        return super.checkConsistent();
    }
}

