/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.impl.zx81;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import sinclair.basic.ZX81Translate;
import tapeutils.SampleGenerator;
import tapeutils.zx81.PFile;
import tapeutils.zx81.TZXZX81Block;

public class ZX81SampleGenerator
implements SampleGenerator {
    private byte[][] mProgramBytes;
    private int[] mProgramGaps;
    private byte[][] mProgramNameBytes;
    private static final double DEFAULT_SAMPLE_RATE = 22050.0;
    private static final int WAVE_LENGTH = 7;
    private static final int WAVE_AMPLITUDE = 127;
    private static double WAVE_ANGLE = 0.8975979010256552;
    private int mBitGap = 26;
    private int mLeader = 5000;
    private int mTrailer = 500;

    public ZX81SampleGenerator(PFile pFile, String programName) {
        this.mProgramBytes = new byte[1][];
        this.mProgramBytes[0] = pFile.getBytes();
        this.mProgramGaps = new int[0];
        this.mProgramNameBytes = new byte[1][];
        this.mProgramNameBytes[0] = this.getZX81ProgramName(programName);
    }

    private byte[] getZX81ProgramName(String programName) {
        int length = Math.min(127, programName.length());
        byte[] result = new byte[length];
        int i = 0;
        while (i < length) {
            int value = ZX81Translate.translateASCIIToZX81(programName.charAt(i));
            if (value == -1) {
                throw new IllegalArgumentException("Error: program name contains invalid characters: " + programName);
            }
            result[i] = (byte)value;
            ++i;
        }
        return result;
    }

    public ZX81SampleGenerator(byte[][] programData, byte[][] programNameBytes, int[] programGaps) {
        this.mProgramBytes = programData;
        this.mProgramGaps = programGaps;
        this.mProgramNameBytes = programNameBytes;
        this.checkProgramNameBytes();
    }

    public ZX81SampleGenerator(List blocks) {
        this.mProgramBytes = new byte[blocks.size()][];
        this.mProgramGaps = new int[blocks.size()];
        this.mProgramNameBytes = new byte[blocks.size()][];
        int i = 0;
        while (i < blocks.size()) {
            TZXZX81Block block = (TZXZX81Block)blocks.get(i);
            this.mProgramBytes[i] = block.getBytes();
            this.mProgramGaps[i] = block.getPause();
            this.mProgramNameBytes[i] = block.getProgramNameBytes();
            ++i;
        }
        this.checkProgramNameBytes();
    }

    private void checkProgramNameBytes() {
        int i = 0;
        while (i < this.mProgramNameBytes.length) {
            if (this.mProgramNameBytes[i].length > 127) {
                byte[] newBytes = new byte[127];
                System.arraycopy(this.mProgramNameBytes[i], 0, newBytes, 0, 127);
                this.mProgramNameBytes[i] = newBytes;
            }
            ++i;
        }
    }

    @Override
    public void play(float frequency, boolean squareWave) throws LineUnavailableException {
        AudioFormat format = new AudioFormat(frequency, 8, 1, true, true);
        DataLine.Info sourceInfo = new DataLine.Info(SourceDataLine.class, format);
        byte[] sample = this.convertToSample(frequency, squareWave);
        SourceDataLine line = (SourceDataLine)AudioSystem.getLine(sourceInfo);
        line.open(format, 10000);
        FloatControl gainControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
        gainControl.setValue(gainControl.getMaximum() - 0.01f);
        line.start();
        line.write(sample, 0, sample.length);
        line.drain();
        line.stop();
        line.close();
    }

    @Override
    public void write(float frequency, boolean squareWave, File sampleFile) throws IOException {
        AudioFormat format = new AudioFormat(frequency, 8, 1, true, true);
        byte[] sample = this.convertToSample(frequency, squareWave);
        ByteArrayInputStream bais = new ByteArrayInputStream(sample);
        AudioInputStream ais = new AudioInputStream(bais, format, sample.length);
        AudioFileFormat.Type fileType = AudioFileFormat.Type.WAVE;
        int extPos = sampleFile.getName().indexOf(".");
        if (extPos != -1) {
            String extension = sampleFile.getName().substring(extPos + 1);
            AudioFileFormat.Type[] types = AudioSystem.getAudioFileTypes(ais);
            int i = 0;
            while (i < types.length) {
                if (extension.equalsIgnoreCase(types[i].getExtension())) {
                    fileType = types[i];
                    break;
                }
                ++i;
            }
        }
        AudioSystem.write(ais, fileType, sampleFile);
    }

    public byte[] convertToSample(double rate, boolean squareWave) throws IllegalArgumentException {
        int totalOnes = 0;
        int totalZeros = 0;
        int totalGap = 0;
        int p = 0;
        while (p < this.mProgramBytes.length) {
            byte value;
            int mask;
            int i = 0;
            while (i < this.mProgramBytes[p].length) {
                mask = 128;
                value = this.mProgramBytes[p][i];
                while (mask > 0) {
                    if ((value & mask) != 0) {
                        ++totalOnes;
                    } else {
                        ++totalZeros;
                    }
                    mask >>= 1;
                }
                ++i;
            }
            if (p < this.mProgramGaps.length) {
                totalGap += this.mProgramGaps[p];
            }
            i = 0;
            while (i < this.mProgramNameBytes[p].length) {
                mask = 128;
                value = this.mProgramNameBytes[p][i];
                while (mask > 0) {
                    if ((value & mask) != 0) {
                        ++totalOnes;
                    } else {
                        ++totalZeros;
                    }
                    mask >>= 1;
                }
                ++i;
            }
            ++p;
        }
        double mult = rate / 22050.0;
        int totalSize = (int)((double)((totalOnes * 9 + totalZeros * 4) * 7 + (totalOnes + totalZeros) * this.mBitGap + (int)((double)totalGap * rate / 1000.0) + this.mLeader + this.mTrailer) * mult);
        byte[] buffer = new byte[totalSize];
        int pos = (int)((double)this.mLeader * mult);
        int p2 = 0;
        while (p2 < this.mProgramBytes.length) {
            int i = 0;
            while (i < this.mProgramNameBytes[p2].length) {
                int value = this.mProgramNameBytes[p2][i];
                value = i == this.mProgramNameBytes[p2].length - 1 ? (value |= 0x80) : (value &= 0x7F);
                pos = this.writeByte(buffer, pos, value, mult, squareWave);
                ++i;
            }
            i = 0;
            while (i < this.mProgramBytes[p2].length) {
                pos = this.writeByte(buffer, pos, this.mProgramBytes[p2][i], mult, squareWave);
                ++i;
            }
            if (p2 < this.mProgramGaps.length) {
                int gap = (int)((double)this.mProgramGaps[p2] * rate / 1000.0);
                pos += gap;
            }
            ++p2;
        }
        return buffer;
    }

    private int writeByte(byte[] buffer, int pos, int value, double mult, boolean squareWave) {
        int mask = 128;
        while (mask > 0) {
            pos = this.writeBit(buffer, pos, value & mask, mult, squareWave);
            mask >>= 1;
            pos = (int)((double)pos + (double)this.mBitGap * mult);
        }
        return pos;
    }

    private int writeBit(byte[] buffer, int pos, int bitValue, double mult, boolean squareWave) {
        int waves = bitValue != 0 ? 9 : 4;
        int p = 0;
        while (p < waves) {
            float w = 0.0f;
            while ((double)w < 7.0 * mult) {
                byte val = (byte)(Math.sin(WAVE_ANGLE * (double)w / mult) * 127.0);
                if (squareWave) {
                    buffer[pos++] = (byte)(val < 0 ? -127 : (val > 0 ? 127 : 0));
                } else {
                    buffer[pos++] = val;
                }
                w += 1.0f;
            }
            ++p;
        }
        return pos;
    }
}

