/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.impl.zx81;

import tapeutils.BitProcessor;
import tapeutils.Sample;
import tapeutils.SampleAnalyzer;
import tapeutils.WaveIdentifier;
import tapeutils.WaveProcessor;

public class ZX81WaveProcessor
implements WaveProcessor {
    private SampleAnalyzer mSampleAnalyzer;
    private Sample mSample;
    private WaveIdentifier mWaveIdentifier;
    private BitProcessor mBitProcessor;
    private int mMinGroupGap;
    private int mMaxGroupGap;
    private int mActualMinGroupGap;
    private int mActualMaxGroupGap;
    private int mActualMinZeroLength;
    private int mActualMaxZeroLength;
    private int mActualMinOneLength;
    private int mActualMaxOneLength;
    private int mGroupStart = 0;
    private int mWaveCount = 0;
    private int mGroupEnd = 0;
    private int mLastGroupEnd = 0;
    private int mLastGroupStart = 0;
    private int mFourthGroupEnd = 0;
    private int mIgnoredPeaks = 0;
    private int mIgnoredEnd = 0;
    private int mTotalWaveCount;
    private int mTotalWaveAmplitude;

    public ZX81WaveProcessor(Sample sample, SampleAnalyzer analyzer, int minGap, int maxGap, BitProcessor processor) {
        this.mSample = sample;
        this.mSampleAnalyzer = analyzer;
        this.mBitProcessor = processor;
        double rateMult = this.mSample.getRateMultiplier();
        this.mMinGroupGap = (int)((double)minGap * rateMult);
        this.mMaxGroupGap = (int)((double)maxGap * rateMult);
    }

    @Override
    public void setWaveIdentifier(WaveIdentifier identifier) {
        this.mWaveIdentifier = identifier;
    }

    @Override
    public void initialize() {
        this.mActualMinGroupGap = this.mMaxGroupGap;
        this.mActualMaxGroupGap = this.mMinGroupGap;
        this.mActualMinZeroLength = 999999;
        this.mActualMaxZeroLength = 0;
        this.mActualMinOneLength = 999999;
        this.mActualMaxOneLength = 0;
        this.mWaveCount = 0;
        this.mGroupStart = 0;
        this.mGroupEnd = 0;
        this.mLastGroupEnd = 0;
        this.mLastGroupStart = 0;
        this.mFourthGroupEnd = 0;
        this.mIgnoredPeaks = 0;
        this.mIgnoredEnd = 0;
        this.mTotalWaveAmplitude = 0;
        this.mTotalWaveCount = 0;
    }

    @Override
    public int processWave(int waveStart, int waveEnd, int amplitude, int minLength, int maxLength, int currentPos) {
        boolean debugBit = this.mSampleAnalyzer.debuggingBit(waveStart);
        switch (this.mWaveCount) {
            case 0: {
                if (this.mGroupEnd == 0 || waveStart - this.mGroupEnd >= this.mMinGroupGap) {
                    if (debugBit) {
                        this.mSampleAnalyzer.debugBitMessage(waveStart, "Adding peak 1 at " + waveStart + " distance from last = " + (waveStart - this.mGroupEnd));
                    }
                    if (waveStart - this.mGroupEnd < 0) {
                        new Exception().printStackTrace();
                    }
                    if (this.mGroupEnd != 0 && waveStart < this.mSample.numSamples() && waveStart - this.mGroupEnd > this.mMaxGroupGap) {
                        this.mSampleAnalyzer.warning(waveStart, "Maximum group gap (" + this.mMaxGroupGap + ") exceeded: " + (waveStart - this.mGroupEnd) + " group end at " + this.mGroupEnd);
                    }
                    this.mGroupStart = waveStart;
                    this.mGroupEnd = waveEnd;
                    this.mTotalWaveAmplitude += amplitude;
                    ++this.mWaveCount;
                    ++this.mTotalWaveCount;
                    this.mIgnoredPeaks = 0;
                    this.mIgnoredEnd = 0;
                    break;
                }
                this.checkIgnored(waveStart, waveEnd, amplitude, "E");
                if (!debugBit) break;
                this.mSampleAnalyzer.debugBitMessage(waveStart, "Ignoring peak at " + waveStart + " distance from last = " + (waveStart - this.mGroupEnd) + " Total ignored = " + this.mIgnoredPeaks);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (this.mWaveCount < 9 && waveEnd - this.mGroupStart < maxLength * (this.mWaveCount + 1) * 4 / 3 && waveStart - this.mGroupEnd < maxLength / 3) {
                    ++this.mWaveCount;
                    ++this.mTotalWaveCount;
                    this.mTotalWaveAmplitude += amplitude;
                    if (debugBit) {
                        this.mSampleAnalyzer.debugBitMessage(waveStart, "Adding peak " + this.mWaveCount + " at " + waveStart + " distance from last = " + (waveStart - this.mGroupEnd));
                    }
                    this.mGroupEnd = waveEnd;
                    if (this.mWaveCount == 4) {
                        this.mFourthGroupEnd = waveEnd;
                        break;
                    }
                    if (this.mWaveCount <= 4) break;
                    this.checkIgnored(waveStart, waveEnd, amplitude, "W");
                    break;
                }
                if (this.mLastGroupEnd > 0 && this.mWaveCount < 3 && waveEnd - this.mGroupStart < maxLength * (this.mWaveCount + 2) + maxLength / 2 && waveStart - this.mGroupEnd < maxLength * 4 / 3 && waveStart - this.mGroupEnd > minLength) {
                    this.mWaveCount += 2;
                    this.mTotalWaveCount += 2;
                    this.mTotalWaveAmplitude += amplitude * 2;
                    this.mSampleAnalyzer.warning(waveStart, "Assuming one missing peak");
                    if (debugBit) {
                        this.mSampleAnalyzer.debugBitMessage(waveStart, "Adding peak " + this.mWaveCount + " plus missing peak at " + waveStart + " distance from last = " + (waveStart - this.mGroupEnd));
                    }
                    this.mGroupEnd = waveEnd;
                    if (this.mWaveCount != 4) break;
                    this.mFourthGroupEnd = waveEnd;
                    break;
                }
                if (this.mLastGroupEnd > 0 && this.mWaveCount == 1 && waveEnd - this.mGroupStart < maxLength * (this.mWaveCount + 3) + maxLength / 2 && waveStart - this.mGroupEnd < maxLength * 7 / 3 && waveStart - this.mGroupEnd > minLength * 2) {
                    this.mSampleAnalyzer.warning(waveStart, "Assuming two missing peaks");
                    this.mWaveCount += 3;
                    this.mTotalWaveCount += 3;
                    this.mTotalWaveAmplitude += amplitude * 3;
                    if (debugBit) {
                        this.mSampleAnalyzer.debugBitMessage(waveStart, "Adding peak " + this.mWaveCount + " plus two missing peaks at " + waveStart + " distance from last = " + (waveStart - this.mGroupEnd));
                    }
                    this.mGroupEnd = waveEnd;
                    if (this.mWaveCount != 4) break;
                    this.mFourthGroupEnd = waveEnd;
                    break;
                }
                if (debugBit) {
                    this.mSampleAnalyzer.debugBitMessage(waveStart, "Adding peak after " + this.mWaveCount + " outside group at " + waveStart + " distance from last = " + (waveStart - this.mGroupEnd) + "; max distance allowed " + maxLength / 3 + "  End of peak distance = " + (waveEnd - this.mGroupStart) + "; max allowed " + (maxLength * (this.mWaveCount + 1) + maxLength / 2));
                }
                int invalidWaveCount = -1;
                if (this.mWaveCount < 4) {
                    if (waveStart - this.mLastGroupEnd >= this.mMaxGroupGap && this.mLastGroupEnd != 0) {
                        invalidWaveCount = this.mWaveCount;
                    }
                    this.mGroupEnd = this.mLastGroupEnd;
                } else if (this.mWaveCount < 9) {
                    this.mGroupEnd = this.mFourthGroupEnd;
                    this.addBit(0);
                    this.mIgnoredPeaks = 0;
                    this.mIgnoredEnd = 0;
                } else {
                    this.addBit(1);
                    this.mIgnoredPeaks = 0;
                    this.mIgnoredEnd = this.mGroupEnd;
                }
                this.mWaveCount = 0;
                this.mFourthGroupEnd = 0;
                if (waveStart - this.mGroupEnd >= this.mMinGroupGap && !this.mSampleAnalyzer.isLoadComplete()) {
                    if (debugBit) {
                        this.mSampleAnalyzer.debugBitMessage(waveStart, "Minimum group gap exceeded; distance from previous group: " + (waveStart - this.mGroupEnd) + " min: " + this.mMinGroupGap);
                    }
                    if (waveStart < this.mSample.numSamples() && this.mLastGroupEnd != 0 && waveStart - this.mLastGroupEnd > this.mMaxGroupGap) {
                        if (!this.mWaveIdentifier.processingDropOut() && waveStart - this.mLastGroupEnd < 3 * this.mMaxGroupGap) {
                            if (this.mSampleAnalyzer.debuggingWave(waveStart)) {
                                this.mSampleAnalyzer.debugWaveMessage(waveStart, "Attempting with lower noise threshold");
                            }
                            if (debugBit) {
                                this.mSampleAnalyzer.debugBitMessage(waveStart, "Undoing last bit while attempting with lower noise threshold");
                            }
                            this.mLastGroupEnd = this.mBitProcessor.undoLastBit();
                            this.mWaveIdentifier.startProcessingDropOut(waveStart);
                            this.mWaveCount = 0;
                            this.mGroupEnd = this.mLastGroupEnd;
                            this.mSampleAnalyzer.clearMessages(this.mLastGroupStart - 2);
                            if (this.mLastGroupStart > 1) {
                                return this.mLastGroupStart - 2;
                            }
                            return 0;
                        }
                        int numBits = this.mBitProcessor.getNumberOfBits();
                        if (numBits < 8) {
                            if (debugBit) {
                                this.mSampleAnalyzer.debugBitMessage(waveStart, "Maximum group gap (" + this.mMaxGroupGap + ") exceeded: " + (waveStart - this.mLastGroupEnd) + " group end at " + this.mLastGroupEnd);
                            }
                            if (debugBit) {
                                this.mSampleAnalyzer.debugBitMessage(waveStart, "Ignoring " + numBits + " previous bit(s)");
                            }
                            if (debugBit) {
                                this.mSampleAnalyzer.debugBitMessage(waveStart, "Undoing last bits as not within program");
                            }
                            while (numBits-- > 0) {
                                this.mBitProcessor.undoLastBit();
                            }
                            this.mLastGroupStart = 0;
                            this.mLastGroupEnd = 0;
                            invalidWaveCount = -1;
                            this.mWaveIdentifier.initialize();
                            this.mSampleAnalyzer.clearMessages(0);
                        } else {
                            this.mSampleAnalyzer.warning(waveStart, "Maximum group gap (" + this.mMaxGroupGap + ") exceeded: " + (waveStart - this.mLastGroupEnd) + " group end at " + this.mLastGroupEnd);
                            int groupGap = waveStart - this.mGroupEnd;
                            int possibleOneEnd = this.mLastGroupStart + (this.mActualMinOneLength + this.mActualMaxOneLength) / 2;
                            if (this.mBitProcessor.getLastBitValue() == 0 && groupGap >= this.mMinGroupGap + this.mActualMinOneLength - this.mActualMaxZeroLength && groupGap <= this.mMaxGroupGap + this.mActualMinOneLength - this.mActualMaxZeroLength && possibleOneEnd < waveStart - this.mMinGroupGap) {
                                if (debugBit) {
                                    this.mSampleAnalyzer.debugBitMessage(waveStart, "Replacing last 0 bit with a 1 bit");
                                }
                                this.mBitProcessor.undoLastBit();
                                this.mLastGroupEnd = possibleOneEnd;
                                this.mBitProcessor.addBit(this.mLastGroupStart, this.mLastGroupEnd, 1);
                                this.mSampleAnalyzer.warning(waveStart, "    Changed previous bit from a 0 to a 1");
                                invalidWaveCount = -1;
                            }
                        }
                    }
                    if (debugBit) {
                        this.mSampleAnalyzer.debugBitMessage(waveStart, "Starting new group");
                    }
                    this.mGroupStart = waveStart;
                    this.mGroupEnd = waveEnd;
                    ++this.mWaveCount;
                    ++this.mTotalWaveCount;
                    this.mTotalWaveAmplitude += amplitude;
                } else {
                    if (debugBit) {
                        this.mSampleAnalyzer.debugBitMessage(waveStart, "Ignoring noise; distance from previous group: " + (waveStart - this.mGroupEnd) + " min: " + this.mMinGroupGap);
                    }
                    this.checkIgnored(waveStart, waveEnd, amplitude, "B");
                }
                if (invalidWaveCount == -1) break;
                this.mSampleAnalyzer.error(waveStart, "Group of " + invalidWaveCount);
                break;
            }
            default: {
                this.mSampleAnalyzer.error(waveStart, "Group of " + this.mWaveCount);
            }
        }
        return currentPos;
    }

    private void checkIgnored(int waveStart, int waveEnd, int amplitude, String type) {
        if (this.mTotalWaveCount > 0 && amplitude > this.mTotalWaveAmplitude / (this.mTotalWaveCount * 2)) {
            boolean gap;
            boolean bl = gap = waveStart != this.mFourthGroupEnd && this.mIgnoredEnd <= waveStart - 4;
            if (!type.equals("W") && gap) {
                this.mIgnoredPeaks = 0;
            }
            if (!type.equals("W") || !gap) {
                this.mIgnoredPeaks += waveEnd - waveStart;
                this.mIgnoredEnd = waveEnd;
            }
        }
    }

    private void addBit(int bitValue) {
        if (this.mLastGroupEnd != 0) {
            int groupGap = this.mGroupStart - this.mLastGroupEnd;
            if (groupGap < this.mActualMinGroupGap) {
                this.mActualMinGroupGap = groupGap;
            }
            if (groupGap > this.mActualMaxGroupGap) {
                this.mActualMaxGroupGap = groupGap;
            }
        }
        int groupSize = this.mGroupEnd - this.mGroupStart;
        if (bitValue == 1) {
            if (groupSize < this.mActualMinOneLength) {
                this.mActualMinOneLength = groupSize;
            }
            if (groupSize > this.mActualMaxOneLength) {
                this.mActualMaxOneLength = groupSize;
            }
        } else {
            if (groupSize < this.mActualMinZeroLength) {
                this.mActualMinZeroLength = groupSize;
            }
            if (groupSize > this.mActualMaxZeroLength) {
                this.mActualMaxZeroLength = groupSize;
            }
        }
        this.mLastGroupStart = this.mGroupStart;
        this.mLastGroupEnd = this.mGroupEnd;
        this.mBitProcessor.addBit(this.mGroupStart, this.mGroupEnd, bitValue);
    }

    @Override
    public int checkGroupGap(int lastEnd, int nextStart) {
        if (nextStart - lastEnd > this.mMinGroupGap) {
            return 0;
        }
        return Math.max(this.mActualMinGroupGap, this.mMinGroupGap);
    }

    @Override
    public int getActualMinGroupGap() {
        return this.mActualMinGroupGap;
    }

    @Override
    public int getActualMaxGroupGap() {
        return this.mActualMaxGroupGap;
    }

    @Override
    public int getActualMinZeroLength() {
        return this.mActualMinZeroLength;
    }

    @Override
    public int getActualMaxZeroLength() {
        return this.mActualMaxZeroLength;
    }

    @Override
    public int getActualMinOneLength() {
        return this.mActualMinOneLength;
    }

    @Override
    public int getActualMaxOneLength() {
        return this.mActualMaxOneLength;
    }
}

