/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.swing.ImageIcon;
import tapeutils.gui.ProgressBar;

public class ConvertToMono
implements WindowListener {
    private Frame mFrame = new Frame("WAV File Mono Converter");
    private Label mFileNameLabel;
    private ProgressBar mProgressBar;
    public static final String FRAME_ICON_FILE = "/images/TapeConverterFrameIcon.gif";

    public static void main(String[] args) {
        File outputDir;
        String input = "";
        String output = "";
        boolean overwrite = false;
        boolean leftOnly = false;
        boolean rightOnly = false;
        int aPos = 0;
        while (aPos < args.length) {
            if ((args[aPos].equals("-input") || args[aPos].equals("-i")) && aPos < args.length) {
                input = args[++aPos];
            } else if ((args[aPos].equals("-output") || args[aPos].equals("-o")) && aPos < args.length) {
                output = args[++aPos];
            } else if ((args[aPos].equals("-overwrite") || args[aPos].equals("-y")) && aPos < args.length) {
                overwrite = true;
            } else if (args[aPos].equals("-left") && !rightOnly) {
                leftOnly = true;
            } else if (args[aPos].equals("-right") && !leftOnly) {
                rightOnly = true;
            } else {
                ConvertToMono.usage();
            }
            ++aPos;
        }
        File inputFile = new File(input);
        if (!inputFile.exists()) {
            System.err.println("File " + inputFile + " does not exist.");
            ConvertToMono.usage();
        }
        if (!(outputDir = new File(output)).exists() || !outputDir.isDirectory()) {
            System.err.println("File " + outputDir + " is not directory.");
            ConvertToMono.usage();
        }
        new ConvertToMono(inputFile, outputDir, overwrite, leftOnly, rightOnly);
    }

    private ConvertToMono(File inputFile, File outputDir, boolean overwrite, boolean leftOnly, boolean rightOnly) {
        this.mFrame.addWindowListener(this);
        this.mFrame.setLayout(new BorderLayout());
        Image iconImage = new ImageIcon(this.getClass().getResource(FRAME_ICON_FILE)).getImage();
        this.mFrame.setIconImage(iconImage);
        this.mFileNameLabel = new Label("", 1);
        this.mFrame.add("North", this.mFileNameLabel);
        this.mFileNameLabel.setSize(400, 50);
        this.mProgressBar = new ProgressBar(Color.cyan);
        this.mProgressBar.setPercentageText(false);
        this.mFrame.add("Center", this.mProgressBar);
        this.mProgressBar.setSize(400, 50);
        this.mFrame.pack();
        this.mFrame.setVisible(true);
        if (inputFile.isDirectory()) {
            String[] files = inputFile.list();
            int i = 0;
            while (i < files.length) {
                if (files[i].toLowerCase().endsWith(".wav")) {
                    File conv = new File(inputFile, files[i]);
                    this.mFileNameLabel.setText("Converting " + (i + 1) + "/" + files.length + ": " + conv);
                    this.convertToMono(conv, outputDir, overwrite, leftOnly, rightOnly);
                }
                ++i;
            }
        } else {
            this.mFileNameLabel.setText("Converting " + inputFile);
            this.convertToMono(inputFile, outputDir, overwrite, leftOnly, rightOnly);
        }
        this.mFrame.dispose();
    }

    private void convertToMono(File inputFile, File outputDir, boolean overwrite, boolean leftOnly, boolean rightOnly) {
        String inputFileName = inputFile.getName();
        String outputFileName = String.valueOf(inputFileName.substring(0, inputFileName.length() - 6)) + (inputFileName.substring(inputFileName.length() - 6, inputFileName.length() - 4).equals("_0") ? ".A.wav" : ".B.wav");
        File outputFile = new File(outputDir, outputFileName);
        if (outputFile.exists() && !overwrite) {
            System.err.println("Output file " + outputFile + " already exists.");
            return;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFile));
            AudioInputStream ais = AudioSystem.getAudioInputStream(in);
            AudioFormat inputFormat = ais.getFormat();
            int channels = inputFormat.getChannels();
            boolean bigEndian = inputFormat.isBigEndian();
            int frameSize = inputFormat.getFrameSize();
            int numberOfSamples = ais.available() / frameSize;
            int sampleSize = frameSize / channels;
            byte[] monoData = new byte[numberOfSamples];
            byte[] buffer = new byte[200000 * frameSize];
            int dataPos = 0;
            int numRead = ais.read(buffer);
            System.out.println("Number of channels: " + channels + " samplesize " + sampleSize + " framesize " + frameSize);
            while (numRead != -1) {
                int pos = 0;
                while (pos < numRead) {
                    byte value = 0;
                    int c = 0;
                    while (c < channels) {
                        byte high;
                        byte cval = 0;
                        cval = sampleSize == 1 ? buffer[pos + c * sampleSize] : (high = bigEndian ? buffer[pos + c * sampleSize] : buffer[pos + 1 + c * sampleSize]);
                        if (leftOnly) {
                            if (c == 0) {
                                value = cval;
                            }
                        } else if (rightOnly) {
                            if (c == 1) {
                                value = cval;
                            }
                        } else if (Math.abs(cval) > Math.abs(value)) {
                            value = cval;
                        }
                        ++c;
                    }
                    monoData[dataPos++] = value;
                    pos += frameSize;
                }
                int percentage = (int)((double)((float)dataPos / (float)numberOfSamples) * 100.0);
                this.mProgressBar.setBarText("Converted " + dataPos + " / " + numberOfSamples + " = " + percentage + "%");
                this.mProgressBar.setCurrentValue(percentage);
                numRead = ais.read(buffer);
            }
            AudioFormat outputFormat = new AudioFormat(44100.0f, 8, 1, true, true);
            FileOutputStream out = new FileOutputStream(outputFile);
            ByteArrayInputStream bais = new ByteArrayInputStream(monoData);
            AudioInputStream aisOut = new AudioInputStream(bais, outputFormat, monoData.length);
            AudioSystem.write(aisOut, AudioFileFormat.Type.WAVE, out);
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (Exception exc) {
            System.err.println("Error processing " + inputFile + " : " + exc.getMessage());
            exc.printStackTrace();
            ConvertToMono.usage();
        }
    }

    private static void usage() {
        System.out.println("Usage: ");
        System.out.println("java " + ConvertToMono.class.getName());
        System.out.println("   {-input  | -i} {fileName|directoryName}  The name of the .WAV file or directory to process.");
        System.out.println("   {-output | -o} directoryName             The name of the output directory.");
        System.out.println("   [-overwrite | -y]                        Overwrite existing output files.");
        System.exit(-1);
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        this.mFrame.dispose();
        System.exit(0);
    }

    @Override
    public void windowClosed(WindowEvent evt) {
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }
}

