/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.zx81;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.LineUnavailableException;
import sinclair.basic.ZX81Basic;
import sinclair.basic.ZX81SysVars;
import tapeutils.impl.zx81.ZX81SampleGenerator;

public class PFile {
    private byte[] mFileBytes;
    private int mVarsOffset;
    private int mProgramOffset;
    private int mVarsEndOffset;
    private int mDisplayOffset;
    private int mLength;
    private String mProgramName;

    public PFile(File file, String programName) throws IOException {
        this.mProgramName = programName;
        FileInputStream fis = new FileInputStream(file);
        this.mFileBytes = new byte[fis.available()];
        fis.read(this.mFileBytes);
        fis.close();
        this.initialize();
    }

    public PFile(byte[] fileBytes, String programName) {
        this.mFileBytes = fileBytes;
        this.mProgramName = programName;
        this.initialize();
    }

    private void initialize() {
        this.mProgramOffset = 116;
        this.mDisplayOffset = ZX81SysVars.getVariableValueOffset(this.mFileBytes, 16396, 2);
        this.mVarsOffset = ZX81SysVars.getVariableValueOffset(this.mFileBytes, 16400, 2);
        this.mVarsEndOffset = ZX81SysVars.getVariableValueOffset(this.mFileBytes, 16404, 2);
        if (this.mDisplayOffset < 0) {
            this.mDisplayOffset = this.mVarsOffset;
        }
        this.mLength = this.mVarsEndOffset;
    }

    public void list(boolean outputSystem, boolean outputVariables, boolean outputDisplay, boolean dumpNumberValues) {
        if (this.mProgramName != null) {
            System.out.println("Program name: '" + this.mProgramName + "'");
        }
        if (outputSystem) {
            this.listSystemVariables(true);
        }
        this.listProgram(true, dumpNumberValues);
        if (outputDisplay) {
            this.listDisplay(true);
        }
        if (outputVariables) {
            this.listVariables(true);
        }
    }

    public String listSystemVariables(boolean print) {
        StringBuffer sb = new StringBuffer();
        sb.append("System variables:\n");
        ZX81SysVars.dumpSystemVariables(this.mFileBytes, 0, 16393, sb);
        String result = sb.toString();
        if (print) {
            System.out.println(sb);
        }
        return result;
    }

    public String listProgram(boolean print, boolean dumpNumberValues) {
        StringBuffer sb = new StringBuffer();
        sb.append("Basic program:\n");
        ZX81Basic.dumpProgramLines(this.mFileBytes, this.mProgramOffset, this.mDisplayOffset, dumpNumberValues, sb);
        String result = sb.toString();
        if (print) {
            System.out.println(sb);
        }
        return result;
    }

    public String listDisplay(boolean print) {
        StringBuffer sb = new StringBuffer();
        sb.append("Display:\n");
        ZX81Basic.dumpDisplay(this.mFileBytes, this.mDisplayOffset, this.mVarsOffset, sb);
        String result = sb.toString();
        if (print) {
            System.out.println(sb);
        }
        return result;
    }

    public String listVariables(boolean print) {
        StringBuffer sb = new StringBuffer();
        sb.append("Variables:\n");
        ZX81Basic.dumpVariables(this.mFileBytes, this.mVarsOffset, this.mVarsEndOffset, sb);
        String result = sb.toString();
        if (print) {
            System.out.println(sb);
        }
        return result;
    }

    public int getTotalFileLength() {
        return this.mLength;
    }

    public int getProgramEndOffset() {
        return this.mDisplayOffset;
    }

    public int getDisplayEndOffset() {
        return this.mVarsOffset;
    }

    public void write(OutputStream output) throws IOException {
        output.write(this.mFileBytes, 0, Math.min(this.mLength, this.mFileBytes.length));
    }

    public byte getByte(int index) {
        return this.mFileBytes[index];
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.mLength];
        System.out.println("Length = " + this.mLength + " filebytes = " + this.mFileBytes.length);
        System.arraycopy(this.mFileBytes, 0, result, 0, Math.min(this.mLength, this.mFileBytes.length));
        return result;
    }

    public void writeSampleToFile(float frequency, File sampleFile, boolean squareWave) throws IOException {
        ZX81SampleGenerator gen = new ZX81SampleGenerator(this, this.mProgramName);
        gen.write(frequency, squareWave, sampleFile);
    }

    public void play(float frequency, boolean squareWave) throws LineUnavailableException {
        ZX81SampleGenerator gen = new ZX81SampleGenerator(this, this.mProgramName);
        gen.play(frequency, squareWave);
    }
}

