/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.zx81;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import tapeutils.impl.zx81.ZX81SampleAnalyzer;
import tapeutils.zx81.TapeConverter;

public class TZXZX81Block {
    private byte[] mProgramBytes;
    private byte[] mProgramNameBytes;
    private int mPause = 1000;
    private byte[] mZeroSymbolTable = DEFAULT_ZERO_SYMBOL_TABLE;
    private byte[] mOneSymbolTable = DEFAULT_ONE_SYMBOL_TABLE;
    private static final byte[] DEFAULT_ZERO_SYMBOL_TABLE;
    private static final byte[] DEFAULT_ONE_SYMBOL_TABLE;
    private static final int[][] BLOCK_LENGTH_DATA;

    static {
        byte[] byArray = new byte[37];
        byArray[0] = 3;
        byArray[1] = 18;
        byArray[2] = 2;
        byArray[3] = 8;
        byArray[4] = 2;
        byArray[5] = 18;
        byArray[6] = 2;
        byArray[7] = 8;
        byArray[8] = 2;
        byArray[9] = 18;
        byArray[10] = 2;
        byArray[11] = 8;
        byArray[12] = 2;
        byArray[13] = 18;
        byArray[14] = 2;
        byArray[15] = 81;
        byArray[16] = 18;
        DEFAULT_ZERO_SYMBOL_TABLE = byArray;
        DEFAULT_ONE_SYMBOL_TABLE = new byte[]{3, 18, 2, 8, 2, 18, 2, 8, 2, 18, 2, 8, 2, 18, 2, 8, 2, 18, 2, 8, 2, 18, 2, 8, 2, 18, 2, 8, 2, 18, 2, 8, 2, 18, 2, 81, 18};
        int[][] nArrayArray = new int[75][];
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[1] = 2;
        nArray[2] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 15;
        nArray2[1] = 3;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[3] = 4;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[1] = 1;
        nArray4[2] = 2;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[4];
        nArray5[0] = 7;
        nArray5[1] = 3;
        nArray5[2] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[4];
        nArray6[0] = 5;
        nArray6[1] = 3;
        nArray6[2] = 1;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[4];
        nArray7[1] = 4;
        nArray7[2] = 1;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[4];
        nArray8[1] = 4;
        nArray8[2] = 1;
        nArrayArray[7] = nArray8;
        int[] nArray9 = new int[4];
        nArray9[1] = 4;
        nArray9[2] = 1;
        nArrayArray[8] = nArray9;
        int[] nArray10 = new int[4];
        nArray10[1] = 4;
        nArray10[2] = 1;
        nArrayArray[9] = nArray10;
        int[] nArray11 = new int[4];
        nArray11[1] = 4;
        nArray11[2] = 1;
        nArrayArray[10] = nArray11;
        int[] nArray12 = new int[4];
        nArray12[1] = 4;
        nArray12[2] = 1;
        nArrayArray[11] = nArray12;
        int[] nArray13 = new int[4];
        nArray13[1] = 4;
        nArray13[2] = 1;
        nArrayArray[12] = nArray13;
        int[] nArray14 = new int[4];
        nArray14[1] = 4;
        nArray14[2] = 1;
        nArrayArray[13] = nArray14;
        int[] nArray15 = new int[4];
        nArray15[1] = 4;
        nArray15[2] = 1;
        nArrayArray[14] = nArray15;
        int[] nArray16 = new int[4];
        nArray16[1] = 4;
        nArray16[2] = 1;
        nArrayArray[15] = nArray16;
        int[] nArray17 = new int[4];
        nArray17[3] = 2;
        nArrayArray[16] = nArray17;
        int[] nArray18 = new int[4];
        nArray18[1] = 1;
        nArray18[2] = 1;
        nArrayArray[17] = nArray18;
        nArrayArray[18] = new int[4];
        int[] nArray19 = new int[4];
        nArray19[3] = 2;
        nArrayArray[19] = nArray19;
        int[] nArray20 = new int[4];
        nArray20[3] = 2;
        nArrayArray[20] = nArray20;
        nArrayArray[21] = new int[4];
        int[] nArray21 = new int[4];
        nArray21[1] = 2;
        nArray21[2] = 2;
        nArrayArray[22] = nArray21;
        nArrayArray[23] = new int[4];
        int[] nArray22 = new int[4];
        nArray22[1] = 2;
        nArray22[2] = 1;
        nArrayArray[24] = nArray22;
        int[] nArray23 = new int[4];
        nArray23[1] = 4;
        nArray23[2] = 1;
        nArrayArray[25] = nArray23;
        int[] nArray24 = new int[4];
        nArray24[3] = 4;
        nArrayArray[26] = nArray24;
        int[] nArray25 = new int[4];
        nArray25[1] = 4;
        nArray25[2] = 1;
        nArrayArray[27] = nArray25;
        int[] nArray26 = new int[4];
        nArray26[1] = 4;
        nArray26[2] = 1;
        nArrayArray[28] = nArray26;
        int[] nArray27 = new int[4];
        nArray27[1] = 4;
        nArray27[2] = 1;
        nArrayArray[29] = nArray27;
        int[] nArray28 = new int[4];
        nArray28[1] = 4;
        nArray28[2] = 1;
        nArrayArray[30] = nArray28;
        int[] nArray29 = new int[4];
        nArray29[1] = 4;
        nArray29[2] = 1;
        nArrayArray[31] = nArray29;
        int[] nArray30 = new int[4];
        nArray30[1] = 1;
        nArray30[2] = 1;
        nArrayArray[32] = nArray30;
        int[] nArray31 = new int[4];
        nArray31[0] = 1;
        nArray31[1] = 1;
        nArray31[2] = 1;
        nArrayArray[33] = nArray31;
        int[] nArray32 = new int[4];
        nArray32[1] = 2;
        nArray32[2] = 1;
        nArrayArray[34] = nArray32;
        int[] nArray33 = new int[4];
        nArray33[1] = 1;
        nArray33[2] = 3;
        nArrayArray[35] = nArray33;
        int[] nArray34 = new int[4];
        nArray34[3] = 8;
        nArrayArray[36] = nArray34;
        int[] nArray35 = new int[4];
        nArray35[0] = 16;
        nArray35[1] = 4;
        nArrayArray[37] = nArray35;
        int[] nArray36 = new int[4];
        nArray36[1] = 4;
        nArray36[2] = 1;
        nArrayArray[38] = nArray36;
        int[] nArray37 = new int[4];
        nArray37[1] = 4;
        nArray37[2] = 1;
        nArrayArray[39] = nArray37;
        int[] nArray38 = new int[4];
        nArray38[1] = 4;
        nArray38[2] = 1;
        nArrayArray[40] = nArray38;
        int[] nArray39 = new int[4];
        nArray39[1] = 4;
        nArray39[2] = 1;
        nArrayArray[41] = nArray39;
        int[] nArray40 = new int[4];
        nArray40[1] = 4;
        nArray40[2] = 1;
        nArrayArray[42] = nArray40;
        int[] nArray41 = new int[4];
        nArray41[1] = 4;
        nArray41[2] = 1;
        nArrayArray[43] = nArray41;
        int[] nArray42 = new int[4];
        nArray42[1] = 4;
        nArray42[2] = 1;
        nArrayArray[44] = nArray42;
        int[] nArray43 = new int[4];
        nArray43[1] = 4;
        nArray43[2] = 1;
        nArrayArray[45] = nArray43;
        int[] nArray44 = new int[4];
        nArray44[1] = 4;
        nArray44[2] = 1;
        nArrayArray[46] = nArray44;
        int[] nArray45 = new int[4];
        nArray45[1] = 4;
        nArray45[2] = 1;
        nArrayArray[47] = nArray45;
        int[] nArray46 = new int[4];
        nArray46[0] = 1;
        nArray46[1] = 3;
        nArray46[2] = 1;
        nArrayArray[48] = nArray46;
        int[] nArray47 = new int[4];
        nArray47[1] = 4;
        nArray47[2] = 1;
        nArrayArray[49] = nArray47;
        int[] nArray48 = new int[4];
        nArray48[1] = 4;
        nArray48[2] = 1;
        nArrayArray[50] = nArray48;
        int[] nArray49 = new int[4];
        nArray49[1] = 4;
        nArray49[2] = 1;
        nArrayArray[51] = nArray49;
        int[] nArray50 = new int[4];
        nArray50[1] = 4;
        nArray50[2] = 1;
        nArrayArray[52] = nArray50;
        int[] nArray51 = new int[4];
        nArray51[1] = 4;
        nArray51[2] = 1;
        nArrayArray[53] = nArray51;
        int[] nArray52 = new int[4];
        nArray52[1] = 4;
        nArray52[2] = 1;
        nArrayArray[54] = nArray52;
        int[] nArray53 = new int[4];
        nArray53[1] = 4;
        nArray53[2] = 1;
        nArrayArray[55] = nArray53;
        int[] nArray54 = new int[4];
        nArray54[1] = 4;
        nArray54[2] = 1;
        nArrayArray[56] = nArray54;
        int[] nArray55 = new int[4];
        nArray55[1] = 4;
        nArray55[2] = 1;
        nArrayArray[57] = nArray55;
        int[] nArray56 = new int[4];
        nArray56[1] = 4;
        nArray56[2] = 1;
        nArrayArray[58] = nArray56;
        int[] nArray57 = new int[4];
        nArray57[1] = 4;
        nArray57[2] = 1;
        nArrayArray[59] = nArray57;
        int[] nArray58 = new int[4];
        nArray58[1] = 4;
        nArray58[2] = 1;
        nArrayArray[60] = nArray58;
        int[] nArray59 = new int[4];
        nArray59[1] = 4;
        nArray59[2] = 1;
        nArrayArray[61] = nArray59;
        int[] nArray60 = new int[4];
        nArray60[1] = 4;
        nArray60[2] = 1;
        nArrayArray[62] = nArray60;
        int[] nArray61 = new int[4];
        nArray61[1] = 4;
        nArray61[2] = 1;
        nArrayArray[63] = nArray61;
        int[] nArray62 = new int[4];
        nArray62[1] = 4;
        nArray62[2] = 1;
        nArrayArray[64] = nArray62;
        int[] nArray63 = new int[4];
        nArray63[1] = 4;
        nArray63[2] = 1;
        nArrayArray[65] = nArray63;
        int[] nArray64 = new int[4];
        nArray64[1] = 4;
        nArray64[2] = 1;
        nArrayArray[66] = nArray64;
        int[] nArray65 = new int[4];
        nArray65[1] = 4;
        nArray65[2] = 1;
        nArrayArray[67] = nArray65;
        int[] nArray66 = new int[4];
        nArray66[1] = 4;
        nArray66[2] = 1;
        nArrayArray[68] = nArray66;
        int[] nArray67 = new int[4];
        nArray67[1] = 4;
        nArray67[2] = 1;
        nArrayArray[69] = nArray67;
        int[] nArray68 = new int[4];
        nArray68[1] = 4;
        nArray68[2] = 1;
        nArrayArray[70] = nArray68;
        int[] nArray69 = new int[4];
        nArray69[1] = 4;
        nArray69[2] = 1;
        nArrayArray[71] = nArray69;
        int[] nArray70 = new int[4];
        nArray70[1] = 4;
        nArray70[2] = 1;
        nArrayArray[72] = nArray70;
        int[] nArray71 = new int[4];
        nArray71[1] = 4;
        nArray71[2] = 1;
        nArrayArray[73] = nArray71;
        int[] nArray72 = new int[4];
        nArray72[3] = 9;
        nArrayArray[74] = nArray72;
        BLOCK_LENGTH_DATA = nArrayArray;
    }

    public TZXZX81Block(ZX81SampleAnalyzer analyzer, int pause) {
        this.mProgramBytes = analyzer.getBytes();
        this.mProgramNameBytes = analyzer.getProgramNameBytes();
        if (this.mProgramNameBytes == null) {
            this.mProgramNameBytes = new byte[0];
        }
        this.mPause = pause;
    }

    public TZXZX81Block(InputStream is) throws IOException {
        this.read(is);
    }

    public static List readTZXZX81Blocks(File file) throws IOException {
        return TZXZX81Block.readTZXZX81Blocks(TapeConverter.getInputStream(file));
    }

    public static List readTZXZX81Blocks(InputStream is) throws IOException {
        byte[] header = new byte[7];
        is.read(header);
        if (!new String(header).equals("ZXTape!")) {
            throw new IOException("Not a TZX file");
        }
        if (is.read() != 26) {
            throw new IOException("Not a TZX file");
        }
        int major = is.read();
        int minor = is.read();
        if (major < 1 || major == 1 && minor < 20) {
            throw new IOException("TZX file must be v1.20 or higher");
        }
        ArrayList<TZXZX81Block> blocks = new ArrayList<TZXZX81Block>();
        int blockType = is.read();
        while (blockType != -1) {
            if (blockType == 25) {
                TZXZX81Block block = TZXZX81Block.createTZXZX81Block(is);
                if (block != null) {
                    blocks.add(block);
                }
            } else if (blockType == 48) {
                int len = is.read();
                byte[] text = new byte[len];
                is.read(text);
            } else {
                TZXZX81Block.skipTZXBlock(is, blockType);
            }
            blockType = is.read();
        }
        return blocks;
    }

    private static TZXZX81Block createTZXZX81Block(InputStream is) {
        try {
            return new TZXZX81Block(is);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void skipTZXBlock(InputStream is, int blockType) throws IOException {
        int[] blockData = BLOCK_LENGTH_DATA[blockType - 16];
        int multiplier = blockData[2];
        if (multiplier == 0) {
            is.skip(blockData[3]);
        } else {
            int lengthOffset = blockData[0];
            int lengthSize = blockData[1];
            is.skip(lengthOffset);
            int dataLength = 0;
            if (lengthSize > 0) {
                dataLength += is.read();
            }
            if (lengthSize > 1) {
                dataLength += is.read() << 8;
            }
            if (lengthSize > 2) {
                dataLength += is.read() << 16;
            }
            if (lengthSize > 3) {
                dataLength += is.read() << 24;
            }
            is.skip(dataLength * multiplier);
        }
    }

    public byte[] getBytes() {
        return this.mProgramBytes;
    }

    public byte[] getProgramNameBytes() {
        return this.mProgramNameBytes;
    }

    public int getPause() {
        return this.mPause;
    }

    public byte[] getZeroSymbolTable() {
        return this.mZeroSymbolTable;
    }

    public byte[] getOneSymbolTable() {
        return this.mOneSymbolTable;
    }

    public void write(OutputStream os) throws IOException {
        os.write(25);
        int length = 14 + this.mZeroSymbolTable.length + this.mOneSymbolTable.length + this.mProgramNameBytes.length + this.mProgramBytes.length;
        os.write(length & 0xFF);
        os.write(length >> 8 & 0xFF);
        os.write(length >> 16 & 0xFF);
        os.write(length >> 24 & 0xFF);
        os.write(this.mPause & 0xFF);
        os.write(this.mPause >> 8 & 0xFF);
        os.write(0);
        os.write(0);
        os.write(0);
        os.write(0);
        os.write(0);
        os.write(0);
        int symbols = (this.mProgramBytes.length + this.mProgramNameBytes.length) * 8;
        os.write(symbols & 0xFF);
        os.write(symbols >> 8 & 0xFF);
        os.write(symbols >> 16 & 0xFF);
        os.write(symbols >> 24 & 0xFF);
        os.write((this.mZeroSymbolTable.length - 1) / 2);
        os.write(2);
        os.write(this.mZeroSymbolTable);
        os.write(this.mOneSymbolTable);
        if (this.mProgramNameBytes.length > 1) {
            os.write(this.mProgramNameBytes, 0, this.mProgramNameBytes.length - 1);
        }
        if (this.mProgramNameBytes.length > 0) {
            os.write(this.mProgramNameBytes[this.mProgramNameBytes.length - 1] | 0x80);
        }
        os.write(this.mProgramBytes);
    }

    public boolean read(InputStream is) throws IOException {
        int totalLength = is.read() + (is.read() << 8) + (is.read() << 16) + (is.read() << 24);
        this.mPause = is.read() + (is.read() << 8);
        totalLength -= 2;
        is.read();
        is.read();
        is.read();
        is.read();
        totalLength -= 4;
        is.read();
        --totalLength;
        is.read();
        --totalLength;
        int symbols = is.read() + (is.read() << 8) + (is.read() << 16) + (is.read() << 24);
        int totalNumBytes = symbols / 8;
        totalLength -= 4;
        int symbolTableSize = is.read() * 2 + 1;
        this.mZeroSymbolTable = new byte[symbolTableSize];
        this.mOneSymbolTable = new byte[symbolTableSize];
        --totalLength;
        int numSymbols = is.read();
        --totalLength;
        if (numSymbols != 2) {
            is.skip(totalLength);
            return false;
        }
        is.read(this.mZeroSymbolTable);
        is.read(this.mOneSymbolTable);
        int programNameLength = 0;
        byte[] programNameBuffer = new byte[128];
        int b = is.read();
        while (b < 128 && programNameLength < 127) {
            programNameBuffer[programNameLength++] = (byte)b;
            b = is.read();
        }
        programNameBuffer[programNameLength++] = (byte)(b - 128);
        this.mProgramNameBytes = new byte[programNameLength];
        System.arraycopy(programNameBuffer, 0, this.mProgramNameBytes, 0, programNameLength);
        int programLength = totalNumBytes - programNameLength;
        this.mProgramBytes = new byte[programLength];
        is.read(this.mProgramBytes);
        return true;
    }
}

