/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.zx81;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.UIManager;
import tapeutils.AnalysisEvent;
import tapeutils.AnalysisListener;
import tapeutils.MultiSampleAnalyzer;
import tapeutils.Sample;
import tapeutils.SampleAnalyzer;
import tapeutils.gui.ConversionFrame;
import tapeutils.gui.MessageSelectionListener;
import tapeutils.impl.zx81.ZX81SampleAnalyzer;
import tapeutils.impl.zx81.ZX81SampleAnalyzerFactory;
import tapeutils.impl.zx81.ZX81SampleGenerator;
import tapeutils.zx81.DebugLevels;
import tapeutils.zx81.PFile;
import tapeutils.zx81.PreferenceAccessor;
import tapeutils.zx81.Preferences;
import tapeutils.zx81.TZXZX81Block;
import tapeutils.zx81.TapeConverterParameters;

public class TapeConverter
implements AnalysisListener {
    private Sample[] mSamples = new Sample[2];
    private File[] mSampleFiles = new File[2];
    private MultiSampleAnalyzer[] mSampleAnalyzers = new MultiSampleAnalyzer[2];
    private TapeConverterParameters[] mSampleParams = new TapeConverterParameters[2];
    private Set[] mMessageSelectionListeners = new HashSet[]{new HashSet(), new HashSet()};
    private Set[] mAnalysisListeners = new HashSet[]{new HashSet(), new HashSet()};
    private ConversionFrame mFrame;
    private Preferences mPreferences;
    private DebugLevels mDebugLevels;
    public static final String APPLICATION_NAME = "ZX81 Tape Converter";
    public static final String DEBUG_FILE = "ZTCDebug.log";
    private static final String PREFS_FILE = "ZTCPrefs.ini";
    private static final String COPYRIGHT = "(c) Simon Holdsworth 2007, http://www.zx81stuff.org.uk";
    private static final String ZIP_FILE_HEADER = "Generated by ZX81 Tape Converter, (c) Simon Holdsworth 2007, http://www.zx81stuff.org.uk";
    private static final String TZX_TEXT_BLOCK = "TZX file created by ZX81 Tape Converter, (c) Simon Holdsworth 2007, http://www.zx81stuff.org.uk";
    private static final String PREFERENCE_FILE_HEADER = "ZX81 Tape Converter Preference File, (c) Simon Holdsworth 2007, http://www.zx81stuff.org.uk";
    public static final String PREF_SAMPLE_DIRECTORY = "TapeConverter.sampleDirectory";
    public static final String PREF_PFILE_DIRECTORY = "TapeConverter.pFileDirectory";
    public static final String PREF_TZXFILE_DIRECTORY = "TapeConverter.tzxFileDirectory";
    public static final String PREF_ANALYSIS_CONFIG_FILE = "TapeConverter.analysisConfigFile";
    public static final String PREF_SAMPLE_RATE = "TapeConverter.sampleRate";
    public static final String PREF_P_PROGRAM_NAME = "TapeConverter.pProgramName";
    public static final String PREF_SQUARE_WAVE = "TapeConverter.squareWave";
    public static final String PREF_SAVE_SAMPLE_AS_ZIP = "TapeConverter.saveSampleAsZIP";
    public static final String PREF_AUTO_SHOW_RESULTS = "TapeConverter.autoShowResults";
    public static final String PREF_MAXIMUM_ERRORS = "TapeConverter.maximumErrors";
    public static final String PREF_MAXIMUM_WARNINGS = "TapeConverter.maximumWarnings";
    public static final String PREF_DEBUG_WAVE = "TapeConverter.debugWave";
    public static final String PREF_DEBUG_BIT = "TapeConverter.debugBit";
    public static final String PREF_DEBUG_BYTE = "TapeConverter.debugByte";
    public static final String PREF_DEBUG_GENERAL = "TapeConverter.debugGeneral";
    public static final String PREF_DEBUG_START = "TapeConverter.debugStart";
    public static final String PREF_DEBUG_END = "TapeConverter.debugEnd";
    public static final String PREF_DEBUG_FILE = "TapeConverter.debugFile";

    public static void main(String[] args) throws Exception {
        File sample1File = null;
        File sample2File = null;
        String pFileName = null;
        boolean showGUI = true;
        TapeConverterParameters sample1Params = new TapeConverterParameters();
        TapeConverterParameters sample2Params = new TapeConverterParameters(sample1Params);
        TapeConverterParameters currentParams = sample1Params;
        boolean forceWrite = false;
        int aPos = 0;
        while (aPos < args.length) {
            if ((args[aPos].equals("-sampleFile") || args[aPos].equals("-s")) && aPos < args.length) {
                if (sample1File == null) {
                    String sample1FileName;
                    if ((sample1File = new File(sample1FileName = args[++aPos])).exists()) {
                        sample1Params.setSampleFileName(sample1FileName, true);
                    } else {
                        System.err.println("Error: sample file " + sample1FileName + " does not exist.");
                        TapeConverter.usage();
                    }
                } else {
                    System.err.println("Error: sample file name specified twice.");
                    TapeConverter.usage();
                }
            } else if ((args[aPos].equals("-sample2File") || args[aPos].equals("-2")) && aPos < args.length) {
                if (sample2File == null) {
                    String sample2FileName;
                    if ((sample2File = new File(sample2FileName = args[++aPos])).exists()) {
                        sample2Params.setSampleFileName(sample2FileName, true);
                        currentParams = sample2Params;
                    } else {
                        System.err.println("Error: sample 2 file " + sample2FileName + " does not exist.");
                        TapeConverter.usage();
                    }
                } else {
                    System.err.println("Error: sample 2 file name specified twice.");
                    TapeConverter.usage();
                }
            } else if ((args[aPos].equals("-configFile") || args[aPos].equals("-c")) && aPos < args.length) {
                String configFileName;
                File configFile;
                if ((configFile = new File(configFileName = args[++aPos])).exists()) {
                    sample1Params.loadConfigFile(new File(configFileName));
                    sample2Params.initialize();
                }
            } else if ((args[aPos].equals("-pFile") || args[aPos].equals("-p")) && aPos < args.length) {
                pFileName = args[++aPos];
            } else if (args[aPos].equals("-noGui") || args[aPos].equals("-g")) {
                showGUI = false;
            } else if (args[aPos].equals("-forceWrite") || args[aPos].equals("-w")) {
                forceWrite = true;
            } else if (args[aPos].equals("-invert") || args[aPos].equals("-i")) {
                currentParams.setInvert(true);
            } else if (args[aPos].equals("-data") || args[aPos].equals("-d")) {
                try {
                    currentParams.getDefaults().setNumDataBytes(Integer.parseInt(args[++aPos]));
                }
                catch (NumberFormatException exc) {
                    TapeConverter.usage();
                }
            } else if ((args[aPos].equals("-noise") || args[aPos].equals("-n")) && aPos < args.length) {
                try {
                    currentParams.getDefaults().setNoiseThreshold(Integer.parseInt(args[++aPos]));
                }
                catch (NumberFormatException exc) {
                    TapeConverter.usage();
                }
            } else if ((args[aPos].equals("-minGap") || args[aPos].equals("-m")) && aPos < args.length) {
                try {
                    currentParams.getDefaults().setMinGap(Integer.parseInt(args[++aPos]));
                }
                catch (NumberFormatException exc) {
                    TapeConverter.usage();
                }
            } else if ((args[aPos].equals("-maxGap") || args[aPos].equals("-x")) && aPos < args.length) {
                try {
                    currentParams.getDefaults().setMaxGap(Integer.parseInt(args[++aPos]));
                }
                catch (NumberFormatException exc) {
                    TapeConverter.usage();
                }
            } else if ((args[aPos].equals("-begin") || args[aPos].equals("-b")) && aPos < args.length) {
                try {
                    currentParams.setBeginIndex(Integer.parseInt(args[++aPos]));
                }
                catch (NumberFormatException exc) {
                    TapeConverter.usage();
                }
            } else if ((args[aPos].equals("-channel") || args[aPos].equals("-h")) && aPos < args.length) {
                try {
                    currentParams.setChannel(Integer.parseInt(args[++aPos]));
                }
                catch (NumberFormatException exc) {
                    TapeConverter.usage();
                }
            } else {
                TapeConverter.usage();
            }
            ++aPos;
        }
        if (sample1File == null && !showGUI) {
            System.err.println("Sample file must be provided when not using the GUI.");
            TapeConverter.usage();
        }
        TapeConverter converter = new TapeConverter(sample1File, sample2File, sample1Params, sample2Params, showGUI);
        if (sample1File != null) {
            converter.convert();
        }
        if (!showGUI) {
            if (pFileName != null) {
                converter.writePFiles(0, forceWrite, new String[]{pFileName});
            } else {
                converter.writePFiles(0, forceWrite);
            }
        }
    }

    public static InputStream getInputStream(File f) throws IOException {
        if (f != null) {
            if (f.getName().toLowerCase().endsWith(".zip")) {
                ZipFile z = new ZipFile(f);
                Enumeration<? extends ZipEntry> e = z.entries();
                if (!e.hasMoreElements()) {
                    throw new IOException("ZIP file has no entries.");
                }
                ZipEntry first = e.nextElement();
                return new BufferedInputStream(z.getInputStream(first));
            }
            return new BufferedInputStream(new FileInputStream(f));
        }
        return null;
    }

    private OutputStream getOutputStream(File f) throws IOException {
        if (f != null) {
            String name = f.getName();
            if (name.toLowerCase().endsWith(".zip")) {
                return this.getZipOutputStream(new FileOutputStream(f), name.substring(0, name.length() - 4), 0L);
            }
            return new FileOutputStream(f);
        }
        return null;
    }

    private ZipOutputStream getZipOutputStream(OutputStream os, String name, long lastModified) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        zos.setComment(ZIP_FILE_HEADER);
        zos.setLevel(9);
        ZipEntry entry = new ZipEntry(name);
        if (lastModified > 0L) {
            entry.setTime(lastModified);
        }
        zos.putNextEntry(entry);
        return zos;
    }

    private void closeOutputStream(OutputStream os) throws IOException {
        if (os instanceof ZipOutputStream) {
            ((ZipOutputStream)os).closeEntry();
        }
        os.close();
    }

    public TapeConverter(File sampleFile, TapeConverterParameters sampleParams) throws Exception {
        this(sampleFile, null, sampleParams, null, false);
    }

    public TapeConverter(File sample1File, File sample2File, TapeConverterParameters sample1Params, TapeConverterParameters sample2Params, boolean showGUI) throws Exception {
        this.mSampleParams[0] = sample1Params;
        this.mSampleParams[1] = sample2Params;
        this.mSampleFiles[0] = sample1File;
        this.mSampleFiles[1] = sample2File;
        this.loadSample(0);
        this.loadSample(1);
        this.mPreferences = new Preferences(PREFS_FILE, PREFERENCE_FILE_HEADER);
        this.mDebugLevels = new DebugLevels(this.mPreferences);
        if (showGUI) {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            this.mFrame = new ConversionFrame();
            this.mFrame.initialize(this);
            this.mFrame.setVisible(true);
        } else {
            this.mFrame = null;
        }
    }

    private void loadSample(int sampleNumber) throws IOException, UnsupportedAudioFileException {
        if (this.mSampleFiles[sampleNumber] != null) {
            this.mSamples[sampleNumber] = null;
            TapeConverterParameters params = this.mSampleParams[sampleNumber];
            InputStream in = TapeConverter.getInputStream(this.mSampleFiles[sampleNumber]);
            AudioInputStream ais = AudioSystem.getAudioInputStream(in);
            this.mSamples[sampleNumber] = new Sample(ais, params.getInvert(), params.getChannel());
        }
    }

    public void convert() {
        if (this.mSamples[0] == null) {
            throw new IllegalArgumentException("Convert called with null sample.");
        }
        this.analyze();
    }

    public void samplePropertiesUpdated(int sampleNumber) throws IOException, UnsupportedAudioFileException {
        this.loadSample(sampleNumber);
    }

    private void analyze() {
        this.analyze(0);
        if (this.mSamples[1] != null) {
            this.analyze(1);
        }
    }

    private void analyze(int sampleNumber) {
        MultiSampleAnalyzer analyzer;
        TapeConverterParameters params = this.mSampleParams[sampleNumber];
        ZX81SampleAnalyzerFactory factory = new ZX81SampleAnalyzerFactory(this.mSamples[sampleNumber], params.getAnalyzerParameters());
        factory.setDebugLevels(this.mDebugLevels);
        this.mSampleAnalyzers[sampleNumber] = analyzer = new MultiSampleAnalyzer(this.mSamples[sampleNumber], factory, params);
        analyzer.addAnalysisListener(this);
        analyzer.analyze(params.getBeginIndex(), this.mPreferences.get(PREF_MAXIMUM_ERRORS, 50), this.mPreferences.get(PREF_MAXIMUM_WARNINGS, 1000), false);
        if (this.mFrame == null) {
            analyzer.printMessages();
            System.out.print(String.valueOf(analyzer.numErrors()) + " errors, " + analyzer.numWarnings() + " warnings.");
        }
    }

    public int writePFiles(int sampleNumber, File directory) throws IOException {
        String[] pFiles = this.mSampleParams[sampleNumber].getPFileNames(false);
        int i = 0;
        while (i < pFiles.length) {
            this.writePFile(sampleNumber, i, new File(directory, pFiles[i]));
            ++i;
        }
        return pFiles.length;
    }

    public void writePFiles(int sampleNumber, boolean forceWrite, String[] pFileNames) throws IOException {
        String[] pFiles = this.mSampleParams[sampleNumber].getPFileNames(false);
        if (this.numErrors(sampleNumber) == 0 || forceWrite) {
            int i = 0;
            while (i < pFiles.length && i < this.mSampleAnalyzers[sampleNumber].numAnalyzers()) {
                String name = i < pFileNames.length ? pFileNames[i] : pFiles[i];
                this.writePFile(sampleNumber, i, new File(name));
                ++i;
            }
        }
    }

    public void writePFiles(int sampleNumber, boolean forceWrite) throws IOException {
        String[] pFiles = this.mSampleParams[sampleNumber].getPFileNames(false);
        if (this.numErrors(sampleNumber) == 0 || forceWrite) {
            int i = 0;
            while (i < pFiles.length && i < this.mSampleAnalyzers[sampleNumber].numAnalyzers()) {
                this.writePFile(sampleNumber, i, new File(pFiles[i]));
                ++i;
            }
        }
    }

    public void writePFile(int sampleNumber, int index, File pFile) throws IOException {
        this.writePFile(sampleNumber, index, new FileOutputStream(pFile));
        if (this.mFrame == null) {
            System.out.println(" Saved data to " + pFile);
        }
    }

    public void writePFile(int sampleNumber, int index, OutputStream os) throws IOException {
        SampleAnalyzer sa = this.mSampleAnalyzers[sampleNumber].getSampleAnalyzer(index);
        sa.write(os);
        os.close();
    }

    public void writeTZXFile(int sampleNumber, File tzxFile) throws IOException {
        OutputStream os = this.getOutputStream(tzxFile);
        this.writeTZXFile(sampleNumber, os);
        this.closeOutputStream(os);
    }

    public void writeTZXZIPFile(int sampleNumber, OutputStream os, String name, long lastModified) throws IOException {
        ZipOutputStream zos = this.getZipOutputStream(os, name, lastModified);
        this.writeTZXFile(sampleNumber, os);
        this.closeOutputStream(zos);
    }

    public void writeTZXFile(int sampleNumber, OutputStream os) throws IOException {
        os.write("ZXTape!".getBytes());
        os.write(26);
        os.write(1);
        os.write(20);
        os.write(48);
        os.write(TZX_TEXT_BLOCK.length());
        os.write(TZX_TEXT_BLOCK.getBytes());
        MultiSampleAnalyzer multiAnalyzer = this.mSampleAnalyzers[sampleNumber];
        int i = 0;
        while (i < multiAnalyzer.numAnalyzers()) {
            int pause = 1;
            ZX81SampleAnalyzer analyzer = (ZX81SampleAnalyzer)multiAnalyzer.getSampleAnalyzer(i);
            if (i < multiAnalyzer.numAnalyzers() - 1) {
                ZX81SampleAnalyzer nextAnalyzer = (ZX81SampleAnalyzer)multiAnalyzer.getSampleAnalyzer(i + 1);
                int distanceSamples = nextAnalyzer.getFirstBitStartIndex() - analyzer.getLastBitEndIndex();
                pause = (int)((double)distanceSamples * 1000.0 / this.mSamples[sampleNumber].getSamplesPerSecond());
            }
            os.write(48);
            String programName = analyzer.getProgramName();
            programName = programName != null && programName.length() > 0 ? "Program Name: " + programName : "Data file";
            os.write(programName.length());
            os.write(programName.getBytes());
            new TZXZX81Block(analyzer, pause).write(os);
            ++i;
        }
    }

    public int numErrors(int sampleNumber) {
        return this.mSampleAnalyzers[sampleNumber].numErrors();
    }

    public void cleanUp() {
        this.mSampleAnalyzers[0].cleanUp();
        if (this.mSampleAnalyzers[1] != null) {
            this.mSampleAnalyzers[1].cleanUp();
        }
        this.mSampleAnalyzers[0] = null;
        this.mSampleAnalyzers[1] = null;
    }

    public TapeConverterParameters getParameters(int sampleNumber) {
        return this.mSampleParams[sampleNumber];
    }

    public Sample getSample(int sampleNumber) {
        return this.mSamples[sampleNumber];
    }

    public SampleAnalyzer getSampleAnalyzer(int sampleNumber) {
        return this.mSampleAnalyzers[sampleNumber];
    }

    public File getSampleFile(int sampleNumber) {
        return this.mSampleFiles[sampleNumber];
    }

    public int numSamples() {
        return this.mSamples[1] == null ? 1 : 2;
    }

    public int undo(int sampleNumber) {
        return this.getSampleAnalyzer(sampleNumber).undo(this.mPreferences.get(PREF_MAXIMUM_ERRORS, 50), this.mPreferences.get(PREF_MAXIMUM_WARNINGS, 1000), false);
    }

    public int redo(int sampleNumber) {
        return this.getSampleAnalyzer(sampleNumber).redo(this.mPreferences.get(PREF_MAXIMUM_ERRORS, 50), this.mPreferences.get(PREF_MAXIMUM_WARNINGS, 1000), false);
    }

    public ConversionFrame getConversionFrame() {
        return this.mFrame;
    }

    public void loadSample(File sampleFile, int sampleNumber) throws IOException, UnsupportedAudioFileException {
        String fileName = sampleFile.getName().toLowerCase();
        if (fileName.endsWith(".tzx") || fileName.endsWith(".tzx.zip")) {
            sampleFile = this.convertTZXToSample(sampleFile);
        } else if (fileName.endsWith(".p") || fileName.endsWith(".p.zip")) {
            sampleFile = this.convertPToSample(sampleFile);
        }
        this.mSampleFiles[sampleNumber] = sampleFile;
        this.mSampleParams[sampleNumber].setSampleFileName(sampleFile.getName(), true);
        this.loadSample(sampleNumber);
        this.convert();
        if (this.mSampleAnalyzers[sampleNumber].numMessages() > 0) {
            this.fireMessageSelectionEvent(sampleNumber, 0);
        }
    }

    public void saveSample(File sampleFile, int sampleNumber) throws IOException {
        OutputStream os = this.getOutputStream(sampleFile);
        if (this.mSamples[sampleNumber] == null) {
            throw new IOException("No valid sample file to save");
        }
        this.mSamples[sampleNumber].save(os);
        this.closeOutputStream(os);
        this.mSampleParams[sampleNumber].sampleSaved(sampleFile);
        this.mSampleFiles[sampleNumber] = sampleFile;
    }

    public void closeSample(int sampleNumber) {
        this.mSampleFiles[sampleNumber] = null;
        this.mSamples[sampleNumber] = null;
    }

    private File convertTZXToSample(File tzxFile) throws IOException {
        List blocks = TZXZX81Block.readTZXZX81Blocks(tzxFile);
        float sampleRate = this.mPreferences.get(PREF_SAMPLE_RATE, 22050.0f);
        boolean squareWave = this.mPreferences.get(PREF_SQUARE_WAVE, false);
        File sampleFile = File.createTempFile("temp", ".wav");
        sampleFile.deleteOnExit();
        ZX81SampleGenerator generator = new ZX81SampleGenerator(blocks);
        generator.write(sampleRate, squareWave, sampleFile);
        return sampleFile;
    }

    private File convertPToSample(File pFile) throws IOException {
        float sampleRate = this.mPreferences.get(PREF_SAMPLE_RATE, 22050.0f);
        String zx81Name = this.mPreferences.get(PREF_P_PROGRAM_NAME, "P");
        boolean squareWave = this.mPreferences.get(PREF_SQUARE_WAVE, false);
        return this.convertPToSample(pFile, zx81Name, sampleRate, squareWave);
    }

    private File convertPToSample(File pFile, String zx81Name, float sampleRate, boolean squareWave) throws IOException {
        PFile p = new PFile(pFile, zx81Name);
        File sampleFile = File.createTempFile("temp", ".wav");
        sampleFile.deleteOnExit();
        p.writeSampleToFile(sampleRate, sampleFile, squareWave);
        return sampleFile;
    }

    public void loadConfig(File configFile) throws IOException {
        this.mSampleParams[0].loadConfigFile(configFile);
        if (this.mSamples[0] != null) {
            this.mSamples[0].setInvert(this.mSampleParams[0].getInvert());
            this.mSamples[0].setChannel(this.mSampleParams[0].getChannel());
        }
        if (this.mSamples[1] != null) {
            this.mSampleParams[1].loadConfigFile(configFile);
            this.mSamples[1].setInvert(this.mSampleParams[1].getInvert());
            this.mSamples[1].setChannel(this.mSampleParams[1].getChannel());
        }
        if (this.mSamples[0] != null) {
            this.convert();
        }
    }

    public void saveConfig(File configFile) throws IOException {
        this.mSampleParams[0].saveConfigFile(configFile);
    }

    public PreferenceAccessor getPreferences(Object accessor) {
        return new PreferenceAccessor(accessor, this.mPreferences);
    }

    public void addAnalysisListener(int sampleNumber, AnalysisListener l) {
        this.mAnalysisListeners[sampleNumber].add(l);
    }

    @Override
    public void analysisComplete(AnalysisEvent event) {
        int sourceId = event.getSource() == this.mSampleAnalyzers[0] ? 0 : 1;
        Set listeners = this.mAnalysisListeners[sourceId];
        event.setSourceId(sourceId);
        for (AnalysisListener listener : listeners) {
            listener.analysisComplete(event);
        }
    }

    public void addMessageSelectionListener(int sampleNumber, MessageSelectionListener l) {
        this.mMessageSelectionListeners[sampleNumber].add(l);
    }

    public void fireMessageSelectionEvent(int sampleNumber, int messageNumber) {
        Iterator i = this.mMessageSelectionListeners[sampleNumber].iterator();
        while (i.hasNext()) {
            ((MessageSelectionListener)i.next()).messageSelected(sampleNumber, messageNumber);
        }
    }

    private static void usage() {
        System.out.println("Usage: ");
        System.out.println("java " + TapeConverter.class.getName());
        System.out.println("  [{-sampleFile |-s} fileName]   Sample file name (.WAV, .AIFF. .AU, etc.)");
        System.out.println("  [{-sample2File|-2} fileName]   Second sample file name (.WAV, .AIFF. .AU, etc.)");
        System.out.println("  [{-pFile      |-p} fileName]   The name of the .p file to save to (only valid with -noGui/-g)");
        System.out.println("  [{-noGui      |-g}]            Don't show GUI (in which case sample file must be provided).");
        System.out.println("  [{-invert     |-i}]            Invert samples.");
        System.out.println("  [{-noise      |-n} threshold]  Noise threshold.");
        System.out.println("  [{-minGap     |-m} minGap]     Minimum gap between groups.");
        System.out.println("  [{-maxGap     |-x} maxGap]     Maximum gap between groups.");
        System.out.println("  [{-channel    |-h} channel]    Channel number within sample.");
        System.out.println("  [{-data       |-d} numBytes]   Data only. Process the given number of bytes.");
        System.out.println("  [{-forceWrite |-w}]            Force write of resulting file even after errors.");
        System.out.println("  [{-begin      |-b}]            Index within sample to start processing.");
        System.out.println("  [{-configFile |-c} configFile] Name of a properties file with convert parameters");
        System.exit(-1);
    }
}

