/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import tapeutils.zx81.TapeConverter;
import tapeutils.zx81.TapeConverterParameters;
import util.RadixSort;

public class ConvertTest {
    public static void main(String[] args) {
        String sDirName = null;
        String pDirName = null;
        String tzxDirName = null;
        String configFile = null;
        boolean newOnly = false;
        int aPos = 0;
        while (aPos < args.length) {
            if ((args[aPos].equals("-sampleDirectory") || args[aPos].equals("-s")) && aPos < args.length) {
                sDirName = args[++aPos];
            } else if ((args[aPos].equals("-pDirectory") || args[aPos].equals("-p")) && aPos < args.length) {
                pDirName = args[++aPos];
            } else if ((args[aPos].equals("-tzxDirectory") || args[aPos].equals("-t")) && aPos < args.length) {
                tzxDirName = args[++aPos];
            } else if ((args[aPos].equals("-configFile") || args[aPos].equals("-c")) && aPos < args.length) {
                configFile = args[++aPos];
            } else if (args[aPos].equals("-newOnly") || args[aPos].equals("-n")) {
                newOnly = true;
            } else {
                ConvertTest.usage();
            }
            ++aPos;
        }
        if (sDirName == null || pDirName == null || tzxDirName == null) {
            ConvertTest.usage();
        }
        File sDir = new File(sDirName);
        File pDir = new File(pDirName);
        File tzxDir = new File(tzxDirName);
        if (!(sDir.isDirectory() && pDir.isDirectory() && tzxDir.isDirectory())) {
            ConvertTest.usage();
        }
        Properties p = new Properties();
        if (configFile != null && new File(configFile).exists()) {
            try {
                p.load(new FileInputStream(configFile));
            }
            catch (IOException exc) {
                System.err.println("Failed to load config file " + configFile + ": " + exc.getMessage());
            }
        }
        ConvertTest.test(sDir, pDir, tzxDir, p, newOnly);
    }

    private static void usage() {
        System.out.println("Usage: ");
        System.out.println("java " + ConvertTest.class.getName());
        System.out.println("   {-sampleDirectory|-s}  directory   The directory containing the sample files.");
        System.out.println("   {-pDirectory     |-p}  directory   The directory containing the .p files.");
        System.out.println("   {-tzxDirectory   |-t}  directory   The directory containing the .tzx files.");
        System.exit(-1);
    }

    private static void test(File sDir, File pDir, File tzxDir, Properties props, boolean newOnly) {
        int tested = 0;
        int failed = 0;
        int skipped = 0;
        int newP = 0;
        int newTZX = 0;
        ArrayList<Object> failedList = new ArrayList<Object>();
        HashSet<File> checkedPFiles = new HashSet<File>();
        HashSet<File> allPFiles = new HashSet<File>();
        HashSet<File> checkedTZXFiles = new HashSet<File>();
        HashSet<File> allTZXFiles = new HashSet<File>();
        Object[] subDirs = sDir.list();
        RadixSort.radixSort(subDirs);
        int d = 0;
        while (d < subDirs.length) {
            File subDir = new File(sDir, (String)subDirs[d]);
            if (subDir.isDirectory()) {
                System.out.println("\nProcessing subdirectory " + (String)subDirs[d]);
                File pSubDir = new File(pDir, (String)subDirs[d]);
                String[] pSubDirFiles = pSubDir.list();
                int i = 0;
                while (i < pSubDirFiles.length) {
                    allPFiles.add(new File(pSubDir, pSubDirFiles[i]));
                    ++i;
                }
                File tzxSubDir = new File(tzxDir, (String)subDirs[d]);
                String[] tzxSubDirFiles = tzxSubDir.list();
                int i2 = 0;
                while (i2 < tzxSubDirFiles.length) {
                    allTZXFiles.add(new File(tzxSubDir, tzxSubDirFiles[i2]));
                    ++i2;
                }
                Object[] sampleFiles = subDir.list();
                RadixSort.radixSort(sampleFiles);
                int i3 = 0;
                while (i3 < sampleFiles.length) {
                    System.out.println();
                    File sampleFile = new File(subDir, (String)sampleFiles[i3]);
                    ++tested;
                    if (((String)sampleFiles[i3]).indexOf("Broken") > -1) {
                        System.out.println(String.valueOf(sampleFiles[i3]) + ": skipping broken file.");
                        ++skipped;
                    } else if (sampleFile.isDirectory()) {
                        System.out.println(String.valueOf(sampleFiles[i3]) + ": skipping directory.");
                        ++skipped;
                    } else {
                        System.out.println(String.valueOf(sampleFiles[i3]) + ": testing.");
                        TapeConverterParameters cp = new TapeConverterParameters((String)sampleFiles[i3], props);
                        String[] pFileNames = cp.getPFileNames(true);
                        File[] pFiles = new File[pFileNames.length];
                        boolean filesExist = true;
                        int j = 0;
                        while (j < pFiles.length) {
                            pFiles[j] = new File(pSubDir, pFileNames[j]);
                            filesExist &= pFiles[j].exists();
                            ++j;
                        }
                        File tzxFile = new File(tzxSubDir, String.valueOf(cp.getRootName()) + ".tzx");
                        if (newOnly && (filesExist &= tzxFile.exists())) {
                            System.out.println("  Skipping - " + pFiles.length + " .P file(s) already exists.");
                            int j2 = 0;
                            while (j2 < pFiles.length) {
                                checkedPFiles.add(pFiles[j2]);
                                ++j2;
                            }
                            checkedTZXFiles.add(tzxFile);
                        } else {
                            TapeConverter converter;
                            try {
                                converter = new TapeConverter(sampleFile, cp);
                                converter.convert();
                            }
                            catch (Exception exc) {
                                System.out.println(String.valueOf(sampleFiles[i3]) + ": Failed! Exception = " + exc);
                                failedList.add(sampleFiles[i3]);
                                ++failed;
                                converter = null;
                            }
                            if (converter != null && converter.numErrors(0) > 0) {
                                System.out.println(String.valueOf(sampleFiles[i3]) + ": Failed! Errors = " + converter.numErrors(0));
                                failedList.add(sampleFiles[i3]);
                                ++failed;
                                converter = null;
                            }
                            if (converter != null) {
                                System.out.println();
                                int j3 = 0;
                                while (j3 < pFiles.length) {
                                    try {
                                        if (!pFiles[j3].exists()) {
                                            converter.writePFile(0, j3, pFiles[j3]);
                                            System.out.println(String.valueOf(pFiles[j3].getName()) + ": Succeeded: no file to compare with.");
                                            ++newP;
                                        } else {
                                            if (checkedPFiles.contains(pFiles[j3])) {
                                                System.out.println(pFiles[j3] + ": has already been checked!");
                                            }
                                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                            converter.writePFile(0, j3, baos);
                                            if (!ConvertTest.checkExistingFile(pFiles[j3], baos)) {
                                                failedList.add(sampleFiles[i3]);
                                                ++failed;
                                            }
                                        }
                                    }
                                    catch (Exception exc) {
                                        System.out.println(String.valueOf(pFiles[j3].getName()) + ": Failed: " + exc.getMessage());
                                        failedList.add(sampleFiles[i3]);
                                        ++failed;
                                    }
                                    checkedPFiles.add(pFiles[j3]);
                                    ++j3;
                                }
                                if (checkedTZXFiles.contains(tzxFile)) {
                                    System.out.println(tzxFile + ": has already been checked!");
                                } else {
                                    try {
                                        if (!tzxFile.exists()) {
                                            converter.writeTZXFile(0, tzxFile);
                                            System.out.println(String.valueOf(tzxFile.getName()) + ": Succeeded: no file to compare with.");
                                            ++newTZX;
                                        } else {
                                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                            converter.writeTZXFile(0, baos);
                                            if (!ConvertTest.checkExistingFile(tzxFile, baos)) {
                                                failedList.add(sampleFiles[i3]);
                                                ++failed;
                                            }
                                        }
                                    }
                                    catch (Exception exc) {
                                        System.out.println(String.valueOf(tzxFile.getName()) + ": Failed: " + exc.getMessage());
                                        exc.printStackTrace();
                                        failedList.add(sampleFiles[i3]);
                                        ++failed;
                                    }
                                }
                                checkedTZXFiles.add(tzxFile);
                            }
                            if (converter != null) {
                                converter.cleanUp();
                            }
                        }
                    }
                    ++i3;
                }
            }
            ++d;
        }
        System.out.println("\n\nTested " + (tested - skipped) + " .wav files. " + checkedPFiles.size() + " .P files, new: " + newP + ", " + checkedTZXFiles.size() + " .TZX files, new: " + newTZX + ". Failed samples: " + failed);
        int i = 0;
        while (i < failed) {
            System.out.println("  " + failedList.get(i));
            ++i;
        }
        System.out.println();
        for (File f : allPFiles) {
            if (checkedPFiles.contains(f)) continue;
            System.out.println(f + " not generated by any sample file.");
        }
        for (File f : allTZXFiles) {
            if (checkedTZXFiles.contains(f)) continue;
            System.out.println(f + " not generated by any sample file.");
        }
    }

    private static boolean checkExistingFile(File pFile, ByteArrayOutputStream baos) throws IOException {
        byte[] tBytes = baos.toByteArray();
        FileInputStream fis = new FileInputStream(pFile);
        if (fis.available() != tBytes.length) {
            System.out.println(String.valueOf(pFile.getName()) + ": Failed: file is incorrect length (" + tBytes.length + ", should be " + fis.available());
            return false;
        }
        byte[] pBytes = new byte[tBytes.length];
        int total = fis.read(pBytes);
        while (total < tBytes.length) {
            total += fis.read(pBytes, total, pBytes.length - total);
        }
        int b = 0;
        while (b < tBytes.length) {
            if (tBytes[b] != pBytes[b]) {
                System.out.println(String.valueOf(pFile.getName()) + ": Failed: file comparison failed at offset " + b + " got " + (tBytes[b] & 0xFF) + " expected " + (pBytes[b] & 0xFF));
                return false;
            }
            ++b;
        }
        System.out.println(String.valueOf(pFile.getName()) + ": Succeeded comparison with existing file " + pFile);
        return true;
    }
}

