/*
 * Decompiled with CFR 0.152.
 */
package util;

import util.LargeIntArray;

public class BlockSequence {
    private LargeIntArray mStarts;
    private LargeIntArray mEnds;
    private LargeIntArray mValues;
    private int mNumBlocks;
    private int mFirstBlockStart;
    private int mFirstBlockEnd;
    private int mLastBlockEnd;
    private int mPreviousFindIndex;
    private int mPreviousFindPosition;
    private int mPreviousFindBlockEnd;

    public BlockSequence() {
        this.mValues = new LargeIntArray();
        this.mStarts = new LargeIntArray();
        this.mEnds = new LargeIntArray();
    }

    public BlockSequence(int initialSize) {
        this.mValues = new LargeIntArray(initialSize);
        this.mStarts = new LargeIntArray(initialSize);
        this.mEnds = new LargeIntArray(initialSize);
    }

    public void initialize() {
        this.mValues.clear();
        this.mStarts.clear();
        this.mEnds.clear();
        this.mNumBlocks = 0;
        this.mFirstBlockStart = -1;
        this.mFirstBlockEnd = -1;
        this.mLastBlockEnd = -1;
        this.mPreviousFindPosition = -1;
        this.mPreviousFindBlockEnd = -1;
        this.mPreviousFindIndex = -9999;
    }

    public void addBlock(int start, int end, int value) {
        if (end == 0) {
            throw new IllegalArgumentException("Cannot add block ending at 0");
        }
        if (this.mFirstBlockStart == -1) {
            this.mFirstBlockStart = start;
            this.mFirstBlockEnd = end;
        }
        while (start < this.mLastBlockEnd) {
            this.removeLastBlock();
        }
        this.mStarts.add(start);
        this.mEnds.add(end);
        this.mValues.add(value);
        ++this.mNumBlocks;
        this.mLastBlockEnd = end;
    }

    public void removeLastBlock() {
        if (this.mNumBlocks > 0) {
            this.mStarts.remove();
            this.mEnds.remove();
            this.mValues.remove();
            --this.mNumBlocks;
            if (this.mNumBlocks == 0) {
                this.mFirstBlockStart = -1;
                this.mFirstBlockEnd = -1;
                this.mLastBlockEnd = -1;
            } else {
                this.mLastBlockEnd = this.mEnds.get(this.mNumBlocks - 1);
            }
        }
    }

    public int isBlockEnd(int index) {
        int position = this.findPosition(index);
        if (position < this.mNumBlocks && index == this.mEnds.get(position)) {
            return position;
        }
        return -1;
    }

    private int findPosition(int index) {
        if (index < this.mFirstBlockEnd) {
            return 0;
        }
        if (index >= this.mLastBlockEnd) {
            return this.mNumBlocks;
        }
        int oldFindIndex = this.mPreviousFindIndex;
        this.mPreviousFindIndex = index;
        if (index == oldFindIndex + 1) {
            if (index < this.mPreviousFindBlockEnd) {
                return this.mPreviousFindPosition;
            }
            ++this.mPreviousFindPosition;
            this.mPreviousFindBlockEnd = this.mEnds.get(this.mPreviousFindPosition);
            return this.mPreviousFindPosition;
        }
        int rangeStart = 1;
        int rangeEnd = this.mNumBlocks - 1;
        int testPos = this.getFindPosition(rangeStart, rangeEnd, index);
        int loops = 0;
        while (true) {
            ++loops;
            int previousEnd = this.mEnds.get(testPos - 1);
            if (index >= previousEnd) {
                int end = this.mEnds.get(testPos);
                if (index < end) {
                    this.mPreviousFindPosition = testPos;
                    this.mPreviousFindBlockEnd = end;
                    return testPos;
                }
                rangeStart = testPos + 1;
            } else {
                rangeEnd = testPos;
            }
            testPos = this.getFindPosition(rangeStart, rangeEnd, index);
        }
    }

    private final int getFindPosition(int start, int end, int index) {
        int startIndex = this.mEnds.get(start - 1);
        int endIndex = this.mEnds.get(end);
        if (index < startIndex || index > endIndex) {
            System.out.println("Error whilst searching: index out of range: " + startIndex + "," + index + "," + endIndex);
        }
        double ratio = (double)(index - startIndex) / (double)(endIndex - startIndex);
        int result = start + (int)((double)(end - start) * ratio);
        return result;
    }

    public void getValues(int[] values, int start) {
        int end;
        int position = this.findPosition(start);
        int blockStart = end = start + values.length;
        int blockEnd = 0;
        int blockValue = 0;
        if (position < this.mNumBlocks) {
            blockStart = this.mStarts.get(position);
            blockEnd = this.mEnds.get(position);
            blockValue = this.mValues.get(position);
        }
        int i = start;
        while (i < end) {
            if (i < blockStart) {
                values[i] = 0;
            } else if (i < blockEnd) {
                values[i] = blockValue;
            } else if (++position < this.mNumBlocks) {
                blockStart = this.mStarts.get(position);
                blockEnd = this.mEnds.get(position);
                blockValue = this.mValues.get(position);
            } else {
                blockStart = end;
            }
            ++i;
        }
    }

    public int getValue(int index) {
        int position = this.findPosition(index);
        if (position == this.mNumBlocks) {
            return 0;
        }
        if (index < this.mStarts.get(position)) {
            return 0;
        }
        return this.mValues.get(position);
    }

    public void getBlockNumber(int index, int[] pos) {
        int position;
        pos[0] = position = this.findPosition(index);
        pos[1] = position < this.mNumBlocks ? index - this.mStarts.get(position) : 0;
    }

    public int getBlockStart(int position) {
        if (position >= 0 && position < this.mNumBlocks) {
            return this.mStarts.get(position);
        }
        return -1;
    }

    public int getBlockEnd(int position) {
        if (position >= 0 && position < this.mNumBlocks) {
            return this.mEnds.get(position);
        }
        return -1;
    }

    public int getBlockValue(int position) {
        return this.mValues.get(position);
    }

    public int getLastBlockValue() {
        if (this.mNumBlocks == 0) {
            return 0;
        }
        return this.mValues.get(this.mNumBlocks - 1);
    }

    public void clear() {
        this.initialize();
    }

    public int length() {
        return this.mNumBlocks;
    }
}

