/*
 * Decompiled with CFR 0.152.
 */
package sinclair.basic;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import sinclair.basic.Distance;
import sinclair.basic.ZX81SysVars;
import sinclair.basic.ZX81Translate;

public class ZX81Basic {
    private static final int LINE_WRAP = 80;
    public static boolean DEBUG = false;

    public static void dumpProgram(byte[] memory, int start, int display, int vars, int varsEnd, boolean dumpNumberValues, StringBuffer buff) {
        buff.append("BASIC listing:\n\n");
        ZX81Basic.dumpProgramLines(memory, start, display, dumpNumberValues, buff);
        buff.append("\nDisplay:\n\n");
        ZX81Basic.dumpDisplay(memory, display, vars, buff);
        buff.append("\nVariables:\n\n");
        ZX81Basic.dumpVariables(memory, vars, varsEnd, buff);
    }

    public static void dumpProgramLines(byte[] memory, int start, int end, boolean dumpNumberValues, StringBuffer buff) {
        Map programLines = ZX81Basic.getProgramLines(memory, start, end);
        for (Map.Entry e : programLines.entrySet()) {
            int lineNumber = (Integer)e.getKey();
            byte[] line = (byte[])e.getValue();
            ZX81Basic.dumpLine(line, lineNumber, dumpNumberValues, true, true, buff);
        }
    }

    public static void dumpLine(byte[] memory, int number, boolean dumpNumberValues, StringBuffer buff) {
        ZX81Basic.dumpLine(memory, number, dumpNumberValues, true, true, buff);
    }

    public static void dumpLine(byte[] memory, int number, boolean dumpNumberValues, boolean translate, boolean wrap, StringBuffer buff) {
        int ch;
        String pad;
        StringBuffer lineBuffer = new StringBuffer();
        String string = number < 10 ? "   " : (number < 100 ? "  " : (pad = number < 1000 ? " " : ""));
        if (translate) {
            lineBuffer.append(pad).append(number).append(' ');
        } else {
            ZX81Translate.translateASCIIToZX81(String.valueOf(pad) + number + " ", lineBuffer);
        }
        int pos = 0;
        boolean remStatement = (memory[0] & 0xFF) == 234;
        while (pos < memory.length - 1) {
            if ((ch = memory[pos++] & 0xFF) == 126 && !remStatement) {
                if (dumpNumberValues) {
                    lineBuffer.append("{");
                    pos = ZX81Basic.getNumber(memory, pos, lineBuffer);
                    lineBuffer.append("}");
                } else {
                    pos += 5;
                }
            } else if (translate) {
                lineBuffer.append(ZX81Translate.translateZX81ToASCII(ch));
            } else {
                lineBuffer.append(ZX81Translate.expandZX81(ch));
            }
            if (!wrap || lineBuffer.length() <= 80) continue;
            buff.append(lineBuffer);
            buff.append('\n');
            lineBuffer.setLength(0);
        }
        ch = -1;
        if (pos < memory.length) {
            ch = memory[pos++] & 0xFF;
        }
        if (ch != 118) {
            System.out.println("Warning: BASIC line " + number + " does not end with NEWLINE");
        }
        buff.append(lineBuffer);
        if (translate) {
            buff.append('\n');
        } else {
            buff.append('v');
        }
    }

    public static void dumpDisplay(byte[] memory, int start, int end, StringBuffer buff) {
        int pos = start;
        if (end > memory.length) {
            end = memory.length;
        }
        while (pos < end) {
            int ch;
            if ((ch = memory[pos++] & 0xFF) == 118) {
                buff.append("#\n#");
                continue;
            }
            buff.append(ZX81Translate.translateZX81ToASCII(ch));
        }
    }

    public static void dumpVariables(byte[] memory, int start, int end, StringBuffer buff) {
        Map variables = ZX81Basic.getVariables(memory, start, end, true);
        for (Map.Entry e : variables.entrySet()) {
            String varName = (String)e.getKey();
            String varValue = (String)e.getValue();
            buff.append(varName).append("=").append(varValue).append('\n');
        }
    }

    public static int getNumber(byte[] content, int pos, StringBuffer buff) {
        if (pos > content.length - 5) {
            buff.append("[invalid number data]");
            return pos;
        }
        long E = content[pos] & 0xFF;
        long A = content[pos + 1] & 0xFF;
        long B = content[pos + 2] & 0xFF;
        long C = content[pos + 3] & 0xFF;
        long D = content[pos + 4] & 0xFF;
        double number = (double)(2 * (A < 128L ? 1 : 0) - 1) * Math.pow(2.0, E - 160L) * (double)(((256L * (A + (long)(128 * (A < 128L ? 1 : 0))) + B) * 256L + C) * 256L + D);
        buff.append('[').append(number);
        int i = 0;
        while (i < 5) {
            buff.append(',').append(Integer.toString(content[pos++] & 0xFF));
            ++i;
        }
        buff.append(']');
        return pos;
    }

    /*
     * Unable to fully structure code
     */
    public static void getArray(byte[] content, int start, int len, StringBuffer buff, boolean number, boolean wrap) {
        block8: {
            try {
                totalSize = 1;
                pos = start;
                numDims = content[pos++] & 255;
                if (ZX81Basic.DEBUG) {
                    System.out.println("Array number of dimensions " + numDims);
                }
                dims = new int[numDims];
                i = 0;
                while (i < numDims) {
                    dims[i] = (content[pos++] & 255) + ((content[pos++] & 255) << 8);
                    if (ZX81Basic.DEBUG) {
                        System.out.println("Array dimension " + i + " size = " + dims[i] + " at byte " + (pos - 2));
                    }
                    if ((totalSize *= dims[i]) > len) {
                        throw new IllegalArgumentException("Error: total array size > length");
                    }
                    ++i;
                }
                ZX81Basic.getArray(content, pos, buff, dims, 0, number);
                break block8;
            }
            catch (RuntimeException exc) {
                if (ZX81Basic.DEBUG) {
                    System.out.println("   Failed to parse array: " + exc);
                    exc.printStackTrace();
                }
                lastWrap = pos = start;
                buff.setLength(0);
                ** while (pos < start + len)
            }
lbl-1000:
            // 1 sources

            {
                buff.append(ZX81Translate.translateZX81ToASCII((char)content[pos++] & 255));
                if (!wrap || pos - lastWrap <= 80) continue;
                buff.append('\n');
                lastWrap = pos;
                continue;
            }
        }
    }

    public static void getArray(byte[] content, int pos, StringBuffer buff, int[] dims, int dim, boolean number) {
        boolean lastChars;
        buff.append('{');
        boolean bl = lastChars = dim == dims.length - 1 && !number;
        if (lastChars) {
            buff.append('\"');
        }
        int i = 0;
        while (i < dims[dim]) {
            if (dim == dims.length - 1) {
                if (number) {
                    pos = ZX81Basic.getNumber(content, pos, buff);
                } else {
                    buff.append(ZX81Translate.translateZX81ToASCII((char)content[pos++]));
                }
            } else {
                ZX81Basic.getArray(content, pos, buff, dims, dim + 1, number);
            }
            if (i < dims[dim] - 1 && !lastChars) {
                buff.append(',');
            }
            ++i;
        }
        if (lastChars) {
            buff.append('\"');
        }
        buff.append('}');
    }

    public static int comparePrograms(byte[] prog1, byte[] prog2, boolean compVars, int allowable) {
        Map lines1 = ZX81Basic.getProgramLines(prog1);
        Map lines2 = ZX81Basic.getProgramLines(prog2);
        Map vars1 = null;
        Map vars2 = null;
        if (compVars) {
            vars1 = ZX81Basic.getVariables(prog1);
            vars2 = ZX81Basic.getVariables(prog2);
        }
        return ZX81Basic.comparePrograms(lines1, vars1, lines2, vars2, compVars, allowable);
    }

    public static int comparePrograms(Map lines1, Map vars1, Map lines2, Map vars2, boolean compVars, int allowable) {
        Integer lineNumber;
        Map.Entry entry;
        int difference = 0;
        Iterator i = lines1.entrySet().iterator();
        while (i.hasNext() && difference < allowable) {
            entry = i.next();
            lineNumber = (Integer)entry.getKey();
            byte[] line1 = (byte[])entry.getValue();
            byte[] line2 = (byte[])lines2.get(lineNumber);
            if (line2 == null) {
                difference += line1.length;
                if (!DEBUG) continue;
                System.out.println("ddd Line " + lineNumber + " not in prog2 difference = " + line1.length + " total " + difference);
                continue;
            }
            int olddiff = difference;
            if (!DEBUG || (difference += Distance.getDistance(line1, line2, allowable)) <= olddiff) continue;
            System.out.println("ddd Line " + lineNumber + " difference = " + (difference - olddiff) + " total " + difference);
        }
        i = lines2.entrySet().iterator();
        while (i.hasNext() && difference < allowable) {
            entry = i.next();
            lineNumber = (Integer)entry.getKey();
            byte[] line2 = (byte[])entry.getValue();
            byte[] line1 = (byte[])lines1.get(lineNumber);
            if (line1 != null) continue;
            difference += line2.length;
            if (!DEBUG) continue;
            System.out.println("ddd Line " + lineNumber + " not in prog1 difference = " + line2.length + " total " + difference);
        }
        if (compVars && difference < allowable) {
            int varsDiff = ZX81Basic.compareVariables(vars1, vars2, allowable);
            difference += varsDiff;
            if (DEBUG) {
                System.out.println("ddd Vars difference = " + varsDiff + " total " + difference);
            }
        }
        return difference;
    }

    private static int compareVariables(Map vars1, Map vars2, int allowable) {
        String varName;
        Map.Entry entry;
        int difference = 0;
        if (DEBUG) {
            System.out.println("Prog 1 has " + vars1.size() + " vars; prog 2 has " + vars2.size());
        }
        if (vars1.size() == 0 || vars2.size() == 0) {
            return 0;
        }
        Iterator i = vars1.entrySet().iterator();
        while (i.hasNext() && difference < allowable) {
            entry = i.next();
            varName = (String)entry.getKey();
            byte[] varValue1 = (byte[])entry.getValue();
            byte[] varValue2 = (byte[])vars2.get(varName);
            if (varValue2 == null) {
                difference += varValue1.length + varName.length();
                if (!DEBUG) continue;
                System.out.println("ddd Variable " + varName + " not in prog2 difference = " + (varValue1.length + varName.length()) + " total " + difference);
                continue;
            }
            int olddiff = difference;
            if (DEBUG) {
                System.out.println("ddd Variable " + varName + " difference in length = " + Math.abs(varValue1.length - varValue2.length));
            }
            if (!DEBUG || (difference += Distance.getDistance(varValue1, varValue2, allowable)) <= olddiff) continue;
            System.out.println("ddd Variable " + varName + " difference = " + (difference - olddiff) + " total " + difference);
        }
        i = vars2.entrySet().iterator();
        while (i.hasNext() && difference < allowable) {
            entry = i.next();
            varName = (String)entry.getKey();
            byte[] varValue2 = (byte[])entry.getValue();
            byte[] varValue1 = (byte[])vars1.get(varName);
            if (varValue1 != null) continue;
            difference += varValue2.length + varName.length();
            if (!DEBUG) continue;
            System.out.println("ddd Variable " + varName + " not in prog1 difference = " + (varValue2.length + varName.length()) + " total " + difference);
        }
        return difference;
    }

    public static Map getProgramLines(byte[] memory) {
        int start = 116;
        int end = ZX81SysVars.getVariableValueOffset(memory, 16396, 2);
        if (end < 0) {
            end = ZX81SysVars.getVariableValueOffset(memory, 16400, 2);
        }
        return ZX81Basic.getProgramLines(memory, start, end);
    }

    public static Map getProgramLines(byte[] memory, int start, int end) {
        TreeMap<Integer, byte[]> result = new TreeMap<Integer, byte[]>();
        int pos = start;
        if (end > memory.length) {
            end = memory.length;
        }
        while (pos < end - 3) {
            int lineLength;
            int lineNumber = ((memory[pos++] & 0xFF) << 8) + (memory[pos++] & 0xFF);
            if ((lineLength = (memory[pos++] & 0xFF) + ((memory[pos++] & 0xFF) << 8)) > end - pos) {
                lineLength = end - pos;
            }
            if (lineLength <= 0) continue;
            byte[] line = new byte[lineLength];
            System.arraycopy(memory, pos, line, 0, lineLength);
            result.put(new Integer(lineNumber), line);
            pos += lineLength;
        }
        return result;
    }

    public static Map getVariables(byte[] memory) {
        int varsStart = ZX81SysVars.getVariableValueOffset(memory, 16400, 2);
        int varsEnd = ZX81SysVars.getVariableValueOffset(memory, 16404, 2);
        return ZX81Basic.getVariables(memory, varsStart, varsEnd, false);
    }

    /*
     * Unable to fully structure code
     */
    public static Map getVariables(byte[] memory, int start, int end, boolean wrap) {
        block22: {
            if (ZX81Basic.DEBUG) {
                System.out.println("Getting variables from " + start + " to " + end);
            }
            result = new TreeMap<String, String>();
            pos = start;
            if (end > memory.length) {
                end = memory.length;
            }
            try {
                while (pos < end - 1) {
                    varType = (memory[pos] & 255) >> 5;
                    varNameFirst = (char)(memory[pos++] & 63);
                    varName = new StringBuffer();
                    varValue = new StringBuffer();
                    if (ZX81Basic.DEBUG) {
                        System.out.println("   Variable type: " + varType);
                    }
                    lastWrap = pos;
                    switch (varType) {
                        case 2: {
                            varNameFirst = (char)(varNameFirst + 32);
                            varName.append(ZX81Translate.translateZX81ToASCII(varNameFirst)).append('$');
                            varValue.append('\"');
                            len = (memory[pos++] & 255) + ((memory[pos++] & 255) << 8);
                            i = 0;
                            while (i < len) {
                                varValue.append(ZX81Translate.translateZX81ToASCII((char)memory[pos++]));
                                if (wrap && pos - lastWrap > 80) {
                                    varValue.append('\n');
                                    lastWrap = pos;
                                }
                                ++i;
                            }
                            varValue.append('\"');
                            break;
                        }
                        case 3: {
                            varName.append(ZX81Translate.translateZX81ToASCII(varNameFirst));
                            pos = ZX81Basic.getNumber(memory, pos, varValue);
                            break;
                        }
                        case 4: {
                            varNameFirst = (char)(varNameFirst + 32);
                            varName.append(ZX81Translate.translateZX81ToASCII(varNameFirst));
                            totalLen = (memory[pos++] & 255) + ((memory[pos++] & 255) << 8);
                            if (ZX81Basic.DEBUG) {
                                System.out.println("Array name '" + varName.toString() + "' total length " + totalLen);
                            }
                            if (pos + totalLen > end) {
                                throw new IllegalArgumentException("Error: array length too long: " + totalLen);
                            }
                            ZX81Basic.getArray(memory, pos, totalLen, varValue, true, wrap);
                            pos += totalLen;
                            break;
                        }
                        case 5: {
                            varName.append(ZX81Translate.translateZX81ToASCII(varNameFirst));
                            do {
                                varNameNext = (char)(memory[pos] & 127);
                                varName.append(ZX81Translate.translateZX81ToASCII(varNameNext));
                            } while ((memory[pos++] & 128) == 0);
                            pos = ZX81Basic.getNumber(memory, pos, varValue);
                            break;
                        }
                        case 6: {
                            varNameFirst = (char)(varNameFirst + 32);
                            varName.append(ZX81Translate.translateZX81ToASCII(varNameFirst)).append('$');
                            totalLen = (memory[pos++] & 255) + ((memory[pos++] & 255) << 8);
                            ZX81Basic.getArray(memory, pos, totalLen, varValue, false, wrap);
                            pos += totalLen;
                            break;
                        }
                        case 7: {
                            varName.append(ZX81Translate.translateZX81ToASCII(varNameFirst));
                            pos = ZX81Basic.getNumber(memory, pos, varValue);
                            varValue.append(" TO ");
                            pos = ZX81Basic.getNumber(memory, pos, varValue);
                            varValue.append(" STEP ");
                            pos = ZX81Basic.getNumber(memory, pos, varValue);
                            varValue.append(" LOOPLINE ");
                            loop = (memory[pos++] & 255) + ((memory[pos++] & 255) << 8);
                            varValue.append(Integer.toString(loop));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Error: variable type: " + varType);
                        }
                    }
                    if (ZX81Basic.DEBUG) {
                        System.out.println("Variable name '" + varName.toString() + "' value '" + varValue.toString() + "'");
                    }
                    result.put(varName.toString(), varValue.toString());
                }
                break block22;
            }
            catch (RuntimeException exc) {
                if (ZX81Basic.DEBUG) {
                    System.out.println("   Failed to parse variables: " + exc);
                    exc.printStackTrace();
                }
                buff = new StringBuffer();
                lastWrap = pos = start;
                ** while (pos < end)
            }
lbl-1000:
            // 1 sources

            {
                buff.append(ZX81Translate.translateZX81ToASCII((char)memory[pos++] & 255));
                if (!wrap || pos - lastWrap <= 80) continue;
                buff.append('\n');
                lastWrap = pos;
                continue;
            }
lbl110:
            // 1 sources

            result.put("!", buff.toString());
        }
        return result;
    }

    public static Map getVariableMemory(byte[] memory) {
        int varsStart = ZX81SysVars.getVariableValueOffset(memory, 16400, 2);
        int varsEnd = ZX81SysVars.getVariableValueOffset(memory, 16404, 2);
        return ZX81Basic.getVariableMemory(memory, varsStart, varsEnd);
    }

    public static Map getVariableMemory(byte[] memory, int start, int end) {
        if (DEBUG) {
            System.out.println("Getting variable memory from " + start + " to " + end);
        }
        TreeMap<String, byte[]> result = new TreeMap<String, byte[]>();
        int pos = start;
        if (end > memory.length) {
            end = memory.length;
        }
        try {
            while (pos < end - 1) {
                int varType = (memory[pos] & 0xFF) >> 5;
                char varNameFirst = (char)(memory[pos++] & 0x3F);
                StringBuffer varName = new StringBuffer();
                byte[] value = null;
                if (DEBUG) {
                    System.out.println("   Variable type: " + varType);
                }
                switch (varType) {
                    case 2: {
                        varNameFirst = (char)(varNameFirst + 32);
                        varName.append(ZX81Translate.translateZX81ToASCII(varNameFirst)).append('$');
                        int len = (memory[pos++] & 0xFF) + ((memory[pos++] & 0xFF) << 8);
                        value = new byte[len];
                        System.arraycopy(memory, pos, value, 0, len);
                        pos += len;
                        break;
                    }
                    case 3: {
                        varName.append(ZX81Translate.translateZX81ToASCII(varNameFirst));
                        value = new byte[5];
                        System.arraycopy(memory, pos, value, 0, 5);
                        pos += 5;
                        break;
                    }
                    case 4: {
                        varNameFirst = (char)(varNameFirst + 32);
                        varName.append(ZX81Translate.translateZX81ToASCII(varNameFirst));
                        int totalLen = (memory[pos++] & 0xFF) + ((memory[pos++] & 0xFF) << 8);
                        value = new byte[totalLen];
                        System.arraycopy(memory, pos, value, 0, totalLen);
                        pos += totalLen;
                        break;
                    }
                    case 5: {
                        varName.append(ZX81Translate.translateZX81ToASCII(varNameFirst));
                        do {
                            char varNameNext = (char)(memory[pos] & 0x7F);
                            varName.append(ZX81Translate.translateZX81ToASCII(varNameNext));
                        } while ((memory[pos++] & 0x80) == 0);
                        value = new byte[5];
                        System.arraycopy(memory, pos, value, 0, 5);
                        pos += 5;
                        break;
                    }
                    case 6: {
                        varNameFirst = (char)(varNameFirst + 32);
                        varName.append(ZX81Translate.translateZX81ToASCII(varNameFirst)).append('$');
                        int totalLen = (memory[pos++] & 0xFF) + ((memory[pos++] & 0xFF) << 8);
                        value = new byte[totalLen];
                        System.arraycopy(memory, pos, value, 0, totalLen);
                        pos += totalLen;
                        break;
                    }
                    case 7: {
                        varName.append(ZX81Translate.translateZX81ToASCII(varNameFirst));
                        value = new byte[17];
                        System.arraycopy(memory, pos, value, 0, value.length);
                        pos += value.length;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Error: variable type: " + varType);
                    }
                }
                result.put(varName.toString(), value);
            }
        }
        catch (RuntimeException exc) {
            if (DEBUG) {
                System.out.println("   Failed to parse variables: " + exc);
                exc.printStackTrace();
            }
            byte[] value = new byte[end - start];
            System.arraycopy(memory, start, value, 0, value.length);
            pos = end;
            result.put("!", value);
        }
        return result;
    }
}

