/*
 * Decompiled with CFR 0.152.
 */
package tapeutils;

import java.util.Properties;

public class Parameters {
    private int[] mValues;
    private String[] mKeys;
    private Properties mProperties;
    private int mNumValues;
    private String mPropertyKeyRoot;
    private Parameters mDefaults;

    private Parameters(int[] defaults) {
        this.mNumValues = defaults.length;
        this.mKeys = null;
        this.mValues = new int[this.mNumValues];
        int i = 0;
        while (i < this.mNumValues) {
            this.mValues[i] = defaults[i];
            ++i;
        }
    }

    protected Parameters(String[] keys, int[] defaults) {
        this.mNumValues = keys.length;
        this.mKeys = keys;
        this.mDefaults = new Parameters(defaults);
        this.mValues = new int[this.mNumValues];
        int i = 0;
        while (i < this.mNumValues) {
            this.mValues[i] = defaults[i];
            ++i;
        }
    }

    protected Parameters(String[] keys, Parameters defaults) {
        this.mNumValues = keys.length;
        this.mKeys = keys;
        this.mDefaults = defaults;
        this.mValues = new int[this.mNumValues];
        int i = 0;
        while (i < this.mNumValues) {
            this.mValues[i] = defaults.mValues[i];
            ++i;
        }
    }

    protected void init(Properties props, String root) {
        this.mProperties = props;
        this.mPropertyKeyRoot = root;
        int i = 0;
        while (i < this.mNumValues) {
            this.mValues[i] = Integer.valueOf(this.mProperties.getProperty(String.valueOf(this.mPropertyKeyRoot) + this.mKeys[i], "" + this.mDefaults.mValues[i]));
            ++i;
        }
    }

    private void storeProperties() {
        if (this.mProperties == null) {
            return;
        }
        int i = 0;
        while (i < this.mNumValues) {
            this.storeProperty(i);
            ++i;
        }
    }

    private void storeProperty(int index) {
        if (this.mProperties == null) {
            return;
        }
        if (this.mValues[index] != this.mDefaults.mValues[index]) {
            this.mProperties.setProperty(String.valueOf(this.mPropertyKeyRoot) + this.mKeys[index], "" + this.mValues[index]);
        } else {
            this.mProperties.remove(String.valueOf(this.mPropertyKeyRoot) + this.mKeys[index]);
        }
    }

    private void removeProperties() {
        if (this.mProperties == null) {
            return;
        }
        int i = 0;
        while (i < this.mNumValues) {
            this.mProperties.remove(String.valueOf(this.mPropertyKeyRoot) + this.mKeys[i]);
            ++i;
        }
    }

    protected boolean updatePropertyKeyRoot(String newValue) {
        if (this.mPropertyKeyRoot == null) {
            throw new IllegalArgumentException("Cannot set filename on default parameters.");
        }
        if (newValue == null) {
            throw new IllegalArgumentException("Cannot set null property key root.");
        }
        if (newValue.equals(this.mPropertyKeyRoot)) {
            return false;
        }
        this.removeProperties();
        this.mPropertyKeyRoot = newValue;
        this.storeProperties();
        return true;
    }

    protected int getValue(int index) {
        return this.mValues[index];
    }

    protected int getValue(int index, boolean[] isDefault) {
        isDefault[0] = this.mValues[index] == this.mDefaults.mValues[index];
        return this.mValues[index];
    }

    protected boolean setValue(int index, int newValue) {
        if (newValue == -1) {
            newValue = this.mDefaults.mValues[index];
        }
        if (this.mValues[index] == newValue) {
            return false;
        }
        this.mValues[index] = newValue;
        this.storeProperty(index);
        return true;
    }
}

