/*
 * Decompiled with CFR 0.152.
 */
package tapeutils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import tapeutils.SampleModificationHistory;

public class Sample
implements Runnable {
    private static final int[] mRanges;
    private AudioFormat mAudioFormat;
    private byte[] mSampleData;
    private int mBytesPerFrame;
    private int mBytesPerSample;
    private int mNumFrames;
    private int mNumChannels;
    private int mSelectedChannel = -1;
    private boolean mInverted = false;
    private boolean mBigEndian = false;
    private static final double DEFAULT_SAMPLE_RATE = 44100.0;
    private double mRateMultiplier = 1.0;
    private SampleModificationHistory mModHistory;
    private int mPlayStartIndex = 0;
    private SourceDataLine mLine;

    static {
        int[] nArray = new int[3];
        nArray[1] = 256;
        nArray[2] = 65536;
        mRanges = nArray;
    }

    public Sample(AudioInputStream input, boolean invert, int channel) throws IOException {
        this.mInverted = invert;
        this.mAudioFormat = input.getFormat();
        this.mBytesPerFrame = this.mAudioFormat.getFrameSize();
        this.mBigEndian = this.mAudioFormat.isBigEndian();
        this.mNumChannels = this.mAudioFormat.getChannels();
        this.mBytesPerSample = this.mBytesPerFrame / this.mNumChannels;
        if (channel >= this.mNumChannels) {
            throw new IOException("Invalid channel " + channel + " requested out of " + this.mNumChannels);
        }
        this.mSelectedChannel = channel;
        this.mRateMultiplier = (double)this.mAudioFormat.getSampleRate() / 44100.0;
        this.mSampleData = new byte[input.available()];
        int totalRead = 0;
        int numRead = 0;
        while ((numRead = input.read(this.mSampleData, totalRead, this.mSampleData.length - totalRead)) != -1) {
            totalRead += numRead;
        }
        this.mNumFrames = this.mSampleData.length / this.mBytesPerFrame;
        this.mModHistory = new SampleModificationHistory(this);
        input.close();
    }

    public int getSampleValue(int index) {
        int i;
        int pos = index * this.mBytesPerFrame;
        if (this.mSelectedChannel > 0) {
            pos += this.mBytesPerSample * this.mSelectedChannel;
        }
        int value = 0;
        if (this.mBigEndian) {
            i = 0;
            while (i < this.mBytesPerSample) {
                value = (value << 8) + (this.mSampleData[pos++] & 0xFF);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.mBytesPerSample) {
                value += (this.mSampleData[pos++] & 0xFF) << 8 * i;
                ++i;
            }
        }
        int result = value;
        if (this.mBytesPerSample == 1) {
            result -= 128;
        } else if (result > Short.MAX_VALUE) {
            result = (short)result;
        }
        if (this.mInverted) {
            result = -result;
        }
        return result;
    }

    public void setSampleValue(int index, int value) {
        int pos = index * this.mBytesPerFrame;
        if (this.mSelectedChannel > 0) {
            pos += this.mBytesPerSample * this.mSelectedChannel;
        }
        int result = value;
        result = this.mBytesPerSample == 1 ? (result += 128) : (result += 32768);
        if (this.mInverted) {
            result = -result;
        }
        if (this.mBigEndian) {
            int i = 0;
            while (i < this.mBytesPerSample) {
                this.mSampleData[pos++] = (byte)((result & 255 << 8 * i) >> 8 * i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.mBytesPerSample) {
                this.mSampleData[pos++] = (byte)((result & 255 << 8 * (this.mBytesPerSample - 1 - i)) >> 8 * (this.mBytesPerSample - 1 - i));
                ++i;
            }
        }
    }

    public int numSamples() {
        return this.mNumFrames;
    }

    public int getBytesPerSample() {
        return this.mBytesPerSample;
    }

    public int getRange() {
        return mRanges[this.mBytesPerSample];
    }

    public AudioFormat getAudioFormat() {
        return this.mAudioFormat;
    }

    public double getRateMultiplier() {
        return this.mRateMultiplier;
    }

    public double getSamplesPerSecond() {
        return this.mRateMultiplier * 44100.0;
    }

    public void save(OutputStream out) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.mSampleData);
        AudioInputStream ais = new AudioInputStream(bais, this.mAudioFormat, this.mSampleData.length);
        AudioSystem.write(ais, AudioFileFormat.Type.WAVE, out);
    }

    public void play(int index, boolean newThread) throws LineUnavailableException {
        if (this.mLine != null) {
            return;
        }
        DataLine.Info sourceInfo = new DataLine.Info(SourceDataLine.class, this.mAudioFormat);
        this.mLine = (SourceDataLine)AudioSystem.getLine(sourceInfo);
        this.mLine.open(this.mAudioFormat, 10000);
        FloatControl gainControl = (FloatControl)this.mLine.getControl(FloatControl.Type.MASTER_GAIN);
        gainControl.setValue(gainControl.getMaximum() - 0.01f);
        this.mPlayStartIndex = index;
        if (newThread) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }

    @Override
    public void run() {
        this.mLine.start();
        this.mLine.write(this.mSampleData, this.mPlayStartIndex, this.mSampleData.length - this.mPlayStartIndex);
        if (this.mLine != null) {
            this.mLine.drain();
        }
        this.stopPlaying();
    }

    public synchronized void stopPlaying() {
        if (this.mLine != null) {
            this.mLine.stop();
            this.mLine.close();
            this.mLine = null;
        }
    }

    public void startModification(int index, int length) {
        this.mModHistory.startModification(index, length);
    }

    public void endModification() {
        this.mModHistory.endModification();
    }

    public int undo() {
        return this.mModHistory.undo();
    }

    public int redo() {
        return this.mModHistory.redo();
    }

    public void setChannel(int channel) {
        this.mSelectedChannel = channel;
    }

    public void setInvert(boolean invert) {
        this.mInverted = invert;
    }
}

