/*
 * Decompiled with CFR 0.152.
 */
package tapeutils;

import java.util.ArrayList;
import java.util.List;
import tapeutils.Sample;
import tapeutils.SampleModification;

public class SampleModificationHistory {
    private List mModifications = new ArrayList();
    private int mPosition = 0;
    private Sample mSample;

    public SampleModificationHistory(Sample sample) {
        this.mSample = sample;
    }

    public void startModification(int index, int length) {
        while (this.mPosition < this.mModifications.size()) {
            this.mModifications.remove(this.mModifications.size() - 1);
        }
        SampleModification m = new SampleModification(this.mSample, index, length);
        this.mModifications.add(m);
    }

    public void endModification() {
        SampleModification m = (SampleModification)this.mModifications.get(this.mPosition);
        m.modified();
        ++this.mPosition;
    }

    public int undo() {
        int result = -1;
        if (this.mPosition > 0) {
            --this.mPosition;
            SampleModification m = (SampleModification)this.mModifications.get(this.mPosition);
            result = m.undo();
        }
        return result;
    }

    public int redo() {
        int result = -1;
        if (this.mPosition < this.mModifications.size()) {
            SampleModification m = (SampleModification)this.mModifications.get(this.mPosition);
            result = m.redo();
            ++this.mPosition;
        }
        return result;
    }
}

