/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.gui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import tapeutils.AnalysisEvent;
import tapeutils.AnalysisListener;
import tapeutils.gui.AnalysisResultsPanel;
import tapeutils.gui.ConversionFrame;
import tapeutils.zx81.TapeConverter;

public class AnalysisResultsDialog
extends JDialog
implements ActionListener,
AnalysisListener {
    private JButton mCloseButton;
    private JButton mHelpButton;
    private JPanel mPropsPanel;
    private AnalysisResultsPanel mSample1AnalysisResultsPanel;
    private AnalysisResultsPanel mSample2AnalysisResultsPanel;
    private TapeConverter mConverter;
    private boolean mPositioned = false;

    public AnalysisResultsDialog(TapeConverter converter) {
        super(converter.getConversionFrame(), "Analysis Results", false);
        this.setDefaultCloseOperation(1);
        this.setName("AnalysisResultsDialog");
        this.mConverter = converter;
        this.mConverter.addAnalysisListener(0, this);
        this.mConverter.addAnalysisListener(1, this);
        ConversionFrame cf = this.mConverter.getConversionFrame();
        JPanel buttonPanel = new JPanel();
        this.getContentPane().add((Component)buttonPanel, "South");
        this.mCloseButton = cf.createButton(this, "close", 67, true);
        buttonPanel.add(this.mCloseButton);
        this.mHelpButton = cf.createButton(this, "help", 72, true);
        buttonPanel.add(this.mHelpButton);
        this.mPropsPanel = new JPanel();
        this.mPropsPanel.setLayout(new GridLayout(1, 0));
        this.getContentPane().add((Component)this.mPropsPanel, "Center");
        this.mSample1AnalysisResultsPanel = new AnalysisResultsPanel(this.mConverter, 0);
        this.mPropsPanel.add(this.mSample1AnalysisResultsPanel);
        this.mSample2AnalysisResultsPanel = new AnalysisResultsPanel(this.mConverter, 1);
        this.pack();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && !this.mPositioned) {
            ConversionFrame frame = this.mConverter.getConversionFrame();
            frame.locateWindow(this);
            this.mPositioned = true;
        }
        super.setVisible(visible);
    }

    @Override
    public void analysisComplete(AnalysisEvent event) {
        this.refresh(event.getSourceId());
    }

    public void refresh(int sampleNumber) {
        if (sampleNumber == 0) {
            this.mSample1AnalysisResultsPanel.refresh();
        } else if (this.mConverter.numSamples() > 1) {
            this.mSample2AnalysisResultsPanel.refresh();
            if (this.mPropsPanel.getComponentCount() == 1) {
                this.mPropsPanel.add(this.mSample2AnalysisResultsPanel);
            }
        }
        if (this.mConverter.numSamples() == 1 && this.mPropsPanel.getComponentCount() == 2) {
            this.mPropsPanel.remove(this.mSample2AnalysisResultsPanel);
        }
        this.pack();
        this.repaint();
    }

    @Override
    public synchronized void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JButton) {
            if (source == this.mCloseButton) {
                this.setVisible(false);
            } else if (source == this.mHelpButton) {
                this.mConverter.getConversionFrame().showHelp(this);
            }
        }
    }
}

