/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import tapeutils.AnalysisEvent;
import tapeutils.AnalysisListener;
import tapeutils.gui.AnalysisSettingsPanel;
import tapeutils.gui.ConversionFrame;
import tapeutils.gui.SampleParametersPanel;
import tapeutils.impl.zx81.ZX81SampleAnalyzerParameters;
import tapeutils.zx81.PreferenceAccessor;
import tapeutils.zx81.TapeConverter;
import tapeutils.zx81.TapeConverterParameters;

public class AnalysisSettingsDialog
extends JDialog
implements ActionListener,
AnalysisListener {
    private JButton mOKButton;
    private JButton mApplyButton;
    private JButton mCancelButton;
    private JButton mHelpButton;
    private JButton mConfigFileLoadButton;
    private JButton mConfigFileSaveButton;
    private JButton mConfigFileSaveAsButton;
    private JLabel mConfigFileLabel;
    private JTabbedPane[] mTabbedPanes = new JTabbedPane[2];
    private int mNumSamples;
    private JPanel mCentrePanel;
    private JFileChooser mFileDialog;
    private TapeConverter mConverter;
    private PreferenceAccessor mPrefs;
    private boolean mPositioned = false;

    public AnalysisSettingsDialog(TapeConverter converter) {
        super(converter.getConversionFrame(), "Analysis Settings", false);
        this.setDefaultCloseOperation(1);
        this.setName("AnalysisSettingsDialog");
        this.mConverter = converter;
        this.mConverter.addAnalysisListener(0, this);
        this.mConverter.addAnalysisListener(1, this);
        ConversionFrame cf = this.mConverter.getConversionFrame();
        this.mPrefs = this.mConverter.getPreferences(this);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new FlowLayout(0));
        this.getContentPane().add((Component)topPanel, "North");
        topPanel.add(cf.createLabel(this, "configfilelabel"));
        cf.addToolTipText(this, topPanel, "configfile");
        this.mConfigFileLabel = new JLabel();
        topPanel.add(this.mConfigFileLabel);
        this.mConfigFileLoadButton = cf.createButton(this, "load", 76, true);
        topPanel.add(this.mConfigFileLoadButton);
        this.mConfigFileSaveButton = cf.createButton(this, "save", 83, true);
        topPanel.add(this.mConfigFileSaveButton);
        this.mConfigFileSaveAsButton = cf.createButton(this, "saveas", 65, true);
        topPanel.add(this.mConfigFileSaveAsButton);
        this.mCentrePanel = new JPanel(new GridLayout(1, 0));
        this.getContentPane().add((Component)this.mCentrePanel, "Center");
        this.mTabbedPanes[0] = new JTabbedPane();
        this.mTabbedPanes[0].setBorder(BorderFactory.createTitledBorder("Sample 1 Settings"));
        cf.addToolTipText(this, this.mTabbedPanes[0], "sample1settings");
        this.mTabbedPanes[1] = new JTabbedPane();
        this.mTabbedPanes[1].setBorder(BorderFactory.createTitledBorder("Sample 2 Settings"));
        cf.addToolTipText(this, this.mTabbedPanes[1], "sample2settings");
        this.mCentrePanel.add(this.mTabbedPanes[0]);
        this.mNumSamples = 1;
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.mOKButton = cf.createButton(this, "ok", 79, true);
        buttonPanel.add(this.mOKButton);
        this.mApplyButton = cf.createButton(this, "apply", 65, true);
        buttonPanel.add(this.mApplyButton);
        this.mCancelButton = cf.createButton(this, "cancel", 67, true);
        buttonPanel.add(this.mCancelButton);
        this.mHelpButton = cf.createButton(this, "help", 72, true);
        buttonPanel.add(this.mHelpButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.mFileDialog = new JFileChooser("Select Configuration File to Load");
        this.refresh();
    }

    public void refresh() {
        File configFile;
        TapeConverterParameters cp = this.mConverter.getParameters(0);
        if (cp.getConfigFile() == null && (configFile = this.mPrefs.get("TapeConverter.analysisConfigFile", new File(""))).exists() && !configFile.isDirectory()) {
            try {
                cp.loadConfigFile(configFile);
            }
            catch (IOException exc) {
                this.mConverter.getConversionFrame().errorLoadingFile(configFile, exc);
            }
        }
        if ((configFile = cp.getConfigFile()) != null) {
            this.mConfigFileLabel.setText(configFile.toString());
        } else {
            this.mConfigFileLabel.setText("none");
        }
        this.mConfigFileSaveButton.setEnabled(configFile != null);
        int newSamples = this.mConverter.numSamples();
        if (newSamples != this.mNumSamples) {
            if (newSamples == 1) {
                this.mCentrePanel.remove(this.mTabbedPanes[1]);
            } else {
                this.mCentrePanel.add(this.mTabbedPanes[1]);
            }
            this.mNumSamples = newSamples;
        }
        this.refreshParameters(0);
        this.pack();
    }

    public void refreshParameters(int sampleNumber) {
        JTabbedPane pane = this.mTabbedPanes[sampleNumber];
        pane.removeAll();
        TapeConverterParameters cp = this.mConverter.getParameters(sampleNumber);
        ZX81SampleAnalyzerParameters defaults = cp.getDefaults();
        SampleParametersPanel sp = new SampleParametersPanel(this.mConverter);
        sp.initialize(cp);
        pane.add("Sample", sp);
        if (defaults.getFileName() != null) {
            AnalysisSettingsPanel panel = new AnalysisSettingsPanel(this.mConverter);
            panel.initialize(defaults);
            pane.add("Defaults", panel);
            String[] files = cp.getFileNames();
            if (files != null && files.length > 1) {
                ZX81SampleAnalyzerParameters[] p = cp.getAnalyzerParameters();
                int i = 0;
                while (i < p.length) {
                    panel = new AnalysisSettingsPanel(this.mConverter);
                    panel.initialize(p[i]);
                    pane.add("" + (i + 1), panel);
                    ++i;
                }
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && !this.mPositioned) {
            ConversionFrame frame = this.mConverter.getConversionFrame();
            frame.locateWindow(this);
            this.mPositioned = true;
        }
        super.setVisible(visible);
    }

    private void saveConfigFile(boolean getFileName) {
        File saveFile = null;
        TapeConverterParameters cp = this.mConverter.getParameters(0);
        File oldConfigFile = cp.getConfigFile();
        if (oldConfigFile == null || getFileName) {
            int result;
            if (oldConfigFile != null) {
                this.mFileDialog.setCurrentDirectory(oldConfigFile.getAbsoluteFile().getParentFile());
            }
            if ((result = this.mFileDialog.showSaveDialog(this)) == 0) {
                saveFile = this.mFileDialog.getSelectedFile();
            }
        } else {
            saveFile = oldConfigFile;
        }
        if (saveFile != null && !saveFile.isDirectory()) {
            try {
                this.mConverter.saveConfig(saveFile);
                this.mPrefs.set("TapeConverter.analysisConfigFile", saveFile.getAbsolutePath());
                this.refresh();
                JOptionPane.showMessageDialog(this, "Saved configuration settings to " + saveFile, "Saved configuration settings", 1);
            }
            catch (IOException exc) {
                this.mConverter.getConversionFrame().errorSavingFile(saveFile, exc);
            }
        }
    }

    private void loadConfigFile() {
        File f;
        int result;
        TapeConverterParameters cp = this.mConverter.getParameters(0);
        if (cp.getConfigFile() != null) {
            this.mFileDialog.setSelectedFile(cp.getConfigFile().getAbsoluteFile());
        }
        if ((result = this.mFileDialog.showOpenDialog(this)) == 0 && !(f = this.mFileDialog.getSelectedFile()).isDirectory()) {
            try {
                this.mConverter.loadConfig(f);
                this.mConfigFileSaveButton.setEnabled(true);
                this.mPrefs.set("TapeConverter.analysisConfigFile", f.getAbsolutePath());
                this.refresh();
                JOptionPane.showMessageDialog(this, "Loaded configuration settings from " + f, "Loaded configuration settings", 1);
            }
            catch (IOException exc) {
                this.mConverter.getConversionFrame().errorLoadingFile(f, exc);
            }
        }
    }

    private void applyChanges(boolean stayVisible) {
        this.setVisible(stayVisible);
        boolean updated = this.applyChanges(0);
        if (this.mNumSamples == 2) {
            updated |= this.applyChanges(1);
        }
        if (updated) {
            this.mConverter.convert();
        }
    }

    private boolean applyChanges(int sampleNumber) {
        JTabbedPane pane = this.mTabbedPanes[sampleNumber];
        if (pane.getComponentCount() == 0) {
            return false;
        }
        SampleParametersPanel sp = (SampleParametersPanel)pane.getComponentAt(0);
        boolean[] updates = new boolean[2];
        sp.apply(updates);
        if (updates[0]) {
            try {
                this.mConverter.samplePropertiesUpdated(sampleNumber);
            }
            catch (IOException exc) {
                this.mConverter.getConversionFrame().errorLoadingFile(this.mConverter.getSampleFile(sampleNumber), exc);
            }
            catch (UnsupportedAudioFileException exc) {
                this.mConverter.getConversionFrame().errorLoadingFile(this.mConverter.getSampleFile(sampleNumber), exc);
            }
        }
        if (pane.getComponentCount() > 1) {
            AnalysisSettingsPanel p = (AnalysisSettingsPanel)pane.getComponentAt(1);
            p.apply(updates);
            updates[0] = false;
            int i = 2;
            while (i < pane.getTabCount()) {
                p = (AnalysisSettingsPanel)pane.getComponentAt(i);
                p.apply(updates);
                ++i;
            }
            if (updates[0] && pane.getTabCount() > 1) {
                this.mConverter.getParameters(sampleNumber).fileNamesUpdated();
            }
        }
        return updates[1];
    }

    @Override
    public void analysisComplete(AnalysisEvent event) {
        int sourceId = event.getSourceId();
        if (sourceId == 0) {
            this.refresh();
        } else {
            this.refreshParameters(sourceId);
        }
    }

    @Override
    public synchronized void actionPerformed(ActionEvent evt) {
        try {
            Object source = evt.getSource();
            if (source instanceof JButton) {
                if (source == this.mConfigFileLoadButton) {
                    this.loadConfigFile();
                } else if (source == this.mConfigFileSaveButton) {
                    this.saveConfigFile(false);
                } else if (source == this.mConfigFileSaveAsButton) {
                    this.saveConfigFile(true);
                } else if (source == this.mCancelButton) {
                    this.refresh();
                    this.setVisible(false);
                } else if (source == this.mApplyButton) {
                    this.applyChanges(true);
                } else if (source == this.mOKButton) {
                    this.applyChanges(false);
                } else if (source == this.mHelpButton) {
                    this.mConverter.getConversionFrame().showHelp(this);
                }
            }
        }
        catch (Throwable exc) {
            this.mConverter.getConversionFrame().unexpectedError("Handling action", exc);
        }
    }
}

