/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.gui;

import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tapeutils.gui.ConversionFrame;
import tapeutils.impl.zx81.ZX81SampleAnalyzerParameters;
import tapeutils.zx81.TapeConverter;

public class AnalysisSettingsPanel
extends JPanel {
    private ZX81SampleAnalyzerParameters mParameters;
    private JTextField mNameField;
    private JLabel mPropertyKeyLabel;
    private JTextField mNoiseField;
    private JTextField mMinGapField;
    private JTextField mMaxGapField;
    private JTextField mMaxWaveLengthField;
    private JTextField mNumBytesField;

    public AnalysisSettingsPanel(TapeConverter converter) {
        this.setName("AnalysisSettingsPanel");
        this.setLayout(new GridLayout(0, 2));
        ConversionFrame cf = converter.getConversionFrame();
        this.add(cf.createLabel(this, "programnamelabel"));
        this.mNameField = cf.createTextField(this, "programname", -1);
        this.add(this.mNameField);
        this.add(cf.createLabel(this, "propertykeylabel"));
        this.mPropertyKeyLabel = cf.createLabel(this, "propertykey");
        this.add(this.mPropertyKeyLabel);
        this.add(cf.createLabel(this, "noiselabel"));
        this.mNoiseField = cf.createTextField(this, "noise", -1);
        this.add(this.mNoiseField);
        this.add(cf.createLabel(this, "mingaplabel"));
        this.mMinGapField = cf.createTextField(this, "mingap", -1);
        this.add(this.mMinGapField);
        this.add(cf.createLabel(this, "maxgaplabel"));
        this.mMaxGapField = cf.createTextField(this, "maxgap", -1);
        this.add(this.mMaxGapField);
        this.add(cf.createLabel(this, "maxwavelengthlabel"));
        this.mMaxWaveLengthField = cf.createTextField(this, "maxwavelength", -1);
        this.add(this.mMaxWaveLengthField);
        this.add(cf.createLabel(this, "numbyteslabel"));
        this.mNumBytesField = cf.createTextField(this, "numbytes", -1);
        this.add(this.mNumBytesField);
    }

    public void initialize(ZX81SampleAnalyzerParameters params) {
        this.mParameters = params;
        String fileName = params.getFileName();
        if (fileName != null && fileName.length() > 0) {
            this.mNameField.setEnabled(true);
            this.mNameField.setText(params.getFileName());
        } else {
            this.mNameField.setEnabled(false);
            this.mNameField.setText("none (defaults)");
        }
        this.mPropertyKeyLabel.setText(params.getPropertyKey());
        boolean[] isDefault = new boolean[1];
        this.mNoiseField.setText(this.getValueText(this.mParameters.getNoiseThreshold(isDefault), isDefault));
        this.mMinGapField.setText(this.getValueText(this.mParameters.getMinGap(isDefault), isDefault));
        this.mMaxGapField.setText(this.getValueText(this.mParameters.getMaxGap(isDefault), isDefault));
        this.mMaxWaveLengthField.setText(this.getValueText(this.mParameters.getMaxWaveLength(isDefault), isDefault));
        this.mNumBytesField.setText(this.getValueText(this.mParameters.getNumDataBytes(isDefault), isDefault));
        this.repaint();
    }

    private String getValueText(int value, boolean[] isDefault) {
        return String.valueOf(isDefault[0] ? "Default: " : "") + value;
    }

    private int getTextValue(String text) {
        if ((text = text.trim().toLowerCase()).length() == 0 || text.startsWith("def")) {
            return -1;
        }
        return Integer.parseInt(text);
    }

    public void apply(boolean[] updated) {
        String newName = this.mNameField.getText();
        if (newName.length() == 0) {
            JOptionPane.showMessageDialog(this.getParent(), "Invalid file name: " + newName, "Invalid file name", 0);
            this.mNameField.setText(this.mParameters.getFileName());
        }
        if (this.mNameField.isEnabled()) {
            updated[0] = updated[0] | this.mParameters.setFileName(newName);
            this.mPropertyKeyLabel.setText(this.mParameters.getPropertyKey());
        }
        updated[1] = updated[1] | this.mParameters.setNoiseThreshold(this.getTextValue(this.mNoiseField.getText()));
        updated[1] = updated[1] | this.mParameters.setMinGap(this.getTextValue(this.mMinGapField.getText()));
        updated[1] = updated[1] | this.mParameters.setMaxGap(this.getTextValue(this.mMaxGapField.getText()));
        updated[1] = updated[1] | this.mParameters.setMaxWaveLength(this.getTextValue(this.mMaxWaveLengthField.getText()));
        updated[1] = updated[1] | this.mParameters.setNumDataBytes(this.getTextValue(this.mNumBytesField.getText()));
    }
}

