/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import tapeutils.AnalysisEvent;
import tapeutils.AnalysisListener;
import tapeutils.SampleAnalyzer;
import tapeutils.gui.ConversionFrame;
import tapeutils.gui.SamplePanel;
import tapeutils.zx81.TapeConverter;

public class DualSamplePanel
extends JPanel
implements ActionListener,
KeyListener,
AnalysisListener {
    private JButton mSyncBottomButton;
    private JButton mSyncTopButton;
    private JButton mSyncFirstErrorButton;
    private JButton mSyncFirstDiffButton;
    private JButton mSyncNextDiffButton;
    private JPanel mButtonPanel;
    private JPanel mCentrePanel;
    private SamplePanel[] mSamplePanels = new SamplePanel[2];
    private int mNumSamples;
    private TapeConverter mConverter;

    public DualSamplePanel(TapeConverter converter) {
        this.setName("DualSamplePanel");
        this.mConverter = converter;
        this.mConverter.addAnalysisListener(0, this);
        this.mConverter.addAnalysisListener(1, this);
        ConversionFrame cf = this.mConverter.getConversionFrame();
        this.setLayout(new BorderLayout());
        this.mCentrePanel = new JPanel();
        this.add((Component)this.mCentrePanel, "Center");
        this.mCentrePanel.setLayout(new GridLayout(0, 1));
        this.mSamplePanels[0] = new SamplePanel(converter, 0);
        this.mSamplePanels[1] = new SamplePanel(converter, 1);
        this.mCentrePanel.add(this.mSamplePanels[0]);
        this.mNumSamples = 1;
        this.mButtonPanel = new JPanel();
        this.mButtonPanel.setLayout(new GridLayout(1, 0));
        this.mSyncBottomButton = cf.createButton(this, "syncbottom", -1, true);
        this.mButtonPanel.add(this.mSyncBottomButton);
        this.mSyncTopButton = cf.createButton(this, "synctop", -1, true);
        this.mButtonPanel.add(this.mSyncTopButton);
        this.mSyncFirstErrorButton = cf.createButton(this, "syncfirsterror", -1, true);
        this.mButtonPanel.add(this.mSyncFirstErrorButton);
        this.mSyncFirstDiffButton = cf.createButton(this, "syncfirstdiff", -1, true);
        this.mButtonPanel.add(this.mSyncFirstDiffButton);
        this.mSyncNextDiffButton = cf.createButton(this, "syncnextdiff", -1, true);
        this.mButtonPanel.add(this.mSyncNextDiffButton);
        this.addKeyListeners(this);
        this.refresh();
    }

    private void addKeyListeners(Component comp) {
        comp.addKeyListener(this);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            Component[] children = cont.getComponents();
            int i = 0;
            while (i < children.length) {
                this.addKeyListeners(children[i]);
                ++i;
            }
        }
    }

    @Override
    public void analysisComplete(AnalysisEvent event) {
        this.refresh();
    }

    public void refresh() {
        int newSamples = this.mConverter.numSamples();
        if (newSamples != this.mNumSamples) {
            if (newSamples == 1) {
                this.mCentrePanel.remove(this.mSamplePanels[1]);
                this.remove(this.mButtonPanel);
            } else {
                this.mCentrePanel.add(this.mSamplePanels[1]);
                this.add((Component)this.mButtonPanel, "South");
            }
            this.mNumSamples = newSamples;
            this.mConverter.getConversionFrame().pack();
        }
    }

    private void syncFirstError() {
        if (this.mNumSamples == 1) {
            return;
        }
        SampleAnalyzer analyzer1 = this.mConverter.getSampleAnalyzer(0);
        SampleAnalyzer analyzer2 = this.mConverter.getSampleAnalyzer(1);
        int sample1Messages = analyzer1.numMessages();
        int sample2Messages = analyzer2.numMessages();
        if (sample1Messages == 0 && sample2Messages == 0) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = 999999999;
        int[] num1 = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 999999999;
        int[] num2 = nArray2;
        if (sample1Messages > 0) {
            analyzer1.getBitNumber(analyzer1.getMessageIndex(0), num1);
        }
        if (sample2Messages > 0) {
            analyzer2.getBitNumber(analyzer2.getMessageIndex(0), num2);
        }
        if (num1[0] < num2[0]) {
            this.mSamplePanels[0].displayMessage(0);
            this.mSamplePanels[1].syncWith(this.mSamplePanels[0]);
        } else {
            this.mSamplePanels[1].displayMessage(0);
            this.mSamplePanels[0].syncWith(this.mSamplePanels[1]);
        }
    }

    private void syncDifference(boolean first) {
        if (this.mNumSamples == 1) {
            return;
        }
        SampleAnalyzer analyzer1 = this.mConverter.getSampleAnalyzer(0);
        SampleAnalyzer analyzer2 = this.mConverter.getSampleAnalyzer(1);
        int numBytes = Math.min(analyzer1.getNumBytes(), analyzer2.getNumBytes());
        int off1 = -1;
        int off2 = -1;
        int startByte = 0;
        if (!first) {
            int[] pos = new int[2];
            analyzer1.getByteNumber(this.mSamplePanels[0].getIndex(), pos);
            startByte = pos[0] + 2;
        }
        int i = startByte;
        while (i < numBytes) {
            if (analyzer1.getByte(i) != analyzer2.getByte(i)) {
                off1 = Math.max(0, analyzer1.getByteStartIndex(i) - 50);
                off2 = Math.max(0, analyzer2.getByteStartIndex(i) - 50);
                this.mSamplePanels[0].setIndex(off1);
                this.mSamplePanels[1].setIndex(off2);
                int bitMask = 128;
                int byte1 = analyzer1.getByte(i);
                int byte2 = analyzer2.getByte(i);
                int bitNumber = 0;
                boolean found = false;
                while (!found && bitMask > 0) {
                    if ((byte1 & bitMask) != (byte2 & bitMask)) {
                        found = true;
                        continue;
                    }
                    ++bitNumber;
                    bitMask >>= 1;
                }
                off1 = analyzer1.getBitStartIndex(bitNumber += 8 * i);
                off2 = analyzer2.getBitStartIndex(bitNumber);
                this.mSamplePanels[0].setCursorIndex(off1);
                this.mSamplePanels[1].setCursorIndex(off2);
                return;
            }
            ++i;
        }
    }

    public void setIndex(int sampleNumber, int index) {
        this.mSamplePanels[sampleNumber].setIndex(index);
    }

    public int getIndex(int sampleNum) {
        return this.mSamplePanels[sampleNum].getIndex();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            Object source = evt.getSource();
            if (source instanceof JButton) {
                if (source == this.mSyncBottomButton) {
                    this.mSamplePanels[1].syncWith(this.mSamplePanels[0]);
                } else if (source == this.mSyncTopButton) {
                    this.mSamplePanels[0].syncWith(this.mSamplePanels[1]);
                } else if (source == this.mSyncFirstErrorButton) {
                    this.syncFirstError();
                } else if (source == this.mSyncFirstDiffButton) {
                    this.syncDifference(true);
                } else if (source == this.mSyncNextDiffButton) {
                    this.syncDifference(false);
                }
            }
        }
        catch (Throwable exc) {
            this.mConverter.getConversionFrame().unexpectedError("Handling action", exc);
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == 'd') {
            this.syncDifference(true);
        } else if (evt.getKeyChar() == 'n') {
            this.syncDifference(false);
        } else if (evt.getKeyChar() == 'e') {
            this.syncFirstError();
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }
}

