/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import tapeutils.gui.ConversionFrame;
import tapeutils.gui.HelpTreeNode;
import tapeutils.zx81.TapeConverter;

public class HelpDialog
extends JDialog
implements ActionListener,
HyperlinkListener,
TreeSelectionListener {
    private JButton mCloseButton;
    private JButton mHistoryBackButton;
    private JButton mHistoryForwardButton;
    private JEditorPane mHelpPane;
    private JTree mHelpNavigator;
    private JScrollPane mScrollPane;
    private Map mHelpIdMap;
    private List mPageHistory;
    private List mScrollHistory;
    private int mHistoryPosition = 0;
    private TapeConverter mConverter;
    private boolean mPositioned = false;

    public HelpDialog(TapeConverter converter) {
        super(converter.getConversionFrame(), "Help", false);
        this.setDefaultCloseOperation(1);
        this.setName("HelpDialog");
        this.loadHelpData();
        this.mConverter = converter;
        ConversionFrame cf = this.mConverter.getConversionFrame();
        JPanel topPanel = new JPanel();
        this.mHistoryBackButton = cf.createButton(this, "back", 66, true);
        topPanel.add(this.mHistoryBackButton);
        this.mHistoryBackButton.setEnabled(false);
        this.mHistoryForwardButton = cf.createButton(this, "forward", 70, true);
        topPanel.add(this.mHistoryForwardButton);
        this.mHistoryForwardButton.setEnabled(false);
        this.getContentPane().add((Component)topPanel, "North");
        this.mHelpPane = new JEditorPane();
        this.mHelpPane.setContentType("text/html");
        this.mHelpPane.setEditable(false);
        this.mHelpPane.addHyperlinkListener(this);
        this.showHelp(((String)this.mHelpIdMap.get("root_id")).trim());
        cf.addToolTipText(this, this.mHelpPane, "help");
        this.mScrollPane = new JScrollPane();
        this.getContentPane().add((Component)this.mScrollPane, "Center");
        this.mScrollPane.getViewport().setView(this.mHelpPane);
        this.getContentPane().add((Component)this.mHelpNavigator, "West");
        cf.addToolTipText(this, this.mHelpNavigator, "navigator");
        JPanel bottomPanel = new JPanel();
        this.getContentPane().add((Component)bottomPanel, "South");
        this.mCloseButton = cf.createButton(this, "close", 67, true);
        bottomPanel.add(this.mCloseButton);
        this.setSize(600, 400);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && !this.mPositioned) {
            ConversionFrame frame = this.mConverter.getConversionFrame();
            frame.locateWindow(this);
            this.mPositioned = true;
        }
        super.setVisible(visible);
    }

    public void showHelp(String helpId) {
        String helpURL = (String)this.mHelpIdMap.get(helpId.trim());
        if (helpURL == null) {
            this.mConverter.getConversionFrame().unexpectedError("Invalid help id: " + helpId);
            return;
        }
        this.showHelpPage(helpURL, true);
    }

    public void showHelpPage(String helpURL, boolean addToHistory) {
        URL url;
        if (helpURL == null) {
            return;
        }
        int hashPos = helpURL.indexOf(35);
        String anchor = null;
        if (hashPos != -1) {
            anchor = helpURL.substring(hashPos);
            helpURL = helpURL.substring(0, hashPos);
        }
        if ((url = this.getClass().getResource(helpURL)) == null) {
            this.mConverter.getConversionFrame().unexpectedError("Failed to get URL resource for " + helpURL);
            return;
        }
        if (anchor != null) {
            try {
                url = new URL(String.valueOf(url.toExternalForm()) + anchor);
            }
            catch (MalformedURLException exc) {
                this.mConverter.getConversionFrame().unexpectedError("Failed to create url from " + url.toExternalForm() + " and " + anchor, exc);
                return;
            }
        }
        this.showHelpPage(url, addToHistory);
    }

    public void showHelpPage(URL helpURL, boolean addToHistory) {
        if (addToHistory) {
            while (this.mHistoryPosition < this.mPageHistory.size()) {
                this.mPageHistory.remove(this.mHistoryPosition);
                this.mScrollHistory.remove(this.mHistoryPosition);
            }
            if (this.mHistoryPosition > 0) {
                this.storeScrollPosition(this.mScrollHistory.size());
            }
        }
        try {
            this.mHelpPane.setPage(helpURL);
        }
        catch (Exception exc) {
            this.mConverter.getConversionFrame().unexpectedError("Loading page " + helpURL, exc);
        }
        if (addToHistory) {
            this.mPageHistory.add(helpURL);
            ++this.mHistoryPosition;
            this.mHistoryBackButton.setEnabled(this.mHistoryPosition > 1);
            this.mHistoryForwardButton.setEnabled(false);
        }
    }

    private void loadHelpData() {
        this.mHelpIdMap = new Properties();
        this.mPageHistory = new ArrayList();
        this.mScrollHistory = new ArrayList();
        try {
            InputStream is = this.getClass().getResourceAsStream("/help/help.data");
            if (is == null) {
                throw new IOException("Failed to locate resource /help/help.data");
            }
            ((Properties)this.mHelpIdMap).load(is);
        }
        catch (IOException exc) {
            this.mConverter.getConversionFrame().unexpectedError("Loading help data", exc);
        }
        String rootId = ((String)this.mHelpIdMap.get("root_id")).trim();
        String rootName = ((String)this.mHelpIdMap.get("root_name")).trim();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new HelpTreeNode(rootName, rootId));
        this.addTreeEntries(rootId, root);
        this.mHelpNavigator = new JTree(root);
        this.mHelpNavigator.getSelectionModel().setSelectionMode(1);
        this.mHelpNavigator.addTreeSelectionListener(this);
    }

    private void addTreeEntries(String helpId, DefaultMutableTreeNode parent) {
        if (!helpId.equals("root") && this.mHelpIdMap.get(helpId.trim()) == null) {
            System.err.println("Error: help Id " + helpId + " does not have a mapping");
        }
        int pos = 0;
        String childId = (String)this.mHelpIdMap.get(String.valueOf(helpId) + "_child" + pos + "_id");
        while (childId != null) {
            childId = childId.trim();
            String childName = ((String)this.mHelpIdMap.get(String.valueOf(helpId) + "_child" + pos + "_name")).trim();
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(new HelpTreeNode(childName, childId));
            parent.add(childNode);
            this.addTreeEntries(childId, childNode);
            childId = (String)this.mHelpIdMap.get(String.valueOf(helpId) + "_child" + ++pos + "_id");
        }
    }

    private void moveBack() {
        if (this.mHistoryPosition > 1) {
            --this.mHistoryPosition;
            this.storeScrollPosition(this.mHistoryPosition);
            URL url = (URL)this.mPageHistory.get(this.mHistoryPosition - 1);
            this.showHelpPage(url, false);
            this.restoreScrollPosition(this.mHistoryPosition - 1);
            this.mHistoryForwardButton.setEnabled(true);
            this.mHistoryBackButton.setEnabled(this.mHistoryPosition > 1);
        }
    }

    private void moveForward() {
        if (this.mHistoryPosition < this.mPageHistory.size()) {
            this.storeScrollPosition(this.mHistoryPosition - 1);
            ++this.mHistoryPosition;
            URL url = (URL)this.mPageHistory.get(this.mHistoryPosition - 1);
            this.showHelpPage(url, false);
            this.restoreScrollPosition(this.mHistoryPosition - 1);
            this.mHistoryForwardButton.setEnabled(this.mHistoryPosition < this.mPageHistory.size());
            this.mHistoryBackButton.setEnabled(true);
        }
    }

    private void storeScrollPosition(int index) {
        if (index >= this.mScrollHistory.size()) {
            this.mScrollHistory.add(new Integer(this.mScrollPane.getVerticalScrollBar().getValue()));
        } else {
            this.mScrollHistory.set(index, new Integer(this.mScrollPane.getVerticalScrollBar().getValue()));
        }
    }

    private void restoreScrollPosition(int index) {
        Integer viewPosition = (Integer)this.mScrollHistory.get(index);
        this.mScrollPane.getVerticalScrollBar().setValue(viewPosition);
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.mHelpNavigator.getLastSelectedPathComponent();
        if (node != null && node.getUserObject() instanceof HelpTreeNode) {
            this.showHelp(((HelpTreeNode)node.getUserObject()).getHelpId());
        }
    }

    @Override
    public synchronized void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JButton) {
            if (source == this.mCloseButton) {
                this.setVisible(false);
            } else if (source == this.mHistoryBackButton) {
                this.moveBack();
            } else if (source == this.mHistoryForwardButton) {
                this.moveForward();
            }
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
            this.showHelpPage(evt.getURL(), true);
        }
    }
}

