/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sinclair.basic.ZX81Basic;

public class ListCanvas
extends Canvas {
    public static final int LINES = 30;
    public static final int LINE_WIDTH = 32;
    static final int MAGNIFICATION = 1;
    private static final byte[] NO_LISTING_AVAILABLE_BYTES;
    private static List mNoListingAvailableLines;
    private BufferedImage mBackImage = null;
    private int mLineNumber = 0;
    private List mLines = mNoListingAvailableLines;
    private Object[][][] mFontData = null;
    private Object[][][] mInverseFontData = null;

    static {
        byte[] byArray = new byte[29];
        byArray[2] = 29;
        byArray[3] = 28;
        byArray[5] = 53;
        byArray[6] = 55;
        byArray[7] = 46;
        byArray[8] = 51;
        byArray[9] = 57;
        byArray[11] = 11;
        byArray[12] = 56;
        byArray[13] = 52;
        byArray[14] = 55;
        byArray[15] = 55;
        byArray[16] = 62;
        byArray[18] = 51;
        byArray[19] = 52;
        byArray[21] = 49;
        byArray[22] = 46;
        byArray[23] = 56;
        byArray[24] = 57;
        byArray[25] = 46;
        byArray[26] = 51;
        byArray[27] = 44;
        byArray[28] = 11;
        NO_LISTING_AVAILABLE_BYTES = byArray;
        mNoListingAvailableLines = new ArrayList();
        mNoListingAvailableLines.add(new String(NO_LISTING_AVAILABLE_BYTES));
    }

    public ListCanvas(InputStream fontDataStream) {
        this.initializeFontData(fontDataStream);
    }

    public void setLineNumber(int number) {
        this.mLineNumber = number;
        this.draw();
        this.repaint();
    }

    private void initializeBackImage() {
        if (this.mBackImage == null) {
            int w = 256;
            int h = 240;
            this.mBackImage = new BufferedImage(w, h, 1);
        }
    }

    public void draw() {
        if (this.mLines == null) {
            return;
        }
        Graphics g = this.mBackImage.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.mBackImage.getWidth(), this.mBackImage.getHeight());
        WritableRaster wr = this.mBackImage.getRaster();
        int i = this.mLineNumber;
        int y = 0;
        while (i < this.mLineNumber + 30 && i < this.mLines.size()) {
            String s = (String)this.mLines.get(i);
            int j = 0;
            int x = 0;
            while (j < s.length()) {
                boolean invert;
                int c = s.charAt(j);
                boolean bl = invert = c > 127;
                if ((c &= 0x7F) < this.mFontData.length) {
                    Object[][] fontData = invert ? this.mInverseFontData[c] : this.mFontData[c];
                    int k = 0;
                    while (k < 8) {
                        int l = 0;
                        while (l < 8) {
                            wr.setDataElements(x + l, y + k, fontData[k][l]);
                            ++l;
                        }
                        ++k;
                    }
                }
                ++j;
                x += 8;
            }
            ++i;
            y += 8;
        }
    }

    public void initializeFontData(InputStream is) {
        this.initializeBackImage();
        ColorModel cm = this.mBackImage.getColorModel();
        Object white = cm.getDataElements(Color.WHITE.getRGB(), null);
        Object black = cm.getDataElements(Color.BLACK.getRGB(), null);
        this.mFontData = new Object[96][8][8];
        this.mInverseFontData = new Object[96][8][8];
        try {
            is.skip(7680L);
            int i = 0;
            while (i < 96) {
                int j = 0;
                while (j < 8) {
                    int nextCharData = is.read();
                    int m = 128;
                    int k = 0;
                    while (m > 0) {
                        this.mFontData[i][j][k] = (nextCharData & m) > 0 ? black : white;
                        this.mInverseFontData[i][j][k] = (nextCharData & m) > 0 ? white : black;
                        m >>= 1;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            is.close();
        }
        catch (IOException exc) {
            System.err.println("Error loading font data.");
            exc.printStackTrace();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.mBackImage == null) {
            this.draw();
        }
        if (this.mBackImage != null) {
            g.drawImage(this.mBackImage, 0, 0, null);
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(256, 240);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setFileContent(byte[] fileBytes) {
        this.mLines = mNoListingAvailableLines;
        Map lines = ZX81Basic.getProgramLines(fileBytes);
        Iterator i = lines.entrySet().iterator();
        ArrayList<StringBuffer> dumpedLines = new ArrayList<StringBuffer>();
        while (i.hasNext()) {
            StringBuffer buff = new StringBuffer();
            Map.Entry e = i.next();
            int lineNumber = (Integer)e.getKey();
            byte[] line = (byte[])e.getValue();
            ZX81Basic.dumpLine(line, lineNumber, false, false, false, buff);
            dumpedLines.add(buff);
        }
        this.mLines = new ArrayList();
        int dl = 0;
        while (dl < dumpedLines.size()) {
            StringBuffer buff = (StringBuffer)dumpedLines.get(dl);
            int numLines = (buff.length() - 1) / 32;
            int lastLine = (buff.length() - 1) % 32;
            int pos = 0;
            int l = 0;
            while (l < numLines) {
                this.mLines.add(buff.substring(pos, pos + 32));
                ++l;
                pos += 32;
            }
            if (lastLine > 0) {
                this.mLines.add(buff.substring(pos, pos + lastLine));
            }
            ++dl;
        }
        this.mLineNumber = 0;
        this.draw();
        this.repaint();
    }

    public int numLines() {
        return this.mLines == null ? 0 : this.mLines.size();
    }
}

