/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import tapeutils.AnalysisEvent;
import tapeutils.AnalysisListener;
import tapeutils.Sample;
import tapeutils.SampleAnalyzer;
import tapeutils.gui.MessageSelectionListener;
import tapeutils.zx81.TapeConverter;

public class SampleCanvas
extends JComponent
implements AdjustmentListener,
ComponentListener,
ActionListener,
MouseListener,
AnalysisListener,
MessageSelectionListener,
KeyListener {
    private int mStartIndex = 0;
    private JScrollBar mScrollbar = null;
    private JButton mNextErrorButton;
    private JButton mPreviousErrorButton;
    private JButton mNextErrorWarningButton;
    private JButton mPreviousErrorWarningButton;
    private JButton mSetToZeroButton;
    private JButton mSetToOneButton;
    private JButton mSaveButton;
    private JButton mUndoButton;
    private JButton mRedoButton;
    private JLabel mIndexLabel;
    private int mCurrentMessageNumber = -1;
    private int mCursorIndex = -1;
    private TapeConverter mConverter;
    private Sample mSample;
    private int mSampleNumber;

    public SampleCanvas(TapeConverter converter, int sampleNumber, JScrollBar scrollbar, JButton prevError, JButton nextError, JButton prevErrorWarning, JButton nextErrorWarning, JButton setToZero, JButton setToOne, JButton save, JButton undo, JButton redo, JLabel indexLabel) {
        this.mConverter = converter;
        this.mConverter.addAnalysisListener(sampleNumber, this);
        this.mConverter.addMessageSelectionListener(sampleNumber, this);
        this.mSampleNumber = sampleNumber;
        this.mScrollbar = scrollbar;
        this.mScrollbar.setEnabled(false);
        this.mIndexLabel = indexLabel;
        scrollbar.addAdjustmentListener(this);
        this.mPreviousErrorButton = prevError;
        this.mPreviousErrorButton.setEnabled(false);
        this.mPreviousErrorButton.addActionListener(this);
        this.mNextErrorButton = nextError;
        this.mNextErrorButton.setEnabled(false);
        this.mNextErrorButton.addActionListener(this);
        this.mPreviousErrorWarningButton = prevErrorWarning;
        this.mPreviousErrorWarningButton.setEnabled(false);
        this.mPreviousErrorWarningButton.addActionListener(this);
        this.mNextErrorWarningButton = nextErrorWarning;
        this.mNextErrorWarningButton.setEnabled(false);
        this.mNextErrorWarningButton.addActionListener(this);
        this.mSetToZeroButton = setToZero;
        this.mSetToZeroButton.setEnabled(false);
        this.mSetToZeroButton.addActionListener(this);
        this.mSetToOneButton = setToOne;
        this.mSetToOneButton.setEnabled(false);
        this.mSetToOneButton.addActionListener(this);
        this.mSaveButton = save;
        this.mSaveButton.setEnabled(false);
        this.mSaveButton.addActionListener(this);
        this.mRedoButton = redo;
        this.mRedoButton.setEnabled(false);
        this.mRedoButton.addActionListener(this);
        this.mUndoButton = undo;
        this.mUndoButton.setEnabled(false);
        this.mUndoButton.addActionListener(this);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    @Override
    public void analysisComplete(AnalysisEvent event) {
        Sample newSample = this.mConverter.getSample(this.mSampleNumber);
        if (newSample != this.mSample) {
            this.setStartIndex(0);
            this.mCurrentMessageNumber = -1;
            this.mSample = newSample;
        }
        SampleAnalyzer analyzer = event.getSource();
        this.updateButtons(analyzer);
        this.mSetToZeroButton.setEnabled(true);
        this.mSetToOneButton.setEnabled(true);
        this.mSaveButton.setEnabled(true);
        this.mRedoButton.setEnabled(true);
        this.mUndoButton.setEnabled(true);
        this.mScrollbar.setEnabled(true);
        this.updateScrollbar();
        this.repaint();
    }

    private void updateButtons(SampleAnalyzer analyzer) {
        int messages = analyzer.numMessages();
        int errors = analyzer.numErrors();
        this.mPreviousErrorButton.setEnabled(errors > 0);
        this.mNextErrorButton.setEnabled(errors > 0);
        this.mPreviousErrorWarningButton.setEnabled(messages > 0);
        this.mNextErrorWarningButton.setEnabled(messages > 0);
    }

    @Override
    public void paint(Graphics g) {
        int h;
        int p;
        SampleAnalyzer analyzer = this.mConverter.getSampleAnalyzer(this.mSampleNumber);
        if (this.mSample == null || analyzer == null) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int possRange = this.mSample.getRange();
        double mult = (double)height / (double)possRange;
        int zeroLine = height / 2;
        int max = Math.min(width, this.mSample.numSamples() - this.mStartIndex);
        int i = 0;
        while (i < max) {
            p = analyzer.getBitValue(this.mStartIndex + i);
            if (p == 0) {
                g.setColor(Color.CYAN);
            } else if (p == 1) {
                g.setColor(Color.BLUE);
            }
            if (p != -1) {
                g.drawLine(i, 0, i, height);
            }
            ++i;
        }
        g.setColor(Color.RED);
        i = 0;
        while (i < max) {
            p = analyzer.getWaveValue(this.mStartIndex + i);
            h = (int)((double)p * mult);
            g.drawLine(i, zeroLine, i, zeroLine - h);
            ++i;
        }
        g.setColor(Color.BLACK);
        i = 0;
        while (i < max) {
            int s = this.mSample.getSampleValue(this.mStartIndex + i);
            h = (int)((double)s * mult);
            g.drawLine(i, zeroLine, i, zeroLine - h);
            ++i;
        }
        g.setColor(Color.BLACK);
        i = 0;
        while (i < max) {
            String b = analyzer.getByteValue(this.mStartIndex + i);
            if (b != null) {
                g.drawString(b, i, 20);
                g.drawString(b, i + 1, 20);
            }
            ++i;
        }
        g.setColor(Color.BLACK);
        int noiseThreshold = analyzer.getNoiseThreshold(this.mStartIndex);
        int nh = (int)((double)noiseThreshold * mult);
        g.drawLine(0, zeroLine - nh, width, zeroLine - nh);
        g.drawLine(0, zeroLine + nh, width, zeroLine + nh);
        g.setColor(Color.GREEN);
        int firstBitStartIndex = analyzer.getFirstBitStartIndex();
        int lastBitEndIndex = analyzer.getLastBitEndIndex();
        g.drawLine(firstBitStartIndex - this.mStartIndex, 0, firstBitStartIndex - this.mStartIndex, height);
        g.drawLine(lastBitEndIndex - this.mStartIndex, 0, lastBitEndIndex - this.mStartIndex, height);
        if (this.mCursorIndex != 0) {
            g.setColor(Color.MAGENTA);
            g.drawLine(this.mCursorIndex - this.mStartIndex, 0, this.mCursorIndex - this.mStartIndex, height);
        }
    }

    private void displayCurrentMessage() {
        SampleAnalyzer analyzer = this.mConverter.getSampleAnalyzer(this.mSampleNumber);
        this.setCursorIndex(analyzer.getMessageIndex(this.mCurrentMessageNumber));
        this.setStartIndex(Math.max(this.mCursorIndex - this.getWidth() / 2, 0));
    }

    public void displayMessage(int messageNumber) {
        SampleAnalyzer analyzer = this.mConverter.getSampleAnalyzer(this.mSampleNumber);
        if (messageNumber > -1 && messageNumber < analyzer.numMessages()) {
            this.mCurrentMessageNumber = messageNumber;
            this.displayCurrentMessage();
        }
    }

    public void syncWith(SampleCanvas other) {
        int[] pos = new int[2];
        other.getBitNumber(pos);
        SampleAnalyzer analyzer = this.mConverter.getSampleAnalyzer(this.mSampleNumber);
        int newIndex = analyzer.getBitStartIndex(pos[0]) + pos[1];
        if (newIndex != -1) {
            this.setStartIndex(newIndex);
        }
    }

    public void setStartIndex(int index) {
        this.mStartIndex = index;
        this.mScrollbar.setValue(this.mStartIndex);
        this.mIndexLabel.setText("S:" + this.mStartIndex + " C:" + this.mCursorIndex);
        this.repaint();
    }

    public void setCursorIndex(int index) {
        this.mCursorIndex = index;
        this.mIndexLabel.setText("S:" + this.mStartIndex + " C:" + this.mCursorIndex);
        this.repaint();
    }

    public int getStartIndex() {
        return this.mStartIndex;
    }

    public void getBitNumber(int[] pos) {
        SampleAnalyzer analyzer = this.mConverter.getSampleAnalyzer(this.mSampleNumber);
        analyzer.getBitNumber(this.mStartIndex, pos);
    }

    private void updateScrollbar() {
        Sample sample = this.mConverter.getSample(this.mSampleNumber);
        if (sample != null) {
            int maxRange = sample.numSamples();
            int currentRange = this.getWidth();
            this.mScrollbar.setBlockIncrement(currentRange);
            this.mScrollbar.setMaximum(maxRange - currentRange);
        }
    }

    private void setBit(int value) {
        if (this.mCursorIndex != -1) {
            SampleAnalyzer analyzer = this.mConverter.getSampleAnalyzer(this.mSampleNumber);
            analyzer.setBitValue(this.mCursorIndex, value, this.mConverter.getPreferences(this).get("TapeConverter.maximumErrors", 50), this.mConverter.getPreferences(this).get("TapeConverter.maximumWarnings", 1000), false);
            this.mCurrentMessageNumber = -1;
        }
    }

    private void undo() {
        int undoIndex = this.mConverter.undo(this.mSampleNumber);
        if (undoIndex < this.mStartIndex || undoIndex > this.mStartIndex + this.getWidth()) {
            this.setStartIndex(Math.max(this.mCursorIndex - this.getWidth() / 2, 0));
            this.setCursorIndex(undoIndex);
        }
    }

    private void redo() {
        int undoIndex = this.mConverter.redo(this.mSampleNumber);
        if (undoIndex < this.mStartIndex || undoIndex > this.mStartIndex + this.getWidth()) {
            this.setStartIndex(Math.max(this.mCursorIndex - this.getWidth() / 2, 0));
            this.setCursorIndex(undoIndex);
        }
    }

    private void selectPreviousError() {
        boolean done = false;
        int messageNumber = this.mCurrentMessageNumber;
        SampleAnalyzer analyzer = this.mConverter.getSampleAnalyzer(this.mSampleNumber);
        Sample sample = this.mConverter.getSample(this.mSampleNumber);
        while (messageNumber > 0 && !done) {
            boolean bl = done = analyzer.isMessageError(--messageNumber) && analyzer.getMessageIndex(messageNumber) < sample.numSamples();
        }
        if (done) {
            this.mConverter.fireMessageSelectionEvent(this.mSampleNumber, messageNumber);
        }
    }

    private void selectNextError() {
        boolean done = false;
        int messageNumber = this.mCurrentMessageNumber;
        SampleAnalyzer analyzer = this.mConverter.getSampleAnalyzer(this.mSampleNumber);
        Sample sample = this.mConverter.getSample(this.mSampleNumber);
        while (messageNumber < analyzer.numMessages() - 1 && !done) {
            boolean bl = done = analyzer.isMessageError(++messageNumber) && analyzer.getMessageIndex(messageNumber) < sample.numSamples();
        }
        if (done) {
            this.mConverter.fireMessageSelectionEvent(this.mSampleNumber, messageNumber);
        }
    }

    @Override
    public void messageSelected(int sampleNumber, int messageNumber) {
        this.mCurrentMessageNumber = messageNumber;
        this.displayCurrentMessage();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 300);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        this.setStartIndex(evt.getValue());
    }

    @Override
    public void componentResized(ComponentEvent evt) {
        this.updateScrollbar();
    }

    @Override
    public void componentHidden(ComponentEvent evt) {
    }

    @Override
    public void componentMoved(ComponentEvent evt) {
    }

    @Override
    public void componentShown(ComponentEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '0') {
            this.setBit(0);
        } else if (evt.getKeyChar() == '1') {
            this.setBit(1);
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        try {
            if (source instanceof JButton) {
                if (source == this.mPreviousErrorWarningButton) {
                    if (this.mCurrentMessageNumber > 0) {
                        this.mConverter.fireMessageSelectionEvent(this.mSampleNumber, this.mCurrentMessageNumber - 1);
                    }
                } else if (source == this.mNextErrorWarningButton) {
                    SampleAnalyzer analyzer = this.mConverter.getSampleAnalyzer(this.mSampleNumber);
                    if (this.mCurrentMessageNumber < analyzer.numMessages() - 1) {
                        this.mConverter.fireMessageSelectionEvent(this.mSampleNumber, this.mCurrentMessageNumber + 1);
                    }
                } else if (source == this.mPreviousErrorButton) {
                    this.selectPreviousError();
                } else if (source == this.mNextErrorButton) {
                    this.selectNextError();
                } else if (source == this.mSetToZeroButton) {
                    this.setBit(0);
                } else if (source == this.mSetToOneButton) {
                    this.setBit(1);
                } else if (source == this.mSaveButton) {
                    this.mConverter.getConversionFrame().saveSample(this.mSampleNumber, false);
                } else if (source == this.mUndoButton) {
                    this.undo();
                } else if (source == this.mRedoButton) {
                    this.redo();
                }
            }
        }
        catch (Throwable exc) {
            this.mConverter.getConversionFrame().unexpectedError("Handling action", exc);
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        Point point = evt.getPoint();
        this.setCursorIndex(point.x + this.mStartIndex);
        this.requestFocus();
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }
}

