/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import tapeutils.gui.ConversionFrame;
import tapeutils.gui.SampleCanvas;
import tapeutils.zx81.TapeConverter;

public class SamplePanel
extends JPanel {
    private SampleCanvas mSampleCanvas;

    public SamplePanel(TapeConverter converter, int sampleNumber) {
        this.setName("SamplePanel");
        ConversionFrame cf = converter.getConversionFrame();
        this.setLayout(new BorderLayout());
        JScrollBar sb = new JScrollBar(0);
        sb.setUnitIncrement(5);
        this.add((Component)sb, "South");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(2, 0));
        this.add((Component)buttonPanel, "North");
        JButton prevErrorWarning = cf.createButton(this, "preverrorwarning", -1, false);
        buttonPanel.add(prevErrorWarning);
        JButton prevError = cf.createButton(this, "preverror", -1, false);
        buttonPanel.add(prevError);
        JButton setToZero = cf.createButton(this, "settozero", 48, false);
        buttonPanel.add(setToZero);
        JButton undo = cf.createButton(this, "undo", 85, false);
        buttonPanel.add(undo);
        JButton save = cf.createButton(this, "save", 83, false);
        buttonPanel.add(save);
        JButton nextErrorWarning = cf.createButton(this, "nexterrorwarning", -1, false);
        buttonPanel.add(nextErrorWarning);
        JButton nextError = cf.createButton(this, "nexterror", -1, false);
        buttonPanel.add(nextError);
        JButton setToOne = cf.createButton(this, "settoone", 49, false);
        buttonPanel.add(setToOne);
        JButton redo = cf.createButton(this, "redo", 82, false);
        buttonPanel.add(redo);
        JLabel indexLabel = new JLabel("", 0);
        cf.addToolTipText(this, indexLabel, "SamplePanel_index");
        buttonPanel.add(indexLabel);
        this.mSampleCanvas = new SampleCanvas(converter, sampleNumber, sb, prevError, nextError, prevErrorWarning, nextErrorWarning, setToZero, setToOne, save, undo, redo, indexLabel);
        cf.addToolTipText(this, this.mSampleCanvas, "canvas");
        this.add((Component)this.mSampleCanvas, "Center");
    }

    public void syncWith(SamplePanel other) {
        this.mSampleCanvas.syncWith(other.getSampleCanvas());
    }

    public void displayMessage(int messageNumber) {
        this.mSampleCanvas.displayMessage(messageNumber);
    }

    public int getIndex() {
        return this.mSampleCanvas.getStartIndex();
    }

    public void setIndex(int index) {
        this.mSampleCanvas.setStartIndex(index);
    }

    public void setCursorIndex(int index) {
        this.mSampleCanvas.setCursorIndex(index);
    }

    public SampleCanvas getSampleCanvas() {
        return this.mSampleCanvas;
    }
}

