/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.impl;

import tapeutils.BitProcessor;
import tapeutils.ByteProcessor;
import tapeutils.SampleAnalyzer;
import util.BlockSequence;

public class SimpleBitProcessor
implements BitProcessor {
    private SampleAnalyzer mSampleAnalyzer;
    private ByteProcessor mByteProcessor;
    private BlockSequence mBits;
    private int mCurrentByte = 0;
    private int mCurrentByteStartIndex = 0;
    private int mFirstBitStart = -1;
    private int mLastBitEnd = -1;
    private int mCurrentBits = 0;
    private static final int BLOCK_SIZE = 8192;

    public SimpleBitProcessor(SampleAnalyzer analyzer, ByteProcessor processor) {
        this.mSampleAnalyzer = analyzer;
        this.mByteProcessor = processor;
        this.mBits = new BlockSequence(8192);
    }

    @Override
    public void initialize() {
        this.mBits.initialize();
        this.mFirstBitStart = -1;
        this.mLastBitEnd = -1;
        this.mCurrentBits = 0;
        this.mCurrentByte = 0;
    }

    @Override
    public void addBit(int bitStart, int bitEnd, int bitValue) {
        if (this.mFirstBitStart == -1) {
            this.mFirstBitStart = bitStart;
        }
        if (this.mLastBitEnd < bitEnd) {
            this.mLastBitEnd = bitEnd;
        }
        if (this.mSampleAnalyzer.debuggingBit(bitStart)) {
            this.mSampleAnalyzer.debugBitMessage(bitStart, "FOUND a " + bitValue);
        }
        this.mBits.addBlock(bitStart, bitEnd, bitValue + 1);
        ++this.mCurrentBits;
        this.mCurrentByte = (this.mCurrentByte << 1) + bitValue;
        if (this.mCurrentBits == 1) {
            this.mCurrentByteStartIndex = bitStart;
        }
        if (this.mCurrentBits == 8) {
            this.mByteProcessor.processByte(this.mCurrentByteStartIndex, bitEnd, this.mCurrentByte);
            this.mCurrentByte = 0;
            this.mCurrentBits = 0;
            if (this.mSampleAnalyzer.isLoadComplete() && this.mSampleAnalyzer.debuggingBit(bitStart)) {
                this.mSampleAnalyzer.debugBitMessage(bitStart, "Load complete");
            }
        }
    }

    @Override
    public int undoLastBit() {
        int result = 0;
        if (this.mBits.length() > 0) {
            if (this.mCurrentBits > 0) {
                --this.mCurrentBits;
                this.mCurrentByte >>= 1;
            } else {
                this.mCurrentBits = 7;
                this.mCurrentByte = this.mByteProcessor.undoLastByte() >> 1;
            }
            this.mBits.removeLastBlock();
            if (this.mBits.length() == 0) {
                this.mFirstBitStart = -1;
            } else {
                result = this.mBits.getBlockEnd(this.mBits.length() - 1);
            }
        }
        return result;
    }

    @Override
    public synchronized int getBitValue(int index) {
        return this.mBits.getValue(index) - 1;
    }

    @Override
    public void getBitNumber(int index, int[] pos) {
        this.mBits.getBlockNumber(index, pos);
    }

    @Override
    public int getBitStartIndex(int number) {
        return this.mBits.getBlockStart(number);
    }

    @Override
    public int getBitEndIndex(int number) {
        return this.mBits.getBlockEnd(number);
    }

    @Override
    public int getLastBitValue() {
        return this.mBits.getLastBlockValue() - 1;
    }

    @Override
    public int getFirstBitStartIndex() {
        return this.mFirstBitStart;
    }

    @Override
    public int getLastBitEndIndex() {
        return this.mLastBitEnd;
    }

    @Override
    public int getNumberOfBits() {
        return this.mBits.length();
    }
}

