/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import sinclair.basic.ZX81Translate;
import tapeutils.ByteProcessor;
import tapeutils.SampleAnalyzer;
import util.BlockSequence;

public class SimpleByteProcessor
implements ByteProcessor {
    protected SampleAnalyzer mSampleAnalyzer;
    protected BlockSequence mBytes;
    protected Map mByteEndMap = new HashMap();
    protected int mNumExpectedBytes = 99999999;
    private static final int BLOCK_SIZE = 8192;
    protected boolean mFixedNumberOfBytes = false;

    public SimpleByteProcessor(SampleAnalyzer analyzer) {
        this.mSampleAnalyzer = analyzer;
        this.mBytes = new BlockSequence(8192);
    }

    public SimpleByteProcessor(SampleAnalyzer analyzer, int numBytes) {
        this(analyzer);
        this.mNumExpectedBytes = numBytes;
        this.mFixedNumberOfBytes = true;
    }

    @Override
    public void initialize() {
        this.mSampleAnalyzer.debugMessage("Byte Processor Initializing", true);
        this.mBytes.initialize();
        this.mByteEndMap.clear();
        if (!this.mFixedNumberOfBytes) {
            this.mNumExpectedBytes = 99999999;
        }
    }

    @Override
    public void processByte(int start, int end, int byteValue) {
        if (this.mSampleAnalyzer.debuggingByte(start)) {
            this.mSampleAnalyzer.debugByteMessage(start, "BYTE VALUE to " + end + " @ " + this.mBytes.length() + " = " + Integer.toBinaryString(byteValue) + " translated " + ZX81Translate.translateZX81ToASCII(byteValue) + " numExpected " + this.mNumExpectedBytes);
        }
        this.mBytes.addBlock(start, end, byteValue);
        this.mByteEndMap.put(new Integer(end), new Integer(this.mBytes.length() - 1));
        if (this.mBytes.length() >= this.mNumExpectedBytes) {
            if (this.mSampleAnalyzer.debuggingByte(start)) {
                this.mSampleAnalyzer.debugByteMessage(start, "Load completed: " + this.mNumExpectedBytes + " loaded.");
            }
            this.mSampleAnalyzer.loadCompleted();
        }
    }

    @Override
    public int undoLastByte() {
        int result = 0;
        if (this.mBytes.length() > 0) {
            int endIndex = this.mBytes.getBlockEnd(this.mBytes.length() - 1);
            if (this.mSampleAnalyzer.debuggingByte(endIndex)) {
                this.mSampleAnalyzer.debugByteMessage(endIndex, "BYTE VALUE undoing at " + endIndex + " @ " + this.mBytes.length());
            }
            this.mByteEndMap.remove(new Integer(endIndex));
            result = this.mBytes.getLastBlockValue();
            this.mBytes.removeLastBlock();
        }
        return result;
    }

    @Override
    public void write(OutputStream output) throws IOException {
        output.write(this.getBytes());
    }

    @Override
    public byte[] getBytes() {
        byte[] result = new byte[this.mBytes.length()];
        int i = 0;
        while (i < this.mBytes.length()) {
            result[i] = (byte)this.mBytes.getBlockValue(i);
            ++i;
        }
        return result;
    }

    @Override
    public int numBytesProcessed() {
        return this.mBytes.length();
    }

    @Override
    public int numExpectedBytes() {
        return this.mNumExpectedBytes;
    }

    @Override
    public int getByteNumber(int index) {
        Integer num = (Integer)this.mByteEndMap.get(new Integer(index));
        if (num != null) {
            return num;
        }
        return -1;
    }

    @Override
    public void getByteNumber(int index, int[] pos) {
        this.mBytes.getBlockNumber(index, pos);
    }

    @Override
    public int getByteStartIndex(int number) {
        return this.mBytes.getBlockStart(number);
    }

    @Override
    public int getByteValue(int byteNumber) {
        return this.mBytes.getBlockValue(byteNumber);
    }

    @Override
    public String checkConsistent() {
        return null;
    }
}

