/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.impl.zx81;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import sinclair.basic.ZX81Translate;
import tapeutils.AnalysisEvent;
import tapeutils.AnalysisListener;
import tapeutils.BitProcessor;
import tapeutils.ByteProcessor;
import tapeutils.Message;
import tapeutils.Sample;
import tapeutils.SampleAnalyzer;
import tapeutils.WaveIdentifier;
import tapeutils.WaveProcessor;
import tapeutils.impl.SimpleBitProcessor;
import tapeutils.impl.SimpleByteProcessor;
import tapeutils.impl.SineWaveIdentifier;
import tapeutils.impl.zx81.ZX81BASICByteProcessor;
import tapeutils.impl.zx81.ZX81SampleAnalyzerParameters;
import tapeutils.impl.zx81.ZX81WaveProcessor;
import tapeutils.zx81.DebugLevels;

public class ZX81SampleAnalyzer
implements SampleAnalyzer {
    private Sample mSample;
    private WaveIdentifier mWaveIdentifier;
    private WaveProcessor mWaveProcessor;
    private BitProcessor mBitProcessor;
    private ByteProcessor mByteProcessor;
    private boolean mLoadComplete = false;
    private int mBeginIndex;
    private int mNumErrors;
    private int mLastMessageIndex;
    private int mNumWarnings;
    private ArrayList mMessages;
    private String mProgramName;
    private byte[] mProgramNameBytes;
    DebugLevels mDebugLevels;
    private Set mListeners;
    private static final int[] mWaveValues;

    static {
        int[] nArray = new int[13];
        nArray[0] = 70;
        nArray[1] = 90;
        nArray[2] = 100;
        nArray[3] = 100;
        nArray[4] = 90;
        nArray[5] = 70;
        nArray[7] = -70;
        nArray[8] = -90;
        nArray[9] = -100;
        nArray[10] = -100;
        nArray[11] = -90;
        nArray[12] = -70;
        mWaveValues = nArray;
    }

    public ZX81SampleAnalyzer(Sample sample, ZX81SampleAnalyzerParameters params) {
        this.mSample = sample;
        this.mByteProcessor = params.getNumDataBytes() > 0 ? new SimpleByteProcessor(this, params.getNumDataBytes()) : new ZX81BASICByteProcessor(this);
        this.mBitProcessor = new SimpleBitProcessor(this, this.mByteProcessor);
        this.mWaveProcessor = new ZX81WaveProcessor(this.mSample, this, params.getMinGap(), params.getMaxGap(), this.mBitProcessor);
        this.mWaveIdentifier = new SineWaveIdentifier(this.mSample, this, params.getNoiseThreshold(), params.getMaxWaveLength(), this.mWaveProcessor);
        this.mWaveProcessor.setWaveIdentifier(this.mWaveIdentifier);
        this.mListeners = new HashSet();
    }

    @Override
    public int analyze(int beginIndex, int maxErrors, int maxWarnings, boolean printMessages) {
        String error;
        int lastBitPos;
        int pos = beginIndex;
        int end = beginIndex + (int)(600.0 * this.mSample.getSamplesPerSecond());
        if (end > this.mSample.numSamples()) {
            end = this.mSample.numSamples();
        }
        this.mBeginIndex = beginIndex;
        this.mLoadComplete = false;
        this.mNumErrors = 0;
        this.mLastMessageIndex = -1;
        this.mNumWarnings = 0;
        this.mMessages = new ArrayList();
        this.mWaveIdentifier.initialize();
        this.mWaveProcessor.initialize();
        this.mBitProcessor.initialize();
        this.mByteProcessor.initialize();
        this.debugMessage("SA: Processing from " + pos + " to " + end, false);
        while (pos < end && !this.mLoadComplete && this.mNumWarnings < maxWarnings && this.mNumErrors < maxErrors) {
            pos = this.mWaveIdentifier.identifyNextWave(pos, this.mSample.getSampleValue(pos));
        }
        this.debugMessage("SA: Load complete: " + this.mLoadComplete + " at " + pos + " warnings: " + this.mNumWarnings + " errors: " + this.mNumErrors, false);
        if (!this.mLoadComplete) {
            this.mWaveIdentifier.completeProcessing();
        }
        if ((lastBitPos = this.mBitProcessor.getLastBitEndIndex()) != -1) {
            pos = lastBitPos;
        }
        int bytesProcessed = this.mByteProcessor.numBytesProcessed();
        if (!this.mLoadComplete && bytesProcessed > 0) {
            this.error(this.mSample.numSamples(), "Loading not complete - did not load enough bytes (" + this.mByteProcessor.numBytesProcessed() + " out of " + this.mByteProcessor.numExpectedBytes() + ")");
        }
        if ((error = this.mByteProcessor.checkConsistent()) != null) {
            this.warning(this.mSample.numSamples(), error);
        }
        if (printMessages) {
            this.printMessages();
        }
        this.fireAnalysisComplete();
        return pos;
    }

    @Override
    public boolean isLoadComplete() {
        return this.mLoadComplete;
    }

    @Override
    public void loadCompleted() {
        this.mLoadComplete = true;
    }

    @Override
    public void write(OutputStream output) throws IOException {
        this.mByteProcessor.write(output);
    }

    @Override
    public int getWaveValue(int index) {
        return this.mWaveIdentifier.getWaveValue(index);
    }

    @Override
    public int getFitValue(int index) {
        return this.mWaveIdentifier.getFitValue(index);
    }

    @Override
    public int getBitValue(int index) {
        return this.mBitProcessor.getBitValue(index);
    }

    @Override
    public void getBitNumber(int index, int[] pos) {
        this.mBitProcessor.getBitNumber(index, pos);
    }

    @Override
    public int getBitStartIndex(int number) {
        return this.mBitProcessor.getBitStartIndex(number);
    }

    @Override
    public int getBitEndIndex(int number) {
        return this.mBitProcessor.getBitEndIndex(number);
    }

    @Override
    public int setBitValue(int index, int value, int maxErrors, int maxWarnings, boolean printMessages) {
        int waves = value != 0 ? 9 : 4;
        int skip = (int)(1.0 / this.mSample.getRateMultiplier());
        int bitWidth = waves * mWaveValues.length / skip;
        int gap = 3 * mWaveValues.length / skip;
        index = this.checkBitPosition(index);
        int modWidth = bitWidth + 2 * gap;
        this.mSample.startModification(index - gap, modWidth);
        int g = 0;
        while (g < gap) {
            this.mSample.setSampleValue(index - 1 - g, 0);
            ++g;
        }
        int p = 0;
        while (p < waves) {
            int w = 0;
            while (w < mWaveValues.length) {
                this.mSample.setSampleValue(index++, (byte)mWaveValues[w]);
                w += skip;
            }
            ++p;
        }
        g = 0;
        while (g < gap) {
            this.mSample.setSampleValue(index + g, 0);
            ++g;
        }
        this.mSample.endModification();
        if (index < this.mBeginIndex) {
            this.mBeginIndex = index;
        }
        return this.analyze(this.mBeginIndex, maxErrors, maxWarnings, printMessages);
    }

    private int checkBitPosition(int index) {
        int previousBitEnd;
        int suggested;
        int[] pos = new int[2];
        this.getBitNumber(index, pos);
        int previousBit = pos[0] - 1;
        if (previousBit != -1 && (suggested = this.mWaveProcessor.checkGroupGap(previousBitEnd = this.getBitEndIndex(previousBit), index)) != 0) {
            index = previousBitEnd + suggested;
        }
        return index;
    }

    @Override
    public int undo(int maxErrors, int maxWarnings, boolean printMessages) {
        int index = this.mSample.undo();
        this.analyze(this.mBeginIndex, maxErrors, maxWarnings, printMessages);
        return index;
    }

    @Override
    public int redo(int maxErrors, int maxWarnings, boolean printMessages) {
        int index = this.mSample.redo();
        this.analyze(this.mBeginIndex, maxErrors, maxWarnings, printMessages);
        return index;
    }

    @Override
    public String getByteValue(int index) {
        int n = this.mByteProcessor.getByteNumber(index);
        if (n != -1) {
            int b = this.mByteProcessor.getByteValue(n);
            return String.valueOf(b) + " '" + ZX81Translate.translateZX81ToASCII(b) + "' @ " + n;
        }
        return null;
    }

    @Override
    public byte[] getBytes() {
        return this.mByteProcessor.getBytes();
    }

    @Override
    public int getByteNumber(int index) {
        return this.mByteProcessor.getByteNumber(index);
    }

    @Override
    public void getByteNumber(int index, int[] pos) {
        this.mByteProcessor.getByteNumber(index, pos);
    }

    @Override
    public int getByte(int byteNumber) {
        return this.mByteProcessor.getByteValue(byteNumber);
    }

    @Override
    public int getNumBytes() {
        return this.mByteProcessor.numBytesProcessed();
    }

    @Override
    public int getByteStartIndex(int number) {
        return this.mByteProcessor.getByteStartIndex(number);
    }

    @Override
    public int getNoiseThreshold(int index) {
        return this.mWaveIdentifier.getNoiseThreshold();
    }

    @Override
    public int getFirstBitStartIndex() {
        return this.mBitProcessor.getFirstBitStartIndex();
    }

    @Override
    public int getLastBitEndIndex() {
        return this.mBitProcessor.getLastBitEndIndex();
    }

    @Override
    public void warning(int position, String message) {
        this.mLastMessageIndex = position;
        Message m = new Message(false, position, message);
        this.mMessages.add(m);
        ++this.mNumWarnings;
    }

    @Override
    public int numMessages() {
        return this.mNumWarnings + this.mNumErrors;
    }

    @Override
    public int numWarnings() {
        return this.mNumWarnings;
    }

    @Override
    public void error(int position, String message) {
        this.mLastMessageIndex = position;
        Message m = new Message(true, position, message);
        this.mMessages.add(m);
        ++this.mNumErrors;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void clearMessages(int index) {
        if (this.mLastMessageIndex != -1) ** GOTO lbl15
        return;
lbl-1000:
        // 1 sources

        {
            m = (Message)this.mMessages.remove(this.mMessages.size() - 1);
            if (this.debuggingWave(index)) {
                this.debugWaveMessage(index, "Removing message " + m.getText() + " at " + m.getIndex() + " when retrying at " + index);
            }
            if (m.isError()) {
                --this.mNumErrors;
            } else {
                --this.mNumWarnings;
            }
            if (this.mMessages.size() > 0) {
                m = (Message)this.mMessages.get(this.mMessages.size() - 1);
                this.mLastMessageIndex = m.getIndex();
                continue;
            }
            this.mLastMessageIndex = -1;
lbl15:
            // 3 sources

            ** while (index < this.mLastMessageIndex && this.mMessages.size() > 0)
        }
lbl16:
        // 1 sources

    }

    @Override
    public int numErrors() {
        return this.mNumErrors;
    }

    @Override
    public int getMessageIndex(int messageNumber) {
        Message m = (Message)this.mMessages.get(messageNumber);
        return m.getIndex();
    }

    @Override
    public boolean isMessageError(int messageNumber) {
        Message m = (Message)this.mMessages.get(messageNumber);
        return m.isError();
    }

    @Override
    public void printMessages() {
        if (this.mProgramName != null) {
            System.out.println("    Program name is '" + this.mProgramName + "'");
        }
        int startIndex = this.getFirstBitStartIndex();
        int i = 0;
        while (i < this.mMessages.size()) {
            Message m = (Message)this.mMessages.get(i);
            String pos = m.getIndex() < startIndex ? "(before start)" : "(" + m.getIndex() + ")";
            if (m.isError()) {
                System.err.println("    ERROR: " + pos + " " + m.getText());
            } else {
                System.out.println("    Warning: " + pos + " " + m.getText());
            }
            ++i;
        }
    }

    @Override
    public Message[] getMessages() {
        return this.mMessages.toArray(new Message[this.mMessages.size()]);
    }

    public void setProgramName(String name) {
        this.mProgramName = name;
    }

    public String getProgramName() {
        return this.mProgramName;
    }

    public void setProgramNameBytes(byte[] bytes, int length) {
        this.mProgramNameBytes = new byte[length];
        System.arraycopy(bytes, 0, this.mProgramNameBytes, 0, length);
    }

    public byte[] getProgramNameBytes() {
        return this.mProgramNameBytes;
    }

    @Override
    public void cleanUp() {
        this.mByteProcessor = null;
        this.mBitProcessor = null;
        this.mWaveProcessor = null;
        this.mWaveIdentifier.cleanUp();
        this.mWaveIdentifier = null;
        this.mMessages.clear();
        this.mMessages = null;
        this.mSample = null;
    }

    @Override
    public void addAnalysisListener(AnalysisListener l) {
        this.mListeners.add(l);
    }

    private void fireAnalysisComplete() {
        Iterator i = this.mListeners.iterator();
        while (i.hasNext()) {
            ((AnalysisListener)i.next()).analysisComplete(new AnalysisEvent(this));
        }
    }

    public void setDebugLevels(DebugLevels levels) {
        this.mDebugLevels = levels;
    }

    @Override
    public void debugWaveMessage(int index, String message) {
        if (this.mDebugLevels.mDebugWave && index >= this.mDebugLevels.mStart && index <= this.mDebugLevels.mEnd) {
            this.debug("wave: ", index, message);
        }
    }

    @Override
    public void debugBitMessage(int index, String message) {
        if (this.mDebugLevels.mDebugBit && index >= this.mDebugLevels.mStart && index <= this.mDebugLevels.mEnd) {
            this.debug("bit : ", index, message);
        }
    }

    @Override
    public void debugByteMessage(int index, String message) {
        if (this.mDebugLevels.mDebugByte && index >= this.mDebugLevels.mStart && index <= this.mDebugLevels.mEnd) {
            this.debug("byte: ", index, message);
        }
    }

    @Override
    public void debugMessage(String message, boolean stack) {
        if (!this.mDebugLevels.mDebugGeneral) {
            return;
        }
        this.mDebugLevels.mWriter.print("Debug ");
        this.mDebugLevels.mWriter.println(message);
        if (stack) {
            new Exception().printStackTrace(this.mDebugLevels.mWriter);
        }
        this.mDebugLevels.mWriter.flush();
    }

    private void debug(String type, int index, String message) {
        this.mDebugLevels.mWriter.print(type);
        String indexStr = "000000000" + index + ": ";
        indexStr = indexStr.substring(indexStr.length() - 12);
        this.mDebugLevels.mWriter.print(indexStr);
        this.mDebugLevels.mWriter.println(message);
        this.mDebugLevels.mWriter.flush();
    }

    @Override
    public final boolean debuggingWave(int index) {
        return this.mDebugLevels.mDebugWave && index >= this.mDebugLevels.mStart && index <= this.mDebugLevels.mEnd;
    }

    @Override
    public final boolean debuggingBit(int index) {
        return this.mDebugLevels.mDebugBit && index >= this.mDebugLevels.mStart && index <= this.mDebugLevels.mEnd;
    }

    @Override
    public final boolean debuggingByte(int index) {
        return this.mDebugLevels.mDebugByte && index >= this.mDebugLevels.mStart && index <= this.mDebugLevels.mEnd;
    }
}

