/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.impl.zx81;

import java.util.Properties;
import tapeutils.Parameters;

public class ZX81SampleAnalyzerParameters
extends Parameters {
    private static final int NOISE_THRESHOLD = 0;
    private static final int MIN_GAP = 1;
    private static final int MAX_GAP = 2;
    private static final int MAX_WAVE_LENGTH = 3;
    private static final int NUM_DATA_BYTES = 4;
    private static final String[] KEYS = new String[]{".noise", ".minGap", ".maxGap", ".maxWaveLength", ".numDataBytes"};
    private static final int[] DEFAULTS;
    String mFileRoot;
    String mFileName;
    ZX81SampleAnalyzerParameters mDefaults;

    static {
        int[] nArray = new int[5];
        nArray[0] = 5;
        nArray[1] = 48;
        nArray[2] = 76;
        nArray[3] = 18;
        DEFAULTS = nArray;
    }

    public ZX81SampleAnalyzerParameters() {
        super(KEYS, DEFAULTS);
    }

    public ZX81SampleAnalyzerParameters(ZX81SampleAnalyzerParameters defaults, Properties props, String propertyKey, String fileName) {
        super(KEYS, defaults);
        this.mFileRoot = propertyKey;
        this.mFileName = fileName;
        this.init(props);
    }

    private void init(Properties props) {
        this.init(props, String.valueOf(this.mFileRoot) + this.mFileName);
    }

    public boolean setFileName(String newValue) {
        if (this.mFileName == null) {
            throw new IllegalArgumentException("Cannot set filename on default analyzer parameters.");
        }
        if (newValue == null) {
            throw new IllegalArgumentException("Cannot set null filename.");
        }
        if (newValue.equals(this.mFileName)) {
            return false;
        }
        this.mFileName = newValue;
        return this.updatePropertyKeyRoot(String.valueOf(this.mFileRoot) + this.mFileName);
    }

    public String getPropertyKey() {
        return String.valueOf(this.mFileRoot) + this.mFileName;
    }

    public String getFileName() {
        return this.mFileName;
    }

    public boolean setNoiseThreshold(int newValue) {
        return this.setValue(0, newValue);
    }

    public boolean setMinGap(int newValue) {
        return this.setValue(1, newValue);
    }

    public boolean setMaxGap(int newValue) {
        return this.setValue(2, newValue);
    }

    public boolean setMaxWaveLength(int newValue) {
        return this.setValue(3, newValue);
    }

    public boolean setNumDataBytes(int newValue) {
        return this.setValue(4, newValue);
    }

    public int getNoiseThreshold() {
        return this.getValue(0);
    }

    public int getNoiseThreshold(boolean[] isDefault) {
        return this.getValue(0, isDefault);
    }

    public int getMinGap() {
        return this.getValue(1);
    }

    public int getMinGap(boolean[] isDefault) {
        return this.getValue(1, isDefault);
    }

    public int getMaxGap() {
        return this.getValue(2);
    }

    public int getMaxGap(boolean[] isDefault) {
        return this.getValue(2, isDefault);
    }

    public int getMaxWaveLength() {
        return this.getValue(3);
    }

    public int getMaxWaveLength(boolean[] isDefault) {
        return this.getValue(3, isDefault);
    }

    public int getNumDataBytes() {
        return this.getValue(4);
    }

    public int getNumDataBytes(boolean[] isDefault) {
        return this.getValue(4, isDefault);
    }
}

