/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.zx81;

import java.io.File;
import tapeutils.zx81.PFile;

public class PFileUtils {
    public static void main(String[] args) {
        String pFileName = null;
        boolean outputSystem = false;
        boolean outputVariables = false;
        boolean outputDisplay = false;
        boolean dumpNumberValues = false;
        boolean play = false;
        String sampleFileName = null;
        String zx81Name = null;
        float sampleRate = 22050.0f;
        boolean squareWave = false;
        int aPos = 0;
        while (aPos < args.length) {
            if ((args[aPos].equals("-pFile") || args[aPos].equals("-p")) && aPos < args.length) {
                pFileName = args[++aPos];
            } else if ((args[aPos].equals("-sampleFile") || args[aPos].equals("-f")) && aPos < args.length) {
                sampleFileName = args[++aPos];
            } else if ((args[aPos].equals("-sampleRate") || args[aPos].equals("-r")) && aPos < args.length) {
                sampleRate = Float.parseFloat(args[++aPos]);
            } else if ((args[aPos].equals("-zx81Name") || args[aPos].equals("-z")) && aPos < args.length) {
                zx81Name = args[++aPos];
            } else if (args[aPos].equals("-sysVars") || args[aPos].equals("-s")) {
                outputSystem = true;
            } else if (args[aPos].equals("-vars") || args[aPos].equals("-v")) {
                outputVariables = true;
            } else if (args[aPos].equals("-display") || args[aPos].equals("-d")) {
                outputDisplay = true;
            } else if (args[aPos].equals("-numberValues") || args[aPos].equals("-n")) {
                dumpNumberValues = true;
            } else if (args[aPos].equals("-play")) {
                play = true;
            } else if (args[aPos].equals("-square") || args[aPos].equals("-q")) {
                squareWave = true;
            } else {
                PFileUtils.usage();
            }
            ++aPos;
        }
        File pFile = new File(pFileName);
        if (!pFile.exists()) {
            System.err.println("P file " + pFile + " does not exist.");
            PFileUtils.usage();
        } else if (pFile.isDirectory()) {
            System.err.println("Cannot list directory.");
            PFileUtils.usage();
        }
        File sampleFile = null;
        if (sampleFileName != null && (sampleFile = new File(sampleFileName)).exists()) {
            System.err.println("Sample file " + sampleFile + " already exists.");
            PFileUtils.usage();
        }
        try {
            PFile p = new PFile(pFile, zx81Name);
            if (sampleFile != null) {
                p.writeSampleToFile(sampleRate, sampleFile, squareWave);
            } else if (play) {
                p.play(sampleRate, squareWave);
                System.exit(0);
            } else {
                p.list(outputSystem, outputVariables, outputDisplay, dumpNumberValues);
            }
        }
        catch (Exception exc) {
            System.err.println("Error loading " + pFile + " : " + exc.getMessage());
            exc.printStackTrace();
            PFileUtils.usage();
        }
    }

    private static void usage() {
        System.out.println("Usage: ");
        System.out.println("java " + PFileUtils.class.getName());
        System.out.println("  [ -play            ]             Play the file rather than listing.");
        System.out.println("   {-pFile       |-p}  fileName    .P File name.");
        System.out.println("  [{-sysVars     |-s}]             Output system variables.");
        System.out.println("  [{-vars        |-v}]             Output program variables.");
        System.out.println("  [{-display     |-d}]             Output display file.");
        System.out.println("  [{-numberValues|-n}]             Dump number values in BASIC listing.");
        System.out.println("  [{-sampleFile  |-f}  fileName]   The name of the file to write the sample to.");
        System.out.println("  [{-sampleRate  |-r}  frequency]  The sample rate to be used (default is 22050Hz).");
        System.out.println("  [{-zx81Name    |-z}  name]       The name of the ZX81 file (not needed for list).");
        System.out.println("  [{-square      |-q}]             Output a square wave.");
        System.exit(-1);
    }
}

