/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.zx81;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import tapeutils.zx81.PreferenceListener;

public class Preferences {
    private Properties mProperties;
    private String mFileHeader;
    private File mPreferencesFile;
    private long mLastSaveTime = 0L;
    private Set mListeners = new HashSet();

    public Preferences(String fileName, String fileHeader) throws IOException {
        this.mFileHeader = fileHeader;
        this.mProperties = new Properties();
        String userDir = System.getProperty("user.dir");
        if (userDir != null) {
            this.mPreferencesFile = new File(userDir, fileName);
            if (this.mPreferencesFile.exists()) {
                FileInputStream fis = new FileInputStream(this.mPreferencesFile);
                this.mProperties.load(fis);
                fis.close();
            }
        }
    }

    public String get(String key, String defaultValue) {
        return this.mProperties.getProperty(key, defaultValue);
    }

    public boolean get(String key, boolean defaultValue) {
        return this.mProperties.getProperty(key, "" + defaultValue).trim().equals("true");
    }

    public int get(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.mProperties.getProperty(key, "" + defaultValue));
        }
        catch (NumberFormatException exc) {
            if (this.mProperties.getProperty(key) != null && this.mProperties.getProperty(key).length() > 0) {
                System.err.println("Error: property " + key + " value " + this.mProperties.getProperty(key) + " should be an integer");
            }
            return defaultValue;
        }
    }

    public float get(String key, float defaultValue) {
        try {
            return Float.parseFloat(this.mProperties.getProperty(key, "" + defaultValue));
        }
        catch (NumberFormatException exc) {
            if (this.mProperties.getProperty(key) != null && this.mProperties.getProperty(key).length() > 0) {
                System.err.println("Error: property " + key + " value " + this.mProperties.getProperty(key) + " should be a floating point number");
            }
            return defaultValue;
        }
    }

    public File get(String key, File defaultValue) {
        return new File(this.mProperties.getProperty(key, defaultValue.getAbsolutePath()));
    }

    public boolean set(Object source, String key, String value) {
        String current = this.mProperties.getProperty(key);
        if (value.equals(current)) {
            return true;
        }
        try {
            this.save(false);
        }
        catch (IOException exc) {
            exc.printStackTrace();
            return false;
        }
        this.mProperties.setProperty(key, value);
        this.firePreferenceUpdateEvent(source, key);
        return true;
    }

    public void set(Object source, String key, boolean value) {
        this.set(source, key, "" + value);
    }

    public void set(Object source, String key, int value) {
        this.set(source, key, "" + value);
    }

    public void set(Object source, String key, float value) {
        this.set(source, key, "" + value);
    }

    public void save(boolean force) throws IOException {
        if (this.mPreferencesFile != null) {
            long currentTime = System.currentTimeMillis();
            if (force || this.mLastSaveTime == 0L || currentTime - this.mLastSaveTime > 10000L) {
                TreeMap<Object, Object> tm = new TreeMap<Object, Object>();
                tm.putAll(this.mProperties);
                PrintWriter writer = new PrintWriter(new FileWriter(this.mPreferencesFile));
                writer.println("# " + this.mFileHeader);
                writer.println("# " + new Date().toString());
                for (Map.Entry e : tm.entrySet()) {
                    writer.println(e.getKey() + "=" + ((String)e.getValue()).replaceAll("\\\\", "\\\\\\\\"));
                }
                writer.flush();
                writer.close();
                this.mLastSaveTime = currentTime;
            }
        }
    }

    public void addPreferenceListener(PreferenceListener l) {
        this.mListeners.add(l);
    }

    public void removePreferenceListener(PreferenceListener l) {
        this.mListeners.remove(l);
    }

    public void firePreferenceUpdateEvent(Object source, String key) {
        Iterator i = this.mListeners.iterator();
        while (i.hasNext()) {
            ((PreferenceListener)i.next()).preferenceUpdated(source, key);
        }
    }
}

