/*
 * Decompiled with CFR 0.152.
 */
package tapeutils.zx81;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import tapeutils.Parameters;
import tapeutils.impl.zx81.ZX81SampleAnalyzerParameters;

public class TapeConverterParameters
extends Parameters {
    private static final int INVERT = 0;
    private static final int CHANNEL = 1;
    private static final int BEGIN = 2;
    private static final int MIN_SECONDS_GAP = 3;
    private static final int NUM_FILES = 4;
    private static final String[] KEYS = new String[]{".invert", ".channel", ".begin", ".minSecondsGap", ".numFiles"};
    private static final int[] DEFAULTS;
    private String[] mFileNames;
    private int mNumKnownFiles = 1;
    private File mConfigFile;
    private Properties mProperties;
    private String mRootName;
    private ZX81SampleAnalyzerParameters mDefaults;
    private ZX81SampleAnalyzerParameters[] mAnalyzerParameters;
    private static final String CONFIG_FILE_HEADER = "Tape Utils Analysis Configuration File, (c) Simon Holdsworth 2007, http://www.zx81stuff.org.uk";

    static {
        int[] nArray = new int[5];
        nArray[3] = 2;
        nArray[4] = 200;
        DEFAULTS = nArray;
    }

    public TapeConverterParameters() {
        this(new Properties());
    }

    public TapeConverterParameters(TapeConverterParameters shared) {
        this(shared.mProperties);
    }

    public TapeConverterParameters(Properties props) {
        super(KEYS, DEFAULTS);
        this.mProperties = props;
        this.mDefaults = new ZX81SampleAnalyzerParameters();
    }

    public TapeConverterParameters(String fileName, Properties props) {
        super(KEYS, DEFAULTS);
        this.setSampleFileName(fileName, true);
        this.mProperties = props;
        this.initialize();
    }

    public void setSampleFileName(String sampleFileName, boolean initialize) {
        int extPos = sampleFileName.lastIndexOf(46);
        if (sampleFileName.toLowerCase().endsWith(".zip")) {
            extPos = sampleFileName.lastIndexOf(46, sampleFileName.length() - 5);
        }
        String rootName = extPos != -1 ? sampleFileName.substring(0, extPos) : sampleFileName;
        int slashPos = sampleFileName.lastIndexOf(File.separatorChar);
        this.mRootName = slashPos != -1 ? rootName.substring(slashPos + 1) : rootName;
        this.mRootName = this.trimFileName(this.mRootName, ".Fixed");
        this.mRootName = this.trimFileName(this.mRootName, ".Saved");
        this.mRootName = this.trimFileName(this.mRootName, ".Multi");
        if (initialize) {
            this.initialize();
        }
    }

    private String trimFileName(String name, String toRemove) {
        if (name.endsWith(toRemove)) {
            name = name.substring(0, name.length() - toRemove.length());
        } else {
            int index = name.indexOf(String.valueOf(toRemove) + ".");
            if (index > -1) {
                name = String.valueOf(name.substring(0, index)) + name.substring(index + toRemove.length());
            }
        }
        return name;
    }

    public void sampleSaved(File newFile) {
        String oldTrimmedRootName = this.mRootName;
        this.setSampleFileName(newFile.getName(), false);
        if (oldTrimmedRootName.equals(this.mRootName)) {
            return;
        }
        this.copyProperties(oldTrimmedRootName, this.mRootName);
        int numFiles = this.mFileNames.length;
        this.initialize();
        this.setNumFiles(numFiles);
    }

    private void copyProperties(String oldKey, String newKey) {
        String searchKeyStart = String.valueOf(oldKey) + ".";
        String newKeyStart = String.valueOf(newKey) + ".";
        Properties newProps = new Properties();
        Iterator<Map.Entry<Object, Object>> i = this.mProperties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            String key = (String)entry.getKey();
            if (key.startsWith(searchKeyStart)) {
                String keyToAdd = String.valueOf(newKeyStart) + key.substring(searchKeyStart.length());
                newProps.put(keyToAdd, entry.getValue());
                continue;
            }
            if (!key.startsWith(newKeyStart)) continue;
            i.remove();
        }
        this.mProperties.putAll((Map<?, ?>)newProps);
    }

    public void setConfigFile(File configFile) {
        this.mConfigFile = configFile;
    }

    public void loadConfigFile(File configFile) throws IOException {
        this.mConfigFile = configFile;
        this.mProperties.clear();
        FileInputStream fis = new FileInputStream(this.mConfigFile);
        this.mProperties.load(fis);
        fis.close();
        this.initialize();
    }

    public void saveConfigFile(File configFile) throws IOException {
        TreeMap<Object, Object> tm = new TreeMap<Object, Object>();
        tm.putAll(this.mProperties);
        PrintWriter writer = new PrintWriter(new FileWriter(configFile));
        writer.println("# Tape Utils Analysis Configuration File, (c) Simon Holdsworth 2007, http://www.zx81stuff.org.uk");
        writer.println("# " + new Date().toString());
        for (Map.Entry e : tm.entrySet()) {
            writer.println(e.getKey() + "=" + e.getValue());
        }
        writer.flush();
        writer.close();
        this.mConfigFile = configFile;
    }

    public void initialize() {
        if (this.mRootName == null || this.mProperties == null) {
            this.mDefaults = new ZX81SampleAnalyzerParameters();
            this.mAnalyzerParameters = new ZX81SampleAnalyzerParameters[1];
            this.mAnalyzerParameters[0] = this.mDefaults;
        } else {
            this.mDefaults = new ZX81SampleAnalyzerParameters(new ZX81SampleAnalyzerParameters(), this.mProperties, this.mRootName, "");
            this.init(this.mProperties, this.mRootName);
            this.setFileNames(this.mProperties.getProperty(String.valueOf(this.mRootName) + ".fileNames", ""));
        }
    }

    public void setFileNames(String fileNames) {
        int numExpectedFiles = this.getValue(4);
        if (numExpectedFiles > 1) {
            this.mAnalyzerParameters = new ZX81SampleAnalyzerParameters[numExpectedFiles];
            this.mFileNames = new String[numExpectedFiles];
            StringTokenizer tok = new StringTokenizer(fileNames, ",");
            this.mNumKnownFiles = Math.max(tok.countTokens(), 1);
            int i = 0;
            while (i < numExpectedFiles) {
                this.mFileNames[i] = tok.hasMoreTokens() ? tok.nextToken() : "program" + (i + 1);
                this.initializeParameters(i);
                ++i;
            }
        } else {
            this.mAnalyzerParameters = new ZX81SampleAnalyzerParameters[1];
            this.mAnalyzerParameters[0] = this.mDefaults;
        }
    }

    private void initializeParameters(int index) {
        String propertyKeyRoot = String.valueOf(this.mRootName) + "." + (index + 1) + ".";
        this.mAnalyzerParameters[index] = new ZX81SampleAnalyzerParameters(this.mDefaults, this.mProperties, propertyKeyRoot, this.mFileNames[index]);
    }

    public void fileNamesUpdated() {
        if (this.mAnalyzerParameters.length == 1) {
            return;
        }
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < this.mAnalyzerParameters.length) {
            this.mFileNames[i] = this.mAnalyzerParameters[i].getFileName();
            buff.append(this.mFileNames[i]);
            if (i < this.mAnalyzerParameters.length - 1) {
                buff.append(',');
            }
            ++i;
        }
        String newFileNames = buff.toString();
        this.mProperties.setProperty(String.valueOf(this.mRootName) + ".fileNames", newFileNames);
    }

    public void setNumFiles(int numFiles) {
        if ((this.mFileNames == null || numFiles != this.mFileNames.length) && numFiles > 1) {
            ZX81SampleAnalyzerParameters[] oldParams = this.mAnalyzerParameters;
            String[] oldNames = this.mFileNames;
            this.mAnalyzerParameters = new ZX81SampleAnalyzerParameters[numFiles];
            this.mFileNames = new String[numFiles];
            int i = 0;
            while (i < numFiles) {
                String string = this.mFileNames[i] = oldNames != null && i < oldNames.length ? oldNames[i] : "program" + (i + 1);
                if (i < oldParams.length && oldParams.length != 1) {
                    this.mAnalyzerParameters[i] = oldParams[i];
                } else {
                    this.initializeParameters(i);
                }
                ++i;
            }
        } else if (numFiles == 1) {
            this.mFileNames = new String[1];
            this.mFileNames[0] = this.mRootName;
            this.mAnalyzerParameters = new ZX81SampleAnalyzerParameters[1];
            this.mAnalyzerParameters[0] = this.mDefaults;
        }
    }

    public String getRootName() {
        return this.mRootName;
    }

    public int getNumFiles() {
        if (this.mFileNames == null) {
            return -1;
        }
        return this.mFileNames.length;
    }

    public String[] getFileNames() {
        return this.mFileNames;
    }

    public String[] getPFileNames(boolean knownOnly) {
        String[] result = knownOnly ? new String[this.mNumKnownFiles] : new String[this.mFileNames.length];
        if (result.length == 1) {
            result[0] = String.valueOf(this.mRootName) + ".p";
        } else {
            int i = 0;
            while (i < result.length) {
                result[i] = String.valueOf(this.mRootName) + "." + (i + 1) + "." + this.mFileNames[i] + ".p";
                ++i;
            }
        }
        return result;
    }

    public File getConfigFile() {
        return this.mConfigFile;
    }

    public ZX81SampleAnalyzerParameters getDefaults() {
        return this.mDefaults;
    }

    public ZX81SampleAnalyzerParameters[] getAnalyzerParameters() {
        return this.mAnalyzerParameters;
    }

    public boolean setInvert(boolean newValue) {
        return this.setValue(0, newValue ? 1 : 0);
    }

    public boolean setChannel(int newValue) {
        return this.setValue(1, newValue);
    }

    public boolean setBeginIndex(int newValue) {
        return this.setValue(2, newValue);
    }

    public boolean setMinSecondsGap(int newValue) {
        return this.setValue(3, newValue);
    }

    public boolean setNumExpectedFiles(int newValue) {
        return this.setValue(4, newValue);
    }

    public boolean getInvert() {
        return this.getValue(0) == 1;
    }

    public boolean getInvert(boolean[] isDefault) {
        return this.getValue(0, isDefault) == 1;
    }

    public int getChannel() {
        return this.getValue(1);
    }

    public int getChannel(boolean[] isDefault) {
        return this.getValue(1, isDefault);
    }

    public int getBeginIndex() {
        return this.getValue(2);
    }

    public int getBeginIndex(boolean[] isDefault) {
        return this.getValue(2, isDefault);
    }

    public int getMinSecondsGap() {
        return this.getValue(3);
    }

    public int getMinSecondsGap(boolean[] isDefault) {
        return this.getValue(3, isDefault);
    }

    public int getNumExpectedFiles() {
        return this.getValue(4);
    }

    public int getNumExpectedFiles(boolean[] isDefault) {
        return this.getValue(4, isDefault);
    }
}

