/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.List;

public class LargeIntArray {
    private List mBlocks = new ArrayList();
    private int mLength = 0;
    private int mBlockSize;
    private static final int DEFAULT_BLOCK_SIZE = 65536;

    public LargeIntArray() {
        this(65536);
    }

    public LargeIntArray(int blockSize) {
        this.mBlockSize = blockSize;
    }

    public void add(int value) {
        int[] values;
        int block = this.mLength / this.mBlockSize;
        int pos = this.mLength % this.mBlockSize;
        if (block >= this.mBlocks.size()) {
            values = new int[this.mBlockSize];
            this.mBlocks.add(values);
        } else {
            values = (int[])this.mBlocks.get(block);
        }
        values[pos] = value;
        ++this.mLength;
    }

    public void remove() {
        if (this.mLength > 0) {
            --this.mLength;
        }
    }

    public int get(int index) {
        int block = index / this.mBlockSize;
        int pos = index % this.mBlockSize;
        return ((int[])this.mBlocks.get(block))[pos];
    }

    public int length() {
        return this.mLength;
    }

    public void clear() {
        this.mBlocks.clear();
        this.mLength = 0;
    }
}

