/*
 * Decompiled with CFR 0.152.
 */
package util;

import util.RadixSortByteArrayHandler;
import util.RadixSortElementHandler;
import util.RadixSortStringHandler;

public class RadixSort {
    public static void radixSort(Object[] entries) {
        if (entries.length == 0) {
            return;
        }
        if (entries instanceof byte[][]) {
            RadixSort.radixSort(entries, 0, 0, entries.length, new RadixSortByteArrayHandler());
        } else if (entries instanceof String[]) {
            RadixSort.radixSort(entries, 0, 0, entries.length, new RadixSortStringHandler());
        } else {
            throw new IllegalArgumentException("Array type " + entries.getClass() + " not supported");
        }
    }

    public static void radixSort(Object[] entries, RadixSortElementHandler handler) {
        RadixSort.radixSort(entries, 0, 0, entries.length, handler);
    }

    private static void radixSort(Object[] entries, int keyIndex, int start, int end, RadixSortElementHandler handler) {
        int[] counts = new int[256];
        boolean done = true;
        int variety = 0;
        int i = start;
        while (i < end) {
            int slot = handler.getSlot(entries[i], keyIndex);
            if (slot < 0) {
                System.out.println("Error! slot " + slot + " < 0! " + handler.toString(entries[i]));
                System.exit(0);
            }
            if (handler.length(entries[i]) > keyIndex + 1) {
                done = false;
            }
            int n = slot;
            counts[n] = counts[n] + 1;
            if (counts[slot] == 1) {
                ++variety;
            }
            ++i;
        }
        if (variety == 1) {
            if (!done) {
                RadixSort.radixSort(entries, keyIndex + 1, start, end, handler);
            }
            return;
        }
        int offset = 0;
        int[] offsets = new int[257];
        int i2 = 0;
        while (i2 < counts.length) {
            offsets[i2] = offset;
            offset += counts[i2];
            ++i2;
        }
        offsets[256] = offset;
        Object[] sorted = new Object[end - start];
        int i3 = start;
        while (i3 < end) {
            int slot = handler.getSlot(entries[i3], keyIndex);
            sorted[offsets[slot]] = entries[i3];
            int n = slot;
            offsets[n] = offsets[n] + 1;
            ++i3;
        }
        System.arraycopy(sorted, 0, entries, start, end - start);
        if (!done) {
            i3 = 1;
            while (i3 < counts.length) {
                if (counts[i3] > 2) {
                    RadixSort.radixSort(entries, keyIndex + 1, start + offsets[i3 - 1], start + offsets[i3], handler);
                } else if (counts[i3] == 2) {
                    RadixSort.directCompare(entries, keyIndex + 1, start + offsets[i3 - 1], handler);
                }
                ++i3;
            }
        }
    }

    private static void directCompare(Object[] lines, int keyIndex, int start, RadixSortElementHandler handler) {
        int len1 = handler.length(lines[start]);
        int len2 = handler.length(lines[start + 1]);
        int checkLen = Math.min(len1, len2) + 1;
        while (keyIndex < checkLen) {
            if (len1 == keyIndex) {
                return;
            }
            int key1 = handler.getKey(lines[start], keyIndex);
            int key2 = handler.getKey(lines[start + 1], keyIndex);
            if (len2 == keyIndex || key1 > key2) {
                Object temp = lines[start];
                lines[start] = lines[start + 1];
                lines[start + 1] = temp;
                return;
            }
            if (key1 < key2) {
                return;
            }
            ++keyIndex;
        }
    }
}

