/*
 * Decompiled with CFR 0.152.
 */
package util.awt;

import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class MIEntry {
    private String itemText = "-";
    private String itemCommand = "";
    private boolean enabled = false;
    private int key = 0;

    public MIEntry(String i, String c, boolean e, int k) {
        this.itemText = i;
        this.itemCommand = c;
        this.enabled = e;
        this.key = k;
    }

    public MIEntry(String i, boolean e, int k) {
        this(i, i, e, k);
    }

    public MIEntry(String i, boolean e) {
        this(i, i, e, 0);
    }

    public MIEntry(String i, String c, boolean e) {
        this(i, c, e, 0);
    }

    public MIEntry(String i) {
        this(i, i, false, 0);
    }

    public MIEntry(String i, String c) {
        this(i, c, false, 0);
    }

    public MIEntry() {
    }

    public static void constructMenus(MIEntry[][] items, MenuBar bar, ActionListener listener) {
        int m = 0;
        while (m < items.length) {
            Menu currentMenu = new Menu(items[m][0].itemText);
            int i = 1;
            while (i < items[m].length) {
                if (items[m][i].itemText.equals("-")) {
                    currentMenu.addSeparator();
                } else {
                    MenuItem mi = new MenuItem(items[m][i].itemText);
                    if (items[m][i].key != 0) {
                        mi.setShortcut(new MenuShortcut(items[m][i].key));
                    }
                    if (!items[m][i].enabled) {
                        mi.setEnabled(false);
                    }
                    mi.setActionCommand(items[m][i].itemCommand);
                    mi.addActionListener(listener);
                    currentMenu.add(mi);
                }
                ++i;
            }
            bar.add(currentMenu);
            ++m;
        }
    }

    public static void constructMenus(MIEntry[][] items, JMenuBar bar, ActionListener listener) {
        int m = 0;
        while (m < items.length) {
            JMenu currentMenu = new JMenu(items[m][0].itemText);
            if (items[m][0].key != 0) {
                currentMenu.setMnemonic(items[m][0].key);
            }
            int i = 1;
            while (i < items[m].length) {
                if (items[m][i].itemText.equals("-")) {
                    currentMenu.addSeparator();
                } else {
                    JMenuItem mi = new JMenuItem(items[m][i].itemText);
                    if (items[m][i].key != 0) {
                        mi.setMnemonic(items[m][i].key);
                    }
                    if (!items[m][i].enabled) {
                        mi.setEnabled(false);
                    }
                    mi.setActionCommand(items[m][i].itemCommand);
                    mi.addActionListener(listener);
                    currentMenu.add(mi);
                }
                ++i;
            }
            bar.add(currentMenu);
            ++m;
        }
    }
}

