# -*- coding: utf-8 -*-
import os, sys, msvcrt, pickle, struct

class Program:
	@staticmethod
	def load_buffer(filename):
		f = open(filename, "rb")
		buffer = f.read()		
		f.close()		
		return buffer
    
	@staticmethod
	def save_buffer(filename, buffer):
		f = open(filename, "wb")
		for el in range(0, len(buffer)):	
			f.write(buffer[el])
		f.close()
		
	@staticmethod
	def clone_buffer(buffer):
		clone = []
		for el in range(0, len(buffer)):
			clone.append(buffer[el])
		return clone
	
	@staticmethod
	def mem_copy(src_tab, src_ind, num_elems, dst_tab, dst_ind):
		for el in range(0, num_elems):
			dst_tab[el + dst_ind] = src_tab[el + src_ind]

	@staticmethod
	def exchange_colors(src_tab, dst_tab, p0, p1, p2, p3):
		src_index = 0 * 256
		dst_index = p0 * 256
		Program.mem_copy(src_tab, src_index, 256, dst_tab, dst_index)
		src_index = 1 * 256
		dst_index = p1 * 256
		Program.mem_copy(src_tab, src_index, 256, dst_tab, dst_index)
		src_index = 2 * 256
		dst_index = p2 * 256
		Program.mem_copy(src_tab, src_index, 256, dst_tab, dst_index)
		src_index = 3 * 256
		dst_index = p3 * 256
		Program.mem_copy(src_tab, src_index, 256, dst_tab, dst_index)

	@staticmethod
	def exchange_attributes(src_tab, dst_tab, p0, p1, p2, p3):
		src_index = 1024 + 0 * 1024
		dst_index = 1024 + p0 * 1024
		Program.mem_copy(src_tab, src_index, 1024, dst_tab, dst_index)
		src_index = 1024 + 1 * 1024
		dst_index = 1024 + p1 * 1024
		Program.mem_copy(src_tab, src_index, 1024, dst_tab, dst_index)
		src_index = 1024 + 2 * 1024
		dst_index = 1024 + p2 * 1024
		Program.mem_copy(src_tab, src_index, 1024, dst_tab, dst_index)
		src_index = 1024 + 3 * 1024
		dst_index = 1024 + p3 * 1024
		Program.mem_copy(src_tab, src_index, 1024, dst_tab, dst_index)

	@staticmethod
	def exchange_graphics(src_tab, dst_tab, p0, p1, p2, p3):
		src_index = 5120 + 0 * 512
		dst_index = 5120 + p0 * 512
		Program.mem_copy(src_tab, src_index, 512, dst_tab, dst_index)
		src_index = 5120 + 1 * 512
		dst_index = 5120 + p1 * 512
		Program.mem_copy(src_tab, src_index, 512, dst_tab, dst_index)
		src_index = 5120 + 2 * 512
		dst_index = 5120 + p2 * 512
		Program.mem_copy(src_tab, src_index, 512, dst_tab, dst_index)
		src_index = 5120 + 3 * 512
		dst_index = 5120 + p3 * 512
		Program.mem_copy(src_tab, src_index, 512, dst_tab, dst_index)
		
	@staticmethod							
	def Main(argv):
		if len(argv) < 6:
			print "Parameters are needed !"
		else:
			input_filename = argv[1]
			output_filename = argv[2]
				
			p0dstind = int(argv[3])
			p1dstind = int(argv[4])
			p2dstind = int(argv[5])
			p3dstind = int(argv[6])
			
			#m0dstind = argv[7]
			#m1dstind = argv[8]
			#m2dstind = argv[9]
			#m3dstind = argv[10]
		
			buffer = Program.load_buffer(input_filename)
			clone = Program.clone_buffer(buffer)
			
			Program.exchange_colors(buffer, clone, p0dstind, p1dstind, p2dstind, p3dstind) 
			Program.exchange_attributes(buffer, clone, p0dstind, p1dstind, p2dstind, p3dstind)
			Program.exchange_graphics(buffer, clone, p0dstind, p1dstind, p2dstind, p3dstind)
			
			Program.save_buffer(output_filename, clone)
		
			print "Done"

Program.Main(sys.argv)
