/***************************************/
/*  Use MADS http://mads.atari8.info/  */
/*  Mode: DLI (char mode)              */
/***************************************/

	icl "Susanne_Atari_Irwin.h"

	org $f0

fcnt	.ds 2
fadr	.ds 2
fhlp	.ds 2
cloc	.ds 1
regA	.ds 1
regX	.ds 1
regY	.ds 1

WIDTH	= 40
HEIGHT	= 60

; ---	BASIC switch OFF
	org $2000\ mva #$ff portb\ rts\ ini $2000

; ---	MAIN PROGRAM
	org $2000
ant	dta $E4,a(scr)
	dta $84,$A4,$84,$A4,$84,$A4,$84,$A4,$84,$A4,$84,$A4,$84,$A4,$84,$A4
	dta $84,$A4,$84,$A4,$84,$A4,$84,$A4,$84,$A4,$84,$A4,$84,$A4,$84,$A4
	dta $84,$A4,$84,$A4,$84,$A4,$84,$A4,$84,$A4,$84,$A4,$84,$A4,$84,$A4
	dta $84,$A4,$84,$A4,$84,$A4,$84,$A4,$84,$04
	dta $41,a(ant)

scr	ins "Susanne_Atari_Irwin.scr"

	.ds 0*40

	.ALIGN $0400
fnt	ins "Susanne_Atari_Irwin.fnt"

	ift USESPRITES
	.ALIGN $0800
pmg	.ds $0300
	ift FADECHR = 0
	SPRITES
	els
	.ds $500
	eif
	eif

main
; ---	init PMG

	ift USESPRITES
	mva >pmg pmbase		;missiles and players data address
	mva #$03 pmcntl		;enable players and missiles
	eif

	lda:cmp:req $14		;wait 1 frame

	sei			;stop IRQ interrupts
	mva #$00 nmien		;stop NMI interrupts
	sta dmactl
	mva #$fe portb		;switch off ROM to get 16k more ram

	mwa #NMI $fffa		;new NMI handler

	mva #$c0 nmien		;switch on NMI+DLI again

	ift CHANGES		;if label CHANGES defined

_lp	lda trig0		; FIRE #0
	beq stop

	lda trig1		; FIRE #1
	beq stop

	lda consol		; START
	and #1
	beq stop

	lda skctl
	and #$04
	bne _lp			;wait to press any key; here you can put any own routine

	els

null	jmp DLI.dli1		;CPU is busy here, so no more routines allowed

	eif


stop
	.ifdef FADE_CHARS\ lda #0\ jsr fade_chars\ eif

	mva #$00 pmcntl		;PMG disabled
	tax
	sta:rne hposp0,x+

	mva #$ff portb		;ROM switch on
	mva #$40 nmien		;only NMI interrupts, DLI disabled
	cli			;IRQ enabled

	rts			;return to ... DOS

; ---	DLI PROGRAM

.local	DLI

	?old_dli = *

	ift !CHANGES

dli1	lda trig0		; FIRE #0
	beq stop

	lda trig1		; FIRE #1
	beq stop

	lda consol		; START
	and #1
	beq stop

	lda skctl
	and #$04
	beq stop

	lda vcount
	cmp #$02
	bne dli1

	:3 sta wsync

	mwa #null null+1
	jmp null

	eif

dli_start

dli2
	sta regA
	lda #$03
	sta wsync		;line=4
	nop
	sta vscrol
	DLINEW dli3 1 0 0

dli3
	sta regA
	lda #$04
	sta wsync		;line=8
	nop
	sta vscrol
	DLINEW dli4 1 0 0

dli4
	sta regA
	lda #$03
	sta wsync		;line=12
	nop
	sta vscrol
	DLINEW dli5 1 0 0

dli5
	sta regA
	lda #$04
	sta wsync		;line=16
	nop
	sta vscrol
	DLINEW dli6 1 0 0

dli6
	sta regA
	lda #$03
	sta wsync		;line=20
	nop
	sta vscrol
	DLINEW dli7 1 0 0

dli7
	sta regA
	lda #$04
	sta wsync		;line=24
	nop
	sta vscrol
	DLINEW dli8 1 0 0

dli8
	sta regA
	lda #$03
	sta wsync		;line=28
	nop
	sta vscrol
	DLINEW dli9 1 0 0

dli9
	sta regA
	stx regX
	lda >fnt+$400*$01
	ldx #$04
	sta wsync		;line=32
	sta chbase
	stx vscrol
	DLINEW dli10 1 1 0

dli10
	sta regA
	lda #$03
	sta wsync		;line=36
	nop
	sta vscrol
	DLINEW dli11 1 0 0

dli11
	sta regA
	lda #$04
	sta wsync		;line=40
	nop
	sta vscrol
	DLINEW dli12 1 0 0

dli12
	sta regA
	lda #$03
	sta wsync		;line=44
	nop
	sta vscrol
	DLINEW dli13 1 0 0

dli13
	sta regA
	lda #$04
	sta wsync		;line=48
	nop
	sta vscrol
	DLINEW dli14 1 0 0

dli14
	sta regA
	lda #$03
	sta wsync		;line=52
	nop
	sta vscrol
	DLINEW dli15 1 0 0

dli15
	sta regA
	lda #$04
	sta wsync		;line=56
	nop
	sta vscrol
	DLINEW dli16 1 0 0

dli16
	sta regA
	lda #$03
	sta wsync		;line=60
	nop
	sta vscrol
	DLINEW dli17 1 0 0

dli17
	sta regA
	stx regX
	lda >fnt+$400*$02
	ldx #$04
	sta wsync		;line=64
	sta chbase
	stx vscrol
	DLINEW dli18 1 1 0

dli18
	sta regA
	lda #$03
	sta wsync		;line=68
	nop
	sta vscrol
	sta wsync		;line=69
	sta wsync		;line=70
s5	lda #$00
	sta wsync		;line=71
	sta sizem
	DLINEW dli19 1 0 0

dli19
	sta regA
	lda #$04
	sta wsync		;line=72
	nop
	sta vscrol
	sta wsync		;line=73
	sta wsync		;line=74
x8	lda #$7B
	sta wsync		;line=75
	sta hposm2
	DLINEW dli20 1 0 0

dli20
	sta regA
	stx regX
	sty regY
	lda #$03
s6	ldx #$01
x9	ldy #$7E
	sta wsync		;line=76
	nop
	sta vscrol
	stx sizep2
	sty hposp2
	DLINEW dli21 1 1 1

dli21
	sta regA
	stx regX
	sty regY
	lda #$04
s7	ldx #$03
x10	ldy #$6A
	sta wsync		;line=80
	nop
	sta vscrol
	stx sizep2
	sty hposp2
	sta wsync		;line=81
x11	lda #$97
	sta wsync		;line=82
	sta hposm1
s8	lda #$03
x12	ldx #$83
	sta wsync		;line=83
	sta sizep3
	stx hposp3
	DLINEW dli22 1 1 1

dli22
	sta regA
	stx regX
	lda #$03
x13	ldx #$63
	sta wsync		;line=84
	nop
	sta vscrol
	stx hposp2
	DLINEW dli23 1 1 0

dli23
	sta regA
	stx regX
	lda #$04
	sta wsync		;line=88
	nop
	sta vscrol
	sta wsync		;line=89
	sta wsync		;line=90
s9	lda #$30
x14	ldx #$8B
	sta wsync		;line=91
	sta sizem
	stx hposm3
	DLINEW dli24 1 1 0

dli24
	sta regA
	stx regX
	sty regY
	lda #$03
x15	ldx #$7F
x16	ldy #$5A
	sta wsync		;line=92
	nop
	sta vscrol
	stx hposp0
	sty hposp2
	sta wsync		;line=93
x17	lda #$5D
	sta wsync		;line=94
	sta hposm3
x18	lda #$9B
	sta wsync		;line=95
	sta hposm3
	DLINEW dli25 1 1 1

dli25
	sta regA
	stx regX
	sty regY
	lda >fnt+$400*$03
	ldx #$04
x19	ldy #$5B
	sta wsync		;line=96
	sta chbase
	stx vscrol
	sty hposp2
	DLINEW dli26 1 1 1

dli26
	sta regA
	lda #$03
	sta wsync		;line=100
	nop
	sta vscrol
	sta wsync		;line=101
x20	lda #$67
	sta wsync		;line=102
	sta hposm3
x21	lda #$9A
	sta wsync		;line=103
	sta hposm3
	DLINEW dli27 1 0 0

dli27
	sta regA
	stx regX
	sty regY
	lda #$04
s10	ldx #$F0
x22	ldy #$9D
	sta wsync		;line=104
	nop
	sta vscrol
	stx sizem
	sty hposm3
	sta wsync		;line=105
s11	lda #$01
s12	ldx #$F1
x23	ldy #$69
	sta wsync		;line=106
	sta sizep0
	stx sizem
	sty hposp0
x24	lda #$93
c9	ldx #$0E
	sta wsync		;line=107
	sta hposm1
	stx colpm1
	DLINEW dli28 1 1 1

dli28
	sta regA
	stx regX
	sty regY
	lda #$03
s13	ldx #$01
x25	ldy #$82
	sta wsync		;line=108
	nop
	sta vscrol
	stx sizep3
	sty hposp3
	sta wsync		;line=109
	sta wsync		;line=110
x26	lda #$96
	sta wsync		;line=111
	sta hposm1
	DLINEW dli29 1 1 1

dli29
	sta regA
	stx regX
	lda #$04
	sta wsync		;line=112
	nop
	sta vscrol
	sta wsync		;line=113
	sta wsync		;line=114
s14	lda #$03
x27	ldx #$83
	sta wsync		;line=115
	sta sizep3
	stx hposp3
	DLINEW dli30 1 1 0

dli30
	sta regA
	stx regX
	lda #$03
x28	ldx #$90
	sta wsync		;line=116
	nop
	sta vscrol
	stx hposp1
	sta wsync		;line=117
s15	lda #$F5
x29	ldx #$5F
	sta wsync		;line=118
	sta sizem
	stx hposm1
s16	lda #$75
x30	ldx #$A2
	sta wsync		;line=119
	sta sizem
	stx hposm3
	DLINEW dli31 1 1 0

dli31
	sta regA
	stx regX
	lda >fnt+$400*$04
	ldx #$04
	sta wsync		;line=120
	sta chbase
	stx vscrol
	sta wsync		;line=121
	sta wsync		;line=122
s17	lda #$01
x31	ldx #$68
	sta wsync		;line=123
	sta sizep1
	stx hposp1
	DLINEW dli32 1 1 0

dli32
	sta regA
	stx regX
	lda #$03
x32	ldx #$87
	sta wsync		;line=124
	nop
	sta vscrol
	stx hposp0
	DLINEW dli33 1 1 0

dli33
	sta regA
	stx regX
	lda #$04
	sta wsync		;line=128
	nop
	sta vscrol
	sta wsync		;line=129
s18	lda #$71
x33	ldx #$83
	sta wsync		;line=130
	sta sizem
	stx hposm1
	DLINEW dli34 1 1 0

dli34
	sta regA
	lda #$03
	sta wsync		;line=132
	nop
	sta vscrol
	DLINEW dli35 1 0 0

dli35
	sta regA
	lda #$04
	sta wsync		;line=136
	nop
	sta vscrol
	DLINEW dli36 1 0 0

dli36
	sta regA
	stx regX
	lda #$03
	sta wsync		;line=140
	nop
	sta vscrol
	sta wsync		;line=141
	sta wsync		;line=142
s19	lda #$03
x34	ldx #$6F
	sta wsync		;line=143
	sta sizep1
	stx hposp1
	DLINEW dli37 1 1 0

dli37
	sta regA
	stx regX
	sty regY
	lda >fnt+$400*$05
	ldx #$04
	sta wsync		;line=144
	sta chbase
	stx vscrol
s20	lda #$31
x35	ldx #$A6
c10	ldy #$2C
	sta wsync		;line=145
	sta sizem
	stx hposm3
	sty colpm0
s21	lda #$01
x36	ldx #$5A
x37	ldy #$58
	sta wsync		;line=146
	sta sizem
	stx hposp2
	sty hposm2
s22	lda #$00
x38	ldx #$7A
	sta wsync		;line=147
	sta sizem
	stx hposm0
	DLINEW dli38 1 1 1

dli38
	sta regA
	lda #$03
	sta wsync		;line=148
	nop
	sta vscrol
	DLINEW dli39 1 0 0

dli39
	sta regA
	stx regX
	sty regY
	lda #$04
x39	ldx #$7C
	sta wsync		;line=152
	nop
	sta vscrol
	stx hposm0
s23	lda #$03
x40	ldx #$7D
	sta wsync		;line=153
	sta sizem
	stx hposm0
x41	lda #$80
	sta wsync		;line=154
	sta hposp3
s24	lda #$00
x42	ldx #$7E
x43	ldy #$A5
	sta wsync		;line=155
	sta sizem
	stx hposm0
	sty hposm3
	DLINEW dli40 1 1 1

dli40
	sta regA
	stx regX
	lda #$03
	sta wsync		;line=156
	nop
	sta vscrol
s25	lda #$10
x44	ldx #$60
	sta wsync		;line=157
	sta sizem
	stx hposp2
	sta wsync		;line=158
s26	lda #$00
x45	ldx #$5A
	sta wsync		;line=159
	sta sizem
	stx hposm2
	DLINEW dli41 1 1 0

dli41
	sta regA
	lda #$04
	sta wsync		;line=160
	nop
	sta vscrol
	DLINEW dli42 1 0 0

dli42
	sta regA
	lda #$03
	sta wsync		;line=164
	nop
	sta vscrol
	DLINEW dli43 1 0 0

dli43
	sta regA
	stx regX
	lda >fnt+$400*$06
	ldx #$04
	sta wsync		;line=168
	sta chbase
	stx vscrol
	DLINEW dli44 1 1 0

dli44
	sta regA
	stx regX
	sty regY
	lda #$03
s27	ldx #$01
x46	ldy #$77
	sta wsync		;line=172
	nop
	sta vscrol
	stx sizep1
	sty hposp1
	sta wsync		;line=173
x47	lda #$61
x48	ldx #$9C
	sta wsync		;line=174
	sta hposp0
	stx hposm2
s28	lda #$C4
x49	ldx #$7F
x50	ldy #$94
	sta wsync		;line=175
	sta sizem
	stx hposm1
	sty hposm3
	DLINEW dli45 1 1 1

dli45
	sta regA
	stx regX
	sty regY
	lda #$04
s29	ldx #$00
x51	ldy #$75
	sta wsync		;line=176
	nop
	sta vscrol
	stx sizep2
	sty hposp2
s30	lda #$00
x52	ldx #$72
	sta wsync		;line=177
	sta sizep1
	stx hposp1
s31	lda #$01
x53	ldx #$84
x54	ldy #$87
	sta wsync		;line=178
	sta sizep3
	stx hposp3
	sty hposm0
x55	lda #$60
x56	ldx #$89
	sta wsync		;line=179
	sta hposp0
	stx hposm0
	DLINEW dli46 1 1 1

dli46
	sta regA
	stx regX
	lda #$03
x57	ldx #$61
	sta wsync		;line=180
	nop
	sta vscrol
	stx hposp0
	sta wsync		;line=181
s32	lda #$D0
x58	ldx #$61
	sta wsync		;line=182
	sta sizem
	stx hposm2
s33	lda #$01
x59	ldx #$64
	sta wsync		;line=183
	sta sizep2
	stx hposp2
	DLINEW dli47 1 1 0

dli47
	sta regA
	stx regX
	lda #$04
x60	ldx #$8D
	sta wsync		;line=184
	nop
	sta vscrol
	stx hposp1
x61	lda #$71
	sta wsync		;line=185
	sta hposm0
	DLINEW dli48 1 1 0

dli48
	sta regA
	stx regX
	sty regY
	lda #$03
	sta wsync		;line=188
	nop
	sta vscrol
	sta wsync		;line=189
s34	lda #$C4
x62	ldx #$70
x63	ldy #$7A
	sta wsync		;line=190
	sta sizem
	stx hposm1
	sty hposm2
s35	lda #$00
x64	ldx #$7E
	sta wsync		;line=191
	sta sizep0
	stx hposp0
	DLINEW dli49 1 1 1

dli49
	sta regA
	stx regX
	sty regY
	lda >fnt+$400*$07
	ldx #$04
x65	ldy #$73
	sta wsync		;line=192
	sta chbase
	stx vscrol
	sty hposm0
	sta wsync		;line=193
x66	lda #$7D
	sta wsync		;line=194
	sta hposm2
x67	lda #$74
	sta wsync		;line=195
	sta hposp0
	DLINEW dli50 1 1 1

dli50
	sta regA
	lda #$03
	sta wsync		;line=196
	nop
	sta vscrol
	DLINEW dli51 1 0 0

dli51
	sta regA
	stx regX
	lda >fnt+$400*$05
	ldx #$04
	sta wsync		;line=200
	sta chbase
	stx vscrol
	sta wsync		;line=201
	sta wsync		;line=202
s36	lda #$03
x68	ldx #$74
	sta wsync		;line=203
	sta sizep3
	stx hposp3
	DLINEW dli52 1 1 0

dli52
	sta regA
	stx regX
	lda #$03
	sta wsync		;line=204
	nop
	sta vscrol
	sta wsync		;line=205
	sta wsync		;line=206
s37	lda #$01
x69	ldx #$76
	sta wsync		;line=207
	sta sizep1
	stx hposp1
	DLINEW dli53 1 1 0

dli53
	sta regA
	stx regX
	lda >fnt+$400*$07
	ldx #$04
	sta wsync		;line=208
	sta chbase
	stx vscrol
	DLINEW dli54 1 1 0

dli54
	sta regA
	lda #$03
	sta wsync		;line=212
	nop
	sta vscrol
	DLINEW dli55 1 0 0

dli55
	sta regA
	lda #$04
	sta wsync		;line=216
	nop
	sta vscrol
	DLINEW dli56 1 0 0

dli56
	sta regA
	lda #$03
	sta wsync		;line=220
	nop
	sta vscrol
	DLINEW dli57 1 0 0

dli57
	sta regA
	lda #$04
	sta wsync		;line=224
	nop
	sta vscrol
	DLINEW dli58 1 0 0

dli58
	sta regA
	stx regX
	sty regY
	lda #$03
s38	ldx #$00
x70	ldy #$8D
	sta wsync		;line=228
	nop
	sta vscrol
	stx sizep2
	sty hposp2
	sta wsync		;line=229
s39	lda #$00
x71	ldx #$69
	sta wsync		;line=230
	sta sizep3
	stx hposp3
	DLINEW dli59 1 1 1

dli59
	sta regA
	stx regX
	lda >fnt+$400*$08
	ldx #$04
	sta wsync		;line=232
	sta chbase
	stx vscrol
	DLINEW dli60 1 1 0

dli60
	sta regA
	lda #$03
	sta wsync		;line=236
	nop
	sta vscrol

	lda regA
	rti

.endl

; ---

CHANGES	= 0
FADECHR	= 0

SCHR	= 127

; ---

.proc	NMI

	bit nmist
	bpl VBL

	jmp DLI.dli2
dliv	equ *-2

VBL
	sta regA
	stx regX
	sty regY

	sta nmist		;reset NMI flag

	mwa #ant dlptr		;ANTIC address program

	mva #@dmactl(standard|dma|lineX1|players|missiles) dmactl	;set new screen width

	inc cloc		;little timer

; Initial values

	lda >fnt+$400*$00
	sta chbase
	lda #$04
	sta vscrol
c0	lda #$34
	sta colbak
c1	lda #$38
	sta color0
c2	lda #$2A
	sta color1
c3	lda #$00
	sta color2
c4	lda #$2E
	sta color3
	lda #$02
	sta chrctl
	lda #$04
	sta gtictl
s0	lda #$00
	sta sizep2
x0	lda #$80
	sta hposp2
c5	lda #$2C
	sta colpm2
x1	lda #$88
	sta hposm2
s1	lda #$00
	sta sizep3
x2	lda #$70
	sta hposp3
c6	lda #$2C
	sta colpm3
x3	lda #$6C
	sta hposm3
x4	lda #$79
	sta hposm1
c7	lda #$34
	sta colpm1
s2	lda #$00
	sta sizep0
x5	lda #$68
	sta hposp0
c8	lda #$0E
	sta colpm0
s3	lda #$30
	sta sizem
x6	lda #$7F
	sta hposm0
s4	lda #$00
	sta sizep1
x7	lda #$88
	sta hposp1

	mwa #DLI.dli2 dliv	;set the first address of DLI interrupt
	mwa #DLI.dli1 null+1	;synchronization for the first screen line

;this area is for yours routines

quit
	lda regA
	ldx regX
	ldy regY
	rti

.endp

; ---
	run main
; ---

	opt l-

.MACRO	SPRITES
missiles
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 30
	.he 00 00 00 30 10 90 9C FC 3C 30 3C 3C 0C 00 00 00
	.he 00 00 00 F0 F0 30 F0 F0 F0 F0 30 30 30 30 F0 F0
	.he F0 F0 F3 FF F3 F3 F3 FB FB FF FF F3 F3 F3 FF FF
	.he FF FF FF F3 F3 F3 F3 F3 F3 F3 FF FF FF FF FF FF
	.he FF FF FF FF FF 3F 3F 33 33 F0 F0 F3 F2 F3 F3 F3
	.he F2 F3 F3 F3 C3 F0 80 30 30 00 00 00 00 00 00 00
	.he 00 00 00 0C 00 00 30 F0 FC FC F3 F3 F3 F0 F0 F0
	.he D0 F3 F0 C0 C0 C0 EC E0 F3 F0 F0 C0 C0 80 C0 C0
	.he 80 C0 80 C0 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player0
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 BF 3F FF FF
	.he FF 00 00 00 FF FF FF FD FE FC F8 7C F9 00 00 00
	.he 00 00 F5 FB E3 2B 28 0A AD 89 8E DC 79 00 00 00
	.he 00 00 00 00 F0 78 FF FE FF FF FF FF FF FF FF BF
	.he FF 7F FF 3F FF 7F FF 3B 7F 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 FF FF FF FF FF FF FF FF FF FF
	.he 00 00 00 00 00 00 00 2B FF FE FE E0 F0 F8 FC FF
	.he FF FF FF 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player1
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 EF AA A2 D7 8A BB BF FC 00 00 00
	.he 00 00 00 07 87 8F FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF C9 FD CD FF 09 FF 8C D9 88
	.he C9 80 C1 00 C3 00 49 49 CB C9 EB E1 F7 73 FF 51
	.he FF 7F 7F 00 FF D7 BF B3 5F FB FD E8 FD E8 F0 00
	.he FA 5D FA FC FE FC FA 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 FE FF FF FF FF FF FF FF FE
	.he FF 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
player2
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 3F 3F 3F BF 7F FF 7F FF FF FF FF FF
	.he FF FF FF FF FC FE FE FE FF FF FF FF 7F 7F FF FF
	.he FF FF FF 0F 43 45 51 F1 B9 BD FF FF FF F3 E1 E1
	.he E1 E9 F8 DD F9 E1 C1 D3 E1 E1 C3 E3 EF E7 E7 FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF EF FF FF FF
	.he FF FF FF FF FF FF FF FF F7 FF 7F FF FF 7F 7F 7F
	.he FF 7F FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FA FF FF FF FF FD FB E5 EA C0 00 FF
	.he FF FE FE FE FF FF FF FF FF FF FF FF FF FF 7F 7F
	.he FF 7F FF BF FF BF EF DF DF DF AF FF AF B7 B7 97
	.he 97 9B DB 8B 00 00 00 00 00 00 00 00 8B 07 0F 1F
	.he 2F 5F BF 7F FF FF FF FF 00 00 00 00 00 00 00 00
player3
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
	.he 3C 37 36 F6 FE FE FF FF 00 00 00 E0 F4 F8 F4 FE
	.he FE FE FE E2 C8 D0 C4 C4 DC DC FF FF FF C7 C7 C3
	.he C3 9B 97 F7 C8 C4 F4 F4 F6 F6 FE EA F3 F3 FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF
	.he FF FF BF BF BF BF FF FF FF FF FF FF FF FF FF FF
	.he FF FF FF FF 3F 3F 7F FF FF BF 3F 3F 1F 1F 1F 0F
	.he 4F 2F F7 57 EF 4F AF CF DF 1F 0F 1F 1F 3F 3F FF
	.he FF FF FF FF FF FF FF FF FF FF FF FF FF FF FE FE
	.he FF FE FE FF FD FD FC FC 7A 7A 00 00 00 00 FA FD
	.he FF FF FF FF FF FF FF FF 00 00 00 00 00 00 00 00
.ENDM

USESPRITES = 1

.MACRO	DLINEW
	mva <:1 NMI.dliv
	ift [>?old_dli]<>[>:1]
	mva >:1 NMI.dliv+1
	eif

	ift :2
	lda regA
	eif

	ift :3
	ldx regX
	eif

	ift :4
	ldy regY
	eif

	rti

	.def ?old_dli = *
.ENDM

