;
; FATTY commander for ELITE 128
;

.case   +


.include "commander.i"
.include "systems.i"

.segment "FATTY"

        .word   $0000                   ; Load address (ignored)

DataStart:
        .byte   $00                     ; Missions (bitmapped flags)
        .word   LAVE                    ; Planet code
        .byte   $4A,$5A,$48,$02,$53,$B7 ; Galaxy data
        .dbyt   0, 10000                ; Money
        .byte   70                      ; Fuel
        .byte   $00                     ; Number of current galaxy
        .byte   L_Pulse                 ; Front laser type
        .byte   L_None                  ; Rear laser type
        .byte   L_None                  ; Left laser type
        .byte   L_None                  ; Right laser type
        .word   $0000                   ; Additional mission data
        .byte   $00                     ; Food
        .byte   $00                     ; Textilia
        .byte   $00                     ; Radioactive materials
        .byte   $00                     ; Slaves
        .byte   $00                     ; Liquor
        .byte   $00                     ; Luxury goods
        .byte   $00                     ; Narcotica
        .byte   $00                     ; Computer
        .byte   $00                     ; Machines
        .byte   $00                     ; Alloy
        .byte   $00                     ; Firearms
        .byte   $00                     ; Furs
        .byte   $00                     ; Minerals
        .byte   $00                     ; Gold
        .byte   $00                     ; Platinum
        .byte   $00                     ; Gems
        .byte   $00                     ; Alien goods
        .byte   $00                     ; ECM available
        .byte   $00                     ; IFF available
        .byte   $00                     ; Fuel scoops available
        .byte   $00                     ; Hyperspace unit
        .byte   $00                     ; Energy unit (= production value)
        .byte   $80                     ; Docking computer available
        .byte   $00                     ; Galactic hyperdrive available
        .byte   $00                     ; Escape capsule available
        .byte   $00                     ; Extra cargo bay
        .byte   $00                     ; Military drive available
        .word   0                       ; Count of trumbels
        .byte   $00                     ; Rating fraction
        .byte   $03                     ; Missile count
        .byte   $00                     ; Legal status (clean/offender/fugitive)
        .byte   $10                     ; Food available
        .byte   $0F                     ; Textilia available
        .byte   $11                     ; Radioactive materials available
        .byte   $00                     ; Slaves available
        .byte   $03                     ; Liquor available
        .byte   $1C                     ; Luxury goods available
        .byte   $0E                     ; Narcotica available
        .byte   $00                     ; Computer available
        .byte   $00                     ; Machines available
        .byte   $0A                     ; Alloy available
        .byte   $00                     ; Firearms available
        .byte   $11                     ; Furs available
        .byte   $3A                     ; Minerals available
        .byte   $07                     ; Gold available
        .byte   $09                     ; Platinum available
        .byte   $08                     ; Gems available
        .byte   $00                     ; Alien goods available
        .byte   $00                     ; Price factor
        .word   0                       ; Rating/kills
        .word   0                       ; Special cargo target
        .word   0                       ; Time left for special cargo delivery
        .byte   0                       ; Payment for special cargo
        .byte   0                       ; Type/illegality of special cargo

.assert (* - DataStart) = (C_Size - C_Data), error
