;copy ZEROPAGE_POINTER_3 to ZEROPAGE_POINTER_4
;size in PARAM3 hi, PARAM4 lo

!zone CopyMemory
CopyMemory
          sei

          lda #%00110100    ; alles RAM
          sta $01

          lda PARAM3
          beq .NoHiByte


          ldy #0
          sty PARAM1

-
          lda (ZEROPAGE_POINTER_3),y
          sta (ZEROPAGE_POINTER_4),y
          iny
          bne -

          inc ZEROPAGE_POINTER_3 + 1
          inc ZEROPAGE_POINTER_4 + 1

          inc PARAM1
          lda PARAM1
          cmp PARAM3
          bne -

.NoHiByte
          ldy #0
          lda PARAM4
          beq +

-
          lda (ZEROPAGE_POINTER_3),y
          sta (ZEROPAGE_POINTER_4),y
          iny
          cpy PARAM4
          bne -

+

          lda #$36    ; alles RAM ausser IO
          sta $01
          cli

          rts


;------------------------------------------------------------
;generates a sometimes random number
;------------------------------------------------------------
!zone GenerateRandomNumber
GenerateRandomNumber
          lda $dc04
          ;eor RANDOM_SEED
          eor $dc05
          eor $dd04
          adc $dd05
          eor $dd06
          eor $dd07
          ;sta RANDOM_SEED
          rts
          
          
          
!zone ClearScreen
ClearScreen
          ;lda #32
;          ldx #0
;-          
;          sta SCREEN_CHAR,x
;          sta SCREEN_CHAR + 250,x
;          sta SCREEN_CHAR + 500,x
;          sta SCREEN_CHAR + 750,x
;          
;          inx
;          cpx #250
;          bne -
          
          ldx #0
--         
          ldy #0
          lda SCREEN_LINE_OFFSET_TABLE_LO,x
          sta ZEROPAGE_POINTER_1
          sta ZEROPAGE_POINTER_2
          lda SCREEN_LINE_OFFSET_TABLE_HI,x
          sta ZEROPAGE_POINTER_1 + 1
          clc
          adc #>( SCREEN_COLOR - SCREEN_CHAR )
          sta ZEROPAGE_POINTER_2 + 1
          
          lda #160
          sta (ZEROPAGE_POINTER_1),y
          lda #0
          sta (ZEROPAGE_POINTER_2),y
          
          iny
          lda #32
-          
          sta (ZEROPAGE_POINTER_1),y
          
          iny
          cpy #40
          bne -
          
          
          inx
          cpx #25
          bne --
          
          rts
          
          
          
;abwarten der Rasterzeile (in A)
!zone WaitFrame
WaitFrame
          cmp VIC.RASTER_POS
          beq WaitFrame

-
          cmp VIC.RASTER_POS
          bne -
          rts
          
          
        
;return number of the first set bit from LSB side
!zone NumberOfBit
NumberOfBit
          sta PARAM9
          lda #0
          sta PARAM3
          
-          
          lda PARAM9
          and #$01
          bne .BitFound
          
          lsr PARAM9
          inc PARAM3
          jmp -
          
          
.BitFound
          lda PARAM3
          rts
  
          
;lower end = PARAM5
;higher end = PARAM6
!zone GenerateRangedRandom
GenerateRangedRandom
          lda PARAM6
          sec
          sbc PARAM5
          clc
          adc #1
          sta PARAM6

          jsr GenerateRandomNumber
.CheckValue          
          cmp PARAM6
          bcc .ValueOk
          
          ;too high
          sec
          sbc PARAM6
          jmp .CheckValue

.ValueOk
          clc
          adc PARAM5
          rts  
          


BIT_TABLE
          !byte 1,2,4,8,16,32,64,128