* = $0801

SPRITE_LOCATION         = $d000

SCREEN_COLOR            = $d800 
SCREEN_CHAR             = $c000
CHARSET_MEMORY          = $f800

SPRITE_POINTER_BASE     = SCREEN_CHAR + 1016
SPRITE_BASE             = ( SPRITE_LOCATION % 16384 ) / 64

JOY_RIGHT = 8
JOY_LEFT = 4
JOY_UP = 1
JOY_DOWN = 2
JOY_FIRE  = 16

PARAM1    = $67
PARAM2    = $68
PARAM3    = $69
PARAM4    = $6A
PARAM5    = $6B
PARAM6    = $05
PARAM7    = $2d

PARAM9    = $2b
PARAM10   = $2c

LOCAL1    = $02
LOCAL2    = $03
LOCAL3    = $04

ZEROPAGE_POINTER_1 = $6C
ZEROPAGE_POINTER_2 = $6E
ZEROPAGE_POINTER_3 = $70
ZEROPAGE_POINTER_4 = $C1
ZEROPAGE_POINTER_5 = $C3

ZEROPAGE_POINTER_1A = $2f
ZEROPAGE_POINTER_2A = $31
ZEROPAGE_POINTER_3A = $33

CURRENT_INDEX = $fb
CURRENT_SUB_INDEX = $fe

NUM_SPRITES = 32

!src <kernal.asm>


!basic

          lda #8
          sta VIC.CHARSET_MULTICOLOR_1
          lda #0
          sta VIC.CHARSET_MULTICOLOR_2
          lda #5
          sta VIC.BACKGROUND_COLOR
          lda #2
          sta VIC.SPRITE_MULTICOLOR_1
          lda #0
          sta VIC.SPRITE_MULTICOLOR_2

          lda #0
          sta VIC.BORDER_COLOR
          
          ;all RAM for setting up sprites and charset
          LDA #<CHARSET
          STA ZEROPAGE_POINTER_3
          LDA #>CHARSET
          STA ZEROPAGE_POINTER_3 + 1
          lda #<CHARSET_MEMORY
          sta ZEROPAGE_POINTER_4
          lda #>CHARSET_MEMORY
          sta ZEROPAGE_POINTER_4 + 1
          lda #<( 240 * 8 )
          sta PARAM4
          lda #>( 240 * 8 )
          sta PARAM3
          jsr CopyMemory

          sei
          
          ;disable cia #1 generating timer irqs
          lda #$7f 
          sta CIA1.IRQ_CONTROL
          
          ;acknowledge any pending cia timer interrupts
          ;this is just so we're 100% safe
          lda CIA1.IRQ_CONTROL
          
          lda #$34
          sta PROCESSOR_PORT
          
          ;copy sprites
          lda #<SPRITES
          sta ZEROPAGE_POINTER_3
          lda #>SPRITES
          sta ZEROPAGE_POINTER_3 + 1

          lda #<SPRITE_LOCATION
          sta ZEROPAGE_POINTER_4
          lda #>SPRITE_LOCATION
          sta ZEROPAGE_POINTER_4 + 1

          lda #<( NUM_SPRITES * 64 ) 
          sta PARAM4
          lda #>( NUM_SPRITES * 64 )
          sta PARAM3
          jsr CopyMemory
          
          lda #$36
          sta PROCESSOR_PORT
          
          cli
          
          ;VIC bank
          lda CIA2.DATA_PORT_A
          and #$fc
          sta CIA2.DATA_PORT_A
          
          lda #$0e
          sta VIC.MEMORY_CONTROL
          
          lda #$1b
          sta VIC.CONTROL_1
          
          jsr ClearScreen
          
          jsr SFXInit
          jsr InitIRQ
          
          jmp Title

          
!src "util.asm"
!src "game.asm"
!src "objects.asm"
!src "sfx.asm"
!src "irq.asm"
!src "level.asm"
!src "title.asm"
!src "done.asm"
!src "retry.asm"


SCREEN_LINE_OFFSET_TABLE_HI
!for ROW = 0 TO 24
          !byte >( SCREEN_CHAR + ROW * 40 )
!end

SCREEN_LINE_OFFSET_TABLE_LO
!for ROW = 0 TO 24
          !byte <( SCREEN_CHAR + ROW * 40 )
!end


CHARSET
          !media "ld47.charsetproject",CHAR
          
SPRITES
          !media "LD47.spriteproject",SPRITE,0,NUM_SPRITES

          !mediasrc "gametiles.mapproject",TILES_,tile
          
          !mediasrc "gametiles.mapproject",SCREENS_,map
          
          