NUM_OBJECTS = 8

TYPE_WAGON              = 1
TYPE_OBJECT_SHADOW      = 2
TYPE_ENEMY_WAGON        = 3
TYPE_PLAYER_CURSOR      = 4
TYPE_DIAMOND            = 5
TYPE_EXPLOSION          = 6

SPRITE_WAGON            = SPRITE_BASE + 0
SPRITE_OBJECT_SHADOW    = SPRITE_BASE + 1
SPRITE_OBJECT_V         = SPRITE_BASE + 12
SPRITE_OBJECT_SHADOW_V  = SPRITE_BASE + 13

SPRITE_CURSOR_NSE       = SPRITE_BASE + 16
SPRITE_CURSOR_NSW       = SPRITE_BASE + 17
SPRITE_CURSOR_NWE       = SPRITE_BASE + 18
SPRITE_CURSOR_SWE       = SPRITE_BASE + 19
SPRITE_CURSOR_NSWE      = SPRITE_BASE + 20
SPRITE_CURSOR_BLOCKED   = SPRITE_BASE + 21

SPRITE_DIAMOND_1        = SPRITE_BASE + 22

SPRITE_EXPLOSION        = SPRITE_BASE + 26

SPRITE_CENTER_OFFSET_X  = 8
SPRITE_CENTER_OFFSET_Y  = 11

OBJECT_HEIGHT           = 10



OBJECT_TYPE
          !fill NUM_OBJECTS

OBJECT_POS_X
          !fill NUM_OBJECTS

OBJECT_POS_Y
          !fill NUM_OBJECTS
          
OBJECT_ANIM_POS          
          !fill NUM_OBJECTS
OBJECT_ANIM_DELAY
          !fill NUM_OBJECTS
OBJECT_MOVE_POS          
          !fill NUM_OBJECTS
OBJECT_STATE          
          !fill NUM_OBJECTS
OBJECT_CHAR_POS_X
          !fill NUM_OBJECTS
OBJECT_CHAR_POS_X_DELTA
          !fill NUM_OBJECTS
OBJECT_CHAR_POS_Y
          !fill NUM_OBJECTS
OBJECT_CHAR_POS_Y_DELTA
          !fill NUM_OBJECTS
OBJECT_MOVE_SPEED
          !fill NUM_OBJECTS,1
          
OBJECT_TILE_POS
          !byte 0,0,0,0,0,0,0,0
          
OBJECT_DIR          
          !byte DIR_E,DIR_E,DIR_E,DIR_E,DIR_E,DIR_E,DIR_E,DIR_E
          
TYPE_START_COLOR = * - 1
          !byte 0     ;wagon
          !byte 11    ;wagon shadow
          !byte 0     ;enemy wagon
          !byte 1     ;player cursor
          !byte 4     ;diamond
          !byte 7     ;explosion
          
TYPE_START_SPRITE = * - 1
          !byte SPRITE_WAGON
          !byte SPRITE_OBJECT_SHADOW
          !byte SPRITE_WAGON
          !byte SPRITE_CURSOR_BLOCKED
          !byte SPRITE_DIAMOND_1
          !byte SPRITE_EXPLOSION
          
TYPE_START_DELTA_Y = * - 1
          !byte 0     ;wagon
          !byte 0     ;wagon shot
          !byte 0     ;enemy wagon
          !byte 0     ;player cursor
          !byte 0     ;diamond
          !byte 0     ;explosion
          
TYPE_IS_ENEMY = * - 1
          !byte 0               ;wagon
          !byte 0               ;wagon shadow
          !byte 1               ;enemy wagon
          !byte 0               ;player cursor
          !byte 2               ;diamond
          !byte 0     ;explosion

OBJECT_BEHAVIOUR_TABLE_LO = * - 1
          !byte <BHWagon
          !byte <BHWagonShadow
          !byte <BHWagon
          !byte <BHCursor
          !byte <BHDiamond
          !byte <BHExplosion

OBJECT_BEHAVIOUR_TABLE_HI = * - 1
          !byte >BHWagon
          !byte >BHWagonShadow
          !byte >BHWagon
          !byte >BHCursor
          !byte >BHDiamond
          !byte >BHExplosion
          
          
!zone ObjectControl          
ObjectControl          
          ldx #0
          stx CURRENT_INDEX
          
-
          ldy OBJECT_TYPE,x
          beq .NextObject
          
          lda OBJECT_BEHAVIOUR_TABLE_LO,y
          sta .JUMPPOS
          lda OBJECT_BEHAVIOUR_TABLE_HI,y
          sta .JUMPPOS + 1
          
.JUMPPOS = * + 1          
          jsr $8000
          
.NextObject          
          inc CURRENT_INDEX
          ldx CURRENT_INDEX
          cpx #NUM_OBJECTS
          bne -
          
          rts
          
          
          
!zone BHWagon
BHWagon
          lda LEVEL_COMPLETED
          beq +
          rts
+          
          
          jsr CheckCollisions
          
          inc OBJECT_ANIM_DELAY,x
          lda OBJECT_ANIM_DELAY,x
          and #$03
          bne +
          
          lda #0
          sta OBJECT_ANIM_DELAY,x
          
          lda SPRITE_POINTER_BASE,x
          eor #$02
          sta SPRITE_POINTER_BASE,x
+          

          lda OBJECT_MOVE_SPEED,x
          asl
          asl
          asl
          ora SPEED_TABLE_POS
          tay
          lda SPEED_TABLE,y
          sta PARAM7
          bne .GoWagonNextStep
          rts
          
WagonNextStep
          dec PARAM7
          bne .GoWagonNextStep
          rts
          
.GoWagonNextStep          

          
          lda OBJECT_MOVE_POS,x
          beq .StartNewMove
          jmp .KeepMoving
          
.StartNewMove          
          ;start new move
          ldy OBJECT_TILE_POS,x
          lda LEVEL_DATA,y
          sta PARAM10
          
          cpy OBJECT_TILE_POS
          bne .NotOnCursor
          
          lda CURSOR_ACTIVE
          beq .NotOnCursor
          
          ;fall through to override table (must be behind TILE_RESULTING_DIR table!)
          lda OBJECT_DIR,x
          jsr NumberOfBit
          sta PARAM1
          
          asl PARAM10
          asl PARAM10
          lda PARAM10
          clc
          adc PARAM1
          tay
          
          lda TILE_OVERRIDE_DIR,y
          sta OBJECT_DIR,x
          
          lda #SFX_PICK_DOT
          jsr SFXPlay
          ldx CURRENT_INDEX
          jmp .DirWasChanged
          
.NotOnCursor          
          ;can we go straight?
          lda PARAM10
          and OBJECT_DIR,x
          beq .CantGoStraight
          
          ;go straight
          ;yes
          jmp .KeepMovingStraight
          
.CantGoStraight
          lda OBJECT_DIR,x
          jsr NumberOfBit
          sta PARAM1

          lda PARAM10
          asl
          asl
          clc
          adc PARAM1
          tay
          
          lda TILE_RESULTING_DIR,y
          sta OBJECT_DIR,x
          
          lda #SFX_PICK_DOT
          jsr SFXPlay
          ldx CURRENT_INDEX
          
.DirWasChanged                    
.KeepMovingStraight
          ;set up new tile pos
          
          ;flatten dir
          lda OBJECT_DIR,x
          jsr NumberOfBit
          sta PARAM6
          
          ldy PARAM6
          lda OBJECT_TILE_POS,x
          clc
          adc TILE_DELTA,y
          sta OBJECT_TILE_POS,x
          
          ;rotate sprite
          lda OBJECT_DIR,x
          and #12
          beq .Horz

          lda #SPRITE_OBJECT_V
          sta SPRITE_POINTER_BASE,x
          lda #SPRITE_OBJECT_SHADOW_V
          sta SPRITE_POINTER_BASE + 1,x
          jmp .Vert
          
.Horz
          lda #SPRITE_WAGON
          sta SPRITE_POINTER_BASE,x
          lda #SPRITE_OBJECT_SHADOW
          sta SPRITE_POINTER_BASE + 1,x
          
.Vert          
.KeepMoving   
          lda #1
          sta MOVE_TWO_SPRITES
          jsr MoveInDirection
          
          jmp WagonNextStep
          
          
          
!zone MoveInDirection
MoveInDirection  
          inc OBJECT_MOVE_POS,x
          lda OBJECT_MOVE_POS,x
          cmp #12  ;we move 2 pixels
          bne +
          lda #0
          sta OBJECT_MOVE_POS,x
+          
  
          lda OBJECT_DIR,x
          cmp #DIR_E
          beq .GoE
          cmp #DIR_W
          beq .GoW
          cmp #DIR_N
          beq .GoN
          cmp #DIR_S
          beq .GoS
          
          rts

.GoE      
          jsr ObjectMoveRight
          jsr ObjectMoveRight
          
          lda MOVE_TWO_SPRITES
          beq +
          
          inx
          jsr ObjectMoveRight
          jsr ObjectMoveRight
          dex
+          
          rts

.GoW
          jsr ObjectMoveLeft
          jsr ObjectMoveLeft
          
          lda MOVE_TWO_SPRITES
          beq +
          
          inx
          jsr ObjectMoveLeft
          jsr ObjectMoveLeft
          dex
+          
          rts
          
.GoN
          jsr ObjectMoveUp
          jsr ObjectMoveUp
          
          lda MOVE_TWO_SPRITES
          beq +
          
          inx
          jsr ObjectMoveUp
          jsr ObjectMoveUp
          dex
          
+          
          rts
          
.GoS
          jsr ObjectMoveDown
          jsr ObjectMoveDown
          
          lda MOVE_TWO_SPRITES
          beq +
          
          inx
          jsr ObjectMoveDown
          jsr ObjectMoveDown
          dex
+          
          rts


!zone BHWagonShadow
BHWagonShadow
          lda SPRITE_POINTER_BASE - 1,x
          clc
          adc #1
          sta SPRITE_POINTER_BASE,x
          rts
          
          
          
!zone BHExplosion
BHExplosion
          inc OBJECT_ANIM_DELAY,x
          lda OBJECT_ANIM_DELAY,x
          and #$03
          bne +
          
          inc OBJECT_ANIM_POS,x
          lda OBJECT_ANIM_POS,x
          cmp #3
          beq ++
          
          clc
          adc #SPRITE_EXPLOSION
          sta SPRITE_POINTER_BASE,x
          rts
          
++
          jmp RemoveObject
          
+
          rts



!zone BHCursor
BHCursor
          lda LEVEL_COMPLETED
          ora PLAYER_KILLED
          beq +
          rts
+          

          lda #0
          sta MOVE_TWO_SPRITES

          lda OBJECT_MOVE_POS,x
          beq .CanControl
          
          jsr MoveInDirection
          jmp .UpdateAnim

.CanControl
          lda JOY_VALUE
          and #JOY_FIRE
          bne .NotFire
          
          lda PLAYER_CAN_SET_HERE
          bne +
          
          lda BUTTON_RELEASED
          beq .NotFire
          
          lda #0
          sta BUTTON_RELEASED
          
          ;can't set here
          lda #SFX_BEEP_LO
          jsr SFXPlay
          ldx CURRENT_INDEX
          
          jmp .NotFire
          
+          
          lda CURSOR_ACTIVE
          bne ++
          
          lda #SFX_BLING
          jsr SFXPlay
          ldx CURRENT_INDEX
          
          lda #1
          sta CURSOR_ACTIVE
          lda #0
          sta BUTTON_RELEASED
          jmp ++
          
.NotFire
          lda CURSOR_ACTIVE
          beq ++
          
          lda #SFX_BLING_REVERSE
          jsr SFXPlay
          ldx CURRENT_INDEX

          lda #0
          sta CURSOR_ACTIVE
          
++
          lda JOY_VALUE
          and #JOY_UP
          bne .NotUp
          
          lda CURSOR_TILE_Y
          beq .NotUp

          dec CURSOR_TILE_Y
          
          lda OBJECT_TILE_POS,x
          sec
          sbc #13
          sta OBJECT_TILE_POS,x
          
          lda #SPRITE_CURSOR_BLOCKED
          sta SPRITE_POINTER_BASE,x
          
          lda #DIR_N
          sta OBJECT_DIR,x
          jsr MoveInDirection
          jmp .UpdateAnim
          
.NotUp          
          lda JOY_VALUE
          and #JOY_DOWN
          bne .NotDown
          
          lda CURSOR_TILE_Y
          cmp #7
          beq .NotDown
          
          inc CURSOR_TILE_Y
          lda OBJECT_TILE_POS,x
          clc
          adc #13
          sta OBJECT_TILE_POS,x
          
          lda #SPRITE_CURSOR_BLOCKED
          sta SPRITE_POINTER_BASE,x
          
          lda #DIR_S
          sta OBJECT_DIR,x
          jsr MoveInDirection
          jmp .UpdateAnim

.NotDown          
          lda JOY_VALUE
          and #JOY_LEFT
          bne .NotLeft
          
          lda CURSOR_TILE_X
          beq .NotLeft
          
          dec CURSOR_TILE_X
          dec OBJECT_TILE_POS,x

          lda #SPRITE_CURSOR_BLOCKED
          sta SPRITE_POINTER_BASE,x
          
          lda #DIR_W
          sta OBJECT_DIR,x
          jsr MoveInDirection
          jmp .UpdateAnim
          
.NotLeft          
          lda JOY_VALUE
          and #JOY_RIGHT
          bne .NotRight
          
          lda CURSOR_TILE_X
          cmp #12
          beq .NotRight
          
          inc CURSOR_TILE_X
          inc OBJECT_TILE_POS,x
          
          lda #SPRITE_CURSOR_BLOCKED
          sta SPRITE_POINTER_BASE,x
          
          lda #DIR_E
          sta OBJECT_DIR,x
          
          jsr MoveInDirection
          
.NotRight          
.UpdateAnim       
          ;arrived at tile, can change heer?
          lda OBJECT_MOVE_POS,x
          bne +
          
          ldy OBJECT_TILE_POS,x
          lda LEVEL_DATA,y
          tay
          lda TILE_CHANGEABLE,y
          sta PLAYER_CAN_SET_HERE
          beq .CannotSet
          
          sta SPRITE_POINTER_BASE,x
          jmp +
          
.CannotSet
          lda #SPRITE_CURSOR_BLOCKED
          sta SPRITE_POINTER_BASE,x
          
+          
          

          lda CURSOR_ACTIVE
          beq +
          
          lda #1
          jmp .SetColor

          
+
          inc OBJECT_ANIM_DELAY
          lda OBJECT_ANIM_DELAY
          lsr
          lsr
          and #$07
          tay
          
          lda PLAYER_CAN_SET_HERE
          beq .CantSet
          
          ;can set here
          lda FLASH_COLOR,y
          jmp .SetColor
          
.CantSet
          lda FLASH_RED_COLOR,y
.SetColor          
          sta VIC.SPRITE_COLOR,x
          rts



!zone BHDiamond
BHDiamond
          inc OBJECT_ANIM_DELAY
          lda OBJECT_ANIM_DELAY
          lsr
          lsr
          lsr
          and #$03
          clc
          adc #SPRITE_DIAMOND_1
          sta SPRITE_POINTER_BASE,x
          rts
          
          
          
;check enemy collision with player
;x = player index
!zone CheckCollisions
CheckCollisions
          ldx CURRENT_INDEX
          stx CURRENT_SUB_INDEX
-
          ;don't compare with outself
          ldx CURRENT_SUB_INDEX
          cpx CURRENT_INDEX
          beq .NextObject
          
          lda OBJECT_TYPE,x
          bne +

.NextObject
          inc CURRENT_SUB_INDEX
          ldx CURRENT_SUB_INDEX
          cpx #8
          bne -

          ldx CURRENT_INDEX
          rts

+
          ;check for collision
          ;is in untouchable state?
          lda OBJECT_STATE,x
          bmi .NextObject

          ;is an enemy?
          ldy OBJECT_TYPE,x
          lda TYPE_IS_ENEMY,y
          beq .NextObject

          ldy CURRENT_INDEX
          jsr IsEnemyCollidingWithPlayer
          bne .PlayerCollidedWithEnemy

.NotAPlayerTrolley          
          jmp .NextObject

.PlayerCollidedWithEnemy
          ;player index in x
          ;enemy index in y
          ;player killed?

          ldx CURRENT_INDEX
          ldy CURRENT_SUB_INDEX
          
          ;only player trolleys pick up!
          lda OBJECT_TYPE,x
          cmp #TYPE_ENEMY_WAGON
          beq .NotAPlayerTrolley

          lda OBJECT_TYPE,y
          cmp #TYPE_DIAMOND
          bne .NotADiamond
          
          ;pick up
          ldx CURRENT_SUB_INDEX
          lda #0
          sta DIAMOND_ACTIVE
          jsr RemoveObject
          
          dec SCREEN_CHAR + SCORE_BAR_OFFSET_CRYSTAL
          
          lda #128
          sta DIAMOND_SPAWN_DELAY
          inc NUM_DIAMONDS_PICKED
          lda NUM_DIAMONDS_PICKED
          cmp NUM_POTENTIAL_SPAWN_POS
          bne +
          
          lda #1
          sta LEVEL_COMPLETED
          
          lda #SFX_LEVEL_DONE
          jmp ++
          
+         
          lda #SFX_BULLET

++
          jsr SFXPlay
          jsr IncScore10
          
          ldx CURRENT_INDEX
          rts
          
          
.NotADiamond         
          cmp #TYPE_ENEMY_WAGON
          bne .NextObject
          
          ;kill both!
          lda #SPRITE_EXPLOSION
          sta SPRITE_POINTER_BASE,x
          sta SPRITE_POINTER_BASE,y
          lda #TYPE_EXPLOSION
          sta OBJECT_TYPE,x
          sta OBJECT_TYPE,y
          lda #7
          sta VIC.SPRITE_COLOR,x
          sta VIC.SPRITE_COLOR,y
          
          lda #0
          sta OBJECT_ANIM_DELAY,x
          sta OBJECT_ANIM_POS,x
          sta OBJECT_ANIM_DELAY,y
          sta OBJECT_ANIM_POS,y
          
          ;remove shadows
          inx
          jsr RemoveObject
          tya
          tax
          inx
          jsr RemoveObject
          
          lda #1
          sta PLAYER_KILLED
          
          lda #SFX_CHEST_OPEN
          jsr SFXPlay
          
          ldx CURRENT_INDEX
          
          rts
          
          
!zone IsEnemyCollidingWithPlayer
.CalculateSimpleXPos
          ;Returns a with simple x pos (x halved + 128 if > 256)
          ;modifies y
          lda BIT_TABLE,x
          and VIC.SPRITE_X_EXTEND
          beq .NoXBit

          lda OBJECT_POS_X,x
          lsr
          ora #128
          rts

.NoXBit
          lda OBJECT_POS_X,x
          lsr
          rts

;x is object to check
;          
IsEnemyCollidingWithPlayer
          lda #OBJECT_HEIGHT
          sta PARAM9
          
          ;modifies X
          ;check y pos
          lda OBJECT_POS_Y,x
          sec
          sbc PARAM9              ;offset to bottom
          cmp OBJECT_POS_Y,y
          bcs .NotTouching
          clc
          adc PARAM9
          adc PARAM9
          sec
          sbc #1
          cmp OBJECT_POS_Y,y
          bcc .NotTouching

          ;X = Index in enemy-table
          jsr .CalculateSimpleXPos
          sta PARAM1
          ;vs. player X
          tya
          tax
          jsr .CalculateSimpleXPos

          sec
          sbc #4
          ;position X-Anfang Player - 12 Pixel
          cmp PARAM1
          bcs .NotTouching
          adc #8
          cmp PARAM1
          bcc .NotTouching

          lda #1
          rts

.NotTouching
          lda #0
          rts
          
          
          
          
          
          
;PARAM1 is X
;PARAM2 is Y
;PARAM3 is object type
;returns x is sprite slot
;        A = 0 if spawned, A = 1 if no slot free
!zone SpawnObject
SpawnObject
          ldx #0
-          
          lda OBJECT_TYPE,x
          beq .FreeSlotFound
          
          inx
          cpx #NUM_OBJECTS
          bne -
          
          lda #1
          rts

          
          
CreateObjectInSlot
.FreeSlotFound
          lda PARAM3
          sta OBJECT_TYPE,x

          ;PARAM1 and PARAM2 hold x,y already
          jsr CalcSpritePosFromCharPos

          ;enable sprite
          lda BIT_TABLE,x
          ora VIC.SPRITE_ENABLE
          sta VIC.SPRITE_ENABLE

          ;sprite color
          ldy OBJECT_TYPE,x
          lda TYPE_START_COLOR,y
          sta VIC.SPRITE_COLOR,x
          bpl .NoMulticolor

          lda BIT_TABLE,x
          ora VIC.SPRITE_MULTICOLOR
          sta VIC.SPRITE_MULTICOLOR
          jmp .MultiColorDone

.NoMulticolor
          lda BIT_TABLE,x
          eor #$ff
          and VIC.SPRITE_MULTICOLOR
          sta VIC.SPRITE_MULTICOLOR

.MultiColorDone

          ;initialise enemy values
          lda TYPE_START_SPRITE,y
          sta SPRITE_POINTER_BASE,x

          ;look right per default
          lda #0
          sta OBJECT_ANIM_POS,x
          sta OBJECT_ANIM_DELAY,x
          sta OBJECT_STATE,x
          sta OBJECT_MOVE_POS,x
          sta OBJECT_MOVE_SPEED,x
          
          lda #DIR_E
          sta OBJECT_DIR,x

          lda TYPE_START_DELTA_Y,y
          sta PARAM10
          sty PARAM9

.OffsetY
          beq .NoOffsetY

          jsr MoveSpriteUp
          dec PARAM10
          jmp .OffsetY

.NoOffsetY
          ldy PARAM9

          lda #0
          rts
          
          
          
;CalcSpritePosFromCharPos
;calculates the real sprite coordinates from screen char pos
;and sets them directly
;PARAM1 = char_pos_x
;PARAM2 = char_pos_y
;X      = sprite index
;------------------------------------------------------------
!zone CalcSpritePosFromCharPos
CalcSpritePosFromCharPos

          ;offset screen to border 24,50
          lda BIT_TABLE,x
          eor #$ff
          and VIC.SPRITE_X_EXTEND
          sta VIC.SPRITE_X_EXTEND

          ;need extended x bit?
          lda PARAM1
          sta OBJECT_CHAR_POS_X,x
          cmp #30
          bcc .NoXBit

          lda BIT_TABLE,x
          ora VIC.SPRITE_X_EXTEND
          sta VIC.SPRITE_X_EXTEND

.NoXBit
          ;calculate sprite positions (offset from border)
          txa
          asl
          tay

          lda PARAM1
          asl
          asl
          asl
          clc
          adc #( 24 - SPRITE_CENTER_OFFSET_X )
          sta OBJECT_POS_X,x
          sta VIC.SPRITE_X_POS,y

          lda PARAM2
          sta OBJECT_CHAR_POS_Y,x
          asl
          asl
          asl
          clc
          adc #( 50 - SPRITE_CENTER_OFFSET_Y )
          sta OBJECT_POS_Y,x
          sta VIC.SPRITE_Y_POS,y

          lda #0
          sta OBJECT_CHAR_POS_X_DELTA,x
          sta OBJECT_CHAR_POS_Y_DELTA,x
          rts
          
          

!zone RemoveObject
RemoveObject
          lda #0
          sta OBJECT_TYPE,x
          
          lda BIT_TABLE,x
          eor VIC.SPRITE_ENABLE
          sta VIC.SPRITE_ENABLE
          rts
          
          
;------------------------------------------------------------
;move object up
;x = object index
;------------------------------------------------------------
!zone ObjectMoveUp
ObjectMoveUp
          dec OBJECT_CHAR_POS_Y_DELTA,x

          lda OBJECT_CHAR_POS_Y_DELTA,x
          cmp #$ff
          bne .NoCharStep

          lda OBJECT_CHAR_POS_Y,x
          bne +
          lda #32
          sta OBJECT_CHAR_POS_Y,x
+
          dec OBJECT_CHAR_POS_Y,x
          lda #7
          sta OBJECT_CHAR_POS_Y_DELTA,x

.NoCharStep
          jsr MoveSpriteUp
          rts


;------------------------------------------------------------
;Move Sprite Up
;expect x as sprite index (0 to 7)
;------------------------------------------------------------
!zone MoveSpriteUp
MoveSpriteUp
          dec OBJECT_POS_Y,x

          txa
          asl
          tay

          lda OBJECT_POS_Y,x
          sta VIC.SPRITE_Y_POS,y
          rts

          
          
;------------------------------------------------------------
;move object down
;x = object index
;------------------------------------------------------------
!zone ObjectMoveDown
ObjectMoveDown
          inc OBJECT_CHAR_POS_Y_DELTA,x

          lda OBJECT_CHAR_POS_Y_DELTA,x
          cmp #8
          bne .NoCharStep

          lda #0
          sta OBJECT_CHAR_POS_Y_DELTA,x
          inc OBJECT_CHAR_POS_Y,x

          ;wrap at 32
          lda OBJECT_CHAR_POS_Y,x
          cmp #32
          bne +

          lda #0
          sta OBJECT_CHAR_POS_Y,x

+

.NoCharStep
          jsr MoveSpriteDown
          rts


;------------------------------------------------------------
;Move Sprite Down
;expect x as sprite index (0 to 7)
;------------------------------------------------------------
!zone MoveSpriteDown
MoveSpriteDown
          inc OBJECT_POS_Y,x

          txa
          asl
          tay

          lda OBJECT_POS_Y,x
          sta VIC.SPRITE_Y_POS,y
          rts
          
          
          
!zone ObjectMoveLeft
ObjectMoveLeft
          lda OBJECT_CHAR_POS_X_DELTA,x
          bne .NoCharStep

          lda #8
          sta OBJECT_CHAR_POS_X_DELTA,x
          dec OBJECT_CHAR_POS_X,x

.NoCharStep
          dec OBJECT_CHAR_POS_X_DELTA,x

          jsr MoveSpriteLeft
          rts
          
          
          
;------------------------------------------------------------
;Move Sprite Left
;expect x as sprite index (0 to 7)
;------------------------------------------------------------
!zone MoveSpriteLeft
MoveSpriteLeft
          lda OBJECT_POS_X,x
          bne .NoChangeInExtendedFlag

          lda BIT_TABLE,x
          eor #$ff
          and VIC.SPRITE_X_EXTEND
          sta VIC.SPRITE_X_EXTEND

.NoChangeInExtendedFlag
          dec OBJECT_POS_X,x
          txa
          asl
          tay

          lda OBJECT_POS_X,x
          sta VIC.SPRITE_X_POS,y
          rts
          
          

;------------------------------------------------------------
;move object right
;x = object index
;------------------------------------------------------------
!zone ObjectMoveRight
ObjectMoveRight

          inc OBJECT_CHAR_POS_X_DELTA,x

          lda OBJECT_CHAR_POS_X_DELTA,x
          cmp #8
          bne .NoCharStep

          lda #0
          sta OBJECT_CHAR_POS_X_DELTA,x
          inc OBJECT_CHAR_POS_X,x

.NoCharStep
          jsr MoveSpriteRight
          rts
          
          
          
;------------------------------------------------------------
;Move Sprite Right
;expect x as sprite index (0 to 7)
;------------------------------------------------------------
!zone MoveSpriteRight
MoveSpriteRight
          inc OBJECT_POS_X,x
          lda OBJECT_POS_X,x
          bne .NoChangeInExtendedFlag

          lda BIT_TABLE,x
          ora VIC.SPRITE_X_EXTEND
          sta VIC.SPRITE_X_EXTEND

.NoChangeInExtendedFlag
          txa
          asl
          tay

          lda OBJECT_POS_X,x
          sta VIC.SPRITE_X_POS,y
          rts
          
          
          
!zone SpawnWagon
;x = tile x, y = tile y  
SpawnWagon
          lda #3
          sta PARAM6
 
          ;calc tile pos
          stx PARAM9
          stx PARAM5
          sty PARAM6
          
          lda PARAM6
          sta PARAM2
          beq +
-          
          lda PARAM9
          clc
          adc #13
          sta PARAM9
          dec PARAM2
          bne -
+          
          lda PARAM9
          pha
          
          
          ldy PARAM5
          lda TILE_OFFSET_X,y
          clc
          adc #1
          sta PARAM1

          ldy PARAM6
          lda TILE_OFFSET_Y,y
          clc
          adc #1
          sta PARAM2
          
          lda #TYPE_WAGON
          sta PARAM3
          jsr SpawnObject
          
          pla
          sta OBJECT_TILE_POS,x
          
           
          lda #TYPE_OBJECT_SHADOW
          sta PARAM3
          jsr SpawnObject  
          dex
          rts
          
          
          
!zone ClearObjects
ClearObjects
          ldx #0
          txa
-          
          sta OBJECT_TYPE,x
          sta OBJECT_ANIM_DELAY,x
          sta SPRITE_POINTER_BASE,x
          inx
          cpx #8
          bne - 
          
          sta VIC.SPRITE_ENABLE
         
          rts 
          
          
FLASH_COLOR
          !byte 11,12,15,1,15,12,11,0

FLASH_RED_COLOR
          !byte 2,10,15,1,15,10,2,0

MOVE_TWO_SPRITES
          !byte 0
          
CURSOR_TILE_X
          !byte 0
CURSOR_TILE_Y
          !byte 0          
CURSOR_ACTIVE
          !byte 0

SPEED_TABLE_POS
          !byte 0
          
SPEED_TABLE
          !byte 0,0,0,0,1,0,0,0
          !byte 0,1,0,0,0,1,0,0
          !byte 1,0,1,0,1,0,1,0
          !byte 1,1,1,0,1,1,1,0
          !byte 1,1,1,1,1,1,1,1
          