!zone Retry
Retry
          lda #0
          sta VIC.SPRITE_ENABLE
          
          jsr SFXStopAll
          
          jsr ClearScreen
          
          ;show retry screen
          ldx #0
-          
          lda RETRY_SCREEN,x
          sta SCREEN_CHAR,x
          lda RETRY_SCREEN + 1 * 250,x
          sta SCREEN_CHAR + 1 * 250,x
          lda RETRY_SCREEN + 2 * 250,x
          sta SCREEN_CHAR + 2 * 250,x
          lda RETRY_SCREEN + 3 * 250,x
          sta SCREEN_CHAR + 3 * 250,x

          lda RETRY_SCREEN + 1000,x
          sta SCREEN_COLOR,x
          lda RETRY_SCREEN + 1000 + 1 * 250,x
          sta SCREEN_COLOR + 1 * 250,x
          lda RETRY_SCREEN + 1000 + 2 * 250,x
          sta SCREEN_COLOR + 2 * 250,x
          lda RETRY_SCREEN + 1000 + 3 * 250,x
          sta SCREEN_COLOR + 3 * 250,x
          
          inx
          cpx #250
          bne -
 
          ;copy score value
          ldx #0
-          
          lda TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_SCORE,x
          sta SCREEN_CHAR + $131,x
          inx
          cpx #6
          bne -
          
          lda #SFX_FALL
          jsr SFXPlay
          
          lda #1
          jsr HighlightChoice
          
!zone RetryLoop
RetryLoop
          lda #240
          jsr WaitFrame
          
          inc OBJECT_ANIM_DELAY
          lda OBJECT_ANIM_DELAY
          lsr
          lsr
          and #$07
          tay
          
          lda FLASH_COLOR,y
          jsr HighlightChoice
          
          lda JOY_VALUE
          and #JOY_LEFT
          bne .NotLeft
          
          lda RETRY_CHOICE
          beq .AlreadyLeft
          
          ;un-highlight other choice
          lda #7
          jsr HighlightChoice
          lda #0
          sta RETRY_CHOICE
          lda #1
          jsr HighlightChoice
          
          lda #SFX_PICK_DOT
          jsr SFXPlay
          
          
.AlreadyLeft          
.NotLeft
          lda JOY_VALUE
          and #JOY_RIGHT
          bne .NotRight
          
          lda RETRY_CHOICE
          cmp #1
          beq .AlreadyRight

          ;un-highlight other choice
          lda #7
          jsr HighlightChoice
          
          lda #1
          sta RETRY_CHOICE
          
          lda #1
          jsr HighlightChoice
          
          lda #SFX_PICK_DOT
          jsr SFXPlay
          
.AlreadyRight          
.NotRight
          lda JOY_VALUE
          and #JOY_FIRE
          bne ++
          
          lda BUTTON_RELEASED
          beq +++
          
          lda #1
          sta BUTTON_RELEASED

          lda RETRY_CHOICE
          beq .ChoseRetry
          
          jmp Title
          
          
++          
          lda #1
          sta BUTTON_RELEASED
+++
          jmp RetryLoop
          
          
.ChoseRetry          
          ;reset score
          lda #'0'
          sta TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_SCORE
          sta TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_SCORE + 1
          sta TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_SCORE + 2
          sta TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_SCORE + 3
          sta TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_SCORE + 4
          sta TEXT_CURRENT_SCORE_BAR + SCORE_BAR_OFFSET_SCORE + 5

          jmp StartGame.RestartLevel
          
          
          
!zone HighlightChoice
HighlightChoice
          pha
          
          ldx RETRY_CHOICE
          lda RETRY_POS_LO,x
          sta ZEROPAGE_POINTER_1
          lda RETRY_POS_HI,x
          sta ZEROPAGE_POINTER_1 + 1
          
          ldy #0
          
          pla
          sta (ZEROPAGE_POINTER_1),y
          iny
          sta (ZEROPAGE_POINTER_1),y
          iny
          sta (ZEROPAGE_POINTER_1),y
          iny
          sta (ZEROPAGE_POINTER_1),y
          iny
          sta (ZEROPAGE_POINTER_1),y
          iny
          sta (ZEROPAGE_POINTER_1),y
          iny
          sta (ZEROPAGE_POINTER_1),y
          iny
          sta (ZEROPAGE_POINTER_1),y
          iny
          sta (ZEROPAGE_POINTER_1),y
          ldy #40
          sta (ZEROPAGE_POINTER_1),y
          ldy #40 + 8
          sta (ZEROPAGE_POINTER_1),y
          ldy #80
          sta (ZEROPAGE_POINTER_1),y
          ldy #80 + 8
          sta (ZEROPAGE_POINTER_1),y
          ldy #120
          sta (ZEROPAGE_POINTER_1),y
          ldy #120 + 8
          sta (ZEROPAGE_POINTER_1),y
          ldy #160
          sta (ZEROPAGE_POINTER_1),y
          iny
          sta (ZEROPAGE_POINTER_1),y
          iny
          sta (ZEROPAGE_POINTER_1),y
          iny
          sta (ZEROPAGE_POINTER_1),y
          iny
          sta (ZEROPAGE_POINTER_1),y
          iny
          sta (ZEROPAGE_POINTER_1),y
          iny
          sta (ZEROPAGE_POINTER_1),y
          iny
          sta (ZEROPAGE_POINTER_1),y
          iny
          sta (ZEROPAGE_POINTER_1),y
          rts
          
RETRY_CHOICE
          !byte 0
          
RETRY_POS_LO
          !byte <( SCREEN_COLOR + $211 )
          !byte <( SCREEN_COLOR + $21f )
          
RETRY_POS_HI
          !byte >( SCREEN_COLOR + $211 )
          !byte >( SCREEN_COLOR + $21f )
          
RETRY_SCREEN
          !media "retry.charscreen",charcolor