SFX_ENEMY_DIE     = 1
SFX_BLING         = 2
SFX_HIT           = 3
SFX_DIE           = 4
SFX_PICK_DOT      = 5
SFX_LEVEL_START   = 6
SFX_BULLET        = 7
SFX_SKI           = 8
SFX_SKI_CRASH     = 9
SFX_BEEP_LO       = 10
SFX_BEEP_HI       = 11
SFX_CHEST_OPEN    = 12
SFX_STEP          = 13
SFX_HIT_PLAYER    = 14
SFX_HIT_ENEMY     = 15
SFX_FALL          = 16
SFX_BLING_REVERSE = 17
SFX_LEVEL_DONE    = 18

FX_END            = 0
FX_FREQU_TRIANGLE = 1
FX_FREQU_SAW      = 2 
FX_FREQU_RECT     = 3
FX_FREQU_NOISE    = 4
FX_TAST_RECT      = $20
FX_ADSR           = $40
FX_PAUSE          = $10
FX_SLIDE_UP       = $80
FX_SLIDE_DOWN     = $81

WAVE_NOISE      = 129
WAVE_RECT       = 65
WAVE_SAW        = 33
WAVE_TRIANGLE   = 17

SID_FREQUENCY_LO_1 = $D400
SID_FREQUENCY_HI_1 = $D401
SID_TAST_RECT_LO_1 = $D402
SID_TAST_RECT_HI_1 = $D403   ;high byte 
SID_WAVEFORM_1     = $D404   ;0 = gate (1 start, 0 release), 1 = Sync, 2 = Ring, 3 = Test, 4-7 = Triangle,Saw,Rect,Noise
SID_ATTACK_DECAY_1 = $D405
SID_HOLD_RELEASE_1 = $D406
 
SID_FREQUENCY_LO_2 = $D407
SID_FREQUENCY_HI_2 = $D408
SID_TAST_RECT_LO_2 = $D409
SID_TAST_RECT_HI_2 = $D40A   ;high byte 
SID_WAVEFORM_2     = $D40B   ;0 = gate (1 start, 0 release), 1 = Sync, 2 = Ring, 3 = Test, 4-7 = Triangle,Saw,Rect,Noise
SID_ATTACK_DECAY_2 = $D40C
SID_HOLD_RELEASE_2 = $D40D

SID_FREQUENCY_LO_3 = $D40E
SID_FREQUENCY_HI_3 = $D40F
SID_TAST_RECT_LO_3 = $D410
SID_TAST_RECT_HI_3 = $D411   ;high byte 
SID_WAVEFORM_3     = $D412   ;0 = gate (1 start, 0 release), 1 = Sync, 2 = Ring, 3 = Test, 4-7 = Triangle,Saw,Rect,Noise
SID_ATTACK_DECAY_3 = $D413
SID_HOLD_RELEASE_3 = $D414
  
SID_FILTER_LO      = $D415
SID_FILTER_HI      = $D416
SID_RESONANCE      = $D417   ; 0 keine; 15*16 stark; (+ Filter für 1.Stimme 1; 2.Stimme 2; 3.Stimme 4; extern 8)

SID_VOLUME         = $D418   ; 0 stumm; 15 ganz laut; (+ Filtermodus 3.Stimme Aus 128; Hochpass 64; Bandpass 32; Tiefpass 16)
 
SID_OSCILLATOR_3   = $D41B
SID_ENVILOPE_3     = $D41C


!zone SFXInit
SFXInit
          lda #0
          ldx #0
          
.ClearSid          
          sta SID_FREQUENCY_LO_1,x
          inx
          cpx #( SID_ENVILOPE_3 - SID_FREQUENCY_LO_1 )
          bne .ClearSid
          
          sta FX_CURRENT_FREQ_LO
          sta FX_CURRENT_FREQ_LO + 1
          sta FX_CURRENT_FREQ_LO + 2
          sta FX_CURRENT_FREQ_HI
          sta FX_CURRENT_FREQ_HI + 1
          sta FX_CURRENT_FREQ_HI + 2
          sta FX_CURRENT_WAVE
          sta FX_CURRENT_WAVE + 1
          sta FX_CURRENT_WAVE + 2
          
          lda #15
          sta SID_VOLUME
          rts

          

MUSIC_VOICE_ACTIVE
          !byte 0,0,0
MUSIC_VOICE_MUSIC_INDEX
          !byte 0,0,0
MUSIC_VOICE_MUSIC_POS
          !byte 0,0,0
MUSIC_VOICE_MUSIC_DELAY
          !byte 0,0,0
MUSIC_VOICE_MUSIC_LENGTH
          !byte 0,0,0
MUSIC_VOICE_PRIO
          !byte 0,0,0
    
MUSIC_FX_TABLE_PRIO
          !byte       0   ;dummy entry
          !byte       5   ;enemy killed
          !byte       4   ;pickup
          !byte       3   ;hit
          !byte       5   ;player killed
          !byte       4   ;pick dot
          !byte       5   ;level start
          !byte       4   ;bullet
          !byte       2   ;snow sound
          !byte       6   ;ski crash
          !byte       5   ;beep lo
          !byte       5   ;beep hi
          !byte       5   ;beep hi
          !byte       5   ;beep hi
          !byte       5   ;beep hi
          !byte       5   ;beep hi
          !byte       5   ;beep hi
          !byte       5
          !byte       5
          
MUSIC_FX_TABLE_LO
          !byte 0
          !byte <FX_ENEMY_DIE
          !byte <FX_BLING
          !byte <FX_HIT
          !byte <FX_DIE
          !byte <FX_PICK_DOT
          !byte <FX_LEVEL_START
          !byte <FX_BULLET
          !byte <FX_SKI
          !byte <FX_SKI_CRASH
          !byte <FX_BEEP_LO
          !byte <FX_BEEP_HI
          !byte <FX_CHEST_OPEN
          !byte <FX_STEP
          !byte <FX_HIT_PLAYER
          !byte <FX_HIT_ENEMY
          !byte <FX_FALL
          !byte <FX_BLING_REVERSE
          !byte <FX_LEVEL_DONE

MUSIC_FX_TABLE_HI
          !byte 0
          !byte >FX_ENEMY_DIE
          !byte >FX_BLING
          !byte >FX_HIT
          !byte >FX_DIE
          !byte >FX_PICK_DOT
          !byte >FX_LEVEL_START
          !byte >FX_BULLET
          !byte >FX_SKI
          !byte >FX_SKI_CRASH
          !byte >FX_BEEP_LO
          !byte >FX_BEEP_HI
          !byte >FX_CHEST_OPEN
          !byte >FX_STEP
          !byte >FX_HIT_PLAYER
          !byte >FX_HIT_ENEMY
          !byte >FX_FALL
          !byte >FX_BLING_REVERSE
          !byte >FX_LEVEL_DONE

MUSIC_FX_TABLE_CONTENT_LO
          !byte 0
          !byte <FX_VALUE_1_1
          !byte <FX_VALUE_3_1
          !byte <FX_VALUE_4_1
          !byte <FX_VALUE_5_1
          !byte <FX_VALUE_2_1
          !byte <FX_VALUE_6_1
          !byte <FX_VALUE_7_1
          !byte <FX_VALUE_8_1
          !byte <FX_VALUE_9_1
          !byte <FX_VALUE_10_1
          !byte <FX_VALUE_11_1
          !byte <FX_VALUE_12_1
          !byte <FX_VALUE_13_1
          !byte <FX_VALUE_14_1
          !byte <FX_VALUE_15_1
          !byte <FX_VALUE_16_1
          !byte <FX_VALUE_17_1
          !byte <FX_VALUE_18_1
          
MUSIC_FX_TABLE_CONTENT_HI
          !byte 0
          !byte >FX_VALUE_1_1
          !byte >FX_VALUE_3_1
          !byte >FX_VALUE_4_1
          !byte >FX_VALUE_5_1
          !byte >FX_VALUE_2_1
          !byte >FX_VALUE_6_1
          !byte >FX_VALUE_7_1
          !byte >FX_VALUE_8_1
          !byte >FX_VALUE_9_1
          !byte >FX_VALUE_10_1
          !byte >FX_VALUE_11_1
          !byte >FX_VALUE_12_1
          !byte >FX_VALUE_13_1
          !byte >FX_VALUE_14_1
          !byte >FX_VALUE_15_1
          !byte >FX_VALUE_16_1
          !byte >FX_VALUE_17_1
          !byte >FX_VALUE_18_1

MUSIC_FX_TABLE_CONTENT_2_LO
          !byte 0
          !byte <FX_VALUE_1_2
          !byte <FX_VALUE_3_2
          !byte <FX_VALUE_4_2
          !byte <FX_VALUE_5_2
          !byte <FX_VALUE_2_2
          !byte <FX_VALUE_6_2
          !byte <FX_VALUE_7_2
          !byte <FX_VALUE_8_2
          !byte <FX_VALUE_9_2
          !byte <FX_VALUE_10_2
          !byte <FX_VALUE_11_2
          !byte <FX_VALUE_12_2
          !byte <FX_VALUE_13_2
          !byte <FX_VALUE_14_2
          !byte <FX_VALUE_15_2
          !byte <FX_VALUE_16_2
          !byte <FX_VALUE_17_2
          !byte <FX_VALUE_18_2
          
MUSIC_FX_TABLE_CONTENT_2_HI
          !byte 0
          !byte >FX_VALUE_1_2
          !byte >FX_VALUE_3_2
          !byte >FX_VALUE_4_2
          !byte >FX_VALUE_5_2
          !byte >FX_VALUE_2_2
          !byte >FX_VALUE_6_2
          !byte >FX_VALUE_7_2
          !byte >FX_VALUE_8_2
          !byte >FX_VALUE_9_2
          !byte >FX_VALUE_10_2
          !byte >FX_VALUE_11_2
          !byte >FX_VALUE_12_2
          !byte >FX_VALUE_13_2
          !byte >FX_VALUE_14_2
          !byte >FX_VALUE_15_2
          !byte >FX_VALUE_16_2
          !byte >FX_VALUE_17_2
          !byte >FX_VALUE_18_2

FX_ENEMY_DIE
          !byte FX_ADSR,FX_TAST_RECT,FX_FREQU_NOISE,FX_PAUSE,FX_END
FX_VALUE_1_1
          !byte $88,$20, 0,20,0
FX_VALUE_1_2
          !byte $22,$20,34,0,0
          
FX_PICK_DOT
          !byte FX_ADSR,FX_FREQU_SAW,FX_PAUSE,FX_END
FX_VALUE_2_1
          !byte $22, 0,15,0
FX_VALUE_2_2
          !byte $00,10,0,0

FX_BULLET
          !byte FX_ADSR,FX_FREQU_SAW,FX_PAUSE,FX_END
FX_VALUE_7_1
          !byte $22, 0,5,0
FX_VALUE_7_2
          !byte $00,40,0,0

FX_BLING
          !byte FX_ADSR,FX_FREQU_TRIANGLE,FX_PAUSE,FX_FREQU_TRIANGLE,FX_PAUSE,FX_END
FX_VALUE_3_1
          !byte $88,$00,$04,$00,$04,$00
FX_VALUE_3_2
          !byte $10,$20,$00,$10,$00,$00

FX_BLING_REVERSE
          !byte FX_ADSR,FX_FREQU_TRIANGLE,FX_PAUSE,FX_FREQU_TRIANGLE,FX_PAUSE,FX_END
FX_VALUE_17_1
          !byte $88,$00,$04,$00,$04,$00
FX_VALUE_17_2
          !byte $10,$10,$00,$20,$00,$00

FX_HIT
          !byte FX_ADSR,FX_TAST_RECT,FX_FREQU_NOISE,FX_PAUSE,FX_END
FX_VALUE_4_1
          !byte $88,$40,$C0,$40,$00
FX_VALUE_4_2
          !byte $10,$70,$00,$00,$00

FX_DIE
          !byte FX_ADSR,FX_FREQU_SAW,FX_PAUSE,FX_FREQU_SAW,FX_PAUSE,FX_FREQU_SAW,FX_PAUSE,FX_FREQU_SAW,FX_PAUSE,FX_FREQU_SAW,FX_PAUSE,FX_END
FX_VALUE_5_1
          !byte $13,$00,$07,$00,$07,$00,$07,$00,$07,$00,$07,$00
FX_VALUE_5_2
          !byte $20,$60,$00,$50,$00,$40,$00,$30,$00,$20,$00,$00

FX_LEVEL_START
          !byte FX_ADSR,FX_FREQU_TRIANGLE,FX_PAUSE,FX_FREQU_TRIANGLE,FX_PAUSE,FX_FREQU_TRIANGLE,FX_PAUSE,FX_FREQU_TRIANGLE,FX_PAUSE,FX_FREQU_TRIANGLE,FX_PAUSE,FX_END
FX_VALUE_6_1
          !byte $33,$40,$10,$00,$10,$00,$10,$00,$08,$00,$25,$00
FX_VALUE_6_2
          !byte $F1,$20,$00,$30,$00,$40,$00,$50,$00,$40,$00,$00
          
FX_SKI
          !byte FX_TAST_RECT,FX_ADSR,FX_FREQU_NOISE,FX_PAUSE,FX_END
FX_VALUE_8_1
          !byte $71,$00,$44,$30,$00
FX_VALUE_8_2
          !byte $14,$34,$e0,$10,$00

FX_SKI_CRASH
          !byte FX_ADSR,FX_TAST_RECT,FX_FREQU_NOISE,FX_PAUSE,FX_END
FX_VALUE_9_1
          !byte $87,$40,$C0,$05,$00
FX_VALUE_9_2
          !byte $50,$74,$00,$00,$00

FX_BEEP_LO
          !byte FX_ADSR,FX_FREQU_SAW,FX_PAUSE,FX_END
FX_VALUE_10_1
          !byte $35,$00,$10,$00
FX_VALUE_10_2
          !byte $65,$08,$20,$00

FX_BEEP_HI
          !byte FX_ADSR,FX_FREQU_TRIANGLE,FX_PAUSE,FX_END
FX_VALUE_11_1
          !byte $35,$30,$28,$00
FX_VALUE_11_2
          !byte $65,$40,$40,$00

FX_CHEST_OPEN
          !byte FX_ADSR, FX_FREQU_NOISE,FX_PAUSE,FX_FREQU_NOISE,FX_PAUSE,FX_END
FX_VALUE_12_1
          !byte $2f,$00,$05,$00,$05,$00
FX_VALUE_12_2
          !byte $50,$01,$00,$03,$00,$00
          
FX_STEP
          !byte FX_ADSR, FX_FREQU_TRIANGLE, FX_PAUSE,FX_END
FX_VALUE_13_1
          !byte $2f,$00,$02,$00
FX_VALUE_13_2
          !byte $50,$08,$00,$00
          
FX_HIT_PLAYER
          !byte FX_ADSR, FX_FREQU_NOISE, FX_PAUSE, FX_END
FX_VALUE_14_1
          !byte $2f,$00,$06,$00
FX_VALUE_14_2
          !byte $50,$04,$00,$00

FX_HIT_ENEMY
          !byte FX_ADSR, FX_FREQU_NOISE, FX_PAUSE, FX_END
FX_VALUE_15_1
          !byte $1a,$00,$08,$00
FX_VALUE_15_2
          !byte $30,$0c,$00,$00

FX_FALL
          !byte FX_ADSR, FX_FREQU_SAW, FX_SLIDE_DOWN, FX_END
FX_VALUE_16_1
          !byte $55,$00,$30,$00
FX_VALUE_16_2
          !byte $55,$1f,$a0,$00

        
FX_LEVEL_DONE
          !byte FX_ADSR,FX_FREQU_TRIANGLE,FX_SLIDE_UP,FX_FREQU_TRIANGLE,FX_SLIDE_UP,FX_FREQU_TRIANGLE,FX_SLIDE_UP,FX_FREQU_TRIANGLE,FX_SLIDE_UP,FX_END
FX_VALUE_18_1
          !byte $33,$40,$10,$40,$10,$40,$10,$40,$10,$00
FX_VALUE_18_2
          !byte $F1,$20,$ff,$20,$ff,$20,$ff,$20,$ff,$00
        
!zone SFXUpdate
SFXUpdate
          ldx #0
.NextVoice          
          stx FX_VOICE_INDEX
          lda MUSIC_VOICE_ACTIVE,x
          bne .PlayEffect
.EffectStepDone        
          ldx FX_VOICE_INDEX
          inx
          cpx #3
          bne .NextVoice
          rts

.PlayEffect
          stx FX_VOICE_INDEX
          lda SID_OFFSET,x
          sta FX_SID_OFFSET
          
          ldy MUSIC_VOICE_MUSIC_INDEX,x
          
          lda MUSIC_FX_TABLE_LO,y
          sta ZEROPAGE_POINTER_1A
          lda MUSIC_FX_TABLE_HI,y
          sta ZEROPAGE_POINTER_1A + 1

          lda MUSIC_FX_TABLE_CONTENT_LO,y
          sta ZEROPAGE_POINTER_2A
          lda MUSIC_FX_TABLE_CONTENT_HI,y
          sta ZEROPAGE_POINTER_2A + 1

          lda MUSIC_FX_TABLE_CONTENT_2_LO,y
          sta ZEROPAGE_POINTER_3A
          lda MUSIC_FX_TABLE_CONTENT_2_HI,y
          sta ZEROPAGE_POINTER_3A + 1

          ldy MUSIC_VOICE_MUSIC_POS,x
          
.NextStep
          ldx FX_VOICE_INDEX
          lda SID_OFFSET,x
          tax
          stx FX_SID_OFFSET
          
          lda (ZEROPAGE_POINTER_1A),y
          sta FX_CURRENT_ACTION
          lda (ZEROPAGE_POINTER_2A),y
          sta FX_CURRENT_VALUE_1
          lda (ZEROPAGE_POINTER_3A),y
          sta FX_CURRENT_VALUE_2
          
          lda FX_CURRENT_ACTION
          cmp #FX_FREQU_TRIANGLE
          bne +
          jmp .FrequTriangle
+          
          cmp #FX_FREQU_SAW
          bne +
          jmp .FrequSaw
+          
          cmp #FX_FREQU_NOISE
          bne +
          jmp .FrequNoise
+          
          cmp #FX_ADSR
          bne +
          jmp .ADSR
+          
          cmp #FX_TAST_RECT
          bne .NotTast
          jmp .TastRect
.NotTast          
          cmp #FX_END
          bne .NoEnd
          jmp .EndOfEffect
.NoEnd          
          cmp #FX_SLIDE_UP
          beq .SlideUp
          cmp #FX_SLIDE_DOWN
          beq .SlideDown
          
          cmp #FX_PAUSE
          beq .Pause
          
          ldx FX_VOICE_INDEX
          jmp .EffectStepDone
          
          
.SlideUp
          ;slide delta
          ldx FX_VOICE_INDEX
          lda FX_CURRENT_VALUE_2
          clc
          adc FX_CURRENT_FREQ_LO,x
          sta FX_CURRENT_FREQ_LO,x
          lda FX_CURRENT_FREQ_HI,x
          adc #0
          sta FX_CURRENT_FREQ_HI,x
          
          ldy FX_SID_OFFSET
          lda FX_CURRENT_FREQ_LO,x
          sta SID_FREQUENCY_LO_1,y
          lda FX_CURRENT_FREQ_HI,x
          sta SID_FREQUENCY_HI_1,y
          
          ;delay
          inc MUSIC_VOICE_MUSIC_DELAY,x
          lda FX_CURRENT_VALUE_1
          cmp MUSIC_VOICE_MUSIC_DELAY,x
          beq .SlideUpDone
          jmp .EffectStepDone
          
.SlideUpDone          
          lda #0
          sta MUSIC_VOICE_MUSIC_DELAY,x
          inc MUSIC_VOICE_MUSIC_POS,x
          ldy MUSIC_VOICE_MUSIC_POS,x
          jmp .NextStep

.SlideDown
          ;slide delta
          ldx FX_VOICE_INDEX
          lda FX_CURRENT_FREQ_LO,x
          sec
          sbc FX_CURRENT_VALUE_2
          sta FX_CURRENT_FREQ_LO,x
          lda FX_CURRENT_FREQ_HI,x
          sbc #0
          sta FX_CURRENT_FREQ_HI,x
          
          ldy FX_SID_OFFSET
          lda FX_CURRENT_FREQ_LO,x
          sta SID_FREQUENCY_LO_1,y
          lda FX_CURRENT_FREQ_HI,x
          sta SID_FREQUENCY_HI_1,y
          
          ;delay
          inc MUSIC_VOICE_MUSIC_DELAY,x
          lda FX_CURRENT_VALUE_1
          cmp MUSIC_VOICE_MUSIC_DELAY,x
          beq .SlideUpDone
          jmp .EffectStepDone
          
          
.Pause
          ldx FX_VOICE_INDEX
          inc MUSIC_VOICE_MUSIC_DELAY,x
          
          lda FX_CURRENT_VALUE_1
          cmp MUSIC_VOICE_MUSIC_DELAY,x
          beq .PauseDone
          jmp .EffectStepDone
          
.PauseDone          
          lda #0
          sta MUSIC_VOICE_MUSIC_DELAY,x
          iny
          jmp .NextStep
          
.FrequTriangle          
          ldx FX_VOICE_INDEX
          
          ;wave
          lda #WAVE_TRIANGLE
          sta FX_CURRENT_WAVE,x
          
.SetFrequenceAndWave          
          ;freq lo
          lda FX_CURRENT_VALUE_1
          sta FX_CURRENT_FREQ_LO,x
          ;freq hi
          lda FX_CURRENT_VALUE_2
          sta FX_CURRENT_FREQ_HI,x
          
          ldy FX_SID_OFFSET
          lda FX_CURRENT_FREQ_LO,x
          sta SID_FREQUENCY_LO_1,y
          lda FX_CURRENT_FREQ_HI,x
          sta SID_FREQUENCY_HI_1,y
          lda FX_CURRENT_WAVE,x          
          sta SID_WAVEFORM_1,y
          
          ldx FX_VOICE_INDEX
          inc MUSIC_VOICE_MUSIC_POS,x
          ldy MUSIC_VOICE_MUSIC_POS,x
          jmp .NextStep

.FrequSaw
          ldx FX_VOICE_INDEX
          
          ;wave
          lda #WAVE_SAW
          sta FX_CURRENT_WAVE,x
          jmp .SetFrequenceAndWave          

.FrequNoise
          ldx FX_VOICE_INDEX
          
          ;wave
          lda #WAVE_NOISE
          sta FX_CURRENT_WAVE,x
          jmp .SetFrequenceAndWave          


.ADSR
          ;AD
          lda FX_CURRENT_VALUE_1
          sta SID_ATTACK_DECAY_1,x
          ;SR
          lda FX_CURRENT_VALUE_2
          sta SID_HOLD_RELEASE_1,x
          ;done
          ldx FX_VOICE_INDEX
          inc MUSIC_VOICE_MUSIC_POS,x
          iny
          jmp .NextStep

.TastRect
          ;AD
          lda FX_CURRENT_VALUE_1
          sta SID_TAST_RECT_LO_1,x
          ;SR
          lda FX_CURRENT_VALUE_2
          sta SID_TAST_RECT_HI_1,x
          ;done
          ldx FX_VOICE_INDEX
          inc MUSIC_VOICE_MUSIC_POS,x
          iny
          jmp .NextStep

.EndOfEffect
          ldx FX_SID_OFFSET
          lda #0
          sta SID_WAVEFORM_1,x
          
          ldx FX_VOICE_INDEX
          lda #0
          sta MUSIC_VOICE_ACTIVE,x
          rts
          


;------------------------------------------------------------
;SFXStop
;stops all playing sounds
;------------------------------------------------------------
!zone SFXStopAll
SFXStopAll
          ldx #0
.FXLoop          
          sta MUSIC_VOICE_ACTIVE,x
          ldy SID_OFFSET,x
          sta SID_WAVEFORM_1,y
          inx
          cpx #3
          bne .FXLoop
          rts
          
          
!zone SFXPlayInSlot          
;play effect in A, in slot x (0 to 2)
SFXPlayInSlot          
          pha
          jmp SFXPlay.FreeVoiceFound
          
          
          
!zone SFXPlay
.LOCAL1 
          !byte 0
.LOCAL2
          !byte 0
;------------------------------------------------------------
;SFXPlay
;expects effect index in A
;------------------------------------------------------------
SFXPlay
          pha
          sta .LOCAL1
          sty .LOCAL2
          
          ldx #0
.CheckFreeVoice
          lda MUSIC_VOICE_ACTIVE,x
          beq .FreeVoiceFound
          inx
          cpx #3
          bne .CheckFreeVoice

          ;no free voice found, check same type
          ldx #0
.CheckFreeVoiceWithSameType
          lda MUSIC_VOICE_ACTIVE,x
          cmp .LOCAL1
          beq .FreeVoiceFound
          inx
          cpx #3
          bne .CheckFreeVoiceWithSameType

          ;no free voice found, check prio
          ldx #0
.CheckFreeVoiceWithPrio
          ;get active prio
          ldy MUSIC_VOICE_ACTIVE,x
          lda MUSIC_FX_TABLE_PRIO,y
          
          ;get wanted prio
          ldy .LOCAL2
          cmp MUSIC_FX_TABLE_PRIO,y
          bcs .FreeVoiceFound
          inx
          cpx #3
          bne .CheckFreeVoiceWithPrio
          
          pla
          rts

.FreeVoiceFound
          lda #1
          sta MUSIC_VOICE_ACTIVE,x
          pla
          tay
          lda MUSIC_FX_TABLE_PRIO,y
          sta MUSIC_VOICE_PRIO,x
          tya
          sta MUSIC_VOICE_MUSIC_INDEX,x
          
          lda #0
          sta MUSIC_VOICE_MUSIC_POS,x
          sta MUSIC_VOICE_MUSIC_DELAY,x
          sta MUSIC_VOICE_MUSIC_LENGTH,x
          
          ldy SID_OFFSET,x
          sta SID_WAVEFORM_1,y
          rts
          
          
SID_OFFSET
          !byte 0,7,14


FX_CURRENT_FREQ_LO
          !byte 0,0,0
FX_CURRENT_FREQ_HI
          !byte 0,0,0
FX_CURRENT_WAVE
          !byte 0,0,0
          
FX_CURRENT_ACTION
          !byte 0
FX_CURRENT_VALUE_1
          !byte 0
FX_CURRENT_VALUE_2
          !byte 0

;0 to 2, index to voice          
FX_VOICE_INDEX
          !byte 0
;0, 7, 14, current SID voice offset          
FX_SID_OFFSET
          !byte 0